/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.dataType;

import hu.birot.OTKit.dataType.Form;
import hu.birot.OTKit.dataType.FormValuePair;
import hu.birot.OTKit.dataType.MapForm;
import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Gen;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MapFormExamples {
    public static final MapForm equals(final HashMap<Form, FormValuePair[]> hm) {
        return new MapForm(){

            @Override
            public Form first(Form form1) {
                if (hm.containsKey(form1)) {
                    return ((FormValuePair[])hm.get(form1))[0].form();
                }
                return MapForm.NoMapping;
            }

            @Override
            public Form next(Form form1, Form form_last) {
                if (hm.containsKey(form1)) {
                    FormValuePair[] fvpa = (FormValuePair[])hm.get(form1);
                    int length = fvpa.length;
                    int i = 0;
                    while (i < length) {
                        if (fvpa[i].form().equals(form_last)) {
                            if (i + 1 < length) {
                                return fvpa[i + 1].form();
                            }
                            return MapForm.NoMoreForm;
                        }
                        ++i;
                    }
                    return MapForm.NotInRange;
                }
                return MapForm.NoMapping;
            }

            @Override
            public Form random(Form form1, double rnd) {
                if (hm.containsKey(form1)) {
                    FormValuePair[] fvpa = (FormValuePair[])hm.get(form1);
                    double sum = 0.0;
                    double f = 0.0;
                    int i = 0;
                    while (i < fvpa.length) {
                        sum += fvpa[i].value();
                        ++i;
                    }
                    double rndf = rnd * sum;
                    i = 0;
                    while (i < fvpa.length) {
                        if (rndf <= (f += fvpa[i].value())) {
                            return fvpa[i].form();
                        }
                        ++i;
                    }
                    return MapForm.RndTooHigh;
                }
                return MapForm.NoMapping;
            }

            @Override
            public Vector<Form> all(Form form1) {
                Vector<Form> forms = new Vector<Form>();
                if (hm.containsKey(form1)) {
                    FormValuePair[] fvpa = (FormValuePair[])hm.get(form1);
                    int i = 0;
                    while (i < fvpa.length) {
                        forms.add(fvpa[i].form());
                        ++i;
                    }
                } else {
                    forms.add(MapForm.NoMapping);
                }
                return forms;
            }
        };
    }

    public static final MapForm linearCombination(final MapForm mapform1, final double factor1, final MapForm mapform2, final double factor2) {
        return new MapForm(){

            @Override
            public Form first(Form form1) {
                if (!mapform1.first(form1).equals(MapForm.NoMapping)) {
                    return mapform1.first(form1);
                }
                return mapform2.first(form1);
            }

            @Override
            public Form next(Form form1, Form form_last) {
                if (!mapform1.first(form1).equals(MapForm.NoMapping)) {
                    Form f = mapform1.next(form1, form_last);
                    if (f.equals(MapForm.NoMapping)) {
                        return mapform2.first(form1);
                    }
                    return mapform1.next(form1, form_last);
                }
                return mapform2.next(form1, form_last);
            }

            @Override
            public Form random(Form form1, double rnd) {
                boolean mapform2Maps;
                boolean mapform1Maps = !mapform1.first(form1).equals(MapForm.NoMapping);
                boolean bl = mapform2Maps = !mapform2.first(form1).equals(MapForm.NoMapping);
                if (mapform1Maps && mapform2Maps) {
                    if (rnd < (factor1 + 0.0) / (factor1 + factor2)) {
                        return mapform1.random(form1, rnd * (factor1 + factor2 + 0.0) / factor1);
                    }
                    return mapform2.random(form1, (rnd * (factor1 + factor2 + 0.0) - factor1) / factor2);
                }
                if (mapform1Maps && !mapform2Maps) {
                    return mapform1.random(form1, rnd);
                }
                if (!mapform1Maps && mapform2Maps) {
                    return mapform2.random(form1, rnd);
                }
                return MapForm.NoMapping;
            }

            @Override
            public Vector<Form> all(Form form1) {
                if (mapform1.all(form1).contains(MapForm.InfiniteSet) || mapform2.all(form1).contains(MapForm.InfiniteSet)) {
                    Vector<Form> all = new Vector<Form>();
                    all.add(MapForm.InfiniteSet);
                    return all;
                }
                Vector all = (Vector)mapform1.all(form1).clone();
                for (Form f : mapform2.all(form1)) {
                    if (all.contains(f)) continue;
                    all.add(f);
                }
                return all;
            }
        };
    }

    public static final MapForm composition(final MapForm mapform1, final MapForm mapform2) {
        return new MapForm(){

            @Override
            public Form first(Form form1) {
                Form f2;
                Form f1 = mapform1.first(form1);
                if (f1.equals(MapForm.NoMapping)) {
                    return MapForm.NoMapping;
                }
                do {
                    f2 = mapform2.first(f1);
                    f1 = mapform1.next(form1, f1);
                } while (f2.equals(MapForm.NoMapping) && !f1.equals(MapForm.NoMoreForm));
                return f2;
            }

            @Override
            public Form next(Form form1, Form form_last) {
                boolean found = false;
                Vector<Form> F1 = new Vector<Form>();
                Vector<Form> F2 = new Vector<Form>();
                Form f1 = mapform1.first(form1);
                if (f1.equals(MapForm.NoMapping)) {
                    return MapForm.NoMapping;
                }
                F1.add(f1);
                Form f2 = mapform2.first(f1);
                if (f2.equals(MapForm.NoMapping)) {
                    F2.add(MapForm.NoMoreForm);
                } else {
                    F2.add(f2);
                    if (f2.equals(form_last)) {
                        found = true;
                    }
                }
                int size = 1;
                boolean m1_nomore = false;
                boolean m2_nomore = false;
                while (!m1_nomore || !m2_nomore) {
                    m2_nomore = true;
                    int i = 0;
                    while (i < size) {
                        f2 = (Form)F2.get(i);
                        if (!f2.equals(MapForm.NoMoreForm)) {
                            m2_nomore = false;
                            f2 = mapform2.next((Form)F1.get(i), f2);
                            F2.remove(i);
                            F2.add(i, f2);
                            if (!f2.equals(MapForm.NoMoreForm)) {
                                if (found) {
                                    return f2;
                                }
                                if (f2.equals(form_last)) {
                                    found = true;
                                }
                            }
                        } else if (i < size - 1) {
                            F1.remove(i);
                            F2.remove(i);
                            --i;
                            --size;
                        }
                        ++i;
                    }
                    if (m1_nomore) continue;
                    f1 = mapform1.next(form1, (Form)F1.lastElement());
                    if (f1.equals(MapForm.NoMoreForm)) {
                        m1_nomore = true;
                        continue;
                    }
                    F1.add(f1);
                    f2 = mapform2.first(f1);
                    if (f2.equals(MapForm.NoMapping)) {
                        F2.add(MapForm.NoMoreForm);
                    } else {
                        F2.add(f2);
                        if (found) {
                            return f2;
                        }
                        if (f2.equals(form_last)) {
                            found = true;
                        }
                    }
                    ++size;
                }
                return MapForm.NoMoreForm;
            }

            @Override
            public Form random(Form form1, double rnd) {
                if (rnd > 1.0) {
                    return MapForm.RndTooHigh;
                }
                if (rnd < 0.0) {
                    rnd = 0.0;
                }
                if (rnd == 1.0) {
                    rnd -= 1.0E-6;
                }
                long i = (long)(rnd * 9.223372036854776E18);
                int r1 = Math.abs((int)i);
                int r2 = (int)(i >>> 32);
                Form f1 = mapform1.random(form1, (double)r1 / 2.147483647E9);
                if (f1.equals(MapForm.NoMapping)) {
                    return MapForm.NoMapping;
                }
                return mapform2.random(f1, (double)r2 / 2.147483647E9);
            }

            @Override
            public Vector<Form> all(Form form1) {
                Vector<Form> v = new Vector<Form>();
                Vector<Form> v1 = mapform1.all(form1);
                Vector<Object> v2 = new Vector();
                if (v1.get(0).equals(MapForm.NoMapping)) {
                    v.add(MapForm.NoMapping);
                } else if (v1.get(0).equals(MapForm.InfiniteSet)) {
                    v.add(MapForm.InfiniteSet);
                } else {
                    for (Form f : v1) {
                        v2 = mapform2.all(f);
                        if (((Form)v2.get(0)).equals(MapForm.InfiniteSet)) {
                            v.clear();
                            v.add(MapForm.InfiniteSet);
                            return v;
                        }
                        if (((Form)v2.get(0)).equals(MapForm.NoMapping)) continue;
                        v.addAll(v2);
                    }
                }
                if (v.isEmpty()) {
                    v.add(MapForm.NoMapping);
                }
                return v;
            }
        };
    }

    public static final MapForm fromGen(final Gen gen) {
        return new MapForm(){

            @Override
            public Form first(Form form1) {
                return gen.firstCandidate((Form)form1).sf;
            }

            @Override
            public Form next(Form form1, Form form_last) {
                return gen.nextCandidate((Candidate)new Candidate((Form)form1, (Form)form_last)).sf;
            }

            @Override
            public Form random(Form form1, double rnd) {
                return gen.randomCandidate((Form)form1, (double)rnd).sf;
            }

            @Override
            public Vector<Form> all(Form form1) {
                Vector<Form> f = new Vector<Form>();
                for (Candidate c : gen.allCandidates(form1)) {
                    f.add(c.sf);
                }
                return f;
            }
        };
    }
}

