/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.grammarExamples;

import hu.birot.OTKit.dataType.Form;
import hu.birot.OTKit.dataType.MapForm;
import hu.birot.OTKit.dataType.violation.IntegerViolation;
import hu.birot.OTKit.dataType.violation.Violation;
import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Constraint;
import hu.birot.OTKit.otBuildingBlocks.Gen;
import hu.birot.OTKit.otBuildingBlocks.Grammar;
import hu.birot.OTKit.otBuildingBlocks.Topology;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class MetricalStress
extends Grammar {
    public char EOS = (char)46;
    private char[] vowels;
    private char[] consonants;
    public char BOF = (char)91;
    public char EOF = (char)93;
    public char PRS = (char)49;
    public char SCS = (char)50;
    public char LONG = (char)58;
    public char MORA = (char)181;
    public char SYLL = (char)963;
    public MapForm base = new MapForm(){

        @Override
        public Form first(Form f0) {
            return new Form("" + MetricalStress.this.vowels[0]);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Form next(Form f0, Form f) {
            block6: {
                last = MetricalStress.access$1(MetricalStress.this).size() - 1;
                s = f.string().replace(MetricalStress.this.EOS, MetricalStress.this.PRS).split("" + MetricalStress.this.PRS);
                found = false;
                i = s.length;
                while (!found && i > 0) {
                    p = MetricalStress.access$1(MetricalStress.this).indexOf(s[i - 1]);
                    if (p == -1) {
                        return MapForm.NotInRange;
                    }
                    if (p == last) {
                        --i;
                        continue;
                    }
                    s[i - 1] = (String)MetricalStress.access$1(MetricalStress.this).get(p + 1);
                    found = true;
                }
                n = "";
                if (found) ** GOTO lbl26
                i = s.length;
                while (i > 0) {
                    n = String.valueOf(n) + (String)MetricalStress.access$1(MetricalStress.this).get(0) + MetricalStress.this.EOS;
                    --i;
                }
                n = String.valueOf(n) + (String)MetricalStress.access$1(MetricalStress.this).get(0);
                break block6;
lbl-1000:
                // 1 sources

                {
                    s[i] = (String)MetricalStress.access$1(MetricalStress.this).get(0);
                    ++i;
lbl26:
                    // 2 sources

                    ** while (i < s.length)
                }
lbl27:
                // 1 sources

                var12_9 = s;
                var11_10 = s.length;
                var10_11 = 0;
                while (var10_11 < var11_10) {
                    syll = var12_9[var10_11];
                    n = String.valueOf(n) + syll + MetricalStress.this.EOS;
                    ++var10_11;
                }
                n = n.substring(0, n.length() - 1);
            }
            return new Form(n);
        }

        @Override
        public Form random(Form f0, double rnd) {
            if (rnd > 1.0) {
                return MapForm.RndTooHigh;
            }
            if (rnd < 0.0) {
                rnd = 0.0;
            } else if (rnd == 1.0) {
                rnd -= 1.0E-7;
            }
            rnd = 1.0 - rnd;
            double r = -Math.log(rnd) / Math.log(2.0);
            int l = 1 + (int)Math.floor(r);
            int a = MetricalStress.this.allURsyllables.size();
            int v = (int)Math.floor((rnd / Math.pow(2.0, -l) - 1.0) * Math.pow(a, l));
            String n = "";
            int i = l;
            while (i > 0) {
                n = String.valueOf(n) + (String)MetricalStress.this.allURsyllables.get(v % a) + MetricalStress.this.EOS;
                v /= a;
                --i;
            }
            return new Form(n.substring(0, n.length() - 1));
        }

        @Override
        public Vector<Form> all(Form form1) {
            Vector<Form> v = new Vector<Form>();
            v.add(MapForm.InfiniteSet);
            return v;
        }
    };
    private Vector<String> allURsyllables = new Vector();
    private Set<Character> vwls = new HashSet<Character>();
    private Set<Character> cons = new HashSet<Character>();
    public Gen gen = new Gen(){

        @Override
        public Candidate firstCandidate(Form uf) {
            String[] us = uf.string().replace(MetricalStress.this.EOS, MetricalStress.this.PRS).split("" + MetricalStress.this.PRS);
            String sf = "" + MetricalStress.this.BOF + MetricalStress.this.PRS + us[0] + MetricalStress.this.EOF;
            int i = 1;
            while (i < us.length) {
                sf = String.valueOf(sf) + MetricalStress.this.EOS + us[i];
                ++i;
            }
            return new Candidate(uf, new Form(sf));
        }

        @Override
        public Candidate nextCandidate(Candidate c) {
            Vector<Candidate> all = this.allCandidates(c.uf);
            if (all.get((int)0).sf.equals(MapForm.NoMapping)) {
                return all.get(0);
            }
            int i = all.indexOf(c);
            if (i == -1) {
                return new Candidate(c.uf, MapForm.NotInRange);
            }
            if (i == all.size() - 1) {
                return new Candidate(c.uf, MapForm.NoMoreForm);
            }
            return all.get(i + 1);
        }

        @Override
        public Candidate randomCandidate(Form uf, double rnd) {
            if (rnd > 1.0) {
                return new Candidate(uf, MapForm.RndTooHigh);
            }
            Vector<Candidate> all = this.allCandidates(uf);
            if (all.get((int)0).sf.equals(MapForm.NoMapping)) {
                return all.get(0);
            }
            if (rnd < 0.0) {
                rnd = 0.0;
            }
            if (rnd == 1.0) {
                rnd -= 1.0E-9;
            }
            return all.get((int)Math.floor(rnd * (double)all.size()));
        }

        @Override
        public Vector<Candidate> allCandidates(Form uf) {
            Vector<String> all = new Vector<String>();
            Vector<String> all1 = new Vector<String>();
            all.add("0");
            String[] us = uf.string().replace(MetricalStress.this.EOS, MetricalStress.this.PRS).split("" + MetricalStress.this.PRS);
            int i = 0;
            while (i < us.length) {
                all1.clear();
                for (String f : all) {
                    all1.add(f);
                }
                for (String f : all1) {
                    all.remove(f);
                    char state = f.charAt(0);
                    f = f.substring(1);
                    if (state == '0') {
                        all.add("5" + f + MetricalStress.this.EOS + MetricalStress.this.BOF + MetricalStress.this.PRS + us[i] + MetricalStress.this.EOF);
                        all.add("0" + f + MetricalStress.this.EOS + us[i]);
                        all.add("0" + f + MetricalStress.this.EOS + MetricalStress.this.BOF + MetricalStress.this.SCS + us[i] + MetricalStress.this.EOF);
                        all.add("7" + f + MetricalStress.this.EOS + MetricalStress.this.BOF + MetricalStress.this.PRS + us[i]);
                        all.add("2" + f + MetricalStress.this.EOS + MetricalStress.this.BOF + MetricalStress.this.SCS + us[i]);
                        all.add("1" + f + MetricalStress.this.EOS + MetricalStress.this.BOF + us[i]);
                    }
                    if (state == '1') {
                        all.add("5" + f + MetricalStress.this.EOS + MetricalStress.this.PRS + us[i] + MetricalStress.this.EOF);
                        all.add("0" + f + MetricalStress.this.EOS + MetricalStress.this.SCS + us[i] + MetricalStress.this.EOF);
                    }
                    if (state == '2') {
                        all.add("0" + f + MetricalStress.this.EOS + us[i] + MetricalStress.this.EOF);
                    }
                    if (state == '5') {
                        all.add("5" + f + MetricalStress.this.EOS + us[i]);
                        all.add("5" + f + MetricalStress.this.EOS + MetricalStress.this.BOF + MetricalStress.this.SCS + us[i] + MetricalStress.this.EOF);
                        all.add("7" + f + MetricalStress.this.EOS + MetricalStress.this.BOF + MetricalStress.this.SCS + us[i]);
                        all.add("6" + f + MetricalStress.this.EOS + MetricalStress.this.BOF + us[i]);
                    }
                    if (state == '6') {
                        all.add("5" + f + MetricalStress.this.EOS + MetricalStress.this.SCS + us[i] + MetricalStress.this.EOF);
                    }
                    if (state != '7') continue;
                    all.add("5" + f + MetricalStress.this.EOS + us[i] + MetricalStress.this.EOF);
                }
                ++i;
            }
            Vector<Candidate> allc = new Vector<Candidate>();
            for (String f : all) {
                if (f.charAt(0) != '5') continue;
                allc.add(new Candidate(uf, new Form(f.substring(2))));
            }
            return allc;
        }
    };
    public Topology topology = new Topology(){

        @Override
        public Candidate rndNeighborOf(Candidate c, double rnd) {
            if (rnd > 1.0) {
                return new Candidate(c.uf, MapForm.RndTooHigh);
            }
            Vector<Candidate> all = this.allNeighborsOf(c);
            if (all.get((int)0).sf.equals(MapForm.NoMapping)) {
                return all.get(0);
            }
            if (rnd < 0.0) {
                rnd = 0.0;
            }
            if (rnd == 1.0) {
                rnd -= 1.0E-9;
            }
            return all.get((int)Math.floor(rnd * (double)all.size()));
        }

        @Override
        public Candidate firstNeighborOf(Candidate c) {
            Vector<Candidate> all = this.allNeighborsOf(c);
            if (all.get((int)0).sf.equals(MapForm.NoMapping)) {
                return all.get(0);
            }
            if (all.isEmpty()) {
                return new Candidate(c.uf, MapForm.NoMapping);
            }
            return all.get(0);
        }

        @Override
        public Candidate nextNeighborOf(Candidate c, Candidate c0) {
            if (!c.uf.equals(c0.uf)) {
                return new Candidate(new Form(), MapForm.NotInRange);
            }
            Vector<Candidate> all = this.allNeighborsOf(c);
            if (all.get((int)0).sf.equals(MapForm.NoMapping)) {
                return all.get(0);
            }
            int i = all.indexOf(c0);
            if (i == -1) {
                return new Candidate(c.uf, MapForm.NotInRange);
            }
            if (i == all.size() - 1) {
                return new Candidate(c.uf, MapForm.NoMoreForm);
            }
            return all.get(i + 1);
        }

        @Override
        public Vector<Candidate> allNeighborsOf(Candidate c) {
            Vector<Candidate> neighborhood = new Vector<Candidate>();
            Form uf = c.uf;
            String surfacestring = c.sf.string();
            Vector<String> sf = new Vector<String>();
            String str = "";
            char[] cArray = surfacestring.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char ch = cArray[n2];
                if (ch == MetricalStress.this.EOS) {
                    sf.add(str);
                    str = "";
                } else {
                    str = String.valueOf(str) + ch;
                }
                ++n2;
            }
            sf.add(str);
            int sfsize = sf.size();
            int place_of_PRS = 0;
            int i = 0;
            while (i < sfsize) {
                if (((String)sf.get(i)).contains("" + MetricalStress.this.PRS)) {
                    place_of_PRS = i;
                    i = sfsize;
                }
                ++i;
            }
            Vector<String[]> neighbors = new Vector<String[]>();
            Object[] copy = new String[sfsize];
            int i2 = 0;
            while (i2 < sfsize) {
                str = (String)sf.get(i2);
                if (MetricalStress.this.is_unparsed(str)) {
                    sf.copyInto(copy);
                    copy[i2] = "" + MetricalStress.this.BOF + MetricalStress.this.SCS + str + MetricalStress.this.EOF;
                    neighbors.add((String[])copy.clone());
                } else if (str.startsWith("" + MetricalStress.this.BOF + MetricalStress.this.PRS) && str.endsWith("" + MetricalStress.this.EOF)) {
                    if (i2 > 0 && MetricalStress.this.is_unparsed((String)sf.get(i2 - 1))) {
                        sf.copyInto(copy);
                        copy[i2 - 1] = String.valueOf(MetricalStress.this.BOF) + (String)copy[i2 - 1];
                        copy[i2] = ((String)copy[i2]).substring(1);
                        neighbors.add((String[])copy.clone());
                    }
                    if (i2 < sfsize - 1 && MetricalStress.this.is_unparsed((String)sf.get(i2 + 1))) {
                        sf.copyInto(copy);
                        copy[i2] = ((String)copy[i2]).substring(0, ((String)copy[i2]).length() - 1);
                        copy[i2 + 1] = String.valueOf(copy[i2 + 1]) + MetricalStress.this.EOF;
                        neighbors.add((String[])copy.clone());
                    }
                } else if (str.startsWith("" + MetricalStress.this.BOF + MetricalStress.this.SCS) && str.endsWith("" + MetricalStress.this.EOF)) {
                    sf.copyInto(copy);
                    copy[i2] = ((String)copy[i2]).substring(2, ((String)copy[i2]).length() - 1);
                    neighbors.add((String[])copy.clone());
                    if (i2 > 0 && MetricalStress.this.is_unparsed((String)sf.get(i2 - 1))) {
                        sf.copyInto(copy);
                        copy[i2 - 1] = String.valueOf(MetricalStress.this.BOF) + (String)copy[i2 - 1];
                        copy[i2] = ((String)copy[i2]).substring(1);
                        neighbors.add((String[])copy.clone());
                    }
                    if (i2 < sfsize - 1 && MetricalStress.this.is_unparsed((String)sf.get(i2 + 1))) {
                        sf.copyInto(copy);
                        copy[i2] = ((String)copy[i2]).substring(0, ((String)copy[i2]).length() - 1);
                        copy[i2 + 1] = String.valueOf(copy[i2 + 1]) + MetricalStress.this.EOF;
                        neighbors.add((String[])copy.clone());
                    }
                    sf.copyInto(copy);
                    copy[i2] = ((String)copy[i2]).replace(MetricalStress.this.SCS, MetricalStress.this.PRS);
                    copy[place_of_PRS] = ((String)copy[place_of_PRS]).replace(MetricalStress.this.PRS, MetricalStress.this.SCS);
                    neighbors.add((String[])copy.clone());
                } else if (str.startsWith("" + MetricalStress.this.BOF + MetricalStress.this.PRS)) {
                    sf.copyInto(copy);
                    copy[i2] = String.valueOf(copy[i2]) + MetricalStress.this.EOF;
                    copy[i2 + 1] = ((String)copy[i2 + 1]).substring(0, ((String)copy[i2 + 1]).length() - 1);
                    neighbors.add((String[])copy.clone());
                    sf.copyInto(copy);
                    copy[i2] = String.valueOf(MetricalStress.this.BOF) + ((String)copy[i2]).substring(2);
                    copy[i2 + 1] = String.valueOf(MetricalStress.this.PRS) + (String)copy[i2 + 1];
                    neighbors.add((String[])copy.clone());
                } else if (str.startsWith("" + MetricalStress.this.BOF + MetricalStress.this.SCS)) {
                    sf.copyInto(copy);
                    copy[i2] = String.valueOf(copy[i2]) + MetricalStress.this.EOF;
                    copy[i2 + 1] = ((String)copy[i2 + 1]).substring(0, ((String)copy[i2 + 1]).length() - 1);
                    neighbors.add((String[])copy.clone());
                    sf.copyInto(copy);
                    copy[i2] = String.valueOf(MetricalStress.this.BOF) + ((String)copy[i2]).substring(2);
                    copy[i2 + 1] = String.valueOf(MetricalStress.this.SCS) + (String)copy[i2 + 1];
                    neighbors.add((String[])copy.clone());
                    sf.copyInto(copy);
                    copy[i2] = ((String)copy[i2]).replace(MetricalStress.this.SCS, MetricalStress.this.PRS);
                    copy[place_of_PRS] = ((String)copy[place_of_PRS]).replace(MetricalStress.this.PRS, MetricalStress.this.SCS);
                    neighbors.add((String[])copy.clone());
                } else if (str.startsWith("" + MetricalStress.this.PRS)) {
                    sf.copyInto(copy);
                    copy[i2 - 1] = ((String)copy[i2 - 1]).substring(1);
                    copy[i2] = String.valueOf(MetricalStress.this.BOF) + (String)copy[i2];
                    neighbors.add((String[])copy.clone());
                    sf.copyInto(copy);
                    copy[i2 - 1] = "" + MetricalStress.this.BOF + MetricalStress.this.PRS + ((String)copy[i2 - 1]).substring(1);
                    copy[i2] = ((String)copy[i2]).substring(1);
                    neighbors.add((String[])copy.clone());
                } else if (str.startsWith("" + MetricalStress.this.SCS)) {
                    sf.copyInto(copy);
                    copy[i2 - 1] = ((String)copy[i2 - 1]).substring(1);
                    copy[i2] = String.valueOf(MetricalStress.this.BOF) + (String)copy[i2];
                    neighbors.add((String[])copy.clone());
                    sf.copyInto(copy);
                    copy[i2 - 1] = "" + MetricalStress.this.BOF + MetricalStress.this.SCS + ((String)copy[i2 - 1]).substring(1);
                    copy[i2] = ((String)copy[i2]).substring(1);
                    neighbors.add((String[])copy.clone());
                    sf.copyInto(copy);
                    copy[i2] = ((String)copy[i2]).replace(MetricalStress.this.SCS, MetricalStress.this.PRS);
                    copy[place_of_PRS] = ((String)copy[place_of_PRS]).replace(MetricalStress.this.PRS, MetricalStress.this.SCS);
                    neighbors.add((String[])copy.clone());
                }
                ++i2;
            }
            for (String[] surf : neighbors) {
                str = "";
                String[] stringArray = surf;
                int n3 = surf.length;
                int n4 = 0;
                while (n4 < n3) {
                    String s = stringArray[n4];
                    str = String.valueOf(str) + MetricalStress.this.EOS + s;
                    ++n4;
                }
                neighborhood.add(new Candidate(uf, new Form(str.substring(1))));
            }
            return neighborhood;
        }
    };
    public MapForm utter = new MapForm(){

        @Override
        public Form first(Form form1) {
            return MetricalStress.this.surf2overt(form1);
        }

        @Override
        public Form random(Form form1, double rnd) {
            if (rnd > 1.0) {
                return MapForm.RndTooHigh;
            }
            return MetricalStress.this.surf2overt(form1);
        }

        @Override
        public Form next(Form form1, Form form_last) {
            if (MetricalStress.this.surf2overt(form1).equals(form_last)) {
                return MapForm.NoMoreForm;
            }
            return MapForm.NotInRange;
        }

        @Override
        public Vector<Form> all(Form form1) {
            Vector<Form> v = new Vector<Form>();
            v.add(MetricalStress.this.surf2overt(form1));
            return v;
        }
    };
    public Gen rip = new Gen(){

        @Override
        public Candidate firstCandidate(Form overtform) {
            Vector<Candidate> all = this.allCandidates(overtform);
            if (all.get((int)0).sf.equals(MapForm.NoMapping)) {
                return all.get(0);
            }
            return all.get(0);
        }

        @Override
        public Candidate nextCandidate(Candidate c) {
            Vector<Candidate> all = this.allCandidates(MetricalStress.this.surf2overt(c.sf));
            if (all.get((int)0).sf.equals(MapForm.NoMapping)) {
                return all.get(0);
            }
            int i = all.indexOf(c);
            if (i == -1) {
                return new Candidate(c.uf, MapForm.NotInRange);
            }
            if (i == all.size() - 1) {
                return new Candidate(c.uf, MapForm.NoMoreForm);
            }
            return all.get(i + 1);
        }

        @Override
        public Candidate randomCandidate(Form overtform, double rnd) {
            if (rnd > 1.0) {
                return new Candidate(MetricalStress.this.overt2underl(overtform), MapForm.RndTooHigh);
            }
            Vector<Candidate> all = this.allCandidates(overtform);
            if (all.get((int)0).sf.equals(MapForm.NoMapping)) {
                return all.get(0);
            }
            if (rnd < 0.0) {
                rnd = 0.0;
            }
            if (rnd == 1.0) {
                rnd -= 1.0E-9;
            }
            return all.get((int)Math.floor(rnd * (double)all.size()));
        }

        @Override
        public Vector<Candidate> allCandidates(Form overtform) {
            Vector<String> of = new Vector<String>();
            String str = "";
            char[] cArray = overtform.string().toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char ch = cArray[n2];
                if (ch == MetricalStress.this.EOS) {
                    of.add(str);
                    str = "";
                } else {
                    str = String.valueOf(str) + ch;
                }
                ++n2;
            }
            of.add(str);
            Vector<String> sforms = new Vector<String>();
            Vector<String> sform1 = new Vector<String>();
            sforms.add("0");
            for (String syllable : of) {
                String suffix;
                char state;
                sform1.clear();
                for (String s : sforms) {
                    sform1.add(s);
                }
                sforms.clear();
                if (syllable.charAt(0) == MetricalStress.this.PRS || syllable.charAt(0) == MetricalStress.this.SCS) {
                    for (String sf : sform1) {
                        state = sf.charAt(0);
                        suffix = sf.substring(1);
                        if (state == '0') {
                            sforms.add("0" + suffix + MetricalStress.this.EOS + MetricalStress.this.BOF + syllable + MetricalStress.this.EOF);
                            sforms.add("2" + suffix + MetricalStress.this.EOS + MetricalStress.this.BOF + syllable);
                            continue;
                        }
                        if (state != '1') continue;
                        sforms.add("0" + suffix + MetricalStress.this.EOS + syllable + MetricalStress.this.EOF);
                    }
                    continue;
                }
                for (String sf : sform1) {
                    state = sf.charAt(0);
                    suffix = sf.substring(1);
                    if (state == '0') {
                        sforms.add("0" + suffix + MetricalStress.this.EOS + syllable);
                        sforms.add("1" + suffix + MetricalStress.this.EOS + MetricalStress.this.BOF + syllable);
                        continue;
                    }
                    if (state != '2') continue;
                    sforms.add("0" + suffix + MetricalStress.this.EOS + syllable + MetricalStress.this.EOF);
                }
            }
            Vector<Candidate> allc = new Vector<Candidate>();
            for (String sf : sforms) {
                if (sf.charAt(0) != '0') continue;
                allc.add(new Candidate(MetricalStress.this.overt2underl(overtform), new Form(sf.substring(2))));
            }
            return allc;
        }
    };
    public static final String PARSE = "ParseSyll";
    public static final String BINARY = "FtBin";
    public static final String UNIT_SYLL = "s";
    public static final String UNIT_MORA = "m";
    public static final String NONFINAL = "NonFinality";
    public static final String NONFINALSTRESS = "NonFinalStress";
    public static final String NOCLASH = "*Clash";
    public static final String NOLAPSE = "*Lapse";
    public static final String STRESS_TO_WEIGHT = "Stress2weight";
    public static final String WSP = "WSP";
    public static final int RHTYPE_LEFT = 1;
    public static final int RHTYPE_RIGHT = 2;
    public static final int RHTYPE_NONLEFT = 3;
    public static final int RHTYPE_NONRIGHT = 4;
    public static final String RHTYPE = "RhytmType";
    public static final String ALIGNMENT = "Align";
    public static final String ALIGN_OBJECT_MAINFOOT = "MainFoot";
    public static final String ALIGN_OBJECT_ALLFEET = "AllFeet";
    public static final String ALIGN_CONTAINER_PRWORD = "PrWord";
    public static final String ALIGN_DIRECTION_LEFT = "Left";
    public static final String ALIGN_DIRECTION_RIGHT = "Right";
    public static final String ALIGN_UNIT_SYLLABLE = "s";
    public static final String ALIGN_UNIT_MORA = "m";
    public static final String QALIGNMENT = "QuantAlign";
    public static final int LONGNUCLEUS = 1;
    public static final int CODA = 2;
    public static final int COMPLEXCODA = 4;
    public static final int LONGNUCLEUS_AND_CODA = 8;
    public static final int LONGNUCLEUS_AND_COMPLEXCODA = 16;

    public MetricalStress() {
        char[] vowellist = new char[]{'a', 'e', 'i', 'o', 'u'};
        char[] consonantlist = new char[]{'b', 'c', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm', 'n', 'p', 'q', 'r', 's', 't', 'v', 'w', 'x', 'y', 'z'};
        this.vowels = vowellist;
        this.consonants = consonantlist;
        this.createAllURsyllables();
        this.createVwlsCons();
    }

    public MetricalStress(char[] vowellist, char[] consonantlist) {
        this.vowels = vowellist;
        this.consonants = consonantlist;
        this.createAllURsyllables();
        this.createVwlsCons();
    }

    private void createAllURsyllables() {
        this.allURsyllables.clear();
        char[] cArray = this.vowels;
        int n = this.vowels.length;
        int n2 = 0;
        while (n2 < n) {
            char v = cArray[n2];
            this.allURsyllables.add("" + v);
            char[] cArray2 = this.consonants;
            int n3 = this.consonants.length;
            int n4 = 0;
            while (n4 < n3) {
                char c1 = cArray2[n4];
                this.allURsyllables.add("" + c1 + v);
                this.allURsyllables.add("" + v + c1);
                char[] cArray3 = this.consonants;
                int n5 = this.consonants.length;
                int n6 = 0;
                while (n6 < n5) {
                    char c2 = cArray3[n6];
                    this.allURsyllables.add("" + c1 + v + c2);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void createVwlsCons() {
        char[] cArray = this.vowels;
        int n = this.vowels.length;
        int n2 = 0;
        while (n2 < n) {
            char v = cArray[n2];
            this.vwls.add(Character.valueOf(v));
            ++n2;
        }
        cArray = this.consonants;
        n = this.consonants.length;
        n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            this.cons.add(Character.valueOf(c));
            ++n2;
        }
    }

    private boolean is_unparsed(String syll) {
        return !syll.startsWith("" + this.BOF) && !syll.endsWith("" + this.EOF);
    }

    private Form overt2underl(Form of) {
        String u = "";
        char[] cArray = of.string().toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c != this.PRS && c != this.SCS) {
                u = String.valueOf(u) + c;
            }
            ++n2;
        }
        return new Form(u);
    }

    private Form surf2overt(Form of) {
        String u = "";
        char[] cArray = of.string().toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c != this.BOF && c != this.EOF) {
                u = String.valueOf(u) + c;
            }
            ++n2;
        }
        return new Form(u);
    }

    public Constraint Parse() {
        return new Constraint(PARSE, "Assign one violation mark per syllable unparsed into a foot."){

            public Violation value(Candidate c) {
                String s = c.sf.string();
                int nr_of_feet = 0;
                int nr_of_binary_feet = 0;
                int nr_of_syllables = 1;
                boolean within_foot = false;
                char[] cArray = s.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char b = cArray[n2];
                    if (b == MetricalStress.this.BOF) {
                        within_foot = true;
                        ++nr_of_feet;
                    } else if (b == MetricalStress.this.EOF) {
                        within_foot = false;
                    }
                    if (within_foot && b == MetricalStress.this.EOS) {
                        ++nr_of_binary_feet;
                    }
                    if (b == MetricalStress.this.EOS) {
                        ++nr_of_syllables;
                    }
                    ++n2;
                }
                return IntegerViolation.v(nr_of_syllables - nr_of_feet - nr_of_binary_feet);
            }
        };
    }

    public Constraint Binary() {
        return new Constraint(BINARY, "Assign one violation mark per foot that is composed of a single syllable."){

            public Violation value(Candidate c) {
                String s = c.sf.string();
                int nr_of_feet = 0;
                int nr_of_binary_feet = 0;
                boolean within_foot = false;
                char[] cArray = s.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char b = cArray[n2];
                    if (b == MetricalStress.this.BOF) {
                        within_foot = true;
                        ++nr_of_feet;
                    } else if (b == MetricalStress.this.EOF) {
                        within_foot = false;
                    } else if (within_foot && b == MetricalStress.this.EOS) {
                        ++nr_of_binary_feet;
                    }
                    ++n2;
                }
                return IntegerViolation.v(nr_of_feet - nr_of_binary_feet);
            }
        };
    }

    public Constraint Binary(String unit) {
        int init_value;
        char ch;
        if (unit.equals("m")) {
            ch = this.MORA;
            init_value = -2;
        } else if (unit.equals("s")) {
            ch = this.EOS;
            init_value = -1;
        } else {
            throw new RuntimeException("Definition of constraint Binary: unknown parameter.");
        }
        return new Constraint("FtBin(" + unit + ")", "Assign one violation mark per foot that does not contain at least two " + unit + "s."){

            public Violation value(Candidate c) {
                String s = c.sf.string();
                int v = 0;
                int count = 0;
                boolean within_foot = false;
                char[] cArray = s.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char b = cArray[n2];
                    if (b == MetricalStress.this.BOF) {
                        within_foot = true;
                        count = init_value;
                    } else if (within_foot && b == ch) {
                        ++count;
                    } else if (b == MetricalStress.this.EOF) {
                        within_foot = false;
                        if (count < 0) {
                            ++v;
                        }
                    }
                    ++n2;
                }
                return IntegerViolation.v(v);
            }
        };
    }

    public Constraint BinaryMoraic(final int heavy) {
        return new Constraint("FtBin(Moraic)", "Assign one violation mark to every foot containing a single non-heavy syllable."){

            public Violation value(Candidate c) {
                String s = String.valueOf(c.sf.string()) + MetricalStress.this.EOS;
                int v = 0;
                String syll = "";
                boolean in_monosyllabic_foot = true;
                char[] cArray = s.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char b = cArray[n2];
                    if (b == MetricalStress.this.BOF) {
                        in_monosyllabic_foot = true;
                        syll = "";
                    } else if (in_monosyllabic_foot & b == MetricalStress.this.EOS) {
                        in_monosyllabic_foot = false;
                    } else if (in_monosyllabic_foot & b == MetricalStress.this.EOF) {
                        if (!MetricalStress.this.parseSyll(syll, heavy)) {
                            ++v;
                        }
                        in_monosyllabic_foot = false;
                    } else if (in_monosyllabic_foot) {
                        syll = String.valueOf(syll) + b;
                    }
                    ++n2;
                }
                return IntegerViolation.v(v);
            }
        };
    }

    public Constraint NonFinal() {
        return new Constraint(NONFINAL, "Assign one violation mark if the last syllable is footed, no violation if it is unfooted."){
            final String eof;
            {
                this.eof = "" + MetricalStress.this.EOF;
            }

            public Violation value(Candidate c) {
                if (c.sf.string().endsWith(this.eof)) {
                    return IntegerViolation.oneViolation;
                }
                return IntegerViolation.nullViolation;
            }
        };
    }

    public Constraint NonFinalStress() {
        return new Constraint(NONFINALSTRESS, "Assign one violation mark if the last syllable is stressed, no violation if it is not stressed."){

            public Violation value(Candidate c) {
                boolean lastfinal = false;
                String s = c.sf.string();
                char[] cArray = s.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char b = cArray[n2];
                    if (b == MetricalStress.this.EOS) {
                        lastfinal = false;
                    } else if (b == MetricalStress.this.PRS) {
                        lastfinal = true;
                    } else if (b == MetricalStress.this.SCS) {
                        lastfinal = true;
                    }
                    ++n2;
                }
                if (lastfinal) {
                    return IntegerViolation.oneViolation;
                }
                return IntegerViolation.nullViolation;
            }
        };
    }

    public Constraint NoClash() {
        return new Constraint(NOCLASH, "Assign one violation mark to any stressed syllable that is immediately preceded by another stressed syllable."){

            public Violation value(Candidate c) {
                int v = 0;
                boolean previous_syllable_stressed = false;
                boolean this_syllable_stressed = false;
                String s = c.sf.string();
                char[] cArray = s.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char b = cArray[n2];
                    if (b == MetricalStress.this.EOS) {
                        previous_syllable_stressed = this_syllable_stressed;
                        this_syllable_stressed = false;
                    } else if (b == MetricalStress.this.PRS || b == MetricalStress.this.SCS) {
                        this_syllable_stressed = true;
                        if (previous_syllable_stressed) {
                            ++v;
                        }
                    }
                    ++n2;
                }
                return IntegerViolation.v(v);
            }
        };
    }

    public Constraint NoLapse() {
        return new Constraint(NOLAPSE, "Assign one violation mark to any unstressed syllable that is not adjacent to a stressed syllable or to a word edge."){

            public Violation value(Candidate c) {
                int v = 0;
                boolean two_before_stressed = true;
                boolean previous_syllable_stressed = true;
                boolean this_syllable_stressed = false;
                String s = c.sf.string();
                char[] cArray = s.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char b = cArray[n2];
                    if (b == MetricalStress.this.EOS) {
                        if (!(two_before_stressed || previous_syllable_stressed || this_syllable_stressed)) {
                            ++v;
                        }
                        two_before_stressed = previous_syllable_stressed;
                        previous_syllable_stressed = this_syllable_stressed;
                        this_syllable_stressed = false;
                    } else if (b == MetricalStress.this.PRS || b == MetricalStress.this.SCS) {
                        this_syllable_stressed = true;
                    }
                    ++n2;
                }
                if (!(two_before_stressed || previous_syllable_stressed || this_syllable_stressed)) {
                    ++v;
                }
                return IntegerViolation.v(v);
            }
        };
    }

    public Constraint Stress_to_weight(final int heavy) {
        return new Constraint(STRESS_TO_WEIGHT + heavy, "Assign one violation mark to every stressed syllable that is not heavy."){

            public Violation value(Candidate c) {
                String s = String.valueOf(c.sf.string()) + MetricalStress.this.EOS;
                int v = 0;
                String syll = "";
                boolean nucleus_reached = false;
                boolean stressed = false;
                char[] cArray = s.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char b = cArray[n2];
                    if (b == MetricalStress.this.EOS || b == MetricalStress.this.EOF) {
                        if (nucleus_reached) {
                            if (!MetricalStress.this.parseSyll(syll, heavy) && stressed) {
                                ++v;
                            }
                            nucleus_reached = false;
                            stressed = false;
                            syll = "";
                        }
                    } else if (b == MetricalStress.this.PRS || b == MetricalStress.this.SCS) {
                        stressed = true;
                    } else if (!nucleus_reached && MetricalStress.this.vwls.contains(Character.valueOf(b))) {
                        nucleus_reached = true;
                        syll = "" + b;
                    } else if (nucleus_reached) {
                        syll = String.valueOf(syll) + b;
                    }
                    ++n2;
                }
                return IntegerViolation.v(v);
            }
        };
    }

    public Constraint WSP(final int heavy) {
        return new Constraint(WSP + heavy, "Assign one violation mark to every heavy syllable that is not stressed."){

            public Violation value(Candidate c) {
                String s = String.valueOf(c.sf.string()) + MetricalStress.this.EOS;
                int v = 0;
                String syll = "";
                boolean nucleus_reached = false;
                boolean stressed = false;
                char[] cArray = s.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char b = cArray[n2];
                    if (b == MetricalStress.this.EOS || b == MetricalStress.this.EOF) {
                        if (nucleus_reached) {
                            if (MetricalStress.this.parseSyll(syll, heavy) && !stressed) {
                                ++v;
                            }
                            nucleus_reached = false;
                            stressed = false;
                            syll = "";
                        }
                    } else if (b == MetricalStress.this.PRS || b == MetricalStress.this.SCS) {
                        stressed = true;
                    } else if (!nucleus_reached && MetricalStress.this.vwls.contains(Character.valueOf(b))) {
                        nucleus_reached = true;
                        syll = "" + b;
                    } else if (nucleus_reached) {
                        syll = String.valueOf(syll) + b;
                    }
                    ++n2;
                }
                return IntegerViolation.v(v);
            }
        };
    }

    public Constraint RhType(int type) {
        final int[] t = new int[3];
        if (type == 1) {
            t[0] = 0;
            t[1] = 1;
            t[2] = 0;
        } else if (type == 2) {
            t[0] = 0;
            t[1] = 0;
            t[2] = 1;
        } else if (type == 3) {
            t[0] = 1;
            t[1] = 0;
            t[2] = 1;
        } else if (type == 4) {
            t[0] = 1;
            t[1] = 1;
            t[2] = 0;
        } else {
            throw new RuntimeException("Definition of constraint Rhythm Type: unknown parameter.");
        }
        String[] name = new String[]{"(left)", "(right)", "(non-left)", "(non-right)"};
        return new Constraint(RHTYPE + name[type - 1], "Assign one violation mark to every foot not belonging to the given rhythm type."){

            public Violation value(Candidate c) {
                int v = 0;
                boolean syllable_stressed = false;
                boolean within_foot = false;
                boolean binary_foot = false;
                String s = c.sf.string();
                char[] cArray = s.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char b = cArray[n2];
                    if (b == MetricalStress.this.BOF) {
                        within_foot = true;
                        binary_foot = false;
                    } else if (within_foot && b == MetricalStress.this.EOS) {
                        binary_foot = true;
                    } else if (binary_foot && (b == MetricalStress.this.PRS || b == MetricalStress.this.SCS)) {
                        syllable_stressed = true;
                    } else if (within_foot && b == MetricalStress.this.EOF) {
                        v = !binary_foot ? (v += t[0]) : (syllable_stressed ? (v += t[1]) : (v += t[2]));
                        within_foot = false;
                        syllable_stressed = false;
                        binary_foot = false;
                    }
                    ++n2;
                }
                return IntegerViolation.v(v);
            }
        };
    }

    public Constraint Alignment(String object, String container, String direction, String unit) {
        char u;
        String cnstrname = "Align(" + object + ", " + container + ", " + direction + ", " + unit + ")";
        String cnstrdescr = "Align object " + object + " to container " + container + " in direction " + direction + ", distance measured in units of " + unit + ".";
        if (unit.equals("s")) {
            u = this.EOS;
        } else if (unit.equals("m")) {
            u = this.MORA;
        } else {
            throw new RuntimeException("Definition of constraint Align: unknown unit parameter.");
        }
        if (object.equals(ALIGN_OBJECT_MAINFOOT) && direction.equals(ALIGN_DIRECTION_LEFT) && container.equals(ALIGN_CONTAINER_PRWORD)) {
            return new Constraint(cnstrname, cnstrdescr){

                public Violation value(Candidate can) {
                    int v = 0;
                    int number_of_syllables_so_far = 0;
                    int number_of_syllables_until_latest_bracket = 0;
                    char[] s = can.sf.string().toCharArray();
                    int l = s.length;
                    int i = 0;
                    while (i < l) {
                        char b = s[i];
                        if (b == u) {
                            ++number_of_syllables_so_far;
                        } else if (b == MetricalStress.this.BOF) {
                            number_of_syllables_until_latest_bracket = number_of_syllables_so_far;
                        } else if (b == MetricalStress.this.PRS) {
                            v = number_of_syllables_until_latest_bracket;
                            i = l;
                        }
                        ++i;
                    }
                    return IntegerViolation.v(v);
                }
            };
        }
        if (object.equals(ALIGN_OBJECT_MAINFOOT) && direction.equals(ALIGN_DIRECTION_RIGHT) && container.equals(ALIGN_CONTAINER_PRWORD)) {
            return new Constraint(cnstrname, cnstrdescr){

                public Violation value(Candidate can) {
                    int v = 0;
                    int number_of_syllables_so_far = 0;
                    int number_of_syllables_until_latest_bracket = 0;
                    char[] s = can.sf.string().toCharArray();
                    int i = s.length;
                    while (i > 0) {
                        char b = s[i - 1];
                        if (b == u) {
                            ++number_of_syllables_so_far;
                        } else if (b == MetricalStress.this.EOF) {
                            number_of_syllables_until_latest_bracket = number_of_syllables_so_far;
                        } else if (b == MetricalStress.this.PRS) {
                            v = number_of_syllables_until_latest_bracket;
                            i = 0;
                        }
                        --i;
                    }
                    return IntegerViolation.v(v);
                }
            };
        }
        if (object.equals(ALIGN_OBJECT_ALLFEET) && direction.equals(ALIGN_DIRECTION_LEFT) && container.equals(ALIGN_CONTAINER_PRWORD)) {
            return new Constraint(cnstrname, cnstrdescr){

                public Violation value(Candidate can) {
                    int v = 0;
                    int number_of_syllables_so_far = 0;
                    char[] s = can.sf.string().toCharArray();
                    int l = s.length;
                    int i = 0;
                    while (i < l) {
                        char b = s[i];
                        if (b == u) {
                            ++number_of_syllables_so_far;
                        } else if (b == MetricalStress.this.BOF) {
                            v += number_of_syllables_so_far;
                        }
                        ++i;
                    }
                    return IntegerViolation.v(v);
                }
            };
        }
        if (object.equals(ALIGN_OBJECT_ALLFEET) && direction.equals(ALIGN_DIRECTION_RIGHT) && container.equals(ALIGN_CONTAINER_PRWORD)) {
            return new Constraint(cnstrname, cnstrdescr){

                public Violation value(Candidate can) {
                    int v = 0;
                    int number_of_syllables_so_far = 0;
                    char[] s = can.sf.string().toCharArray();
                    int i = s.length;
                    while (i > 0) {
                        char b = s[i - 1];
                        if (b == u) {
                            ++number_of_syllables_so_far;
                        } else if (b == MetricalStress.this.EOF) {
                            v += number_of_syllables_so_far;
                        }
                        --i;
                    }
                    return IntegerViolation.v(v);
                }
            };
        }
        throw new RuntimeException("Definition of constraint Align: unknown parameters.");
    }

    public Constraint QAlignment(String object, String container, String direction, String unit) {
        char u;
        String cnstrname = "QuantAlign(" + object + ", " + container + ", " + direction + ", " + unit + ")";
        String cnstrdescr = "Align object " + object + " to container " + container + " in direction " + direction + ", quantized distance measured in units of " + unit + ".";
        if (unit.equals("s")) {
            u = this.EOS;
        } else if (unit.equals("m")) {
            u = this.MORA;
        } else {
            throw new RuntimeException("Definition of constraint QAlign: unknown unit parameter.");
        }
        if (object.equals(ALIGN_OBJECT_MAINFOOT) && direction.equals(ALIGN_DIRECTION_LEFT) && container.equals(ALIGN_CONTAINER_PRWORD)) {
            return new Constraint(cnstrname, cnstrdescr){

                public Violation value(Candidate can) {
                    int v = 0;
                    boolean quantized_distance_so_far = false;
                    boolean quantized_distance_until_latest_bracket = false;
                    char[] s = can.sf.string().toCharArray();
                    int l = s.length;
                    int i = 0;
                    while (i < l) {
                        char b = s[i];
                        if (b == u) {
                            quantized_distance_so_far = true;
                        } else if (b == MetricalStress.this.BOF) {
                            quantized_distance_until_latest_bracket = quantized_distance_so_far;
                        } else if (b == MetricalStress.this.PRS) {
                            if (quantized_distance_until_latest_bracket) {
                                ++v;
                            }
                            i = l;
                        } else if (b == MetricalStress.this.EOF) {
                            v = 1;
                            i = l;
                        }
                        ++i;
                    }
                    return IntegerViolation.v(v);
                }
            };
        }
        if (object.equals(ALIGN_OBJECT_MAINFOOT) && direction.equals(ALIGN_DIRECTION_RIGHT) && container.equals(ALIGN_CONTAINER_PRWORD)) {
            return new Constraint(cnstrname, cnstrdescr){

                public Violation value(Candidate can) {
                    int v = 0;
                    boolean quantized_distance_so_far = false;
                    boolean quantized_distance_until_latest_bracket = false;
                    char[] s = can.sf.string().toCharArray();
                    int i = s.length;
                    while (i > 0) {
                        char b = s[i - 1];
                        if (b == u) {
                            quantized_distance_so_far = true;
                        } else if (b == MetricalStress.this.EOF) {
                            quantized_distance_until_latest_bracket = quantized_distance_so_far;
                        } else if (b == MetricalStress.this.PRS) {
                            if (quantized_distance_until_latest_bracket) {
                                ++v;
                            }
                            i = 0;
                        } else if (b == MetricalStress.this.BOF) {
                            v = 1;
                            i = 0;
                        }
                        --i;
                    }
                    return IntegerViolation.v(v);
                }
            };
        }
        if (object.equals(ALIGN_OBJECT_ALLFEET) && direction.equals(ALIGN_DIRECTION_LEFT) && container.equals(ALIGN_CONTAINER_PRWORD)) {
            return new Constraint(cnstrname, cnstrdescr){

                public Violation value(Candidate can) {
                    int v = 0;
                    boolean quantized_distance_so_far = false;
                    char[] s = can.sf.string().toCharArray();
                    int l = s.length;
                    int i = 0;
                    while (i < l) {
                        char b = s[i];
                        if (b == u) {
                            quantized_distance_so_far = true;
                        } else if (b == MetricalStress.this.BOF && quantized_distance_so_far) {
                            ++v;
                        }
                        ++i;
                    }
                    return IntegerViolation.v(v);
                }
            };
        }
        if (object.equals(ALIGN_OBJECT_ALLFEET) && direction.equals(ALIGN_DIRECTION_RIGHT) && container.equals(ALIGN_CONTAINER_PRWORD)) {
            return new Constraint(cnstrname, cnstrdescr){

                public Violation value(Candidate can) {
                    int v = 0;
                    boolean quantized_distance_so_far = false;
                    char[] s = can.sf.string().toCharArray();
                    int i = s.length;
                    while (i > 0) {
                        char b = s[i - 1];
                        if (b == u) {
                            quantized_distance_so_far = true;
                        } else if (b == MetricalStress.this.EOF && quantized_distance_so_far) {
                            ++v;
                        }
                        --i;
                    }
                    return IntegerViolation.v(v);
                }
            };
        }
        throw new RuntimeException("Definition of constraint QAlign: unknown parameters.");
    }

    public Form addMora(Form f, int heavy, int superheavy) {
        String s = String.valueOf(f.string()) + this.EOS;
        String out = "";
        String syll = "";
        boolean nucleus_reached = false;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char b = cArray[n2];
            if (b == this.EOS || b == this.EOF) {
                if (nucleus_reached) {
                    out = this.parseSyll(syll, superheavy) ? String.valueOf(out) + this.MORA + this.MORA + this.MORA : (this.parseSyll(syll, heavy) ? String.valueOf(out) + this.MORA + this.MORA : String.valueOf(out) + this.MORA);
                    nucleus_reached = false;
                }
            } else if (!nucleus_reached && this.vwls.contains(Character.valueOf(b))) {
                nucleus_reached = true;
                syll = "" + b;
            } else if (nucleus_reached) {
                syll = String.valueOf(syll) + b;
            }
            out = String.valueOf(out) + b;
            ++n2;
        }
        return new Form(out.substring(0, out.length() - 1));
    }

    public Form addMora(Form f, int heavy) {
        String s = String.valueOf(f.string()) + this.EOS;
        String out = "";
        String syll = "";
        boolean nucleus_reached = false;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char b = cArray[n2];
            if (b == this.EOS || b == this.EOF) {
                if (nucleus_reached) {
                    out = this.parseSyll(syll, heavy) ? String.valueOf(out) + this.MORA + this.MORA : String.valueOf(out) + this.MORA;
                    nucleus_reached = false;
                }
            } else if (!nucleus_reached && this.vwls.contains(Character.valueOf(b))) {
                nucleus_reached = true;
                syll = "" + b;
            } else if (nucleus_reached) {
                syll = String.valueOf(syll) + b;
            }
            out = String.valueOf(out) + b;
            ++n2;
        }
        return new Form(out.substring(0, out.length() - 1));
    }

    private boolean parseSyll(String s, int feature) {
        boolean in_nucleus = false;
        boolean has_longnucleus = false;
        boolean has_coda = false;
        boolean has_complexcoda = false;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char b = cArray[n2];
            if (!has_complexcoda) {
                if (has_coda) {
                    if (b == this.LONG) {
                        has_complexcoda = true;
                    } else if (this.cons.contains(Character.valueOf(b))) {
                        has_complexcoda = true;
                    }
                } else if (in_nucleus) {
                    if (b == this.LONG) {
                        has_longnucleus = true;
                    } else if (this.vwls.contains(Character.valueOf(b))) {
                        has_longnucleus = true;
                    } else if (this.cons.contains(Character.valueOf(b))) {
                        has_coda = true;
                    }
                } else if (this.vwls.contains(Character.valueOf(b))) {
                    in_nucleus = true;
                }
            }
            ++n2;
        }
        boolean negreturnvalue = true;
        if (has_longnucleus && (feature & 1) > 0) {
            negreturnvalue = false;
        }
        if (negreturnvalue && has_coda && (feature & 2) > 0) {
            negreturnvalue = false;
        }
        if (negreturnvalue && has_complexcoda && (feature & 4) > 0) {
            negreturnvalue = false;
        }
        if (negreturnvalue && has_longnucleus && has_coda && (feature & 8) > 0) {
            negreturnvalue = false;
        }
        if (negreturnvalue && has_longnucleus && has_complexcoda && (feature & 0x10) > 0) {
            negreturnvalue = false;
        }
        return !negreturnvalue;
    }
}

