/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.learning;

import hu.birot.OTKit.dataType.violation.Violation;
import hu.birot.OTKit.learning.ConstraintMotion;
import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Constraint;
import hu.birot.OTKit.otBuildingBlocks.Hierarchy;

public class ConstraintMotionExamples {
    public static ConstraintMotion TesarSmolensky() {
        return new ConstraintMotion(){

            public boolean update(Hierarchy H, Candidate w, Candidate l) {
                boolean change = false;
                if (w.equals(l)) {
                    change = false;
                } else {
                    Constraint W = null;
                    double rank_of_W = Double.NEGATIVE_INFINITY;
                    for (Constraint constr : H.constraints()) {
                        if (!Violation.isBetter(constr.value(w), constr.value(l)) || !(H.rankOf(constr) > rank_of_W)) continue;
                        W = constr;
                        rank_of_W = H.rankOf(constr);
                    }
                    for (Constraint constr : H.constraints()) {
                        if (W == null || !Violation.isBetter(constr.value(l), constr.value(w)) || !(H.rankOf(constr) > rank_of_W)) continue;
                        H.setRank(constr, rank_of_W - 1.0);
                        change = true;
                    }
                }
                return change;
            }
        };
    }

    public static ConstraintMotion Boersma(final double plasticity) {
        return new ConstraintMotion(){

            public boolean update(Hierarchy H, Candidate w, Candidate l) {
                boolean change = false;
                if (w.equals(l)) {
                    change = false;
                } else {
                    for (Constraint con : H.constraints()) {
                        Violation vloser = con.value(l);
                        Violation vwiner = con.value(w);
                        if (Violation.isBetter(vwiner, vloser)) {
                            H.increaseRank(con, plasticity);
                            change = true;
                            continue;
                        }
                        if (!Violation.isBetter(vloser, vwiner)) continue;
                        H.increaseRank(con, -plasticity);
                        change = true;
                    }
                }
                return change;
            }
        };
    }

    public static ConstraintMotion Magri(final double plasticity) {
        return new ConstraintMotion(){

            public boolean update(Hierarchy H, Candidate w, Candidate l) {
                boolean change = false;
                if (w.equals(l)) {
                    change = false;
                } else {
                    Constraint highest_l = null;
                    double r_of_highest_l = Double.NEGATIVE_INFINITY;
                    int nr_of_w = 0;
                    for (Constraint con : H.constraints()) {
                        double r;
                        Violation vloser = con.value(l);
                        Violation vwinner = con.value(w);
                        if (Violation.isBetter(vwinner, vloser)) {
                            H.increaseRank(con, plasticity);
                            change = true;
                            ++nr_of_w;
                        }
                        if (!Violation.isBetter(vloser, vwinner) || !((r = H.rankOf(con).doubleValue()) > r_of_highest_l)) continue;
                        highest_l = con;
                        r_of_highest_l = r;
                    }
                    if (highest_l != null) {
                        H.increaseRank(highest_l, -plasticity * (double)nr_of_w);
                    }
                }
                return change;
            }
        };
    }

    public static ConstraintMotion demotionOnly(final double plasticity) {
        return new ConstraintMotion(){

            public boolean update(Hierarchy H, Candidate w, Candidate l) {
                boolean change = false;
                if (w.equals(l)) {
                    change = false;
                } else {
                    Constraint highest_l = null;
                    double r_of_highest_l = Double.NEGATIVE_INFINITY;
                    int nr_of_w = 0;
                    for (Constraint con : H.constraints()) {
                        double r;
                        Violation vloser = con.value(l);
                        Violation vwinner = con.value(w);
                        if (Violation.isBetter(vwinner, vloser)) {
                            change = true;
                            ++nr_of_w;
                        }
                        if (!Violation.isBetter(vloser, vwinner) || !((r = H.rankOf(con).doubleValue()) > r_of_highest_l)) continue;
                        highest_l = con;
                        r_of_highest_l = r;
                    }
                    if (highest_l != null) {
                        H.increaseRank(highest_l, -plasticity * (double)nr_of_w);
                    }
                }
                return change;
            }
        };
    }

    public static ConstraintMotion singleDemotionOnly(final double plasticity) {
        return new ConstraintMotion(){

            public boolean update(Hierarchy H, Candidate w, Candidate l) {
                boolean change = false;
                if (w.equals(l)) {
                    change = false;
                } else {
                    Constraint highest_l = null;
                    double r_of_highest_l = Double.NEGATIVE_INFINITY;
                    for (Constraint con : H.constraints()) {
                        double r;
                        Violation vloser = con.value(l);
                        Violation vwinner = con.value(w);
                        if (Violation.isBetter(vwinner, vloser)) {
                            change = true;
                        }
                        if (!Violation.isBetter(vloser, vwinner) || !((r = H.rankOf(con).doubleValue()) > r_of_highest_l)) continue;
                        highest_l = con;
                        r_of_highest_l = r;
                    }
                    if (highest_l != null) {
                        H.increaseRank(highest_l, -plasticity);
                    }
                }
                return change;
            }
        };
    }

    public static ConstraintMotion allDemotion(final double plasticity) {
        return new ConstraintMotion(){

            public boolean update(Hierarchy H, Candidate w, Candidate l) {
                boolean change = false;
                if (w.equals(l)) {
                    change = false;
                } else {
                    for (Constraint con : H.constraints()) {
                        Violation vwinner;
                        Violation vloser = con.value(l);
                        if (!Violation.isBetter(vloser, vwinner = con.value(w))) continue;
                        change = true;
                        H.increaseRank(con, -plasticity);
                    }
                }
                return change;
            }
        };
    }

    public static ConstraintMotion antiMagri(final double plasticity) {
        return new ConstraintMotion(){

            public boolean update(Hierarchy H, Candidate w, Candidate l) {
                boolean change = false;
                if (w.equals(l)) {
                    change = false;
                } else {
                    Constraint lowest_w = null;
                    double r_of_lowest_w = Double.POSITIVE_INFINITY;
                    int nr_of_l = 0;
                    for (Constraint con : H.constraints()) {
                        double r;
                        Violation vwinner;
                        Violation vloser = con.value(l);
                        if (Violation.isBetter(vloser, vwinner = con.value(w))) {
                            H.increaseRank(con, -plasticity);
                            change = true;
                            ++nr_of_l;
                        }
                        if (!Violation.isBetter(vwinner, vloser) || !((r = H.rankOf(con).doubleValue()) < r_of_lowest_w)) continue;
                        lowest_w = con;
                        r_of_lowest_w = r;
                    }
                    if (lowest_w != null) {
                        H.increaseRank(lowest_w, plasticity * (double)nr_of_l);
                    }
                }
                return change;
            }
        };
    }
}

