/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.otBuildingBlocks;

import hu.birot.OTKit.dataType.violation.FloatViolation;
import hu.birot.OTKit.dataType.violation.IntegerViolation;
import hu.birot.OTKit.dataType.violation.Violation;
import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Constraint;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConstraintExamples {
    public static Constraint equal(String name, final String str, double val) {
        final FloatViolation viol1 = FloatViolation.v(val);
        final FloatViolation viol0 = FloatViolation.nullViolation;
        return new Constraint(name){

            public Violation value(Candidate c) {
                if (c.sf.string().equals(str)) {
                    return viol1;
                }
                return viol0;
            }
        };
    }

    public static Constraint contain(String name, final String str, double val) {
        return new Constraint(name, val){
            final FloatViolation viol1;
            final Violation viol0;
            {
                super($anonymous0);
                this.viol1 = FloatViolation.v(d);
                this.viol0 = FloatViolation.nullViolation;
            }

            public Violation value(Candidate c) {
                if (c.sf.string().contains(str)) {
                    return this.viol1;
                }
                return this.viol0;
            }
        };
    }

    public static Constraint substring(String name, final String str, final double val) {
        return new Constraint(name){

            public Violation value(Candidate c) {
                int v = 0;
                String sf = c.sf.string();
                int i = 0;
                while (i < sf.length()) {
                    if (sf.startsWith(str, i)) {
                        ++v;
                    }
                    ++i;
                }
                return FloatViolation.v((double)v * val);
            }
        };
    }

    public static Constraint regex(String name, String regex, double val) {
        return new Constraint(name, val, regex){
            final FloatViolation viol1;
            final FloatViolation viol0;
            final Pattern p;
            {
                this.viol1 = FloatViolation.v(d);
                this.viol0 = FloatViolation.nullViolation;
                this.p = Pattern.compile(string);
            }

            public Violation value(Candidate c) {
                Matcher m = this.p.matcher(c.sf.string());
                if (m.matches()) {
                    return this.viol1;
                }
                return this.viol0;
            }
        };
    }

    public static Constraint counter1(String name, final double val) {
        return new Constraint(name){

            public Violation value(Candidate c) {
                return FloatViolation.v(c.sf.counter1() * val);
            }
        };
    }

    public static Constraint counter2(String name, final double val) {
        return new Constraint(name){

            public Violation value(Candidate c) {
                return FloatViolation.v(c.sf.counter2() * val);
            }
        };
    }

    public static Constraint counter3(String name, final double val) {
        return new Constraint(name){

            public Violation value(Candidate c) {
                return FloatViolation.v(c.sf.counter3() * val);
            }
        };
    }

    public static Constraint counter1LessThan(String name, final double threshold, double val) {
        return new Constraint(name, val){
            final FloatViolation viol1;
            final FloatViolation viol0;
            {
                super($anonymous0);
                this.viol1 = FloatViolation.v(d);
                this.viol0 = FloatViolation.nullViolation;
            }

            public Violation value(Candidate c) {
                if (c.sf.counter1() < threshold) {
                    return this.viol1;
                }
                return this.viol0;
            }
        };
    }

    public static Constraint counter1LessEqual(String name, final double threshold, double val) {
        return new Constraint(name, val){
            final FloatViolation viol1;
            final FloatViolation viol0;
            {
                super($anonymous0);
                this.viol1 = FloatViolation.v(d);
                this.viol0 = FloatViolation.nullViolation;
            }

            public Violation value(Candidate c) {
                if (c.sf.counter1() <= threshold) {
                    return this.viol1;
                }
                return this.viol0;
            }
        };
    }

    public static Constraint counter1GreaterThan(String name, final double threshold, double val) {
        return new Constraint(name, val){
            final FloatViolation viol1;
            final FloatViolation viol0;
            {
                super($anonymous0);
                this.viol1 = FloatViolation.v(d);
                this.viol0 = FloatViolation.nullViolation;
            }

            public Violation value(Candidate c) {
                if (c.sf.counter1() > threshold) {
                    return this.viol1;
                }
                return this.viol0;
            }
        };
    }

    public static Constraint counter1GreaterEqual(String name, final double threshold, double val) {
        return new Constraint(name, val){
            final FloatViolation viol1;
            final FloatViolation viol0;
            {
                super($anonymous0);
                this.viol1 = FloatViolation.v(d);
                this.viol0 = FloatViolation.nullViolation;
            }

            public Violation value(Candidate c) {
                if (c.sf.counter1() >= threshold) {
                    return this.viol1;
                }
                return this.viol0;
            }
        };
    }

    public static Constraint counter1EqualTo(String name, final double e, double val) {
        return new Constraint(name, val){
            final FloatViolation viol1;
            final FloatViolation viol0;
            {
                super($anonymous0);
                this.viol1 = FloatViolation.v(d);
                this.viol0 = FloatViolation.nullViolation;
            }

            public Violation value(Candidate c) {
                if (c.sf.counter1() == e) {
                    return this.viol1;
                }
                return this.viol0;
            }
        };
    }

    public static Constraint counter2LessThan(String name, final double threshold, double val) {
        return new Constraint(name, val){
            final FloatViolation viol1;
            final FloatViolation viol0;
            {
                super($anonymous0);
                this.viol1 = FloatViolation.v(d);
                this.viol0 = FloatViolation.nullViolation;
            }

            public Violation value(Candidate c) {
                if (c.sf.counter2() < threshold) {
                    return this.viol1;
                }
                return this.viol0;
            }
        };
    }

    public static Constraint counter2LessEqual(String name, final double threshold, double val) {
        return new Constraint(name, val){
            final FloatViolation viol1;
            final FloatViolation viol0;
            {
                super($anonymous0);
                this.viol1 = FloatViolation.v(d);
                this.viol0 = FloatViolation.nullViolation;
            }

            public Violation value(Candidate c) {
                if (c.sf.counter2() <= threshold) {
                    return this.viol1;
                }
                return this.viol0;
            }
        };
    }

    public static Constraint counter2GreaterThan(String name, final double threshold, double val) {
        return new Constraint(name, val){
            final FloatViolation viol1;
            final FloatViolation viol0;
            {
                super($anonymous0);
                this.viol1 = FloatViolation.v(d);
                this.viol0 = FloatViolation.nullViolation;
            }

            public Violation value(Candidate c) {
                if (c.sf.counter2() > threshold) {
                    return this.viol1;
                }
                return this.viol0;
            }
        };
    }

    public static Constraint counter2GreaterEqual(String name, final double threshold, double val) {
        return new Constraint(name, val){
            final FloatViolation viol1;
            final FloatViolation viol0;
            {
                super($anonymous0);
                this.viol1 = FloatViolation.v(d);
                this.viol0 = FloatViolation.nullViolation;
            }

            public Violation value(Candidate c) {
                if (c.sf.counter2() >= threshold) {
                    return this.viol1;
                }
                return this.viol0;
            }
        };
    }

    public static Constraint counter2EqualTo(String name, final double e, double val) {
        return new Constraint(name, val){
            final FloatViolation viol1;
            final FloatViolation viol0;
            {
                super($anonymous0);
                this.viol1 = FloatViolation.v(d);
                this.viol0 = FloatViolation.nullViolation;
            }

            public Violation value(Candidate c) {
                if (c.sf.counter2() == e) {
                    return this.viol1;
                }
                return this.viol0;
            }
        };
    }

    public static Constraint counter3LessThan(String name, final double threshold, double val) {
        return new Constraint(name, val){
            final FloatViolation viol1;
            final FloatViolation viol0;
            {
                super($anonymous0);
                this.viol1 = FloatViolation.v(d);
                this.viol0 = FloatViolation.nullViolation;
            }

            public Violation value(Candidate c) {
                if (c.sf.counter3() < threshold) {
                    return this.viol1;
                }
                return this.viol0;
            }
        };
    }

    public static Constraint counter3LessEqual(String name, final double threshold, double val) {
        return new Constraint(name, val){
            final FloatViolation viol1;
            final FloatViolation viol0;
            {
                super($anonymous0);
                this.viol1 = FloatViolation.v(d);
                this.viol0 = FloatViolation.nullViolation;
            }

            public Violation value(Candidate c) {
                if (c.sf.counter3() <= threshold) {
                    return this.viol1;
                }
                return this.viol0;
            }
        };
    }

    public static Constraint counter3GreaterThan(String name, final double threshold, final double val) {
        return new Constraint(name){

            public Violation value(Candidate c) {
                FloatViolation viol1 = FloatViolation.v(val);
                FloatViolation viol0 = FloatViolation.nullViolation;
                if (c.sf.counter3() > threshold) {
                    return viol1;
                }
                return viol0;
            }
        };
    }

    public static Constraint counter3GreaterEqual(String name, final double threshold, double val) {
        return new Constraint(name, val){
            final FloatViolation viol1;
            final FloatViolation viol0;
            {
                super($anonymous0);
                this.viol1 = FloatViolation.v(d);
                this.viol0 = FloatViolation.nullViolation;
            }

            public Violation value(Candidate c) {
                if (c.sf.counter3() >= threshold) {
                    return this.viol1;
                }
                return this.viol0;
            }
        };
    }

    public static Constraint counter3EqualTo(String name, final double e, final double val) {
        return new Constraint(name){

            public Violation value(Candidate c) {
                FloatViolation viol1 = FloatViolation.v(val);
                FloatViolation viol0 = FloatViolation.nullViolation;
                if (c.sf.counter3() == e) {
                    return viol1;
                }
                return viol0;
            }
        };
    }

    public static Constraint constant(String name, double val) {
        return new Constraint(name, val){
            final FloatViolation viol1;
            {
                this.viol1 = FloatViolation.v(d);
            }

            public Violation value(Candidate c) {
                return this.viol1;
            }
        };
    }

    public static Constraint constant(String name, int val) {
        return new Constraint(name, val){
            final IntegerViolation viol1;
            {
                this.viol1 = IntegerViolation.v(n);
            }

            public Violation value(Candidate c) {
                return this.viol1;
            }
        };
    }

    public static Constraint constant(String name, final Violation viol) {
        return new Constraint(name){

            public Violation value(Candidate c) {
                return viol;
            }
        };
    }

    public static Constraint sum(String name, final Constraint con1, final Constraint con2) {
        return new Constraint(name){

            public Violation value(Candidate c) {
                return FloatViolation.v(((Number)con1.value(c).value()).doubleValue() + ((Number)con2.value(c).value()).doubleValue());
            }
        };
    }

    public static Constraint sum(String name, final Constraint[] con) {
        return new Constraint(name){
            private final int l;
            {
                super($anonymous0);
                this.l = constraintArray.length;
            }

            public Violation value(Candidate c) {
                double v = 0.0;
                int i = this.l;
                while (--i >= 0) {
                    v += ((Number)con[i].value(c).value()).doubleValue();
                }
                return FloatViolation.v(v);
            }
        };
    }

    public static Constraint max(String name, final Constraint con1, final Constraint con2) {
        return new Constraint(name){

            public Violation value(Candidate c) {
                return FloatViolation.v(Math.max(((Number)con1.value(c).value()).doubleValue(), ((Number)con2.value(c).value()).doubleValue()));
            }
        };
    }

    public static Constraint min(String name, final Constraint con1, final Constraint con2) {
        return new Constraint(name){

            public Violation value(Candidate c) {
                return FloatViolation.v(Math.min(((Number)con1.value(c).value()).doubleValue(), ((Number)con2.value(c).value()).doubleValue()));
            }
        };
    }

    public static Constraint negate(String name, final Constraint con) {
        return new Constraint(name){

            public Violation value(Candidate c) {
                return FloatViolation.v(1.0 - ((Number)con.value(c).value()).doubleValue());
            }
        };
    }

    public static Constraint product(String name, final Constraint con, final double coeff) {
        return new Constraint(name){

            public Violation value(Candidate c) {
                return FloatViolation.v(coeff * ((Number)con.value(c).value()).doubleValue());
            }
        };
    }

    public static Constraint product(String name, final Constraint con1, final Constraint con2) {
        return new Constraint(name){

            public Violation value(Candidate c) {
                return FloatViolation.v(((Number)con1.value(c).value()).doubleValue() * ((Number)con2.value(c).value()).doubleValue());
            }
        };
    }

    public static Constraint product(String name, final Constraint[] con) {
        return new Constraint(name){
            private final int l;
            {
                super($anonymous0);
                this.l = constraintArray.length;
            }

            public Violation value(Candidate c) {
                double v = 1.0;
                int i = this.l;
                while (v != 0.0 && --i >= 0) {
                    v *= ((Number)con[i].value(c).value()).doubleValue();
                }
                return FloatViolation.v(v);
            }
        };
    }

    public static Constraint ratio(String name, final Constraint con1, final Constraint con2) {
        return new Constraint(name){

            public Violation value(Candidate c) {
                return FloatViolation.v(((Number)con1.value(c).value()).doubleValue() / ((Number)con2.value(c).value()).doubleValue());
            }
        };
    }

    public static Constraint ratio(String name, final double constant, final Constraint constraint) {
        return new Constraint(name){

            public Violation value(Candidate c) {
                return FloatViolation.v(constant / ((Number)constraint.value(c).value()).doubleValue());
            }
        };
    }

    public static Constraint linearCombination(String name, final Constraint x, final double a, final Constraint y, final double b) {
        return new Constraint(name){

            public Violation value(Candidate c) {
                return FloatViolation.v(a * ((Number)x.value(c).value()).doubleValue() + b * ((Number)y.value(c).value()).doubleValue());
            }
        };
    }

    public static Constraint condition(String name, final Constraint cond, final Constraint pos, final Constraint zero, final Constraint neg) {
        return new Constraint(name){

            public Violation value(Candidate c) {
                double condition = ((Number)cond.value(c).value()).doubleValue();
                if (condition == 0.0) {
                    return zero.value(c);
                }
                if (condition > 0.0) {
                    return pos.value(c);
                }
                return neg.value(c);
            }
        };
    }

    public static Constraint condition(String name, final Constraint cond, final Constraint tru, final Constraint fal) {
        return new Constraint(name){

            public Violation value(Candidate c) {
                boolean condition = (Boolean)cond.value(c).value();
                if (condition) {
                    return tru.value(c);
                }
                return fal.value(c);
            }
        };
    }
}

