/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.otBuildingBlocks;

import hu.birot.OTKit.dataType.Comparison;
import hu.birot.OTKit.dataType.violation.Violation;
import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Constraint;
import hu.birot.OTKit.otBuildingBlocks.Hierarchy;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Eval {
    public static Comparison CompareOT(Candidate c1, Candidate c2, Constraint[] h) {
        Comparison out = new Comparison();
        out.difference = 0.0;
        out.isBetterThan = false;
        out.isWorseThan = false;
        out.areEquivalent = true;
        int i = h.length - 1;
        while (i > -1) {
            Violation v2;
            Violation v1 = h[i].value(c1);
            if (!Violation.isEqual(v1, v2 = h[i].value(c2))) {
                if (v1.betterEqual(v2)) {
                    out.better = c1;
                    out.worse = c2;
                    out.fatal = h[i];
                    out.difference = v1.difference(v2);
                    out.isBetterThan = true;
                    out.isWorseThan = false;
                    out.areEquivalent = false;
                } else {
                    out.better = c2;
                    out.worse = c1;
                    out.fatal = h[i];
                    out.difference = v1.difference(v2);
                    out.isBetterThan = false;
                    out.isWorseThan = true;
                    out.areEquivalent = false;
                }
                i = -1;
            }
            --i;
        }
        return out;
    }

    public static Comparison CompareHG(Candidate c1, Candidate c2, Hierarchy h) {
        Comparison out = new Comparison();
        out.isBetterThan = false;
        out.isWorseThan = false;
        out.areEquivalent = true;
        double v = 0.0;
        for (Hierarchy.ConstrValue co : h.cv) {
            v += co.weight * co.con.value(c1).difference(co.con.value(c2));
        }
        out.difference = v;
        if (v > 0.0) {
            out.better = c1;
            out.worse = c2;
            out.isBetterThan = true;
            out.isWorseThan = false;
            out.areEquivalent = false;
        } else if (v < 0.0) {
            out.better = c2;
            out.worse = c1;
            out.isBetterThan = false;
            out.isWorseThan = true;
            out.areEquivalent = false;
        }
        return out;
    }

    public static Comparison CompareOT(Candidate c1, Candidate c2, Hierarchy h) {
        return Eval.CompareOT(c1, c2, h.sortedByRank());
    }

    public static Comparison Compare(Candidate c1, Candidate c2, Hierarchy h) {
        Comparison out = new Comparison();
        if (h.type.equalsIgnoreCase("ot")) {
            out = Eval.CompareOT(c1, c2, h);
        } else if (h.type.equalsIgnoreCase("hg")) {
            out = Eval.CompareHG(c1, c2, h);
        } else {
            throw new RuntimeException("Hierarchy type not specified.");
        }
        return out;
    }

    public static Violation[] EvalOT(Candidate c, Constraint[] h) {
        Violation[] v = new Violation[h.length];
        int i = 0;
        while (i < h.length) {
            v[i] = h[i].value(c);
            ++i;
        }
        return v;
    }

    public static double EvalHG(Candidate c, Hierarchy h) {
        double v = 0.0;
        for (Hierarchy.ConstrValue co : h.cv) {
            v += co.weight * (Double)co.con.value(c).value();
        }
        return v;
    }

    public static Vector<Candidate> Compare(Vector<Candidate> candidate_set, Hierarchy h) {
        Vector<Candidate> out = new Vector<Candidate>();
        Comparison comparison = new Comparison();
        out.add(candidate_set.get(0));
        for (Candidate c : candidate_set) {
            if (c == candidate_set.get(0)) continue;
            comparison = Eval.Compare(c, out.get(0), h);
            if (comparison.areEquivalent) {
                out.add(c);
            }
            if (!comparison.isBetterThan) continue;
            out.removeAllElements();
            out.add(c);
        }
        return out;
    }

    public static Vector<Candidate> CompareHG(Vector<Candidate> candidate_set, Hierarchy h) {
        Vector<Candidate> out = new Vector<Candidate>();
        Comparison comparison = new Comparison();
        out.add(candidate_set.get(0));
        for (Candidate c : candidate_set) {
            if (c == candidate_set.get(0)) continue;
            comparison = Eval.CompareHG(c, out.get(0), h);
            if (comparison.areEquivalent) {
                out.add(c);
            }
            if (!comparison.isBetterThan) continue;
            out.removeAllElements();
            out.add(c);
        }
        return out;
    }

    public static Vector<Candidate> CompareOT(Vector<Candidate> candidate_set, Hierarchy h) {
        Vector<Candidate> out = new Vector<Candidate>();
        Comparison comparison = new Comparison();
        out.add(candidate_set.get(0));
        for (Candidate c : candidate_set) {
            if (c == candidate_set.get(0)) continue;
            comparison = Eval.CompareOT(c, out.get(0), h.sortedByRank());
            if (comparison.areEquivalent) {
                out.add(c);
            }
            if (!comparison.isBetterThan) continue;
            out.removeAllElements();
            out.add(c);
        }
        return out;
    }

    public static Vector<Candidate> CompareOT(Vector<Candidate> candidate_set, Constraint[] h) {
        Vector<Candidate> out = new Vector<Candidate>();
        Comparison comparison = new Comparison();
        out.add(candidate_set.get(0));
        for (Candidate c : candidate_set) {
            if (c == candidate_set.get(0)) continue;
            comparison = Eval.CompareOT(c, out.get(0), h);
            if (comparison.areEquivalent) {
                out.add(c);
            }
            if (!comparison.isBetterThan) continue;
            out.removeAllElements();
            out.add(c);
        }
        return out;
    }
}

