/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.otBuildingBlocks;

import hu.birot.OTKit.dataType.Form;
import hu.birot.OTKit.dataType.MapForm;
import hu.birot.OTKit.dataType.MapFormExamples;
import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Gen;
import java.util.Vector;

public class GenExamples {
    public static Gen listOfSurfaceForms(final String[] cand) {
        Form[] cc = new Form[cand.length];
        int i = 0;
        while (i < cand.length) {
            cc[i] = new Form(cand[i]);
            ++i;
        }
        Form[] c = cc;
        return new Gen(c){
            private final int l;
            private final Form[] surfforms;
            {
                this.l = stringArray.length;
                this.surfforms = formArray;
            }

            @Override
            public Candidate randomCandidate(Form uf, double rnd) {
                if (rnd > 1.0) {
                    return new Candidate(uf, MapForm.NoMapping);
                }
                if (rnd == 1.0) {
                    return new Candidate(uf, this.surfforms[this.l - 1]);
                }
                if (rnd < 0.0) {
                    rnd = 0.0;
                }
                return new Candidate(uf, this.surfforms[(int)((double)this.l * rnd)]);
            }

            @Override
            public Candidate firstCandidate(Form uf) {
                return new Candidate(uf, this.surfforms[0]);
            }

            @Override
            public Candidate nextCandidate(Candidate c) {
                String sf = c.sf.string();
                Form next = new Form();
                boolean found = false;
                int i = 0;
                while (i < this.l) {
                    if (cand[i].equals(sf)) {
                        found = true;
                        next = i == this.l - 1 ? MapForm.NoMoreForm : new Form(cand[i + 1]);
                    }
                    ++i;
                }
                if (!found) {
                    next = MapForm.NotInRange;
                }
                return new Candidate(c.uf, next);
            }

            @Override
            public Vector<Candidate> allCandidates(Form uf) {
                Vector<Candidate> can_v = new Vector<Candidate>();
                Form[] formArray = this.surfforms;
                int n = this.surfforms.length;
                int n2 = 0;
                while (n2 < n) {
                    Form s = formArray[n2];
                    can_v.add(new Candidate(uf, s));
                    ++n2;
                }
                return can_v;
            }
        };
    }

    public static Gen listOfSurfaceForms(final Form[] cand) {
        return new Gen(){
            private final int l;
            {
                this.l = formArray.length;
            }

            @Override
            public Candidate randomCandidate(Form uf, double rnd) {
                if (rnd > 1.0) {
                    return new Candidate(uf, MapForm.NoMapping);
                }
                if (rnd == 1.0) {
                    return new Candidate(uf, cand[this.l - 1]);
                }
                if (rnd < 0.0) {
                    rnd = 0.0;
                }
                return new Candidate(uf, cand[(int)((double)this.l * rnd)]);
            }

            @Override
            public Candidate firstCandidate(Form uf) {
                return new Candidate(uf, cand[0]);
            }

            @Override
            public Candidate nextCandidate(Candidate c) {
                Form sf = c.sf;
                Form next = new Form();
                boolean found = false;
                int i = 0;
                while (i < this.l) {
                    if (cand[i].equals(sf)) {
                        found = true;
                        next = i == this.l - 1 ? MapForm.NoMoreForm : cand[i + 1];
                    }
                    ++i;
                }
                if (!found) {
                    next = MapForm.NotInRange;
                }
                return new Candidate(c.uf, next);
            }

            @Override
            public Vector<Candidate> allCandidates(Form uf) {
                Vector<Candidate> can_v = new Vector<Candidate>();
                Form[] formArray = cand;
                int n = cand.length;
                int n2 = 0;
                while (n2 < n) {
                    Form s = formArray[n2];
                    can_v.add(new Candidate(uf, s));
                    ++n2;
                }
                return can_v;
            }
        };
    }

    public static Gen alphabetPower(final String[] alphabet, final int exp) {
        if (exp < 0) {
            throw new RuntimeException("Exponent must be non-negative!");
        }
        if (alphabet.length == 0) {
            throw new RuntimeException("Alphabet must not be empty!");
        }
        int i = 0;
        while (i < alphabet.length) {
            if (alphabet[i].isEmpty()) {
                throw new RuntimeException("Alphabet must not contain the empty string!");
            }
            ++i;
        }
        String f = "";
        int i2 = 0;
        while (i2 < exp) {
            f = String.valueOf(f) + alphabet[0];
            ++i2;
        }
        String f1 = f;
        return new Gen(f1){
            private final int alphsize;
            private final Form firstcandidate;
            {
                this.alphsize = stringArray.length;
                this.firstcandidate = new Form(string);
            }

            private String array2string(int[] a) {
                String s = "";
                int i = 0;
                while (i < exp) {
                    s = String.valueOf(s) + alphabet[a[i]];
                    ++i;
                }
                return s;
            }

            private int[] string2array(String s) {
                array_string_point asp = this.s2a(new array_string_point(new int[0], s, 0));
                if (asp == null) {
                    return null;
                }
                return asp.array;
            }

            private array_string_point s2a(array_string_point asp) {
                if (asp.array.length == 0 && asp.point == this.alphsize) {
                    return null;
                }
                if (asp.string.isEmpty()) {
                    return asp;
                }
                int newint = -1;
                String newstring = "";
                int i = asp.point;
                while (i < this.alphsize) {
                    if (asp.string.startsWith(alphabet[i])) {
                        newint = i;
                        newstring = asp.string.substring(alphabet[i].length());
                        i = this.alphsize;
                    }
                    ++i;
                }
                if (newint == -1 || newstring.isEmpty() && asp.array.length != exp - 1) {
                    if (asp.array.length == 0) {
                        return null;
                    }
                    int[] newarray = new int[asp.array.length - 1];
                    int l = asp.array.length - 1;
                    int i2 = 0;
                    while (i2 < l) {
                        newarray[i2] = asp.array[i2];
                        ++i2;
                    }
                    return this.s2a(new array_string_point(newarray, String.valueOf(alphabet[asp.array[l]]) + asp.string, asp.array[l] + 1));
                }
                int[] newarray = new int[asp.array.length + 1];
                int l = asp.array.length;
                int i3 = 0;
                while (i3 < l) {
                    newarray[i3] = asp.array[i3];
                    ++i3;
                }
                newarray[i3] = newint;
                return this.s2a(new array_string_point(newarray, newstring, 0));
            }

            private int[] arrayInc(int[] a) {
                int[] b = new int[exp];
                boolean carry = true;
                int i = a.length - 1;
                while (i >= 0) {
                    if (carry) {
                        b[i] = a[i] + 1;
                        if (b[i] == this.alphsize) {
                            b[i] = 0;
                        } else {
                            carry = false;
                        }
                    } else {
                        b[i] = a[i];
                    }
                    --i;
                }
                if (carry) {
                    return null;
                }
                return b;
            }

            @Override
            public Candidate randomCandidate(Form uf, double rnd) {
                double r = rnd;
                if (rnd < 0.0) {
                    r = 0.0;
                } else {
                    if (rnd > 1.0) {
                        return new Candidate(uf, MapForm.RndTooHigh);
                    }
                    if (rnd == 1.0) {
                        r = 0.9999999999999;
                    }
                }
                int[] sf = new int[exp];
                int i = 0;
                while (i < exp) {
                    int l;
                    sf[i] = l = (int)(r *= (double)this.alphsize);
                    r -= (double)l;
                    ++i;
                }
                return new Candidate(uf, new Form(this.array2string(sf)));
            }

            @Override
            public Candidate firstCandidate(Form uf) {
                return new Candidate(uf, this.firstcandidate);
            }

            @Override
            public Candidate nextCandidate(Candidate c) {
                int[] sf = this.string2array(c.sf.string());
                if (sf == null) {
                    return new Candidate(c.uf, MapForm.NotInRange);
                }
                if ((sf = this.arrayInc(sf)) == null) {
                    return new Candidate(c.uf, MapForm.NoMoreForm);
                }
                return new Candidate(c.uf, new Form(this.array2string(sf)));
            }

            @Override
            public Vector<Candidate> allCandidates(Form uf) {
                Vector<Candidate> allc = new Vector<Candidate>();
                int[] a = new int[exp];
                while (a != null) {
                    allc.add(new Candidate(uf, new Form(this.array2string(a))));
                    a = this.arrayInc(a);
                }
                return allc;
            }

            final class array_string_point {
                int[] array;
                String string;
                int point;

                array_string_point(int[] a, String s, int p) {
                    this.array = a;
                    this.string = s;
                    this.point = p;
                }
            }
        };
    }

    public static Gen alphabetStar(final String[] alphabet) {
        if (alphabet.length == 0) {
            throw new RuntimeException("Alphabet must not be empty!");
        }
        int i = 0;
        while (i < alphabet.length) {
            if (alphabet[i].isEmpty()) {
                throw new RuntimeException("Alphabet must not contain the empty string!");
            }
            ++i;
        }
        return new Gen(){
            private final int alphsize;
            final Form empty;
            {
                this.alphsize = stringArray.length;
                this.empty = new Form("");
            }

            private String array2string(int[] a) {
                String s = "";
                int i = 0;
                while (i < a.length) {
                    s = String.valueOf(s) + alphabet[a[i]];
                    ++i;
                }
                return s;
            }

            private int[] string2array(String s) {
                array_string_point asp = this.s2a(new array_string_point(new int[0], s, 0));
                if (asp == null) {
                    return null;
                }
                return asp.array;
            }

            private array_string_point s2a(array_string_point asp) {
                if (asp.array.length == 0 && asp.point == this.alphsize) {
                    return null;
                }
                if (asp.string.isEmpty()) {
                    return asp;
                }
                int newint = -1;
                String newstring = "";
                int i = asp.point;
                while (i < this.alphsize) {
                    if (asp.string.startsWith(alphabet[i])) {
                        newint = i;
                        newstring = asp.string.substring(alphabet[i].length());
                        i = this.alphsize;
                    }
                    ++i;
                }
                if (newint == -1) {
                    if (asp.array.length == 0) {
                        return null;
                    }
                    int[] newarray = new int[asp.array.length - 1];
                    int l = asp.array.length - 1;
                    int i2 = 0;
                    while (i2 < l) {
                        newarray[i2] = asp.array[i2];
                        ++i2;
                    }
                    return this.s2a(new array_string_point(newarray, String.valueOf(alphabet[asp.array[l]]) + asp.string, asp.array[l] + 1));
                }
                int[] newarray = new int[asp.array.length + 1];
                int l = asp.array.length;
                int i3 = 0;
                while (i3 < l) {
                    newarray[i3] = asp.array[i3];
                    ++i3;
                }
                newarray[i3] = newint;
                return this.s2a(new array_string_point(newarray, newstring, 0));
            }

            private int[] arrayInc(int[] a) {
                int[] b = new int[a.length];
                boolean carry = true;
                int i = a.length - 1;
                while (i >= 0) {
                    if (carry) {
                        b[i] = a[i] + 1;
                        if (b[i] == this.alphsize) {
                            b[i] = 0;
                        } else {
                            carry = false;
                        }
                    } else {
                        b[i] = a[i];
                    }
                    --i;
                }
                if (!carry) {
                    return b;
                }
                return new int[a.length + 1];
            }

            @Override
            public Candidate randomCandidate(Form uf, double rnd) {
                double r = rnd;
                if (rnd < 0.0) {
                    r = 0.0;
                } else {
                    if (rnd > 1.0) {
                        return new Candidate(uf, MapForm.RndTooHigh);
                    }
                    if (rnd == 1.0) {
                        r = 0.9999999999999;
                    }
                }
                int exp = -((int)(Math.log(1.0 - r) / Math.log(2.0)));
                double ex = Math.pow(2.0, -1 - exp);
                r = 1.0 - (1.0 - r - ex) / ex;
                int[] sf = new int[exp];
                int i = 0;
                while (i < exp) {
                    int l;
                    sf[i] = l = (int)(r *= (double)this.alphsize);
                    r -= (double)l;
                    ++i;
                }
                return new Candidate(uf, new Form(this.array2string(sf)));
            }

            @Override
            public Candidate firstCandidate(Form uf) {
                return new Candidate(uf, this.empty);
            }

            @Override
            public Candidate nextCandidate(Candidate c) {
                int[] sf = this.string2array(c.sf.string());
                if (sf == null) {
                    return new Candidate(c.uf, MapForm.NotInRange);
                }
                return new Candidate(c.uf, new Form(this.array2string(this.arrayInc(sf))));
            }

            @Override
            public Vector<Candidate> allCandidates(Form uf) {
                Vector<Candidate> allc = new Vector<Candidate>();
                allc.add(new Candidate(uf, MapForm.InfiniteSet));
                return allc;
            }

            final class array_string_point {
                int[] array;
                String string;
                int point;

                array_string_point(int[] a, String s, int p) {
                    this.array = a;
                    this.string = s;
                    this.point = p;
                }
            }
        };
    }

    public static final Gen composition(Gen gen1, Gen gen2) {
        MapForm mf1 = MapFormExamples.fromGen(gen1);
        MapForm mf2 = MapFormExamples.fromGen(gen2);
        return new Gen(MapFormExamples.composition(mf1, mf2));
    }
}

