/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.otBuildingBlocks;

import hu.birot.OTKit.dataType.violation.Violation;
import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Constraint;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hierarchy {
    public static final Object no_ranking_value = new Object(){

        public String toString() {
            return "";
        }
    };
    static HashSet<Constraint> Con;
    protected Vector<ConstrValue> cv;
    public String name = "";
    public String type = "";
    public static final String OT = "ot";
    public static final String HG = "hg";
    public static final RuntimeException unknownCon;
    public static final RuntimeException unknownConName;
    Constraint[] sortedByRank;
    public static final String RANK = "rank";
    public static final String RANK1 = "rank1";
    public static final String RANK2 = "rank2";
    public static final String PERTURBED_RANK = "perturbed_rank";
    public static final String UNPERTURBED_RANK = "unperturbed_rank";
    public static final String KVALUE = "kvalue";
    public static final String WEIGHT = "weight";
    public static final String SETRANK = "setrank";
    public static final String VIOLRANK = "violrank";

    static {
        unknownCon = new RuntimeException("Unknown constraint.");
        unknownConName = new RuntimeException("Unknown constraint name.");
    }

    public Hierarchy() {
        this.cv = new Vector();
    }

    public Hierarchy(String name_of_hierarchy) {
        this.name = name_of_hierarchy;
        this.cv = new Vector();
    }

    public void addConstraint(Constraint cnstr) {
        ConstrValue cnstrvalue = new ConstrValue(cnstr);
        if (!this.cv.contains(cnstrvalue)) {
            this.cv.addElement(cnstrvalue);
        } else {
            int index = this.cv.indexOf(cnstrvalue);
            this.cv.get((int)index).con = cnstr;
        }
    }

    public void addConstraintWithRank(Constraint cnstr, double r) {
        ConstrValue cnstrvalue = new ConstrValue(cnstr);
        cnstrvalue.rank = r;
        if (!this.cv.contains(cnstrvalue)) {
            this.cv.addElement(cnstrvalue);
        } else {
            this.setRank(cnstr, r);
        }
    }

    public void addConstraintWithKvalue(Constraint cnstr, double k) {
        ConstrValue cnstrvalue = new ConstrValue(cnstr);
        cnstrvalue.kvalue = k;
        if (!this.cv.contains(cnstrvalue)) {
            this.cv.addElement(cnstrvalue);
        } else {
            this.setKvalue(cnstr, k);
        }
    }

    public void addConstraintWithRank1(Constraint cnstr, double r) {
        ConstrValue cnstrvalue = new ConstrValue(cnstr);
        cnstrvalue.rank1 = r;
        if (!this.cv.contains(cnstrvalue)) {
            this.cv.addElement(cnstrvalue);
        } else {
            this.setRank1(cnstr, r);
        }
    }

    public void addConstraintWithRank2(Constraint cnstr, double r) {
        ConstrValue cnstrvalue = new ConstrValue(cnstr);
        cnstrvalue.rank2 = r;
        if (!this.cv.contains(cnstrvalue)) {
            this.cv.addElement(cnstrvalue);
        } else {
            this.setRank2(cnstr, r);
        }
    }

    public void addConstraintWithUnperturbedRank(Constraint cnstr, double r) {
        ConstrValue cnstrvalue = new ConstrValue(cnstr);
        cnstrvalue.unperturbedRank = r;
        if (!this.cv.contains(cnstrvalue)) {
            this.cv.addElement(cnstrvalue);
        } else {
            this.setUnperturbedRank(cnstr, r);
        }
    }

    public void addConstraintWithPerturbedRank(Constraint cnstr, double r) {
        ConstrValue cnstrvalue = new ConstrValue(cnstr);
        cnstrvalue.perturbedRank = r;
        if (!this.cv.contains(cnstrvalue)) {
            this.cv.addElement(cnstrvalue);
        } else {
            this.setPerturbedRank(cnstr, r);
        }
    }

    public void addConstraintWithWeight(Constraint cnstr, double w) {
        ConstrValue cnstrvalue = new ConstrValue(cnstr);
        cnstrvalue.weight = w;
        if (!this.cv.contains(cnstrvalue)) {
            this.cv.addElement(cnstrvalue);
        } else {
            this.setWeight(cnstr, w);
        }
    }

    public Vector<Constraint> constraints() {
        Vector<Constraint> constr = new Vector<Constraint>();
        for (ConstrValue conval : this.cv) {
            constr.add(conval.con);
        }
        return constr;
    }

    public Vector<String> constraintNames() {
        Vector<String> constr = new Vector<String>();
        for (ConstrValue conval : this.cv) {
            constr.add(conval.con.name());
        }
        return constr;
    }

    public Double rankOf(Constraint cnstr) {
        int i = this.cv.indexOf(new ConstrValue(cnstr));
        if (i == -1) {
            return null;
        }
        return this.cv.get((int)i).rank;
    }

    public Double kvalueOf(Constraint cnstr) {
        int i = this.cv.indexOf(new ConstrValue(cnstr));
        if (i == -1) {
            return null;
        }
        return this.cv.get((int)i).kvalue;
    }

    public Double rank1Of(Constraint cnstr) {
        int i = this.cv.indexOf(new ConstrValue(cnstr));
        if (i == -1) {
            return null;
        }
        return this.cv.get((int)i).rank1;
    }

    public Double rank2Of(Constraint cnstr) {
        int i = this.cv.indexOf(new ConstrValue(cnstr));
        if (i == -1) {
            return null;
        }
        return this.cv.get((int)i).rank2;
    }

    public Double unperturbedRankOf(Constraint cnstr) {
        int i = this.cv.indexOf(new ConstrValue(cnstr));
        if (i == -1) {
            return null;
        }
        return this.cv.get((int)i).unperturbedRank;
    }

    public Double perturbedRankOf(Constraint cnstr) {
        int i = this.cv.indexOf(new ConstrValue(cnstr));
        if (i == -1) {
            return null;
        }
        return this.cv.get((int)i).perturbedRank;
    }

    public Double weightOf(Constraint cnstr) {
        int i = this.cv.indexOf(new ConstrValue(cnstr));
        if (i == -1) {
            return null;
        }
        return this.cv.get((int)i).weight;
    }

    public HashMap<String, Double> rvariableOf(Constraint cnstr) {
        int i = this.cv.indexOf(new ConstrValue(cnstr));
        if (i == -1) {
            return null;
        }
        return this.cv.get((int)i).rvariable;
    }

    public Object get(String cnstr_name, String rankname) {
        int cvsize = this.cv.size();
        int i = 0;
        while (i < cvsize) {
            if (this.cv.get((int)i).con.name().equals(cnstr_name)) {
                return this.cv.get(i).getRank(rankname);
            }
            ++i;
        }
        throw unknownConName;
    }

    public void setRank(Constraint cnstr, double r) {
        int i = this.cv.indexOf(new ConstrValue(cnstr));
        if (i <= -1) {
            throw unknownCon;
        }
        this.cv.get((int)i).rank = r;
    }

    public void setRank(String cnstr_name, double r) {
        int cvsize = this.cv.size();
        int i = 0;
        while (i < cvsize) {
            if (this.cv.get((int)i).con.name().equals(cnstr_name)) {
                this.cv.get((int)i).rank = r;
                i = cvsize + 1;
            }
            ++i;
        }
        if (i == cvsize) {
            throw unknownConName;
        }
    }

    public void setKvalue(Constraint cnstr, double r) {
        int i = this.cv.indexOf(new ConstrValue(cnstr));
        if (i <= -1) {
            throw unknownCon;
        }
        this.cv.get((int)i).kvalue = r;
    }

    public void setKvalue(String cnstr_name, double r) {
        int cvsize = this.cv.size();
        int i = 0;
        while (i < cvsize) {
            if (this.cv.get((int)i).con.name().equals(cnstr_name)) {
                this.cv.get((int)i).kvalue = r;
                i = cvsize + 1;
            }
            ++i;
        }
        if (i == cvsize) {
            throw unknownConName;
        }
    }

    public void setRank1(Constraint cnstr, double r) {
        int i = this.cv.indexOf(new ConstrValue(cnstr));
        if (i <= -1) {
            throw unknownCon;
        }
        this.cv.get((int)i).rank1 = r;
    }

    public void setRank1(String cnstr_name, double r) {
        int cvsize = this.cv.size();
        int i = 0;
        while (i < cvsize) {
            if (this.cv.get((int)i).con.name().equals(cnstr_name)) {
                this.cv.get((int)i).rank1 = r;
                i = cvsize + 1;
            }
            ++i;
        }
        if (i == cvsize) {
            throw unknownConName;
        }
    }

    public void setRank2(Constraint cnstr, double r) {
        int i = this.cv.indexOf(new ConstrValue(cnstr));
        if (i <= -1) {
            throw unknownCon;
        }
        this.cv.get((int)i).rank2 = r;
    }

    public void setRank2(String cnstr_name, double r) {
        int cvsize = this.cv.size();
        int i = 0;
        while (i < cvsize) {
            if (this.cv.get((int)i).con.name().equals(cnstr_name)) {
                this.cv.get((int)i).rank2 = r;
                i = cvsize + 1;
            }
            ++i;
        }
        if (i == cvsize) {
            throw unknownConName;
        }
    }

    public void setUnperturbedRank(Constraint cnstr, double r) {
        int i = this.cv.indexOf(new ConstrValue(cnstr));
        if (i <= -1) {
            throw unknownCon;
        }
        this.cv.get((int)i).unperturbedRank = r;
    }

    public void setUnperturbedRank(String cnstr_name, double r) {
        int cvsize = this.cv.size();
        int i = 0;
        while (i < cvsize) {
            if (this.cv.get((int)i).con.name().equals(cnstr_name)) {
                this.cv.get((int)i).unperturbedRank = r;
                i = cvsize + 1;
            }
            ++i;
        }
        if (i == cvsize) {
            throw unknownConName;
        }
    }

    public void setPerturbedRank(Constraint cnstr, double r) {
        int i = this.cv.indexOf(new ConstrValue(cnstr));
        if (i <= -1) {
            throw unknownCon;
        }
        this.cv.get((int)i).perturbedRank = r;
    }

    public void setPerturbedRank(String cnstr_name, double r) {
        int cvsize = this.cv.size();
        int i = 0;
        while (i < cvsize) {
            if (this.cv.get((int)i).con.name().equals(cnstr_name)) {
                this.cv.get((int)i).perturbedRank = r;
                i = cvsize + 1;
            }
            ++i;
        }
        if (i == cvsize) {
            throw unknownConName;
        }
    }

    public void setWeight(Constraint cnstr, double w) {
        int i = this.cv.indexOf(new ConstrValue(cnstr));
        if (i <= -1) {
            throw unknownCon;
        }
        this.cv.get((int)i).weight = w;
    }

    public void setWeight(String cnstr_name, double w) {
        int cvsize = this.cv.size();
        int i = 0;
        while (i < cvsize) {
            if (this.cv.get((int)i).con.name().equals(cnstr_name)) {
                this.cv.get((int)i).weight = w;
                i = cvsize + 1;
            }
            ++i;
        }
        if (i == cvsize) {
            throw unknownConName;
        }
    }

    public void setRank(String string_describing_hierarchy) {
        String[] H = string_describing_hierarchy.split(">>");
        int L = H.length;
        int i = 0;
        while (i < L) {
            this.setRank(H[i].trim(), (double)(L - i));
            ++i;
        }
    }

    public void set(String cnstr_name, String rankname, Object r) {
        int cvsize = this.cv.size();
        int i = 0;
        while (i < cvsize) {
            if (this.cv.get((int)i).con.name().equals(cnstr_name)) {
                this.cv.get(i).setRank(rankname, r);
                i = cvsize + 1;
            }
            ++i;
        }
        if (i == cvsize) {
            throw unknownConName;
        }
    }

    public Constraint[] sortByRank() {
        Constraint[] conarray = new Constraint[this.cv.size()];
        int size = this.cv.size();
        int i = 0;
        while (i < size) {
            conarray[i] = this.cv.get((int)i).con;
            ++i;
        }
        Arrays.sort(conarray, new Comparator<Object>(){

            @Override
            public int compare(Object ao, Object bo) {
                double r2;
                Constraint a = (Constraint)ao;
                Constraint b = (Constraint)bo;
                int c = 0;
                int i = Hierarchy.this.cv.indexOf(new ConstrValue(a));
                int j = Hierarchy.this.cv.indexOf(new ConstrValue(b));
                double r1 = Hierarchy.this.cv.get((int)i).rank;
                if (r1 > (r2 = Hierarchy.this.cv.get((int)j).rank.doubleValue())) {
                    c = 1;
                }
                if (r1 < r2) {
                    c = -1;
                }
                return c;
            }
        });
        this.sortedByRank = conarray;
        return (Constraint[])conarray.clone();
    }

    public Constraint[] sortedByRank() {
        return this.sortedByRank;
    }

    public String sortedByRankHierarchy() {
        String hier = "";
        int i = this.sortedByRank.length - 1;
        while (i > -1) {
            hier = String.valueOf(hier) + this.sortedByRank[i].name();
            if (i > 0) {
                hier = String.valueOf(hier) + " >> ";
            }
            --i;
        }
        return hier;
    }

    public Constraint[] sortByKvalue() {
        Constraint[] conarray = new Constraint[this.cv.size()];
        int size = this.cv.size();
        int i = 0;
        while (i < size) {
            conarray[i] = this.cv.get((int)i).con;
            ++i;
        }
        Arrays.sort(conarray, new Comparator<Object>(){

            @Override
            public int compare(Object ao, Object bo) {
                double r2;
                Constraint a = (Constraint)ao;
                Constraint b = (Constraint)bo;
                int c = 0;
                int i = Hierarchy.this.cv.indexOf(new ConstrValue(a));
                int j = Hierarchy.this.cv.indexOf(new ConstrValue(b));
                double r1 = Hierarchy.this.cv.get((int)i).kvalue;
                if (r1 > (r2 = Hierarchy.this.cv.get((int)j).kvalue.doubleValue())) {
                    c = 1;
                }
                if (r1 < r2) {
                    c = -1;
                }
                return c;
            }
        });
        return conarray;
    }

    public Constraint[] sortByRank1() {
        Constraint[] conarray = new Constraint[this.cv.size()];
        int size = this.cv.size();
        int i = 0;
        while (i < size) {
            conarray[i] = this.cv.get((int)i).con;
            ++i;
        }
        Arrays.sort(conarray, new Comparator<Object>(){

            @Override
            public int compare(Object ao, Object bo) {
                double r2;
                Constraint a = (Constraint)ao;
                Constraint b = (Constraint)bo;
                int c = 0;
                int i = Hierarchy.this.cv.indexOf(new ConstrValue(a));
                int j = Hierarchy.this.cv.indexOf(new ConstrValue(b));
                double r1 = Hierarchy.this.cv.get((int)i).rank1;
                if (r1 > (r2 = Hierarchy.this.cv.get((int)j).rank1.doubleValue())) {
                    c = 1;
                }
                if (r1 < r2) {
                    c = -1;
                }
                return c;
            }
        });
        return conarray;
    }

    public Constraint[] sortByRank2() {
        Constraint[] conarray = new Constraint[this.cv.size()];
        int size = this.cv.size();
        int i = 0;
        while (i < size) {
            conarray[i] = this.cv.get((int)i).con;
            ++i;
        }
        Arrays.sort(conarray, new Comparator<Object>(){

            @Override
            public int compare(Object ao, Object bo) {
                double r2;
                Constraint a = (Constraint)ao;
                Constraint b = (Constraint)bo;
                int c = 0;
                int i = Hierarchy.this.cv.indexOf(new ConstrValue(a));
                int j = Hierarchy.this.cv.indexOf(new ConstrValue(b));
                double r1 = Hierarchy.this.cv.get((int)i).rank2;
                if (r1 > (r2 = Hierarchy.this.cv.get((int)j).rank2.doubleValue())) {
                    c = 1;
                }
                if (r1 < r2) {
                    c = -1;
                }
                return c;
            }
        });
        return conarray;
    }

    public Constraint[] sortByUnperturbedRank() {
        Constraint[] conarray = new Constraint[this.cv.size()];
        int size = this.cv.size();
        int i = 0;
        while (i < size) {
            conarray[i] = this.cv.get((int)i).con;
            ++i;
        }
        Arrays.sort(conarray, new Comparator<Object>(){

            @Override
            public int compare(Object ao, Object bo) {
                double r2;
                Constraint a = (Constraint)ao;
                Constraint b = (Constraint)bo;
                int c = 0;
                int i = Hierarchy.this.cv.indexOf(new ConstrValue(a));
                int j = Hierarchy.this.cv.indexOf(new ConstrValue(b));
                double r1 = Hierarchy.this.cv.get((int)i).unperturbedRank;
                if (r1 > (r2 = Hierarchy.this.cv.get((int)j).unperturbedRank.doubleValue())) {
                    c = 1;
                }
                if (r1 < r2) {
                    c = -1;
                }
                return c;
            }
        });
        return conarray;
    }

    public Constraint[] sortByPerturbedRank() {
        Constraint[] conarray = new Constraint[this.cv.size()];
        int size = this.cv.size();
        int i = 0;
        while (i < size) {
            conarray[i] = this.cv.get((int)i).con;
            ++i;
        }
        Arrays.sort(conarray, new Comparator<Object>(){

            @Override
            public int compare(Object ao, Object bo) {
                double r2;
                Constraint a = (Constraint)ao;
                Constraint b = (Constraint)bo;
                int c = 0;
                int i = Hierarchy.this.cv.indexOf(new ConstrValue(a));
                int j = Hierarchy.this.cv.indexOf(new ConstrValue(b));
                double r1 = Hierarchy.this.cv.get((int)i).perturbedRank;
                if (r1 > (r2 = Hierarchy.this.cv.get((int)j).perturbedRank.doubleValue())) {
                    c = 1;
                }
                if (r1 < r2) {
                    c = -1;
                }
                return c;
            }
        });
        return conarray;
    }

    public Constraint[] sortByWeight() {
        Constraint[] conarray = new Constraint[this.cv.size()];
        int size = this.cv.size();
        int i = 0;
        while (i < size) {
            conarray[i] = this.cv.get((int)i).con;
            ++i;
        }
        Arrays.sort(conarray, new Comparator<Object>(){

            @Override
            public int compare(Object ao, Object bo) {
                double w2;
                Constraint a = (Constraint)ao;
                Constraint b = (Constraint)bo;
                int c = 0;
                int i = Hierarchy.this.cv.indexOf(new ConstrValue(a));
                int j = Hierarchy.this.cv.indexOf(new ConstrValue(b));
                double w1 = Hierarchy.this.cv.get((int)i).weight;
                if (w1 < (w2 = Hierarchy.this.cv.get((int)j).weight.doubleValue())) {
                    c = 1;
                }
                if (w1 > w2) {
                    c = -1;
                }
                return c;
            }
        });
        return conarray;
    }

    public Constraint[] sortBy(String rank) {
        Constraint[] conarray = new Constraint[this.cv.size()];
        int size = this.cv.size();
        int i = 0;
        while (i < size) {
            conarray[i] = this.cv.get((int)i).con;
            ++i;
        }
        final String r = rank;
        Arrays.sort(conarray, new Comparator<Object>(){

            @Override
            public int compare(Object ao, Object bo) {
                ConstrValue cv2;
                Constraint a = (Constraint)ao;
                Constraint b = (Constraint)bo;
                int c = 0;
                int i = Hierarchy.this.cv.indexOf(new ConstrValue(a));
                int j = Hierarchy.this.cv.indexOf(new ConstrValue(b));
                ConstrValue cv1 = Hierarchy.this.cv.get(i);
                if (cv1.isHigherRanked(cv2 = Hierarchy.this.cv.get(j), r)) {
                    c = 1;
                }
                if (cv2.isHigherRanked(cv1, r)) {
                    c = -1;
                }
                return c;
            }
        });
        return conarray;
    }

    public void copyRank(String r1, String r2) {
        for (ConstrValue c : this.cv) {
            c.setRank(r2, c.getRank(r1));
        }
    }

    public void increaseRank(Constraint cnstr, double delta) {
        int i = this.cv.indexOf(new ConstrValue(cnstr));
        if (i > -1) {
            this.cv.get((int)i).rank = this.cv.get((int)i).rank + delta;
        }
    }

    public void rank2weight(double q) {
        if (q > 0.0) {
            for (ConstrValue c : this.cv) {
                c.weight = -Math.pow(q, c.rank);
            }
        } else {
            throw new RuntimeException("Base must be positive.");
        }
    }

    public void weight2rank(double q) {
        double logq = Math.log(q);
        if (q > 0.0) {
            for (ConstrValue c : this.cv) {
                c.rank = Math.log(-c.weight.doubleValue()) / logq;
            }
        } else {
            throw new RuntimeException("Base must be positive.");
        }
    }

    public void perturbUniform(double r) {
        for (ConstrValue co : this.cv) {
            co.perturbedRank = co.unperturbedRank + r * Math.random();
        }
    }

    public void perturbUniform(double r, double m) {
        double m1 = m - r / 2.0;
        for (ConstrValue co : this.cv) {
            co.perturbedRank = co.unperturbedRank + m1 + r * Math.random();
        }
    }

    public void perturbGaussian(double m, double s) {
        Random generator = new Random((int)(100000.0 * Math.random()));
        for (ConstrValue co : this.cv) {
            co.perturbedRank = co.unperturbedRank + m + s * generator.nextGaussian();
        }
    }

    public void perturbed2rank() {
        for (ConstrValue c : this.cv) {
            c.rank = c.perturbedRank;
        }
    }

    public void unperturbed2rank() {
        for (ConstrValue c : this.cv) {
            c.rank = c.unperturbedRank;
        }
    }

    public void kvalue2rank() {
        for (ConstrValue c : this.cv) {
            c.rank = c.kvalue;
        }
    }

    public void sortByRank2hierarchyKvalue() {
        Constraint[] conarray = new Constraint[this.cv.size()];
        int size = this.cv.size();
        int i = 0;
        while (i < size) {
            conarray[i] = this.cv.get((int)i).con;
            ++i;
        }
        Arrays.sort(conarray, new Comparator<Object>(){

            @Override
            public int compare(Object ao, Object bo) {
                double r2;
                Constraint a = (Constraint)ao;
                Constraint b = (Constraint)bo;
                int c = 0;
                int i = Hierarchy.this.cv.indexOf(new ConstrValue(a));
                int j = Hierarchy.this.cv.indexOf(new ConstrValue(b));
                double r1 = Hierarchy.this.cv.get((int)i).rank;
                if (r1 > (r2 = Hierarchy.this.cv.get((int)j).rank.doubleValue())) {
                    c = 1;
                }
                if (r1 < r2) {
                    c = -1;
                }
                return c;
            }
        });
        i = 0;
        while (i < size) {
            this.setKvalue(conarray[i], (double)i);
            ++i;
        }
    }

    public void sortByRank2hierarchyWeight(double q) {
        Constraint[] conarray = new Constraint[this.cv.size()];
        int size = this.cv.size();
        int i = 0;
        while (i < size) {
            conarray[i] = this.cv.get((int)i).con;
            ++i;
        }
        Arrays.sort(conarray, new Comparator<Object>(){

            @Override
            public int compare(Object ao, Object bo) {
                double r2;
                Constraint a = (Constraint)ao;
                Constraint b = (Constraint)bo;
                int c = 0;
                int i = Hierarchy.this.cv.indexOf(new ConstrValue(a));
                int j = Hierarchy.this.cv.indexOf(new ConstrValue(b));
                double r1 = Hierarchy.this.cv.get((int)i).rank;
                if (r1 > (r2 = Hierarchy.this.cv.get((int)j).rank.doubleValue())) {
                    c = 1;
                }
                if (r1 < r2) {
                    c = -1;
                }
                return c;
            }
        });
        i = 0;
        while (i < size) {
            this.setWeight(conarray[i], -Math.pow(q, i));
            ++i;
        }
    }

    public void sortByRank2hierarchyKvalueAndWeight(double q) {
        Constraint[] conarray = new Constraint[this.cv.size()];
        int size = this.cv.size();
        int i = 0;
        while (i < size) {
            conarray[i] = this.cv.get((int)i).con;
            ++i;
        }
        Arrays.sort(conarray, new Comparator<Object>(){

            @Override
            public int compare(Object ao, Object bo) {
                double r2;
                Constraint a = (Constraint)ao;
                Constraint b = (Constraint)bo;
                int c = 0;
                int i = Hierarchy.this.cv.indexOf(new ConstrValue(a));
                int j = Hierarchy.this.cv.indexOf(new ConstrValue(b));
                double r1 = Hierarchy.this.cv.get((int)i).rank;
                if (r1 > (r2 = Hierarchy.this.cv.get((int)j).rank.doubleValue())) {
                    c = 1;
                }
                if (r1 < r2) {
                    c = -1;
                }
                return c;
            }
        });
        this.sortedByRank = conarray;
        i = 0;
        while (i < size) {
            this.setWeight(conarray[i], -Math.pow(q, i));
            this.setKvalue(conarray[i], (double)i);
            ++i;
        }
    }

    public HashSet<String> allRankingVariables() {
        HashSet<String> rv = new HashSet<String>();
        for (ConstrValue cova : this.cv) {
            if (cova.rank < Double.POSITIVE_INFINITY) {
                rv.add(RANK);
            }
            if (cova.rank1 < Double.POSITIVE_INFINITY) {
                rv.add(RANK1);
            }
            if (cova.rank2 < Double.POSITIVE_INFINITY) {
                rv.add(RANK2);
            }
            if (cova.perturbedRank < Double.POSITIVE_INFINITY) {
                rv.add(PERTURBED_RANK);
            }
            if (cova.unperturbedRank < Double.POSITIVE_INFINITY) {
                rv.add(UNPERTURBED_RANK);
            }
            if (cova.kvalue < Double.POSITIVE_INFINITY) {
                rv.add(KVALUE);
            }
            if (cova.weight < Double.POSITIVE_INFINITY) {
                rv.add(WEIGHT);
            }
            for (String rankvar : cova.rvariable.keySet()) {
                rv.add(rankvar);
            }
        }
        return rv;
    }

    public void removeConstraint(Constraint cnstr) {
        ConstrValue cnstrvalue = new ConstrValue(cnstr);
        int i = this.cv.indexOf(cnstrvalue);
        if (i == -1) {
            throw unknownCon;
        }
        this.cv.remove(i);
    }

    public void removeConstraint(String cnstr) {
        int cvsize = this.cv.size();
        int i = 0;
        while (i < cvsize) {
            if (this.cv.get((int)i).con.name().equals(cnstr)) {
                this.cv.remove(i);
                i = cvsize + 1;
            }
            ++i;
        }
        if (i == cvsize) {
            throw unknownConName;
        }
    }

    public HashMap<Constraint, Violation> value(Candidate can) {
        HashMap<Constraint, Violation> hashmap = new HashMap<Constraint, Violation>();
        for (ConstrValue constrval : this.cv) {
            hashmap.put(constrval.con, constrval.con.value(can));
        }
        return hashmap;
    }

    public int numberOfConstraints() {
        return this.cv.size();
    }

    public Hierarchy clone() {
        Hierarchy hier = new Hierarchy();
        hier.name = this.name;
        hier.type = this.type;
        for (ConstrValue c : this.cv) {
            hier.cv.add(c.clone());
        }
        return hier;
    }

    class ConstrValue {
        Constraint con;
        Double kvalue = Double.NaN;
        Double rank = Double.NaN;
        Double rank1 = Double.NaN;
        Double rank2 = Double.NaN;
        Double unperturbedRank = Double.NaN;
        Double perturbedRank = Double.NaN;
        Double weight = Double.NaN;
        String setrank = null;
        Violation violrank = null;
        HashMap<String, Double> rvariable = new HashMap();

        ConstrValue(Constraint cnstr) {
            this.con = cnstr;
        }

        public boolean equals(Object constrvalue) {
            boolean value = false;
            if (constrvalue != null && constrvalue.getClass().equals(this.getClass())) {
                ConstrValue f = (ConstrValue)constrvalue;
                value = f.con.name().equals(this.con.name());
            }
            return value;
        }

        public ConstrValue clone() {
            ConstrValue cv = new ConstrValue(this.con);
            cv.kvalue = this.kvalue;
            cv.rank = this.rank;
            cv.rank1 = this.rank1;
            cv.rank2 = this.rank2;
            cv.unperturbedRank = this.unperturbedRank;
            cv.perturbedRank = this.perturbedRank;
            cv.weight = this.weight;
            if (this.setrank != null) {
                cv.setrank = this.setrank;
            }
            if (this.violrank != null) {
                cv.violrank = this.violrank.clone();
            }
            for (String k : this.rvariable.keySet()) {
                cv.rvariable.put(k, this.rvariable.get(k));
            }
            return cv;
        }

        public void setRank(String rank, Object value) {
            Double d = Double.NaN;
            try {
                d = Double.parseDouble(value.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (value == no_ranking_value) {
                if (rank.equals(Hierarchy.RANK)) {
                    this.rank = Double.NaN;
                } else if (rank.equals(Hierarchy.RANK1)) {
                    this.rank1 = Double.NaN;
                } else if (rank.equals(Hierarchy.RANK2)) {
                    this.rank2 = Double.NaN;
                } else if (rank.equals(Hierarchy.UNPERTURBED_RANK)) {
                    this.unperturbedRank = Double.NaN;
                } else if (rank.equals(Hierarchy.PERTURBED_RANK)) {
                    this.perturbedRank = Double.NaN;
                } else if (rank.equals(Hierarchy.KVALUE)) {
                    this.kvalue = Double.NaN;
                } else if (rank.equals(Hierarchy.WEIGHT)) {
                    this.weight = Double.NaN;
                } else if (rank.equals(Hierarchy.SETRANK)) {
                    this.setrank = null;
                } else if (rank.equals(Hierarchy.VIOLRANK)) {
                    this.setrank = null;
                } else {
                    this.rvariable.remove(rank);
                }
            } else if (rank.equals(Hierarchy.RANK)) {
                this.rank = d;
            } else if (rank.equals(Hierarchy.RANK1)) {
                this.rank1 = d;
            } else if (rank.equals(Hierarchy.RANK2)) {
                this.rank2 = d;
            } else if (rank.equals(Hierarchy.UNPERTURBED_RANK)) {
                this.unperturbedRank = d;
            } else if (rank.equals(Hierarchy.PERTURBED_RANK)) {
                this.perturbedRank = d;
            } else if (rank.equals(Hierarchy.KVALUE)) {
                this.kvalue = d;
            } else if (rank.equals(Hierarchy.WEIGHT)) {
                this.weight = d;
            } else if (rank.equals(Hierarchy.SETRANK)) {
                this.setrank = value.toString();
            } else if (rank.equals(Hierarchy.VIOLRANK)) {
                this.violrank = (Violation)value;
            } else {
                this.rvariable.put(rank, d);
            }
        }

        public Object getRank(String rankname) {
            Object o = rankname.equals(Hierarchy.RANK) ? this.rank : (rankname.equals(Hierarchy.RANK1) ? this.rank1 : (rankname.equals(Hierarchy.RANK2) ? this.rank2 : (rankname.equals(Hierarchy.PERTURBED_RANK) ? this.perturbedRank : (rankname.equals(Hierarchy.UNPERTURBED_RANK) ? this.unperturbedRank : (rankname.equals(Hierarchy.KVALUE) ? this.kvalue : (rankname.equals(Hierarchy.WEIGHT) ? this.weight : (rankname.equals(Hierarchy.VIOLRANK) ? (this.violrank != null ? this.violrank : no_ranking_value) : (rankname.equals(Hierarchy.SETRANK) ? (this.setrank != null ? this.setrank : no_ranking_value) : (this.rvariable.containsKey(rankname) ? this.rvariable.get(rankname) : no_ranking_value)))))))));
            if (o.equals(Double.NaN)) {
                o = no_ranking_value;
            }
            return o;
        }

        public boolean isHigherRanked(ConstrValue cv, String rank) {
            if (rank.equals(Hierarchy.RANK)) {
                return this.rank > cv.rank;
            }
            if (rank.equals(Hierarchy.RANK1)) {
                return this.rank1 > cv.rank1;
            }
            if (rank.equals(Hierarchy.RANK2)) {
                return this.rank2 > cv.rank2;
            }
            if (rank.equals(Hierarchy.UNPERTURBED_RANK)) {
                return this.unperturbedRank > cv.unperturbedRank;
            }
            if (rank.equals(Hierarchy.PERTURBED_RANK)) {
                return this.perturbedRank > cv.perturbedRank;
            }
            if (rank.equals(Hierarchy.KVALUE)) {
                return this.kvalue > cv.kvalue;
            }
            if (rank.equals(Hierarchy.WEIGHT)) {
                return this.weight < cv.weight;
            }
            if (rank.equals(Hierarchy.SETRANK)) {
                String thi = this.setrank;
                String oth = cv.setrank;
                boolean b = true;
                int i = 0;
                while (b && i < oth.length()) {
                    b = b && thi.lastIndexOf(oth.charAt(i)) > -1;
                    ++i;
                }
                return b;
            }
            if (rank.equals(Hierarchy.VIOLRANK)) {
                return Violation.isBetter(this.violrank, cv.violrank);
            }
            return this.rvariable.get(rank) > cv.rvariable.get(rank);
        }
    }
}

