/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.performance;

import hu.birot.OTKit.performance.CoolingSchedule;
import hu.birot.OTKit.performance.Temperature;

public class CoolingScheduleExamples {
    public static final double EPSILON = 1.0E-9;

    public static CoolingSchedule linear(final double t_max, double t_min, final double t_step) {
        CoolingSchedule cs = new CoolingSchedule(t_min){
            private final double tmin;
            {
                this.tmin = d + 1.0E-9;
            }

            public Temperature initial() {
                Temperature tempinit = new Temperature(t_max);
                return tempinit;
            }

            public Temperature next(Temperature t) {
                Temperature tempnew = t.clone();
                tempnew.real -= t_step;
                return tempnew;
            }

            public boolean stop(Temperature t) {
                return t.real < this.tmin;
            }
        };
        return cs;
    }

    public static CoolingSchedule linear(final double t_max, double t_min, final double t_step, final int repeat) {
        CoolingSchedule cs = new CoolingSchedule(t_min){
            private final double tmin;
            {
                this.tmin = d + 1.0E-9;
            }

            public Temperature initial() {
                Temperature tempinit = new Temperature(t_max);
                tempinit.counter = repeat;
                return tempinit;
            }

            public Temperature next(Temperature t) {
                Temperature tempnew = t.clone();
                --tempnew.counter;
                if (tempnew.counter == 0) {
                    tempnew.real -= t_step;
                    tempnew.counter = repeat;
                }
                return tempnew;
            }

            public boolean stop(Temperature t) {
                return t.real < this.tmin;
            }
        };
        return cs;
    }

    public static CoolingSchedule exponential(final double t_max, double t_min, final double q) {
        CoolingSchedule cs = new CoolingSchedule(t_min){
            private final double tmin;
            {
                this.tmin = d + 1.0E-9;
            }

            public Temperature initial() {
                Temperature tempinit = new Temperature(t_max);
                return tempinit;
            }

            public Temperature next(Temperature t) {
                Temperature tempnew = t.clone();
                tempnew.real *= q;
                return tempnew;
            }

            public boolean stop(Temperature t) {
                return t.real < this.tmin;
            }
        };
        return cs;
    }

    public static CoolingSchedule exponential(final double t_max, double t_min, final double q, final int repeat) {
        CoolingSchedule cs = new CoolingSchedule(t_min){
            private final double tmin;
            {
                this.tmin = d + 1.0E-9;
            }

            public Temperature initial() {
                Temperature tempinit = new Temperature(t_max);
                tempinit.counter = repeat;
                return tempinit;
            }

            public Temperature next(Temperature t) {
                Temperature tempnew = t.clone();
                --tempnew.counter;
                if (tempnew.counter == 0) {
                    tempnew.real *= q;
                    tempnew.counter = repeat;
                }
                return tempnew;
            }

            public boolean stop(Temperature t) {
                return t.real < this.tmin;
            }
        };
        return cs;
    }

    public static CoolingSchedule saot(final double k_max, double k_min, final double k_step, final double t_max, double t_min, final double t_step, final int repeat) {
        CoolingSchedule cs = new CoolingSchedule(t_min, k_min){
            private final double tmin;
            private final double kmin;
            {
                this.tmin = d + 1.0E-9;
                this.kmin = d2 - 1.0E-9;
            }

            public Temperature initial() {
                Temperature tempinit = new Temperature(k_max, t_max);
                tempinit.counter = repeat;
                return tempinit;
            }

            public Temperature next(Temperature t) {
                Temperature tempnew = t.clone();
                --tempnew.counter;
                if (tempnew.counter == 0) {
                    tempnew.real -= t_step;
                    tempnew.counter = repeat;
                    if (tempnew.real <= this.tmin) {
                        tempnew.range -= k_step;
                        tempnew.real = t_max;
                    }
                }
                return tempnew;
            }

            public boolean stop(Temperature t) {
                return t.range < this.kmin;
            }
        };
        return cs;
    }

    public static CoolingSchedule saot(final double k_max, double k_min, final double k_step, final double t_max, double t_min, final double t_step) {
        CoolingSchedule cs = new CoolingSchedule(t_min, k_min){
            private final double tmin;
            private final double kmin;
            {
                this.tmin = d + 1.0E-9;
                this.kmin = d2 - 1.0E-9;
            }

            public Temperature initial() {
                Temperature tempinit = new Temperature(k_max, t_max);
                return tempinit;
            }

            public Temperature next(Temperature t) {
                Temperature tempnew = t.clone();
                tempnew.real -= t_step;
                if (tempnew.real <= this.tmin) {
                    tempnew.range -= k_step;
                    tempnew.real = t_max;
                }
                return tempnew;
            }

            public boolean stop(Temperature t) {
                return t.range < this.kmin;
            }
        };
        return cs;
    }

    public static CoolingSchedule linearNM(final double t_max, final double t_step, final int notmoved) {
        CoolingSchedule cs = new CoolingSchedule(){

            public Temperature initial() {
                Temperature tempinit = new Temperature(t_max);
                return tempinit;
            }

            public Temperature next(Temperature t) {
                Temperature tempnew = t.clone();
                tempnew.real -= t_step;
                return tempnew;
            }

            public boolean stop(Temperature t) {
                return t.unmoved >= notmoved;
            }
        };
        return cs;
    }

    public static CoolingSchedule linearNM(final double t_max, final double t_step, final int notmoved, final int repeat) {
        CoolingSchedule cs = new CoolingSchedule(){

            public Temperature initial() {
                Temperature tempinit = new Temperature(t_max);
                tempinit.counter = repeat;
                return tempinit;
            }

            public Temperature next(Temperature t) {
                Temperature tempnew = t.clone();
                --tempnew.counter;
                if (tempnew.counter == 0) {
                    tempnew.real -= t_step;
                    tempnew.counter = repeat;
                }
                return tempnew;
            }

            public boolean stop(Temperature t) {
                return t.unmoved >= notmoved;
            }
        };
        return cs;
    }

    public static CoolingSchedule exponentialNM(final double t_max, final double q, final int notmoved) {
        CoolingSchedule cs = new CoolingSchedule(){

            public Temperature initial() {
                Temperature tempinit = new Temperature(t_max);
                return tempinit;
            }

            public Temperature next(Temperature t) {
                Temperature tempnew = t.clone();
                tempnew.real *= q;
                return tempnew;
            }

            public boolean stop(Temperature t) {
                return t.unmoved >= notmoved;
            }
        };
        return cs;
    }

    public static CoolingSchedule exponentialNM(final double t_max, final double q, final int notmoved, final int repeat) {
        CoolingSchedule cs = new CoolingSchedule(){

            public Temperature initial() {
                Temperature tempinit = new Temperature(t_max);
                tempinit.counter = repeat;
                return tempinit;
            }

            public Temperature next(Temperature t) {
                Temperature tempnew = t.clone();
                --tempnew.counter;
                if (tempnew.counter == 0) {
                    tempnew.real *= q;
                    tempnew.counter = repeat;
                }
                return tempnew;
            }

            public boolean stop(Temperature t) {
                return t.unmoved >= notmoved;
            }
        };
        return cs;
    }

    public static CoolingSchedule saotNM(final double k_max, final double k_step, final double t_max, double t_min, final double t_step, final int notmoved, final int repeat) {
        CoolingSchedule cs = new CoolingSchedule(t_min){
            private final double tmin;
            {
                this.tmin = d + 1.0E-9;
            }

            public Temperature initial() {
                Temperature tempinit = new Temperature(k_max, t_max);
                tempinit.counter = repeat;
                return tempinit;
            }

            public Temperature next(Temperature t) {
                Temperature tempnew = t.clone();
                --tempnew.counter;
                if (tempnew.counter == 0) {
                    tempnew.real -= t_step;
                    tempnew.counter = repeat;
                    if (tempnew.real <= this.tmin) {
                        tempnew.range -= k_step;
                        tempnew.real = t_max;
                    }
                }
                return tempnew;
            }

            public boolean stop(Temperature t) {
                return t.unmoved >= notmoved;
            }
        };
        return cs;
    }

    public static CoolingSchedule saotNM(final double k_max, final double k_step, final double t_max, double t_min, final double t_step, final int notmoved) {
        CoolingSchedule cs = new CoolingSchedule(t_min){
            private final double tmin;
            {
                this.tmin = d + 1.0E-9;
            }

            public Temperature initial() {
                Temperature tempinit = new Temperature(k_max, t_max);
                return tempinit;
            }

            public Temperature next(Temperature t) {
                Temperature tempnew = t.clone();
                tempnew.real -= t_step;
                if (tempnew.real <= this.tmin) {
                    tempnew.range -= k_step;
                    tempnew.real = t_max;
                }
                return tempnew;
            }

            public boolean stop(Temperature t) {
                return t.unmoved >= notmoved;
            }
        };
        return cs;
    }
}

