/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.performance;

import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Eval;
import hu.birot.OTKit.otBuildingBlocks.Hierarchy;
import hu.birot.OTKit.otBuildingBlocks.Topology;
import hu.birot.OTKit.performance.CoolingSchedule;
import hu.birot.OTKit.performance.RulesOfMoving;
import hu.birot.OTKit.performance.Temperature;
import java.util.Vector;

public class RandomWalks {
    public static boolean verbose = false;

    public static Temperature randomWalk(Candidate w_init, Topology candidate_set, Hierarchy h, RulesOfMoving rom, CoolingSchedule cooling_schedule) {
        Candidate w;
        Candidate w1 = w = w_init;
        if (h.type.equalsIgnoreCase("ot")) {
            h.sortByRank();
        }
        Temperature t = cooling_schedule.initial();
        while (!cooling_schedule.stop(t)) {
            w1 = candidate_set.rndNeighborOf(w, Math.random());
            if (verbose) {
                System.err.println("T = " + t + " ; Position = " + w + " ; Neighbor = " + w1);
            }
            if (rom.move(w, w1, h, t)) {
                w = w1;
                t.unmoved = 0;
            } else {
                ++t.unmoved;
            }
            ++t.iterations;
            t = cooling_schedule.next(t);
        }
        t.output = w;
        return t;
    }

    public static Temperature gradientWalkrnd(Candidate w_init, Topology candidate_set, Hierarchy h, RulesOfMoving rom, CoolingSchedule cooling_schedule) {
        Candidate w;
        Candidate w1 = w = w_init;
        Vector<Object> bestneighbors = new Vector();
        if (h.type.equalsIgnoreCase("ot")) {
            h.sortByRank();
        }
        Temperature t = cooling_schedule.initial();
        while (!cooling_schedule.stop(t)) {
            bestneighbors = Eval.Compare(candidate_set.allNeighborsOf(w), h);
            w1 = (Candidate)bestneighbors.get((int)((double)bestneighbors.size() * Math.random()));
            if (verbose) {
                System.err.println("T = " + t + " ; Position = " + w + " ; Neighbor = " + w1);
            }
            if (rom.move(w, w1, h, t)) {
                w = w1;
                t.unmoved = 0;
            } else {
                ++t.unmoved;
            }
            ++t.iterations;
            t = cooling_schedule.next(t);
        }
        t.output = w;
        return t;
    }

    public static Temperature gradientWalk(Candidate w_init, Topology candidate_set, Hierarchy h, RulesOfMoving rom, CoolingSchedule cooling_schedule) {
        Candidate w;
        Candidate w1 = w = w_init;
        if (h.type.equalsIgnoreCase("ot")) {
            h.sortByRank();
        }
        Temperature t = cooling_schedule.initial();
        while (!cooling_schedule.stop(t)) {
            w1 = Eval.Compare(candidate_set.allNeighborsOf(w), h).get(0);
            if (verbose) {
                System.err.println("T = " + t + " ; Position = " + w + " ; Neighbor = " + w1);
            }
            if (rom.move(w, w1, h, t)) {
                w = w1;
                t.unmoved = 0;
            } else {
                ++t.unmoved;
            }
            ++t.iterations;
            t = cooling_schedule.next(t);
        }
        t.output = w;
        return t;
    }
}

