/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.performance;

import hu.birot.OTKit.dataType.Comparison;
import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Eval;
import hu.birot.OTKit.otBuildingBlocks.Hierarchy;
import hu.birot.OTKit.performance.RulesOfMoving;
import hu.birot.OTKit.performance.Temperature;

public class RulesOfMovingExamples {
    public static final double EPSILON = 1.0E-9;

    public static RulesOfMoving hillClimbing() {
        RulesOfMoving rom = new RulesOfMoving(){

            public boolean move(Candidate c1, Candidate c2, Hierarchy h, Temperature t) {
                return !Eval.Compare((Candidate)c1, (Candidate)c2, (Hierarchy)h).isBetterThan;
            }
        };
        return rom;
    }

    public static RulesOfMoving simulatedAnnealing() {
        RulesOfMoving rom = new RulesOfMoving(){

            public boolean move(Candidate c1, Candidate c2, Hierarchy h, Temperature t) {
                double r;
                boolean move = true;
                Comparison comp = Eval.Compare(c1, c2, h);
                if (comp.isBetterThan && (r = Math.random()) >= this.expo(comp, t, h)) {
                    move = false;
                }
                return move;
            }

            double expo(Comparison c, Temperature t, Hierarchy h) {
                double e = 0.0;
                if (h.type.equalsIgnoreCase("hg")) {
                    e = Math.exp(-c.difference / t.real);
                } else if (h.type.equalsIgnoreCase("ot")) {
                    e = h.kvalueOf(c.fatal) > t.range + 1.0E-9 ? 0.0 : (h.kvalueOf(c.fatal) < t.range - 1.0E-9 ? 1.0 : Math.exp(c.difference / t.real));
                } else {
                    throw new RuntimeException("Type of hierarchy is not 'or' or 'hg'.");
                }
                return e;
            }
        };
        return rom;
    }
}

