/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.runableExamples;

import hu.birot.OTKit.dataType.Form;
import hu.birot.OTKit.dataType.FormValuePair;
import hu.birot.OTKit.dataType.MapFormExamples;
import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Constraint;
import hu.birot.OTKit.otBuildingBlocks.ConstraintExamples;
import hu.birot.OTKit.otBuildingBlocks.Gen;
import hu.birot.OTKit.otBuildingBlocks.GenExamples;
import hu.birot.OTKit.otBuildingBlocks.Hierarchy;
import hu.birot.OTKit.otBuildingBlocks.Topology;
import hu.birot.OTKit.performance.CoolingScheduleExamples;
import hu.birot.OTKit.performance.RandomWalks;
import hu.birot.OTKit.performance.RulesOfMovingExamples;
import hu.birot.OTKit.performance.Temperature;
import java.util.HashMap;
import java.util.Vector;

public class Delta_shape {
    public static void main(String[] args) {
        Candidate a = new Candidate("A"){

            public String toString() {
                return "Candidate A";
            }
        };
        Candidate b = new Candidate("B"){

            public String toString() {
                return "Candidate B";
            }
        };
        Candidate c = new Candidate("C"){

            public String toString() {
                return "Candidate C";
            }
        };
        String[] candidate_strings = new String[]{"A", "B", "C"};
        Gen gen = GenExamples.listOfSurfaceForms(candidate_strings);
        Form[] candidates = new Form[]{a.sf, b.sf, c.sf};
        gen = GenExamples.listOfSurfaceForms(candidates);
        HashMap<Form, FormValuePair[]> hm = new HashMap<Form, FormValuePair[]>();
        FormValuePair[] step1 = new FormValuePair[]{new FormValuePair(b.sf, 1.0)};
        hm.put(a.sf, step1);
        FormValuePair[] step2 = new FormValuePair[]{new FormValuePair(a.sf, 1.0), new FormValuePair(c.sf, 1.0)};
        hm.put(b.sf, step2);
        FormValuePair[] step3 = new FormValuePair[]{new FormValuePair(b.sf, 1.0)};
        hm.put(c.sf, step3);
        Topology candidateset = new Topology(MapFormExamples.equals(hm));
        System.out.println("Neighbourhood:");
        Vector<Candidate> all = gen.allCandidates(new Form());
        Vector<Object> neig = new Vector();
        for (Candidate x : all) {
            System.out.print(x + ":");
            neig = candidateset.allNeighborsOf(x);
            for (Candidate candidate : neig) {
                System.out.print(candidate + " ");
            }
            System.out.println("");
        }
        Constraint c1 = ConstraintExamples.equal("noB", "B", 1.0);
        Constraint c2 = ConstraintExamples.equal("noC", "C", 1.0);
        Hierarchy hierarchy = new Hierarchy();
        hierarchy.type = "OT";
        hierarchy.addConstraintWithKvalue(c1, 2.0);
        hierarchy.addConstraintWithKvalue(c2, 1.0);
        hierarchy.kvalue2rank();
        System.out.println();
        System.out.println("Tableau:");
        System.out.println("    " + c1.name() + " | " + c2.name());
        System.out.println(String.valueOf(a.sf.string()) + " : " + c1.value(a).value() + " | " + c2.value(a).value() + " ");
        System.out.println(String.valueOf(b.sf.string()) + " : " + c1.value(b).value() + " | " + c2.value(b).value() + " ");
        System.out.println(String.valueOf(c.sf.string()) + " : " + c1.value(c).value() + " | " + c2.value(c).value() + " ");
        System.out.println();
        System.out.println("Random walk:");
        int i = 0;
        while (i < 100) {
            Temperature t = RandomWalks.randomWalk(b, candidateset, hierarchy, RulesOfMovingExamples.simulatedAnnealing(), CoolingScheduleExamples.saot(5.0, -2.0, 1.0, 3.0, 0.0, 0.1));
            System.out.println("Run nr. " + i + " from " + b.sf.string() + " has returned output " + t.output.sf.string() + " while performaning " + t.iterations + " iterations.");
            ++i;
        }
    }
}

