/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.uiMyElements;

import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.uiMyElements.MyElement;
import hu.birot.OTKit.uiMyElements.Scheme_cand;
import hu.birot.OTKit.uiMyElements.Universe;
import hu.birot.OTKit.userInterface.OTKit;
import hu.birot.OTKit.userInterface.XMLstuff;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MyCandidate
extends MyElement {
    private String name;
    private String scheme;
    public Vector<String> params = new Vector();

    public String name() {
        return this.name;
    }

    public String scheme() {
        return this.scheme;
    }

    public String tag() {
        return "my_candidate";
    }

    public Node toXML() {
        Document doc = XMLstuff.emptyDocument();
        Element root = doc.createElement("my_candidate");
        doc.appendChild(root);
        root.setAttribute("name", this.name);
        root.setAttribute("scheme", this.scheme);
        int i = 0;
        while (i < this.params.size()) {
            if (this.params.get(i) != null) {
                Element param = doc.createElement("param");
                param.setAttribute("number", "" + (i + 1));
                param.setTextContent(this.params.get(i));
                root.appendChild(param);
            }
            ++i;
        }
        return doc;
    }

    public MyCandidate(String n, String s) {
        this.name = n;
        this.scheme = s;
    }

    public MyCandidate(Node xml) {
        if (xml.getNodeType() != 1 || !xml.getNodeName().equals("my_candidate")) {
            OTKit.error("Not a my_candidate XML tree!");
            OTKit.return_err("Not a my_candidate XML tree!");
        } else {
            this.scheme = xml.getAttributes().getNamedItem("scheme").getNodeValue();
            this.name = xml.getAttributes().getNamedItem("name").getNodeValue();
            this.params.setSize(this.params.size() + 1);
            Node n = xml.getFirstChild();
            while (n != null) {
                if (n.getNodeName().equals("param")) {
                    this.params.setSize(this.params.size() + 1);
                }
                n = n.getNextSibling();
            }
            n = xml.getFirstChild();
            while (n != null) {
                if (n.getNodeName().equals("param")) {
                    int i = Integer.parseInt(n.getAttributes().getNamedItem("number").getNodeValue());
                    this.params.set(i - 1, n.getTextContent());
                }
                n = n.getNextSibling();
            }
            if (Scheme_cand.name2scheme.get(this.scheme) == null) {
                OTKit.error("Candidate scheme '" + this.scheme + "' does not exists!");
                OTKit.return_err("Candidate scheme '" + this.scheme + "' does not exists!");
                this.cand(OTKit.MyUniverse);
            } else {
                this.cand(OTKit.MyUniverse);
            }
        }
    }

    public Candidate cand(Universe U) {
        return Scheme_cand.name2scheme.get(this.scheme).cand(this.name, this.params, U);
    }

    public String shortScript() {
        return "Candidate(\"" + this.name + "\")";
    }

    public String longScript() {
        String h = "Candidate( \"" + this.name + "\", \"" + this.scheme + "\"";
        int i = 0;
        while (i < this.params.size()) {
            if (this.params.get(i) != null) {
                h = String.valueOf(h) + " , \"" + this.params.get(i) + "\"";
            }
            ++i;
        }
        return String.valueOf(h) + " )";
    }

    public MyCandidate clone() {
        MyCandidate mc = new MyCandidate(this.name, this.scheme);
        mc.params = new Vector();
        for (String p : this.params) {
            mc.params.add(p);
        }
        return mc;
    }
}

