/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.uiMyElements;

import hu.birot.OTKit.otBuildingBlocks.Constraint;
import hu.birot.OTKit.uiMyElements.MyElement;
import hu.birot.OTKit.uiMyElements.Scheme_constr;
import hu.birot.OTKit.uiMyElements.Universe;
import hu.birot.OTKit.userInterface.OTKit;
import hu.birot.OTKit.userInterface.XMLstuff;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MyConstraint
extends MyElement {
    public String name;
    public String scheme;
    public Vector<String> params = new Vector();
    public String short_descr;
    public String long_descr;

    public Constraint con(Universe U) {
        return Scheme_constr.name2scheme.get(this.scheme).con(this.name, this.params, U);
    }

    public MyConstraint clone() {
        MyConstraint mc = new MyConstraint();
        mc.long_descr = this.long_descr;
        mc.name = this.name;
        mc.scheme = this.scheme;
        mc.short_descr = this.short_descr;
        mc.params = new Vector();
        for (String s : this.params) {
            mc.params.add(s);
        }
        return mc;
    }

    public MyConstraint() {
        this.name = "";
        this.short_descr = "";
        this.long_descr = "";
        this.scheme = "";
        this.params = new Vector();
    }

    public MyConstraint(Node xml) {
        if (xml.getNodeType() != 1 || !xml.getNodeName().equals("my_constraint")) {
            OTKit.error("Not a my_constraint XML tree!");
            OTKit.return_err("Not a my_constraint XML tree!");
        } else {
            this.scheme = xml.getAttributes().getNamedItem("scheme").getNodeValue();
            this.name = xml.getAttributes().getNamedItem("name").getNodeValue();
            this.params.setSize(this.params.size() + 1);
            Node n = xml.getFirstChild();
            while (n != null) {
                if (n.getNodeName().equals("param")) {
                    this.params.setSize(this.params.size() + 1);
                }
                n = n.getNextSibling();
            }
            n = xml.getFirstChild();
            while (n != null) {
                if (n.getNodeName().equals("short_descr")) {
                    this.short_descr = n.getTextContent();
                } else if (n.getNodeName().equals("long_descr")) {
                    this.long_descr = n.getTextContent();
                } else if (n.getNodeName().equals("param")) {
                    int i = Integer.parseInt(n.getAttributes().getNamedItem("number").getNodeValue());
                    this.params.set(i - 1, n.getTextContent());
                }
                n = n.getNextSibling();
            }
            if (Scheme_constr.name2scheme.get(this.scheme) == null) {
                OTKit.error("Constraint scheme '" + this.scheme + "' does not exists!");
                OTKit.return_err("Constraint scheme '" + this.scheme + "' does not exists!");
                this.con(OTKit.MyUniverse);
            } else {
                this.con(OTKit.MyUniverse);
            }
        }
    }

    public Node toXML() {
        Document doc = XMLstuff.emptyDocument();
        Element root = doc.createElement("my_constraint");
        doc.appendChild(root);
        root.setAttribute("name", this.name);
        root.setAttribute("scheme", this.scheme);
        int i = 0;
        while (i < this.params.size()) {
            if (this.params.get(i) != null) {
                Element param = doc.createElement("param");
                param.setAttribute("number", "" + (i + 1));
                param.setTextContent(this.params.get(i));
                root.appendChild(param);
            }
            ++i;
        }
        if (this.short_descr != null) {
            Element descr = doc.createElement("short_descr");
            descr.setTextContent(this.short_descr);
            root.appendChild(descr);
        }
        if (this.long_descr != null) {
            Element descr = doc.createElement("long_descr");
            descr.setTextContent(this.long_descr);
            root.appendChild(descr);
        }
        return doc;
    }

    public String tag() {
        return "my_constraint";
    }

    public String name() {
        return this.name;
    }

    public String shortScript() {
        return "Constraint(\"" + this.name + "\")";
    }

    public String longScript() {
        String h = "Constraint( \"" + this.name + "\", \"" + this.scheme + "\"";
        int i = 0;
        while (i < this.params.size()) {
            if (this.params.get(i) != null) {
                h = String.valueOf(h) + " , \"" + this.params.get(i) + "\"";
            }
            ++i;
        }
        if (this.short_descr != null && this.long_descr != null) {
            h = String.valueOf(h) + " , \"" + this.short_descr + "\" , \"" + this.long_descr + "\"";
        } else if (this.short_descr == null && this.long_descr != null) {
            h = String.valueOf(h) + " , , \"" + this.long_descr + "\"";
        } else if (this.short_descr != null && this.long_descr == null) {
            h = String.valueOf(h) + " , \"" + this.short_descr + "\"";
        }
        return String.valueOf(h) + " )";
    }
}

