/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.uiMyElements;

import hu.birot.OTKit.otBuildingBlocks.Constraint;
import hu.birot.OTKit.otBuildingBlocks.Hierarchy;
import hu.birot.OTKit.uiMyElements.MyConstraint;
import hu.birot.OTKit.uiMyElements.MyElement;
import hu.birot.OTKit.uiMyElements.Universe;
import hu.birot.OTKit.userInterface.OTKit;
import hu.birot.OTKit.userInterface.XMLstuff;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MyHierarchy
extends MyElement {
    private static final String constraint_tag = "constr";
    private Hierarchy h = new Hierarchy();

    public Hierarchy hier() {
        return this.h.clone();
    }

    public MyHierarchy clone() {
        MyHierarchy mh = new MyHierarchy(this.h.clone());
        return mh;
    }

    public Hierarchy hier(Universe U) {
        Hierarchy hh = this.h.clone();
        for (String cname : this.h.constraintNames()) {
            MyConstraint mc = U.MyConstraints.get(cname);
            if (mc == null) {
                OTKit.return_err("Error when instantiating hierarchy '" + this.h.name + "'. No constraint with name '" + cname + "' in " + U.name() + ".");
                continue;
            }
            hh.addConstraint(mc.con(U));
        }
        return hh;
    }

    public MyHierarchy(Hierarchy hier) {
        this.h = hier;
    }

    public MyHierarchy(Node xml) {
        if (xml.getNodeType() != 1 || !xml.getNodeName().equals("hierarchy")) {
            OTKit.return_err("Not a my_hierarchy XML tree!");
        } else {
            this.h.name = xml.getAttributes().getNamedItem("name").getNodeValue();
            this.h.type = xml.getAttributes().getNamedItem("type").getNodeValue();
            Node n = xml.getFirstChild();
            while (n != null) {
                if (n.getNodeName().equals(constraint_tag)) {
                    String constr_name = n.getAttributes().getNamedItem("name").getNodeValue();
                    this.h.addConstraint(Constraint.empty(constr_name));
                    Node nn = n.getFirstChild();
                    while (nn != null) {
                        if (nn.getNodeName().equals("rank")) {
                            String rankname = nn.getAttributes().getNamedItem("rvariable").getNodeValue();
                            String rankval = nn.getAttributes().getNamedItem("value").getNodeValue();
                            this.h.set(constr_name, rankname, Double.parseDouble(rankval));
                        }
                        nn = nn.getNextSibling();
                    }
                }
                n = n.getNextSibling();
            }
        }
    }

    public Node toXML() {
        Document doc = XMLstuff.emptyDocument();
        Element root = doc.createElement("hierarchy");
        doc.appendChild(root);
        root.setAttribute("name", this.h.name);
        root.setAttribute("type", this.h.type);
        for (Constraint c : this.h.constraints()) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            Element rank;
            double d7;
            Element con = doc.createElement(constraint_tag);
            root.appendChild(con);
            con.setAttribute("name", c.name());
            double r = this.h.rankOf(c);
            if (d7 < Double.POSITIVE_INFINITY) {
                rank = doc.createElement("rank");
                rank.setAttribute("rvariable", "rank");
                rank.setAttribute("value", "" + r);
                con.appendChild(rank);
            }
            r = this.h.rank1Of(c);
            if (d6 < Double.POSITIVE_INFINITY) {
                rank = doc.createElement("rank");
                rank.setAttribute("rvariable", "rank1");
                rank.setAttribute("value", "" + r);
                con.appendChild(rank);
            }
            r = this.h.rank2Of(c);
            if (d5 < Double.POSITIVE_INFINITY) {
                rank = doc.createElement("rank");
                rank.setAttribute("rvariable", "rank2");
                rank.setAttribute("value", "" + r);
                con.appendChild(rank);
            }
            r = this.h.perturbedRankOf(c);
            if (d4 < Double.POSITIVE_INFINITY) {
                rank = doc.createElement("rank");
                rank.setAttribute("rvariable", "perturbed_rank");
                rank.setAttribute("value", "" + r);
                con.appendChild(rank);
            }
            r = this.h.unperturbedRankOf(c);
            if (d3 < Double.POSITIVE_INFINITY) {
                rank = doc.createElement("rank");
                rank.setAttribute("rvariable", "unperturbed_rank");
                rank.setAttribute("value", "" + r);
                con.appendChild(rank);
            }
            r = this.h.kvalueOf(c);
            if (d2 < Double.POSITIVE_INFINITY) {
                rank = doc.createElement("rank");
                rank.setAttribute("rvariable", "kvalue");
                rank.setAttribute("value", "" + r);
                con.appendChild(rank);
            }
            r = this.h.weightOf(c);
            if (d < Double.POSITIVE_INFINITY) {
                rank = doc.createElement("rank");
                rank.setAttribute("rvariable", "weight");
                rank.setAttribute("value", "" + r);
                con.appendChild(rank);
            }
            HashMap<String, Double> rv = this.h.rvariableOf(c);
            for (String key : rv.keySet()) {
                Element rank2 = doc.createElement("rank");
                rank2.setAttribute("rvariable", key);
                rank2.setAttribute("value", "" + rv.get(key));
                con.appendChild(rank2);
            }
        }
        return doc;
    }

    public String longScript() {
        return null;
    }

    public String shortScript() {
        return "Hierarchy(\"" + this.name() + "\")";
    }

    public String tag() {
        return "hierarchy";
    }

    public String name() {
        return this.h.name;
    }
}

