/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.uiMyElements;

import hu.birot.OTKit.uiMyElements.MyElement;
import hu.birot.OTKit.userInterface.OTKit;
import hu.birot.OTKit.userInterface.XMLstuff;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MyTable
extends MyElement {
    private String name;
    private int R;
    private int C;
    private String[][] params;

    public String name() {
        return this.name;
    }

    public int rows() {
        return this.R;
    }

    public int cols() {
        return this.C;
    }

    public String[][] table() {
        return this.params;
    }

    public MyTable clone() {
        MyTable mt = new MyTable(this.name, this.params);
        mt.C = this.C;
        mt.R = this.R;
        return mt;
    }

    public String tag() {
        return "table";
    }

    public Node toXML() {
        Document doc = XMLstuff.emptyDocument();
        Element root = doc.createElement("table");
        doc.appendChild(root);
        root.setAttribute("name", this.name);
        root.setAttribute("nr_rows", "" + this.R);
        root.setAttribute("nr_cols", "" + this.C);
        int i = 0;
        while (i < this.R) {
            Element row = doc.createElement("row");
            int j = 0;
            while (j < this.C) {
                Element cell = doc.createElement("cell");
                cell.setAttribute("row", "" + i);
                cell.setAttribute("col", "" + j);
                cell.setAttribute("value", this.params[i][j]);
                row.appendChild(cell);
                ++j;
            }
            root.appendChild(row);
            ++i;
        }
        return doc;
    }

    public MyTable(String n, String[][] p) {
        this.name = n;
        this.params = (String[][])p.clone();
        this.R = p.length;
        this.C = this.R == 0 ? 0 : p[0].length;
    }

    public MyTable(Node xml) {
        if (xml.getNodeType() != 1 || !xml.getNodeName().equals("table")) {
            OTKit.error("Not a my_table XML tree!");
            OTKit.return_err("Not a my_table XML tree!");
        } else {
            this.name = xml.getAttributes().getNamedItem("name").getNodeValue();
            this.R = Integer.parseInt(xml.getAttributes().getNamedItem("nr_rows").getNodeValue());
            this.C = Integer.parseInt(xml.getAttributes().getNamedItem("nr_cols").getNodeValue());
            this.params = new String[this.R][this.C];
            Node n = xml.getFirstChild();
            while (n != null) {
                if (n.getNodeName().equals("row")) {
                    Node m = n.getFirstChild();
                    while (m != null) {
                        if (m.getNodeName().equals("cell")) {
                            int i = Integer.parseInt(m.getAttributes().getNamedItem("row").getNodeValue());
                            int j = Integer.parseInt(m.getAttributes().getNamedItem("col").getNodeValue());
                            this.params[i][j] = m.getAttributes().getNamedItem("value").getNodeValue();
                        }
                        m = m.getNextSibling();
                    }
                }
                n = n.getNextSibling();
            }
        }
    }

    public String shortScript() {
        return "Table(\"" + this.name + "\")";
    }

    public String longScript() {
        String h = "Table( \"" + this.name + "\" , " + this.R + ", " + this.C;
        int i = 0;
        while (i < this.R) {
            h = String.valueOf(h) + ", ( \"" + this.params[i][0] + "\" ";
            int j = 1;
            while (j < this.C) {
                h = String.valueOf(h) + ", \"" + this.params[i][j] + "\" ";
                ++j;
            }
            h = String.valueOf(h) + ")";
            ++i;
        }
        return String.valueOf(h) + " )";
    }
}

