/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.uiMyElements;

import hu.birot.OTKit.dataType.Form;
import hu.birot.OTKit.dataType.violation.FloatViolation;
import hu.birot.OTKit.dataType.violation.IntegerViolation;
import hu.birot.OTKit.dataType.violation.Violation;
import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Constraint;
import hu.birot.OTKit.otBuildingBlocks.ConstraintExamples;
import hu.birot.OTKit.uiMyElements.MyCandidate;
import hu.birot.OTKit.uiMyElements.MyForm;
import hu.birot.OTKit.uiMyElements.MyTable;
import hu.birot.OTKit.uiMyElements.Universe;
import hu.birot.OTKit.userInterface.FrameOptionsMetrPhon;
import hu.birot.OTKit.userInterface.OTKit;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Pattern;

public class Scheme_constr {
    public static final Constraint error = new Constraint("OTKit_error"){

        public Violation value(Candidate cand) {
            throw new RuntimeException("Undefined constraint!");
        }
    };
    public static final Constraint warning = new Constraint("OTKit_warning"){

        public Violation value(Candidate cand) {
            throw new RuntimeException("Undefined constraint!");
        }
    };
    public static final String type_explicit = "Explicitly defined constraints";
    public static final String type_string = "String in the surface forms";
    public static final String type_alignm = "String alignment on the surface forms";
    public static final String type_counter = "Counters in the surface forms";
    public static final String type_faithf = "Faithfulness constraints";
    public static final String type_arithm = "Constraint arithmetic";
    public static final String type_interface = "Constraint interfaces";
    public static final String type_metrphon = "Metrical phonology";
    public static final String[] Scheme_types = new String[]{"Explicitly defined constraints", "String in the surface forms", "String alignment on the surface forms", "Counters in the surface forms", "Faithfulness constraints", "Constraint arithmetic", "Constraint interfaces", "Metrical phonology"};
    public static final Constraint_scheme[] S = new Constraint_scheme[]{new Constraint_scheme("Cand_P1_gets_P2", "Candidate 'P1' gets P2 violation(s). ", "This constraint assigns P2 violation(s) to the candidate whose name is 'P1'; zero violations to all other candidates. NB: P2 must be parsable to an integer or double.", 2, "Explicitly defined constraints"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            try {
                Double.parseDouble(P.get(1));
            }
            catch (NumberFormatException numFormExcpt) {
                OTKit.error("P2 must be parsable to an integer or a double!");
                return error;
            }
            final FloatViolation v = FloatViolation.v(Double.parseDouble(P.get(1)));
            if (U.MyCandidates.get(P.get(0)) == null) {
                OTKit.warning("No candidate with name '" + P.get(0) + "' in " + U.name() + ".");
                return warning;
            }
            final Candidate c = U.MyCandidates.get(P.get(0)).cand(U);
            return new Constraint(name){

                public Violation value(Candidate can) {
                    if (can.equals(c)) {
                        return v;
                    }
                    return FloatViolation.nullViolation;
                }
            };
        }
    }, new Constraint_scheme("Sf_P1_gets_P2", "Surface form 'P1' gets P2 violation(s). ", "This constraint assigns P2 violation(s) to any candidate whose surface form has name 'P1'; zero violations to all other candidates. NB: P2 must be parsable to an integer or double.", 2, "Explicitly defined constraints"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            try {
                Double.parseDouble(P.get(1));
            }
            catch (NumberFormatException numFormExcpt) {
                OTKit.error("P2 must be parsable to an integer or a double!");
                return error;
            }
            final FloatViolation v = FloatViolation.v(Double.parseDouble(P.get(1)));
            if (U.MyForms.get(P.get(0)) == null) {
                OTKit.warning("No form with name '" + P.get(0) + "' in " + U.name() + ".");
                return warning;
            }
            final Form f = U.MyForms.get(P.get(0)).form(U);
            return new Constraint(name){

                public Violation value(Candidate can) {
                    if (can.sf.equals(f)) {
                        return v;
                    }
                    return FloatViolation.nullViolation;
                }
            };
        }
    }, new Constraint_scheme("String_P1_gets_P2", "Surface string 'P1' gets P2 violation(s). ", "This constraint assigns P2 violation(s) to any candidate whose surface form is string 'P1'; zero violations to all other candidates. NB: P2 must be parsable to an integer or double.", 2, "Explicitly defined constraints"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            try {
                Double.parseDouble(P.get(1));
            }
            catch (NumberFormatException numFormExcpt) {
                OTKit.error("P2 must be parsable to an integer or a double!");
                return error;
            }
            final FloatViolation v = FloatViolation.v(Double.parseDouble(P.get(1)));
            final String sf = P.get(0);
            return new Constraint(name){

                public Violation value(Candidate can) {
                    if (can.sf.string().equals(sf)) {
                        return v;
                    }
                    return FloatViolation.nullViolation;
                }
            };
        }
    }, new Constraint_scheme("Strings_in_Table_P1_col_P2", "Surface strings in column 1 of table 'P1' get column P2 violation(s). ", "Table P1 contains surface strings (column 1) and corresponding violations (column P2). Table P1 is used as an OT tableau: Its first column contains strings. If the string part in the surface form of a candidate is equal to the string in row r column 1 of the table, then row r column P2 gives the number of violations assigned to that candidate. If none of the strings in column 1 matches the surface form, then 0 violations are assigned. \n P2 must be a positive integer. All the cells in column P2 must be parsable to an integer or double. \nYou can use this scheme with the same table P1 and different P2 values to define all the constraints in the tableau encoded as P1.", 2, "Explicitly defined constraints"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            int col;
            MyTable mt = U.MyTables.get(P.get(0));
            if (mt == null) {
                OTKit.error("P1 does not refer to a table in MyUniverse!");
                return error;
            }
            String[][] t = mt.table();
            try {
                col = Integer.parseInt(P.get(1));
            }
            catch (NumberFormatException numFormExcpt) {
                OTKit.error("P2 must be parsable to an integer!");
                return error;
            }
            if (col > U.MyTables.get(P.get(0)).cols()) {
                OTKit.error("P2 too large: greater than number of columns in table " + P.get(0) + " !");
                return error;
            }
            if (col < 1) {
                OTKit.error("P2 must be positive, greater than zero!");
                return error;
            }
            HashMap<String, FloatViolation> m = new HashMap<String, FloatViolation>();
            int l = t.length;
            int i = 0;
            while (i < l) {
                double v;
                try {
                    v = Double.parseDouble(t[i][col - 1]);
                }
                catch (NumberFormatException numFormExcpt) {
                    OTKit.error("Column " + col + " must be parsable to a number in table " + P.get(0) + "!");
                    return error;
                }
                m.put(t[i][0].trim(), FloatViolation.v(v));
                ++i;
            }
            final HashMap<String, FloatViolation> map = m;
            return new Constraint(name){

                public Violation value(Candidate can) {
                    Violation v = (Violation)map.get(can.sf.string());
                    if (v == null) {
                        v = FloatViolation.nullViolation;
                    }
                    return v;
                }
            };
        }
    }, new Constraint_scheme("Forms_in_Table_P1_col_P2", "Surface form names in column 1 of table 'P1' get column P2 violation(s). ", "Table P1 contains names of surface forms (column 1) and corresponding violations (column P2). Table P1 is used as an OT tableau: Its first column contains name strings of (surface) forms in MyUniverse. If the surface form of a candidate is equal to the form named in row r column 1 of the table, then row r column P2 gives the number of violations assigned to that candidate. If none of the forms in column 1 matches the surface form of the candidate to be evaluated, then 0 violations are assigned. \n P2 must be a positive integer. All the cells in column P2 must be parsable to an integer or double. Error occurs if no form in MyUniverse has the name appearing in a cell of column 1.\nYou can use this scheme with the same table P1 and different P2 values to define all the constraints in the tableau encoded as P1.", 2, "Explicitly defined constraints"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            int col;
            MyTable mt = U.MyTables.get(P.get(0));
            if (mt == null) {
                OTKit.error("P1 does not refer to a table in MyUniverse!");
                return error;
            }
            String[][] t = mt.table();
            try {
                col = Integer.parseInt(P.get(1));
            }
            catch (NumberFormatException numFormExcpt) {
                OTKit.error("P2 must be parsable to an integer!");
                return error;
            }
            if (col > U.MyTables.get(P.get(0)).cols()) {
                OTKit.error("P2 too large: greater than number of columns in table " + P.get(0) + " !");
                return error;
            }
            if (col < 1) {
                OTKit.error("P2 too must be positive, greater than zero!");
                return error;
            }
            HashMap<Form, FloatViolation> m = new HashMap<Form, FloatViolation>();
            int l = t.length;
            int i = 0;
            while (i < l) {
                double v;
                try {
                    v = Double.parseDouble(t[i][col - 1]);
                }
                catch (NumberFormatException numFormExcpt) {
                    OTKit.error("Column " + col + " must be parsable to a number in table " + P.get(0) + "!");
                    return error;
                }
                MyForm f = U.MyForms.get(t[i][0].trim());
                if (f == null) {
                    OTKit.warning("Column 0 row " + i + " in table " + P.get(0) + " refers to a Form not present in " + U + "!");
                    return warning;
                }
                m.put(f.form(U), FloatViolation.v(v));
                ++i;
            }
            final HashMap<Form, FloatViolation> map = m;
            return new Constraint(name){

                public Violation value(Candidate can) {
                    Violation v = (Violation)map.get(can.sf);
                    if (v == null) {
                        v = FloatViolation.nullViolation;
                    }
                    return v;
                }
            };
        }
    }, new Constraint_scheme("Candidates_in_Table_P1_col_P2", "Candidate names in column 1 of table 'P1' get column P2 violation(s). ", "Table P1 contains names of candidates (column 1) and corresponding violations (column P2). Table P1 is used as an OT tableau: Its first column contains name strings of candidates in MyUniverse. If the candidate is equal to the candidate named in row r column 1 of the table, then row r column P2 gives the number of violations assigned to that candidate. If none of the candidates in column 1 matches the candidate to be evaluated, then 0 violations are assigned. \n P2 must be a positive integer. All the cells in column P2 must be parsable to an integer or double. Error occurs if no candidate in MyUniverse has the name appearing in a cell of column 1.\nYou can use this scheme with the same table P1 and different P2 values to define all the constraints in the tableau encoded as P1.", 2, "Explicitly defined constraints"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            int col;
            MyTable mt = U.MyTables.get(P.get(0));
            if (mt == null) {
                OTKit.error("P1 does not refer to a table in MyUniverse!");
                return error;
            }
            String[][] t = mt.table();
            try {
                col = Integer.parseInt(P.get(1));
            }
            catch (NumberFormatException numFormExcpt) {
                OTKit.error("P2 must be parsable to an integer!");
                return error;
            }
            if (col < 1) {
                OTKit.error("P2 too must be positive, greater than zero!");
                return error;
            }
            if (col > U.MyTables.get(P.get(0)).cols()) {
                OTKit.error("P2 too large: greater than number of columns in table " + P.get(0) + " !");
                return error;
            }
            HashMap<Candidate, FloatViolation> m = new HashMap<Candidate, FloatViolation>();
            int l = t.length;
            int i = 0;
            while (i < l) {
                double v;
                try {
                    v = Double.parseDouble(t[i][col - 1]);
                }
                catch (NumberFormatException numFormExcpt) {
                    OTKit.error("Column " + col + " must be parsable to a number in table " + P.get(0) + "!");
                    return error;
                }
                MyCandidate c = U.MyCandidates.get(t[i][0].trim());
                if (c == null) {
                    OTKit.warning("Column 0 row " + i + " in table " + P.get(0) + " refers to a Candidate not present in " + U + "!");
                    return warning;
                }
                m.put(c.cand(U), FloatViolation.v(v));
                ++i;
            }
            final HashMap<Candidate, FloatViolation> map = m;
            return new Constraint(name){

                public Violation value(Candidate can) {
                    Violation v = (Violation)map.get(can);
                    if (v == null) {
                        v = FloatViolation.nullViolation;
                    }
                    return v;
                }
            };
        }
    }, new Constraint_scheme("*P1", "Assign one violation mark to each P1. ", "Candidates are strings, and let P1 be a string. This constraint counts the number of substrings in the surface form that are equal to P1 (possibly overlapping substrings), and this value will be the number of violation marks assigned to the candidate. ", 1, "String in the surface forms"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            return ConstraintExamples.substring(name, P.get(0), 1.0);
        }
    }, new Constraint_scheme("*Contain_P1", "Assign one violation if contains P1. ", "Candidates are strings, and let P1 be a string. This constraint assigns a single violation mark to the candidate, if the surface form contains P1 as a substring. ", 1, "String in the surface forms"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            return ConstraintExamples.contain(name, P.get(0), 1.0);
        }
    }, new Constraint_scheme("*Table_P1_col_P2", "Assign substrings in table P1 violations in column P2. ", "Table 'P1' column 1 contains strings. Each substring in the surface form string is assigned as many violations as the value in the same row, column P2.", 2, "String in the surface forms"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            int col;
            MyTable mt = U.MyTables.get(P.get(0));
            if (mt == null) {
                OTKit.error("P1 does not refer to a table in MyUniverse!");
                return error;
            }
            String[][] t = mt.table();
            try {
                col = Integer.parseInt(P.get(1));
            }
            catch (NumberFormatException numFormExcpt) {
                OTKit.error("P2 must be parsable to an integer!");
                return error;
            }
            if (col > U.MyTables.get(P.get(0)).cols()) {
                OTKit.error("P2 too large: greater than number of columns in table " + P.get(0) + " !");
                return error;
            }
            if (col < 1) {
                OTKit.error("P2 must be positive, greater than zero!");
                return error;
            }
            HashMap<String, Double> m = new HashMap<String, Double>();
            int l = t.length;
            int i = 0;
            while (i < l) {
                double v;
                try {
                    v = Double.parseDouble(t[i][col - 1]);
                }
                catch (NumberFormatException numFormExcpt) {
                    OTKit.error("Column " + col + " must be parsable to a number in table " + P.get(0) + "!");
                    return error;
                }
                m.put(t[i][0].trim(), v);
                ++i;
            }
            final HashMap<String, Double> map = m;
            return new Constraint(name){

                public Violation value(Candidate can) {
                    String s = can.sf.string();
                    Double v = 0.0;
                    int i = 0;
                    while (i < s.length()) {
                        for (String key : map.keySet()) {
                            if (!s.startsWith(key, i)) continue;
                            v = v + (Double)map.get(key);
                        }
                        ++i;
                    }
                    return FloatViolation.v(v);
                }
            };
        }
    }, new Constraint_scheme("*Initial_P1", "Assign one violation if begins with P1. ", "Candidates are strings, and let P1 be a string. This constraint assigns a single violation mark to the candidate, if the surface form begins with P1 as a substring (if P1 is a prefix of the candidate). ", 1, "String in the surface forms"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            return new Constraint(name, P){
                private final String P0;
                {
                    this.P0 = (String)vector.get(0);
                }

                public Violation value(Candidate can) {
                    String sf = can.sf.string();
                    IntegerViolation v = sf.startsWith(this.P0) ? IntegerViolation.oneViolation : IntegerViolation.nullViolation;
                    return v;
                }
            };
        }
    }, new Constraint_scheme("*Final_P1", "Assign one violation if ends with P1. ", "Candidates are strings, and let P1 be a string. This constraint assigns a single violation mark to the candidate, if the surface form ends with P1 as a substring (if P1 is a sufix of the candidate). ", 1, "String in the surface forms"){

        @Override
        public Constraint con(String name, final Vector<String> P, Universe U) {
            return new Constraint(name){

                public Violation value(Candidate can) {
                    String sf = can.sf.string();
                    IntegerViolation v = sf.endsWith((String)P.get(0)) ? IntegerViolation.oneViolation : IntegerViolation.nullViolation;
                    return v;
                }
            };
        }
    }, new Constraint_scheme("*is_P1", "Assign P2 violation mark(s) to candidate P1. ", "Candidates are strings, and let P1 be a string. If the surface form is (the same string as) P1, then P2 violation mark(s) is/are assigned to it. All other candidates are assigned 0 marks. P2 must be a number (integer or double).", 2, "String in the surface forms"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            Constraint c;
            try {
                c = ConstraintExamples.equal(name, P.get(0), Double.parseDouble(P.get(1)));
            }
            catch (NumberFormatException numFormExcpt) {
                OTKit.error("P2 must be parsable to an integer or a double!");
                c = error;
            }
            return c;
        }
    }, new Constraint_scheme("Align_P1_left", "Sum of distances of 'P1' from the left of the string", "This gradient alignment constraint searches for (possibly overlapping) substrings \"P1\" within the (string representation of the) surface form, and sums up the distances of these substrings from the left edge of the surface form.", 1, "String alignment on the surface forms"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            return new Constraint(name, P){
                private final String P1;
                {
                    this.P1 = (String)vector.get(0);
                }

                public Violation value(Candidate can) {
                    int v = 0;
                    String sf = can.sf.toString();
                    int l = sf.length();
                    int i = 1;
                    while (i < l) {
                        if (sf.substring(i).startsWith(this.P1)) {
                            v += i;
                        }
                        ++i;
                    }
                    return IntegerViolation.v(v);
                }
            };
        }
    }, new Constraint_scheme("Align_P1_right", "Sum of distances of 'P1' from the right of the string", "This gradient alignment constraint searches for (possibly overlapping) substrings \"P1\" within the (string representation of the) surface form, and sums up the distances of the right edge of these substrings from the right edge of the surface form.", 1, "String alignment on the surface forms"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            return new Constraint(name, P){
                private final String P1;
                private final int length_P1;
                {
                    this.P1 = (String)vector.get(0);
                    this.length_P1 = ((String)vector.get(0)).length();
                }

                public Violation value(Candidate can) {
                    int v = 0;
                    String sf = can.sf.toString();
                    int l = sf.length();
                    int ll = l - this.length_P1;
                    int i = 0;
                    while (i < ll) {
                        if (sf.substring(i).startsWith(this.P1)) {
                            v += ll - i;
                        }
                        ++i;
                    }
                    return IntegerViolation.v(v);
                }
            };
        }
    }, new Constraint_scheme("Align_P1_left_per_P2", "Sum of number of 'P2's between left edge of the string and left edge of 'P1's", "This gradient alignment constraint searches for (possibly overlapping) substrings \"P1\" within the (string representation of the) surface form. For each substring found, the number of (possibly overlapping) substrings \"P2\" between the left edge of the string and the left edge of that instance of \"P1\" is counted. The value returned by this constraint is the sum of these counts for all instances of \"P1\". ", 2, "String alignment on the surface forms"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            return new Constraint(name, P){
                private final String P1;
                private final String P2;
                private final int l_P2;
                {
                    this.P1 = (String)vector.get(0);
                    this.P2 = (String)vector.get(1);
                    this.l_P2 = ((String)vector.get(1)).length();
                }

                public Violation value(Candidate can) {
                    int v = 0;
                    String sf = can.sf.toString();
                    int l = sf.length();
                    int i = 1;
                    while (i < l) {
                        if (sf.substring(i).startsWith(this.P1)) {
                            int j = 0;
                            while (j <= i - this.l_P2) {
                                if (sf.substring(j).startsWith(this.P2)) {
                                    ++v;
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    return IntegerViolation.v(v);
                }
            };
        }
    }, new Constraint_scheme("Align_P1_right_per_P2", "Sum of number of 'P2's between right edge 'P1's and right edge of string", "This gradient alignment constraint searches for (possibly overlapping) substrings \"P1\" within the (string representation of the) surface form. For each substring found, the number of (possibly overlapping) substrings \"P2\" between the right edge of the string and the right edge of that instance of \"P1\" is counted. The value returned by this constraint is the sum of these counts for all instances of \"P1\". ", 2, "String alignment on the surface forms"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            return new Constraint(name, P){
                private final String P1;
                private final String P2;
                private final int l_P1;
                private final int l_P2;
                {
                    this.P1 = (String)vector.get(0);
                    this.P2 = (String)vector.get(1);
                    this.l_P1 = ((String)vector.get(0)).length();
                    this.l_P2 = ((String)vector.get(1)).length();
                }

                public Violation value(Candidate can) {
                    int v = 0;
                    String sf = can.sf.toString();
                    int l = sf.length();
                    int ll = l - this.l_P1;
                    int i = 0;
                    while (i < ll) {
                        if (sf.substring(i).startsWith(this.P1)) {
                            int j = i + this.l_P1;
                            while (j <= l - this.l_P2) {
                                if (sf.substring(j).startsWith(this.P2)) {
                                    ++v;
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    return IntegerViolation.v(v);
                }
            };
        }
    }, new Constraint_scheme("Constant_P1", "Assign P1 violation mark(s) to any candidate. ", "This constraint is a constant function: it assigns the same violation level (namely, P1 violation mark(s)) to all candidates. Although this constraint does not seem to be very useful, you may use it to construct other constraints. ", 1, "Constraint arithmetic"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            Constraint c;
            try {
                c = ConstraintExamples.constant(name, Double.parseDouble(P.get(0)));
            }
            catch (NumberFormatException numFormExcpt) {
                OTKit.error("P1 must be parsable to an integer or a double!");
                c = error;
            }
            return c;
        }
    }, new Constraint_scheme("Constr_P1_+_Constr_P2", "Sum of constraints 'P1' and 'P2'", "This constraint assigns to candidate c the sum of the number of violations assigned to c by constraint 'P1' and 'P2'. NB: be prepared to fatal runtime errors, whenever constraint 'P1' and 'P2' are not loaded to MyUniverse at the time of employing this constraint.", 2, "Constraint arithmetic"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            if (U.MyConstraints.get(P.get(0)) == null && U.MyConstraints.get(P.get(1)) == null) {
                OTKit.warning("Constraint '" + P.get(0) + "' and Constraint '" + P.get(1) + "' not in Universe.");
                return warning;
            }
            if (U.MyConstraints.get(P.get(0)) == null) {
                OTKit.warning("Constraint '" + P.get(0) + "' not in Universe.");
                return warning;
            }
            if (U.MyConstraints.get(P.get(1)) == null) {
                OTKit.warning("Constraint '" + P.get(1) + "' not in Universe.");
                return warning;
            }
            return ConstraintExamples.sum(name, U.MyConstraints.get(P.get(0)).con(U), U.MyConstraints.get(P.get(1)).con(U));
        }
    }, new Constraint_scheme("Constr_P1_*_Constr_P2", "Product of constraints 'P1' and 'P2'", "This constraint assigns to candidate c the product of the number of violations assigned to c by constraint 'P1' and 'P2'. NB: be prepared to fatal runtime errors, whenever constraint 'P1' and 'P2' are not loaded to MyUniverse at the time of employing this constraint.", 2, "Constraint arithmetic"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            if (U.MyConstraints.get(P.get(0)) == null && U.MyConstraints.get(P.get(1)) == null) {
                OTKit.warning("Constraint '" + P.get(0) + "' and Constraint '" + P.get(1) + "' not in Universe.");
                return warning;
            }
            if (U.MyConstraints.get(P.get(0)) == null) {
                OTKit.warning("Constraint '" + P.get(0) + "' not in Universe.");
                return warning;
            }
            if (U.MyConstraints.get(P.get(1)) == null) {
                OTKit.warning("Constraint '" + P.get(1) + "' not in Universe.");
                return warning;
            }
            return ConstraintExamples.product(name, U.MyConstraints.get(P.get(0)).con(U), U.MyConstraints.get(P.get(1)).con(U));
        }
    }, new Constraint_scheme("P1_*_Constr_P2", "P1 times constraint 'P2'", "This constraint assigns to candidate c the number of violations assigned to c by constraint 'P2' multiplied by 'P1'. NB: be prepared to fatal runtime errors, whenever constraint 'P2' is not loaded to MyUniverse at the time of employing this constraint.", 2, "Constraint arithmetic"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            double coeff;
            try {
                coeff = Double.parseDouble(P.get(0));
            }
            catch (NumberFormatException numFormExcpt) {
                OTKit.error("P1 must be parsable to an integer or a double!");
                return error;
            }
            if (U.MyConstraints.get(P.get(1)) == null) {
                OTKit.warning("Constraint '" + P.get(1) + "' not in Universe.");
                return warning;
            }
            return ConstraintExamples.product(name, U.MyConstraints.get(P.get(1)).con(U), coeff);
        }
    }, new Constraint_scheme("Constr_P1_/_Constr_P2", "Ratio of constraints 'P1' and 'P2'", "This constraint assigns to candidate c the ratio of the number of violations assigned to c by constraint 'P1' and 'P2'. NB: be prepared to fatal runtime errors, whenever constraint 'P1' and 'P2' are not loaded to MyUniverse at the time of employing this constraint. Make sure P2 never assigns a zero violations.", 2, "Constraint arithmetic"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            if (U.MyConstraints.get(P.get(0)) == null && U.MyConstraints.get(P.get(1)) == null) {
                OTKit.warning("Constraint '" + P.get(0) + "' and Constraint '" + P.get(1) + "' not in Universe.");
                return warning;
            }
            if (U.MyConstraints.get(P.get(0)) == null) {
                OTKit.warning("Constraint '" + P.get(0) + "' not in Universe.");
                return warning;
            }
            if (U.MyConstraints.get(P.get(1)) == null) {
                OTKit.warning("Constraint '" + P.get(1) + "' not in Universe.");
                return warning;
            }
            return ConstraintExamples.ratio(name, U.MyConstraints.get(P.get(0)).con(U), U.MyConstraints.get(P.get(1)).con(U));
        }
    }, new Constraint_scheme("P1_/_Constr_P2", "P1 divided by constraint 'P2'", "This constraint assigns to candidate c 'P1'divided by the number of violations assigned to c by constraint 'P2'. NB: be prepared to fatal runtime errors, whenever constraint 'P2' is not loaded to MyUniverse at the time of employing this constraint. Make sure P2 never assigns zero violations.", 2, "Constraint arithmetic"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            double coeff;
            try {
                coeff = Double.parseDouble(P.get(0));
            }
            catch (NumberFormatException numFormExcpt) {
                OTKit.error("P1 must be parsable to an integer or a double!");
                return error;
            }
            if (U.MyConstraints.get(P.get(1)) == null) {
                OTKit.warning("Constraint '" + P.get(1) + "' not in Universe.");
                return warning;
            }
            return ConstraintExamples.ratio(name, coeff, U.MyConstraints.get(P.get(1)).con(U));
        }
    }, new Constraint_scheme("Constr_P1_max_Constr_P2", "Max of constraints 'P1' and 'P2'", "This constraint assigns to candidate c the greater one of the number of violations assigned to c by constraint 'P1' and 'P2'. Can be used as logical 'or' for binary (boolean) constraints. NB: be prepared to fatal runtime errors, whenever constraint 'P1' and 'P2' are not loaded to MyUniverse at the time of employing this constraint.", 2, "Constraint arithmetic"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            if (U.MyConstraints.get(P.get(0)) == null && U.MyConstraints.get(P.get(1)) == null) {
                OTKit.warning("Constraint '" + P.get(0) + "' and Constraint '" + P.get(1) + "' not in Universe.");
                return warning;
            }
            if (U.MyConstraints.get(P.get(0)) == null) {
                OTKit.warning("Constraint '" + P.get(0) + "' not in Universe.");
                return warning;
            }
            if (U.MyConstraints.get(P.get(1)) == null) {
                OTKit.warning("Constraint '" + P.get(1) + "' not in Universe.");
                return warning;
            }
            return ConstraintExamples.max(name, U.MyConstraints.get(P.get(0)).con(U), U.MyConstraints.get(P.get(1)).con(U));
        }
    }, new Constraint_scheme("Constr_P1_min_Constr_P2", "Min of constraints 'P1' and 'P2'", "This constraint assigns to candidate c the lesser one of the number of violations assigned to c by constraint 'P1' and 'P2'. Can be used as logical 'and' for binary (boolean) constraints. NB: be prepared to fatal runtime errors, whenever constraint 'P1' and 'P2' are not loaded to MyUniverse at the time of employing this constraint.", 2, "Constraint arithmetic"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            if (U.MyConstraints.get(P.get(0)) == null && U.MyConstraints.get(P.get(1)) == null) {
                OTKit.warning("Constraint '" + P.get(0) + "' and Constraint '" + P.get(1) + "' not in Universe.");
                return warning;
            }
            if (U.MyConstraints.get(P.get(0)) == null) {
                OTKit.warning("Constraint '" + P.get(0) + "' not in Universe.");
                return warning;
            }
            if (U.MyConstraints.get(P.get(1)) == null) {
                OTKit.warning("Constraint '" + P.get(1) + "' not in Universe.");
                return warning;
            }
            return ConstraintExamples.min(name, U.MyConstraints.get(P.get(0)).con(U), U.MyConstraints.get(P.get(1)).con(U));
        }
    }, new Constraint_scheme("Sum_P1", "Sum of constraints 'P1'", "This constraint assigns to candidate c the sum of the violations assigned to c by constraints 'P1'. This parameter must be a list of constraint names in MyUniverse, with a semicolon (;) between the names. White spaces are allowed between the constraint names and the semicolon. So for example \" constr_1 ; constraint_name 2 ; constr 3 ; constr4 \" will create the sum of constraints \"constr_1\", \"constraint_name 2\", \"constr 3\" and \"constr4\". NB: be prepared to fatal runtime errors, whenever the constraints in 'P1' are not loaded to MyUniverse at the time of employing this constraint.", 1, "Constraint arithmetic"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            String[] names = P.get(0).split(";");
            int i = 0;
            while (i < names.length) {
                if (U.MyConstraints.get(names[i].trim()) == null) {
                    OTKit.warning("Constraint '" + names[i].trim() + "' not in Universe.");
                    return warning;
                }
                ++i;
            }
            Constraint[] con = new Constraint[names.length];
            int i2 = 0;
            while (i2 < names.length) {
                con[i2] = U.MyConstraints.get(names[i2].trim()).con(U);
                ++i2;
            }
            return ConstraintExamples.sum(name, con);
        }
    }, new Constraint_scheme("Product_P1", "Product of constraints 'P1'", "This constraint assigns to candidate c the product of the violations assigned to c by constraints 'P1'. This parameter must be a list of constraint names in MyUniverse, with a semicolon (;) between the names. White spaces are allowed between the constraint names and the semicolon. So for example \" constr_1 ; constraint_name 2 ; constr 3 ; constr4 \" will create the product of constraints \"constr_1\", \"constraint_name 2\", \"constr 3\" and \"constr4\". NB: be prepared to fatal runtime errors, whenever the constraints in 'P1' are not loaded to MyUniverse at the time of employing this constraint.", 1, "Constraint arithmetic"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            String[] names = P.get(0).split(";");
            int i = 0;
            while (i < names.length) {
                if (U.MyConstraints.get(names[i].trim()) == null) {
                    OTKit.warning("Constraint '" + names[i].trim() + "' not in Universe.");
                    return warning;
                }
                ++i;
            }
            Constraint[] con = new Constraint[names.length];
            int i2 = 0;
            while (i2 < names.length) {
                con[i2] = U.MyConstraints.get(names[i2].trim()).con(U);
                ++i2;
            }
            return ConstraintExamples.product(name, con);
        }
    }, new Constraint_scheme("P1_:_pos_P2_zero_P3_neg_P4", "Depending on the sign of 'P1': 'P2', 'P3' or 'P4'", "This constraint first evaluates candidate c for constraint 'P1'. If the result is a positive violation, then the constraint returns the violation assigned by constraint 'P2' to c. If the result is a zero violation, then the new constraint returns the violation assigned by 'P3' to c. If the result is a negative violation, then constraint 'P4' determines the value of this new constraint. NB: be prepared to fatal runtime errors, whenever constraint 'P1', 'P2', 'P3' or 'P4' are not loaded to MyUniverse at the time of employing this constraint.", 4, "Constraint arithmetic"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            if (U.MyConstraints.get(P.get(0)) == null) {
                OTKit.warning("Constraint '" + P.get(0) + "' not in Universe.");
                return warning;
            }
            if (U.MyConstraints.get(P.get(1)) == null) {
                OTKit.warning("Constraint '" + P.get(1) + "' not in Universe.");
                return warning;
            }
            if (U.MyConstraints.get(P.get(2)) == null) {
                OTKit.warning("Constraint '" + P.get(2) + "' not in Universe.");
                return warning;
            }
            if (U.MyConstraints.get(P.get(3)) == null) {
                OTKit.warning("Constraint '" + P.get(3) + "' not in Universe.");
                return warning;
            }
            return ConstraintExamples.condition(name, U.MyConstraints.get(P.get(0)).con(U), U.MyConstraints.get(P.get(1)).con(U), U.MyConstraints.get(P.get(2)).con(U), U.MyConstraints.get(P.get(3)).con(U));
        }
    }, new Constraint_scheme("Counter1", "Value of counter 1. ", "This constraint assigns as many violation marks to any candidate as the value of the counter (i.e., counter 1) of the surface form. Only candidates with an empty counter 1 (with a counter 1 equal to zero) satisfy this constraint. Otherwise the level of violation is proportional to the value of the counter. ", 0, "Counters in the surface forms"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            return ConstraintExamples.counter1(name, 1.0);
        }
    }, new Constraint_scheme("Counter2", "Value of counter 2. ", "This constraint assigns as many violation marks to any candidate as the value of the counter 2 of the surface form. Only candidates with an empty counter 2 (with a counter 2 equal to zero) satisfy this constraint. Otherwise, the level of violation is proportional to the value of counter 2. ", 0, "Counters in the surface forms"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            return ConstraintExamples.counter2(name, 1.0);
        }
    }, new Constraint_scheme("Counter3", "Value of counter 3. ", "This constraint assigns as many violation marks to any candidate as the value of the counter 3 of the surface form. Only candidates with an empty counter 3 (with a counter 3 equal to zero) satisfy this constraint. Otherwise, the level of violation is proportional to the value of counter 3. ", 0, "Counters in the surface forms"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            return ConstraintExamples.counter3(name, 1.0);
        }
    }, new Constraint_scheme("uf=sf", "underlying form equals surface form", "This constraint is violated whenever the underlying form and the surface form within a candidate differ. It returns 0, if the two forms are the same (equal, as defined by the Form.equal() method), and 1 otherwise. This constraint can be applied to any type of candidate.", 0, "Faithfulness constraints"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            return new Constraint(name){

                public Violation value(Candidate cand) {
                    if (cand.uf.equals(cand.sf)) {
                        return IntegerViolation.nullViolation;
                    }
                    return IntegerViolation.oneViolation;
                }
            };
        }
    }, new Constraint_scheme("Max", "surface not shorter than underlying form", "This constraint is violated whenever the string in the underlying form is longer than the string in the surface form. The violation is equal to the difference of their length.", 0, "Faithfulness constraints"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            return new Constraint(name){

                public Violation value(Candidate cand) {
                    int s;
                    int u = cand.uf.string().length();
                    if (u > (s = cand.sf.string().length())) {
                        return IntegerViolation.v(u - s);
                    }
                    return IntegerViolation.nullViolation;
                }
            };
        }
    }, new Constraint_scheme("Dep", "surface not longer than underlying form", "This constraint is violated whenever the string in the underlying form is shorter than the string in the surface form. The violation is equal to the difference of their length.", 0, "Faithfulness constraints"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            return new Constraint(name){

                public Violation value(Candidate cand) {
                    int s;
                    int u = cand.uf.string().length();
                    if (u < (s = cand.sf.string().length())) {
                        return IntegerViolation.v(s - u);
                    }
                    return IntegerViolation.nullViolation;
                }
            };
        }
    }, new Constraint_scheme("Dep(P1)", "do not epenthesize P1", "This constraint, working on the string representation of a candidate, is violated if the surface form contains more substring 'P1' than the underlying form. The constraint counts the number u of times 'P1' occurs as a substring in the underlying form (including overlapping substrings), and the corresponding number s in the surface form. The number of violation marks assigned by the candidate is then s-u, if s > u, and 0 otherwise. NB: No correspondence relation is implemented, so for example DEP and MAX with the same argument cannot be violated at the same time.", 1, "Faithfulness constraints"){

        @Override
        public Constraint con(String name, final Vector<String> P, Universe U) {
            return new Constraint(name){

                public Violation value(Candidate cand) {
                    if (cand.uf.equals(cand.sf)) {
                        return IntegerViolation.nullViolation;
                    }
                    String str = (String)P.get(0);
                    int u = 0;
                    String uf = cand.uf.string();
                    int i = 0;
                    while (i < uf.length()) {
                        if (uf.startsWith(str, i)) {
                            ++u;
                        }
                        ++i;
                    }
                    int s = 0;
                    String sf = cand.sf.string();
                    int i2 = 0;
                    while (i2 < sf.length()) {
                        if (sf.startsWith(str, i2)) {
                            ++s;
                        }
                        ++i2;
                    }
                    if (s > u) {
                        return IntegerViolation.v(s - u);
                    }
                    return IntegerViolation.nullViolation;
                }
            };
        }
    }, new Constraint_scheme("Max(P1)", "do not delete P1", "This constraint, working on the string representation of a candidate, is violated if the surface form contains less substring 'P1' than the underlying form. The constraint counts the number u of times 'P1' occurs as a substring in the underlying form (including overlapping substrings), and the corresponding number s in the surface form. The number of violation marks assigned by the candidate is then u-s, if u > s, and 0 otherwise. NB: No correspondence relation is implemented, so for example DEP and MAX with the same argument cannot be violated at the same time.", 1, "Faithfulness constraints"){

        @Override
        public Constraint con(String name, final Vector<String> P, Universe U) {
            return new Constraint(name){

                public Violation value(Candidate cand) {
                    if (cand.uf.equals(cand.sf)) {
                        return IntegerViolation.nullViolation;
                    }
                    String str = (String)P.get(0);
                    int u = 0;
                    String uf = cand.uf.string();
                    int i = 0;
                    while (i < uf.length()) {
                        if (uf.startsWith(str, i)) {
                            ++u;
                        }
                        ++i;
                    }
                    int s = 0;
                    String sf = cand.sf.string();
                    int i2 = 0;
                    while (i2 < sf.length()) {
                        if (sf.startsWith(str, i2)) {
                            ++s;
                        }
                        ++i2;
                    }
                    if (u > s) {
                        return IntegerViolation.v(u - s);
                    }
                    return IntegerViolation.nullViolation;
                }
            };
        }
    }, new Constraint_scheme("P1_o_delete_P2_sf", "Constraint 'P1', after having deleted \"P2\" from surface form", "Constraint 'P1' is applied to a candidate c'; such that c' has the same name and the same underlying form as the original candidate, but its surface form has been replaced by the string representation of the original surface form, in which all instances of the substring \"P2\" have been removed. NB: If the original candidate has a some more complex inner structure (e.g., a chain or a multi), make sure that its uf and sf fields have the necessary information for constraint 'P1'. NB: P2 is seen as a regular expression. So watch out for special characters, such as '+' or '*'.", 2, "Constraint interfaces"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            if (U.MyConstraints.get(P.get(0)) == null) {
                OTKit.warning("Constraint '" + P.get(0) + "' not in Universe.");
                return warning;
            }
            return new Constraint(name, U, P){
                private final Constraint P1;
                private final Pattern P2;
                {
                    this.P1 = universe.MyConstraints.get(vector.get(0)).con(universe);
                    this.P2 = Pattern.compile((String)vector.get(1));
                }

                public Violation value(Candidate cand) {
                    return this.P1.value(new Candidate(cand.name, cand.uf, new Form(this.P2.matcher(cand.sf.toString()).replaceAll(""))));
                }
            };
        }
    }, new Constraint_scheme("P1_o_replace_P2_with_P3_sf", "Constraint 'P1', after having replaced \"P2\" with \"P3\" in the surface form", "Constraint 'P1' is applied to a candidate c'; such that c' has the same name and the same underlying form as the original candidate, but its surface form has been replaced by the string representation of the original surface form, in which all instances of the substring \"P2\" have been replaced by \"P3\". NB: If the original candidate has a some more complex inner structure (e.g., a chain or a multi), make sure that its uf and sf fields have the necessary information for constraint 'P1'. NB: P2 is seen as a regular expression. So watch out for special characters, such as '+' or '*'.", 3, "Constraint interfaces"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            if (U.MyConstraints.get(P.get(0)) == null) {
                OTKit.warning("Constraint '" + P.get(0) + "' not in Universe.");
                return warning;
            }
            return new Constraint(name, U, P){
                private final Constraint P1;
                private final Pattern P2;
                private final String P3;
                {
                    this.P1 = universe.MyConstraints.get(vector.get(0)).con(universe);
                    this.P2 = Pattern.compile((String)vector.get(1));
                    this.P3 = (String)vector.get(2);
                }

                public Violation value(Candidate cand) {
                    return this.P1.value(new Candidate(cand.name, cand.uf, new Form(this.P2.matcher(cand.sf.toString()).replaceAll(this.P3))));
                }
            };
        }
    }, new Constraint_scheme("ParseSyll", "Parse Syllable", "Assign one violation mark per syllable unparsed into a foot.", 0, "Metrical phonology"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            Constraint c = FrameOptionsMetrPhon.newMetricalStress().Parse();
            c.rename(name);
            return c;
        }
    }, new Constraint_scheme("FootBin", "Foot Binarity", "Assign one violation mark per foot that is composed of a single syllable.", 0, "Metrical phonology"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            Constraint c = FrameOptionsMetrPhon.newMetricalStress().Binary();
            c.rename(name);
            return c;
        }
    }, new Constraint_scheme("FootBinMora", "Foot Binarity on moraic level", "Assign one violation mark to a foot, if it contains a single light (non-heavy) syllable. The number specified in P1 defines what makes a syllable heavy: \n  Possible values of P1 are:\n1 -- heavy if syllable has a long nucleus.\n2 -- if it has a coda.\n3 -- if it has a long nucleus OR a coda (or both).\n4 -- it is has a complex coda.\n5 -- if it has a long nucleus OR a complex coda (or both).\n8 -- if it has a long nucleus AND a coda.\n12 -- it is has a complex coda OR if it has a long nucleus and a coda.\n16 -- if it has a long nucleus AND a complex coda.\nThe characters in P2 define the vowels, whereas P3 the consonants. A long nucleus is either a long vowel (a vowel followed by the LONG symbol) or multiple vowel characters. A complex coda is either a long consonant (a consonant followed by the LONG symbol) or multiple consonant characters.", 3, "Metrical phonology"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            int h = 0;
            try {
                h = Integer.parseInt(P.get(0));
            }
            catch (NumberFormatException numFormExcpt) {
                OTKit.error("P1 must be parsable to an integer!");
                return error;
            }
            if (h < 1 || h > 5) {
                OTKit.error("P1 must be between 1 and 5!");
                return error;
            }
            char[] vowels = P.get(1).trim().toCharArray();
            char[] consonants = P.get(2).trim().toCharArray();
            Constraint c = FrameOptionsMetrPhon.newMetricalStress(vowels, consonants).BinaryMoraic(h);
            c.rename(name);
            return c;
        }
    }, new Constraint_scheme("FootBin(P1)", "Foot Binarity(P1)", "Assign one violation mark per foot that is composed of less than two P1. P1 can be 'syll' for syllabic binarity; or 'mora' for moraic binarity. In a moraic analysis, make sure the mora symbols are added to the surface forms. See also schemes FootBin and FottBinMora", 1, "Metrical phonology"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            String c;
            if (P.get(0).trim().equalsIgnoreCase("syll")) {
                c = "s";
            } else if (P.get(0).trim().equalsIgnoreCase("mora")) {
                c = "m";
            } else {
                OTKit.error("P1 must be either 'syll' or 'mora'.");
                return error;
            }
            Constraint cc = FrameOptionsMetrPhon.newMetricalStress().Binary(c);
            cc.rename(name);
            return cc;
        }
    }, new Constraint_scheme("NonFinal", "Non-Finality", "Assign one violation mark if the last syllable is footed, no violation if it is unfooted. (See also scheme 'No Final Stress'.)", 0, "Metrical phonology"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            Constraint c = FrameOptionsMetrPhon.newMetricalStress().NonFinal();
            c.rename(name);
            return c;
        }
    }, new Constraint_scheme("NonFinalStress", "No Final Stress", "Assign one violation mark if the last syllable is stressed, no violation if it is not stressed. (See also scheme 'Non-Finality'.)", 0, "Metrical phonology"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            Constraint c = FrameOptionsMetrPhon.newMetricalStress().NonFinalStress();
            c.rename(name);
            return c;
        }
    }, new Constraint_scheme("*Clash", "No Clash", "Assign one violation mark to any stressed syllable that is immediately preceded by another stressed syllable.", 0, "Metrical phonology"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            Constraint c = FrameOptionsMetrPhon.newMetricalStress().NoClash();
            c.rename(name);
            return c;
        }
    }, new Constraint_scheme("*Lapse", "No Lapse", "Assign one violation mark to any unstressed syllable that is not adjacent to a stressed syllable or to a word edge.", 0, "Metrical phonology"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            Constraint c = FrameOptionsMetrPhon.newMetricalStress().NoLapse();
            c.rename(name);
            return c;
        }
    }, new Constraint_scheme("WSP", "Weight-to-stress principle", "Assign one violation mark to every heavy syllable that is not stressed. The number specified in P1 defines what makes a syllable heavy: \n  Possible values of P1 are:\n1 -- heavy if syllable has a long nucleus.\n2 -- if it has a coda.\n3 -- if it has a long nucleus OR a coda (or both).\n4 -- it is has a complex coda.\n5 -- if it has a long nucleus OR a complex coda (or both).\n8 -- if it has a long nucleus AND a coda.\n12 -- it is has a complex coda OR if it has a long nucleus and a coda.\n16 -- if it has a long nucleus AND a complex coda.\nThe characters in P2 define the vowels, whereas P3 the consonants. A long nucleus is either a long vowel (a vowel followed by the LONG symbol) or multiple vowel characters. A complex coda is either a long consonant (a consonant followed by the LONG symbol) or multiple consonant characters.", 3, "Metrical phonology"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            int h = 0;
            try {
                h = Integer.parseInt(P.get(0));
            }
            catch (NumberFormatException numFormExcpt) {
                OTKit.error("P1 must be parsable to an integer!");
                return error;
            }
            if (h < 1 || h > 5) {
                OTKit.error("P1 must be between 1 and 5!");
                return error;
            }
            char[] vowels = P.get(1).trim().toCharArray();
            char[] consonants = P.get(2).trim().toCharArray();
            Constraint c = FrameOptionsMetrPhon.newMetricalStress(vowels, consonants).WSP(h);
            c.rename(name);
            return c;
        }
    }, new Constraint_scheme("Stress-to-weight", "Stress-to-weight", "Assign one violation mark to every stressed syllable that is not heavy. The number specified in P1 defines what makes a syllable heavy: \n  Possible values of P1 are:\n1 -- heavy if syllable has a long nucleus.\n2 -- if it has a coda.\n3 -- if it has a long nucleus OR a coda (or both).\n4 -- it is has a complex coda.\n5 -- if it has a long nucleus OR a complex coda (or both).\n8 -- if it has a long nucleus AND a coda.\n12 -- it is has a complex coda OR if it has a long nucleus and a coda.\n16 -- if it has a long nucleus AND a complex coda.\nThe characters in P2 define the vowels, whereas P3 the consonants. A long nucleus is either a long vowel (a vowel followed by the LONG symbol) or multiple vowel characters. A complex coda is either a long consonant (a consonant followed by the LONG symbol) or multiple consonant characters.", 3, "Metrical phonology"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            int h = 0;
            try {
                h = Integer.parseInt(P.get(0));
            }
            catch (NumberFormatException numFormExcpt) {
                OTKit.error("P1 must be parsable to an integer!");
                return error;
            }
            if (h < 1 || h > 5) {
                OTKit.error("P1 must be between 1 and 5!");
                return error;
            }
            char[] vowels = P.get(1).trim().toCharArray();
            char[] consonants = P.get(2).trim().toCharArray();
            Constraint c = FrameOptionsMetrPhon.newMetricalStress(vowels, consonants).Stress_to_weight(h);
            c.rename(name);
            return c;
        }
    }, new Constraint_scheme("RhythmType(P1)", "Rhythm Type is P1", "The type is P1, which must be one of the following: 'LEFT', 'RIGHT', 'NONLEFT', 'NONRIGHT'. One violation mark is assigned to each foot not belonging to the preferred type.\n 'LEFT': the first syllable in the foot must be stressed, such as monosyllabic feet and trochees, but not binary iambs.\n 'RIGHT': the last syllable in the foot must be stressed, such as monosyllabic feet and iambs, but not binary trochees.\n 'NONLEFT': the first syllable in the foot must be unstressed, such as binary iambs, but not monosyllabic feet and trochees.\n 'NONRIGHT': the last syllable in the foot must be unstressed, such as binary trochees, but not monosyllabic feet and iambs.", 1, "Metrical phonology"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            int t;
            if (P.get(0).trim().equalsIgnoreCase("left")) {
                t = 1;
            } else if (P.get(0).trim().equalsIgnoreCase("right")) {
                t = 2;
            } else if (P.get(0).trim().equalsIgnoreCase("nonleft")) {
                t = 3;
            } else if (P.get(0).trim().equalsIgnoreCase("nonright")) {
                t = 4;
            } else {
                OTKit.error("P1 must be either 'LEFT' or 'RIGHT' or 'NONLEFT' or 'NONRIGHT'.");
                return error;
            }
            Constraint c = FrameOptionsMetrPhon.newMetricalStress().RhType(t);
            c.rename(name);
            return c;
        }
    }, new Constraint_scheme("Alignment(P1,P2,P3,P4)", "Align(P1,P2,P3,P4)", "Measure the number of P4 ('units') intervening between the P3 ('direction') edge of P2 ('container') and the P3 ('direction') edge of P1 ('object'), summed up for each P1 ('object').\n Possible objects to be aligned: foot with primary stress (P1 = 'mainfoot') or all feet (P2 = 'allfeet').\n Possible container: prosodic word (P2 = 'prword').\n Possible directions: left (P3 = 'l') or right (P3 = 'r').\n Possible units: syllable (P4 = 'syll') or mora (P4 = 'mora').", 4, "Metrical phonology"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            String u;
            String d;
            String o;
            if (P.get(0).trim().equalsIgnoreCase("mainfoot")) {
                o = "MainFoot";
            } else if (P.get(0).trim().equalsIgnoreCase("allfeet")) {
                o = "AllFeet";
            } else {
                OTKit.error("P1 must be either 'mainfoot' or 'allfeet'.");
                return error;
            }
            if (!P.get(1).trim().equalsIgnoreCase("prword")) {
                OTKit.error("P2 must be 'prword'.");
                return error;
            }
            String c = "PrWord";
            if (P.get(2).trim().equalsIgnoreCase("l")) {
                d = "Left";
            } else if (P.get(2).trim().equalsIgnoreCase("r")) {
                d = "Right";
            } else {
                OTKit.error("P3 must be either 'l' or 'r'.");
                return error;
            }
            if (P.get(3).trim().equalsIgnoreCase("syll")) {
                u = "s";
            } else if (P.get(3).trim().equalsIgnoreCase("mora")) {
                u = "m";
            } else {
                OTKit.error("P4 must be either 'syll' or 'mora'.");
                return error;
            }
            Constraint cc = FrameOptionsMetrPhon.newMetricalStress().Alignment(o, c, d, u);
            cc.rename(name);
            return cc;
        }
    }, new Constraint_scheme("QuantizedAlignment(P1,P2,P3,P4)", "QuantAlign(P1,P2,P3,P4)", "One violation for each P1 ('object'), if at least one P4 ('unit') intervenes between the P3 ('direction') edge of P2 ('container') and the P3 ('direction') edge of P1 ('object'). Summed up for each P1 ('object').\n Possible objects to be aligned: foot with primary stress (P1 = 'mainfoot') or all feet (P2 = 'allfeet').\n Possible container: prosodic word (P2 = 'prword').\n Possible directions: left (P3 = 'l') or right (P3 = 'r').\n Possible units: syllable (P4 = 'syll') or mora (P4 = 'mora').", 4, "Metrical phonology"){

        @Override
        public Constraint con(String name, Vector<String> P, Universe U) {
            String u;
            String d;
            String o;
            if (P.get(0).trim().equalsIgnoreCase("mainfoot")) {
                o = "MainFoot";
            } else if (P.get(0).trim().equalsIgnoreCase("allfeet")) {
                o = "AllFeet";
            } else {
                OTKit.error("P1 must be either 'mainfoot' or 'allfeet'.");
                return error;
            }
            if (!P.get(1).trim().equalsIgnoreCase("prword")) {
                OTKit.error("P2 must be 'prword'.");
                return error;
            }
            String c = "PrWord";
            if (P.get(2).trim().equalsIgnoreCase("l")) {
                d = "Left";
            } else if (P.get(2).trim().equalsIgnoreCase("r")) {
                d = "Right";
            } else {
                OTKit.error("P3 must be either 'l' or 'r'.");
                return error;
            }
            if (P.get(3).trim().equalsIgnoreCase("syll")) {
                u = "s";
            } else if (P.get(3).trim().equalsIgnoreCase("mora")) {
                u = "m";
            } else {
                OTKit.error("P4 must be either 'syll' or 'mora'.");
                return error;
            }
            Constraint cc = FrameOptionsMetrPhon.newMetricalStress().QAlignment(o, c, d, u);
            cc.rename(name);
            return cc;
        }
    }};
    public static HashMap<String, Constraint_scheme> name2scheme = new HashMap();

    static {
        int i = 0;
        while (i < S.length) {
            name2scheme.put(Scheme_constr.S[i].name, S[i]);
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Constraint_scheme {
        public String name;
        public String short_descr;
        public String long_descr;
        public int nr_param;
        public String type;

        public Constraint_scheme(String Scheme_name, String short_description, String long_description, int nr_of_param, String scheme_type) {
            this.name = Scheme_name;
            this.short_descr = short_description;
            this.long_descr = long_description;
            this.nr_param = nr_of_param;
            this.type = scheme_type;
        }

        public Constraint con(String name, Vector<String> P, Universe U) {
            return Constraint.empty(null);
        }
    }
}

