/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.uiMyElements;

import hu.birot.OTKit.dataType.Form;
import hu.birot.OTKit.grammarExamples.MetricalStress;
import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Gen;
import hu.birot.OTKit.otBuildingBlocks.GenExamples;
import hu.birot.OTKit.uiMyElements.MyForm;
import hu.birot.OTKit.uiMyElements.MyGen;
import hu.birot.OTKit.uiMyElements.MyTable;
import hu.birot.OTKit.uiMyElements.Scheme_form;
import hu.birot.OTKit.uiMyElements.Universe;
import hu.birot.OTKit.userInterface.FrameOptionsMetrPhon;
import hu.birot.OTKit.userInterface.OTKit;
import java.util.HashMap;
import java.util.Vector;

public class Scheme_gen {
    public static final Gen error = new Gen_scheme("", "", 0, "").gen("OTKit_error", null, null);
    public static final Gen warning = new Gen_scheme("", "", 0, "").gen("OTKit_warning", null, null);
    public static final String type_table = "From table";
    public static final String alphabet = "From alphabet";
    public static final String Gen_arith = "Gen arithmetic";
    public static final String type_string = "String grammar";
    public static final String type_metrphono = "Metrical phonology";
    public static final String[] Scheme_types = new String[]{"From table", "From alphabet", "Gen arithmetic", "String grammar", "Metrical phonology"};
    public static final Gen_scheme[] S = new Gen_scheme[]{new Gen_scheme("Strings_in_table_P1", "The string appearing in column 1 of table P1 constitute the set of candidates. To be more precise: any underlying form uf is mapped to the candidates (uf, sf) such that sf are forms constructed from the string appearing in table P1 column 1. All the candidates have equal weights (i.e., probabilities =  1 / number of cells in column 1 of table P1).", 1, "From table"){

        @Override
        public Gen gen(String name, Vector<String> P, Universe U) {
            MyTable mt = U.MyTables.get(P.get(0));
            if (mt == null) {
                OTKit.warning("Table '" + P.get(0) + "' not in Universe.");
                return warning;
            }
            if (mt.cols() < 1) {
                OTKit.warning("Table '" + P.get(0) + "' must contain at least one column.");
                return error;
            }
            int l = mt.rows();
            String[] cands = new String[l];
            int i = 0;
            while (i < l) {
                cands[i] = mt.table()[i][0];
                ++i;
            }
            return GenExamples.listOfSurfaceForms(cands);
        }
    }, new Gen_scheme("Forms_in_table_P1", "The form names appearing in column 1 of table P1 constitute the set of candidates. To be more precise: any underlying form uf is mapped to the candidates (uf, sf) such that sf is a form in MyUniverse whose name appears in table P1 column 1. If the first column of the table contains strings that do not correspond to any form present in MyUniverse, errors are generated. All the candidates have equal weights (i.e., probabilities =  1 / number of cells in column 1 of table P1).", 1, "From table"){

        @Override
        public Gen gen(String name, Vector<String> P, Universe U) {
            MyTable mt = U.MyTables.get(P.get(0));
            if (mt == null) {
                OTKit.warning("Table '" + P.get(0) + "' not in Universe.");
                return error;
            }
            if (mt.cols() < 1) {
                OTKit.warning("Table '" + P.get(0) + "' must contain at least one column.");
                return error;
            }
            int l = mt.rows();
            Form[] cands = new Form[l];
            int i = 0;
            while (i < l) {
                MyForm mf = U.MyForms.get(mt.table()[i][0]);
                if (mf == null) {
                    OTKit.warning("Universe " + U + " contains no form with name '" + mt.table()[i][0] + "',\n which appears in row " + (i + 1) + " column 1 of table " + P.get(0) + "!");
                    cands[i] = Scheme_form.warning;
                } else {
                    cands[i] = mf.form(U);
                }
                ++i;
            }
            return GenExamples.listOfSurfaceForms(cands);
        }
    }, new Gen_scheme("P1_power_P2", "Alphabet in P1 to the power P2. P1 contains a string of characters, which form the alphabet. Every underlying form is mapped to the strings of length P2 formed of these characters.", 2, "From alphabet"){

        @Override
        public Gen gen(String name, Vector<String> P, Universe U) {
            int exp = 0;
            try {
                exp = Integer.parseInt(P.get(1));
            }
            catch (NumberFormatException numFormExcpt) {
                OTKit.error("P2 must be parsable to an integer!");
                return error;
            }
            String a = P.get(0).trim();
            int l = a.length();
            String[] t = new String[l];
            int i = 0;
            while (i < l) {
                t[i] = "" + a.charAt(i);
                ++i;
            }
            return GenExamples.alphabetPower(t, exp);
        }
    }, new Gen_scheme("P1_star", "Kleene star of alphabet in P1. P1 contains a string of characters, which form the alphabet. Every underlying form is mapped to the strings formed of these characters.", 1, "From alphabet"){

        @Override
        public Gen gen(String name, Vector<String> P, Universe U) {
            String a = P.get(0).trim();
            int l = a.length();
            String[] t = new String[l];
            int i = 0;
            while (i < l) {
                t[i] = "" + a.charAt(i);
                ++i;
            }
            return GenExamples.alphabetStar(t);
        }
    }, new Gen_scheme("Table_P1_power_P2", "Alphabet in table P1 to the power P2. Column 1 of table P1 contain strings, which form the alphabet. Every underlying form is mapped to the language formed by the concatenation of P2 strings taken from this alphabet.", 2, "From alphabet"){

        @Override
        public Gen gen(String name, Vector<String> P, Universe U) {
            MyTable mt = U.MyTables.get(P.get(0));
            if (mt == null) {
                OTKit.warning("Table '" + P.get(0) + "' not in Universe.");
                return error;
            }
            if (mt.cols() < 1) {
                OTKit.warning("Table '" + P.get(0) + "' must contain at least one column.");
                return error;
            }
            int exp = 0;
            try {
                exp = Integer.parseInt(P.get(1));
            }
            catch (NumberFormatException numFormExcpt) {
                OTKit.error("P2 must be parsable to an integer!");
                return error;
            }
            int l = mt.rows();
            String[] t = new String[l];
            int i = 0;
            while (i < l) {
                t[i] = mt.table()[i][0];
                ++i;
            }
            return GenExamples.alphabetPower(t, exp);
        }
    }, new Gen_scheme("Table_P1_star", "Kleene star of alphabet in table P1. Column 1 of table P1 contain strings, which form the alphabet. Every underlying form is mapped to the language formed by the concatenation of any number of strings taken from this alphabet.", 1, "From alphabet"){

        @Override
        public Gen gen(String name, Vector<String> P, Universe U) {
            MyTable mt = U.MyTables.get(P.get(0));
            if (mt == null) {
                OTKit.warning("Table '" + P.get(0) + "' not in Universe.");
                return error;
            }
            if (mt.cols() < 1) {
                OTKit.warning("Table '" + P.get(0) + "' must contain at least one column.");
                return error;
            }
            int l = mt.rows();
            String[] t = new String[l];
            int i = 0;
            while (i < l) {
                t[i] = mt.table()[i][0];
                ++i;
            }
            return GenExamples.alphabetStar(t);
        }
    }, new Gen_scheme("Composition_P1_P2", "Composition of two Gen functions: Gen P1 maps the underlying forms unto some intermediate forms, and subsequently, Gen P2 maps these intermediate forms unto the surface forms.", 2, "Gen arithmetic"){

        @Override
        public Gen gen(String name, Vector<String> P, Universe U) {
            MyGen g0 = U.MyGens.get(P.get(0));
            if (g0 == null) {
                OTKit.warning("Gen '" + P.get(0) + "' not in Universe.");
                return error;
            }
            MyGen g1 = U.MyGens.get(P.get(1));
            if (g1 == null) {
                OTKit.warning("Gen '" + P.get(1) + "' not in Universe.");
                return error;
            }
            return GenExamples.composition(g0.gen(U), g1.gen(U));
        }
    }, new Gen_scheme("Metrical_phono_Gen", "Gen of metrical phonology. Add foot structure and stress. Feet are at most bi-syllabic, word must contain exactly one primary stress, and may contain secondary stresses.", 0, "Metrical phonology"){

        @Override
        public Gen gen(String name, Vector<String> P, Universe U) {
            return FrameOptionsMetrPhon.newMetricalStress().gen;
        }
    }, new Gen_scheme("Metrical_phono_Gen_mora_P1", "Metrical phonology Gen, adding mora symbols. Add foot structure and stress. Feet are at most bi-syllabic, word must contain exactly one primary stress, and may contain secondary stresses. One mora symbol is added to light syllables, and two to heavy syllables. P1 defines what counts as heavy. Possible values are:\n1 -- if syllable has a long nucleus.\n2 -- if it has a coda.\n3 -- if it has a long nucleus OR a coda (or both).\n4 -- it is has a complex coda.\n5 -- if it has a long nucleus OR a complex coda (or both).\n8 -- if it has a long nucleus AND a coda.\n12 -- it is has a complex coda OR if it has a long nucleus and a coda.\n16 -- if it has a long nucleus AND a complex coda.", 1, "Metrical phonology"){

        @Override
        public Gen gen(String name, Vector<String> P, Universe U) {
            int h;
            try {
                h = Integer.parseInt(P.get(0));
            }
            catch (NumberFormatException numFormExcpt) {
                OTKit.error("P1 must be parsable to an integer!");
                return error;
            }
            final MetricalStress G = FrameOptionsMetrPhon.newMetricalStress();
            final Gen g = G.gen;
            return new Gen(){

                @Override
                public Candidate firstCandidate(Form f) {
                    return new Candidate(f, g.firstCandidate((Form)G.addMora((Form)f, (int)h)).sf);
                }

                @Override
                public Candidate nextCandidate(Candidate c) {
                    return g.nextCandidate(c);
                }

                @Override
                public Candidate randomCandidate(Form f, double r) {
                    return new Candidate(f, g.randomCandidate((Form)G.addMora((Form)f, (int)h), (double)r).sf);
                }

                @Override
                public Vector<Candidate> allCandidates(Form f) {
                    Vector<Candidate> v = new Vector<Candidate>();
                    for (Candidate c : g.allCandidates(G.addMora(f, h))) {
                        v.add(new Candidate(f, c.sf));
                    }
                    return v;
                }
            };
        }
    }, new Gen_scheme("Metrical_phono_Gen_mora_P1_P2", "Metrical phonology Gen, adding mora symbols. Add foot structure and stress. Feet are at most bi-syllabic, word must contain exactly one primary stress, and may contain secondary stresses. One mora symbol is added to light syllables, two to heavy syllables, and three to superheavy ones. P1 defines what counts as heavy; P2 defines what counts as superheavy. Possible values of P1 and P2 are:\n1 -- if syllable has a long nucleus.\n2 -- if it has a coda.\n3 -- if it has a long nucleus OR a coda (or both).\n4 -- it is has a complex coda.\n5 -- if it has a long nucleus OR a complex coda (or both).\n8 -- if it has a long nucleus AND a coda.\n12 -- it is has a complex coda OR if it has a long nucleus and a coda.\n16 -- if it has a long nucleus AND a complex coda.", 2, "Metrical phonology"){

        @Override
        public Gen gen(String name, Vector<String> P, Universe U) {
            int s;
            int h;
            try {
                h = Integer.parseInt(P.get(0));
            }
            catch (NumberFormatException numFormExcpt) {
                OTKit.error("P1 must be parsable to an integer!");
                return error;
            }
            try {
                s = Integer.parseInt(P.get(1));
            }
            catch (NumberFormatException numFormExcpt) {
                OTKit.error("P2 must be parsable to an integer!");
                return error;
            }
            final MetricalStress G = FrameOptionsMetrPhon.newMetricalStress();
            final Gen g = G.gen;
            return new Gen(){

                @Override
                public Candidate firstCandidate(Form f) {
                    return new Candidate(f, g.firstCandidate((Form)G.addMora((Form)f, (int)h, (int)s)).sf);
                }

                @Override
                public Candidate nextCandidate(Candidate c) {
                    return g.nextCandidate(c);
                }

                @Override
                public Candidate randomCandidate(Form f, double r) {
                    return new Candidate(f, g.randomCandidate((Form)G.addMora((Form)f, (int)h, (int)s), (double)r).sf);
                }

                @Override
                public Vector<Candidate> allCandidates(Form f) {
                    Vector<Candidate> v = new Vector<Candidate>();
                    for (Candidate c : g.allCandidates(G.addMora(f, h, s))) {
                        v.add(new Candidate(f, c.sf));
                    }
                    return v;
                }
            };
        }
    }, new Gen_scheme("Metrical_phono_base_P1_P2", "Base of metrical phonology. Any input is mapped unto possible underlying forms, which are series of syllables. A syllable is a vowel, preceded by zero or one consonant, and followed by zero or one consonant. An end-of-syllable symbol (a full stop) delineates adjacent syllables. (Let me know if you need complex onsets and complex codas.) The characters forming P1 are used as vowels. The characters forming P2 are used as consonants. For example, if P1 is the string 'aeiuo' and P2 is 'bcdfg', then the base maps any form to forms 'a.bef', 'u' and 'ba.ab.ef.fe', among infinitely many others.", 2, "Metrical phonology"){

        @Override
        public Gen gen(String name, Vector<String> P, Universe U) {
            char[] vowels = P.get(0).trim().toCharArray();
            char[] consonants = P.get(1).trim().toCharArray();
            return new Gen(FrameOptionsMetrPhon.newMetricalStress((char[])vowels, (char[])consonants).base);
        }
    }, new Gen_scheme("Metrical_phono_RIP", "RIP (Robust Interpretive Parsing) in metrical phonology: add foot structure to an overt form already containing stress.", 0, "Metrical phonology"){

        @Override
        public Gen gen(String name, Vector<String> P, Universe U) {
            return FrameOptionsMetrPhon.newMetricalStress().rip;
        }
    }};
    public static HashMap<String, Gen_scheme> name2scheme = new HashMap();

    static {
        int i = 0;
        while (i < S.length) {
            name2scheme.put(Scheme_gen.S[i].name, S[i]);
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Gen_scheme {
        public String name;
        public String description;
        public int nr_param;
        public String type;

        public Gen_scheme(String Scheme_name, String descr, int nr_of_param, String scheme_type) {
            this.name = Scheme_name;
            this.description = descr;
            this.nr_param = nr_of_param;
            this.type = scheme_type;
        }

        public Gen gen(String name, Vector<String> P, Universe U) {
            Gen G = new Gen();
            G.name = name;
            return G;
        }
    }
}

