/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.userInterface;

import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Constraint;
import hu.birot.OTKit.otBuildingBlocks.Hierarchy;
import hu.birot.OTKit.uiMyElements.MyCandidate;
import hu.birot.OTKit.uiMyElements.MyConstraint;
import hu.birot.OTKit.uiMyElements.MyHierarchy;
import hu.birot.OTKit.uiMyElements.Universe;
import hu.birot.OTKit.userInterface.OTKFrame;
import hu.birot.OTKit.userInterface.OTKit;
import hu.birot.OTKit.userInterface.OTKit_GUI;
import hu.birot.OTKit.userInterface.OTKit_script;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FrameActionConstr
extends OTKFrame {
    private static final long serialVersionUID = 1L;
    Universe U;
    MyConstraint co = null;
    MyCandidate ca = null;
    MyHierarchy hi = null;
    JLabel con = new JLabel("");
    JLabel hier = new JLabel("");
    JLabel cand = new JLabel("");
    JTextField viol = new JTextField("");

    public FrameActionConstr(Universe u) {
        super(500, 200, "Apply constraint or hierarchy to a candidate");
        this.U = u != null ? u : OTKit.MyUniverse;
        JPanel grid = new JPanel();
        grid.setLayout(new GridLayout(0, 2, 10, 10));
        this.background.add(grid);
        JButton addCon = new JButton("Constraint:");
        addCon.addActionListener(this);
        addCon.setActionCommand("add_con");
        grid.add(addCon);
        grid.add(this.con);
        JButton addHier = new JButton("Hierarchy:");
        addHier.addActionListener(this);
        addHier.setActionCommand("add_hier");
        grid.add(addHier);
        grid.add(this.hier);
        JButton addCand = new JButton("Candidate:");
        addCand.addActionListener(this);
        addCand.setActionCommand("add_cand");
        grid.add(addCand);
        grid.add(this.cand);
        grid.add(new JLabel("Number of violations: "));
        grid.add(this.viol);
        this.viol.setEditable(false);
        this.update();
    }

    private void update() {
        if (this.co != null) {
            this.con.setText(this.co.name());
        }
        if (this.hi != null) {
            this.hier.setText(this.hi.name());
        }
        if (this.ca != null) {
            this.cand.setText(this.ca.name());
        }
        if (this.co != null && this.ca != null) {
            this.viol.setText("" + this.co.con(this.U).value(this.ca.cand(this.U)));
            String h = "value( " + this.co.shortScript() + " , " + this.ca.shortScript() + " )";
            OTKit.history = String.valueOf(OTKit.history) + h + "\n";
            OTKit_GUI.printText("> " + h);
            OTKit_script script = new OTKit_script();
            script.execScript(h);
        }
        if (this.hi != null && this.ca != null) {
            String text = "";
            Candidate can = this.ca.cand(this.U);
            Hierarchy h = this.hi.hier(this.U);
            if (this.hi.hier((Universe)this.U).type.equalsIgnoreCase("ot")) {
                Constraint[] c = h.sortByRank();
                int i = c.length - 1;
                while (i > -1) {
                    if (!text.isEmpty()) {
                        text = String.valueOf(text) + OTKit.separator;
                    }
                    text = String.valueOf(text) + " " + c[i].value(can) + " ";
                    --i;
                }
                text = String.valueOf(text) + OTKit.end_of_row;
            } else if (this.hi.hier((Universe)this.U).type.equalsIgnoreCase("hg")) {
                double sum = 0.0;
                Constraint[] c = h.sortByWeight();
                int i = c.length - 1;
                while (i > -1) {
                    if (!text.isEmpty() && h.weightOf(c[i]) >= 0.0) {
                        text = String.valueOf(text) + "+";
                    }
                    text = String.valueOf(text) + " " + h.weightOf(c[i]) + " * " + c[i].value(can) + " ";
                    sum += h.weightOf(c[i]) * (Double)c[i].value(can).value();
                    --i;
                }
                text = String.valueOf(text) + "= " + sum;
            }
            this.viol.setText(text);
        }
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String what = e.getActionCommand();
        if (what.equals("close")) {
            this.processEvent(new WindowEvent(this, 201));
        } else if (what.equals("add_con")) {
            Object[] possibleValues = this.U.MyConstraints.keySet().toArray();
            if (possibleValues.length == 0) {
                OTKit.warning("No constraint yet in " + this.U.name() + ".");
            } else {
                Object selectedValue = JOptionPane.showInputDialog(null, "Choose a constraint", "Constraints", 1, null, possibleValues, possibleValues[0]);
                if (selectedValue != null) {
                    this.co = this.U.MyConstraints.get(selectedValue);
                    this.hi = null;
                }
            }
            this.update();
        } else if (what.equals("add_hier")) {
            Object[] possibleValues = this.U.MyHierarchies.keySet().toArray();
            if (possibleValues.length == 0) {
                OTKit.warning("No hierarchy yet in " + this.U.name() + ".");
            } else {
                Object selectedValue = JOptionPane.showInputDialog(null, "Choose a hierarchy", "Hierarchies", 1, null, possibleValues, possibleValues[0]);
                if (selectedValue != null) {
                    this.hi = this.U.MyHierarchies.get(selectedValue);
                    this.co = null;
                }
            }
            this.update();
        } else if (what.equals("add_cand")) {
            Object[] possibleValues = this.U.MyCandidates.keySet().toArray();
            if (possibleValues.length == 0) {
                OTKit.warning("No candidates yet in " + this.U.name() + ".");
            } else {
                Object selectedValue = JOptionPane.showInputDialog(null, "Choose a candidate", "Candidates", 1, null, possibleValues, possibleValues[0]);
                if (selectedValue != null) {
                    this.ca = this.U.MyCandidates.get(selectedValue);
                }
            }
            this.update();
        }
    }
}

