/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.userInterface;

import hu.birot.OTKit.dataType.Form;
import hu.birot.OTKit.dataType.MapForm;
import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Constraint;
import hu.birot.OTKit.otBuildingBlocks.Eval;
import hu.birot.OTKit.otBuildingBlocks.Gen;
import hu.birot.OTKit.otBuildingBlocks.Hierarchy;
import hu.birot.OTKit.uiMyElements.MyForm;
import hu.birot.OTKit.uiMyElements.MyGen;
import hu.birot.OTKit.uiMyElements.MyHierarchy;
import hu.birot.OTKit.uiMyElements.MyTable;
import hu.birot.OTKit.uiMyElements.Universe;
import hu.birot.OTKit.userInterface.FrameDefineForm;
import hu.birot.OTKit.userInterface.OTKFrame;
import hu.birot.OTKit.userInterface.OTKit;
import hu.birot.OTKit.userInterface.OTKit_GUI;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FrameActionFactorialTypology
extends OTKFrame {
    private static final long serialVersionUID = 1L;
    Universe U;
    MyHierarchy hi = null;
    MyForm uf = null;
    MyGen ge = null;
    MyHierarchy fixed = null;
    MyTable apriori = null;
    int ignore = 0;
    JLabel hier = new JLabel("");
    JLabel undf = new JLabel("");
    JLabel gen = new JLabel("");
    JCheckBox verbose = new JCheckBox("Report winners per candidate", true);
    JCheckBox collectAll = new JCheckBox("Collect all hierarchies per winner", false);
    JCheckBox add2MyU = new JCheckBox("Add hierarchies to MyUniverse", false);
    JTextField nr_c = new JTextField("");
    static final String newform = "New form from string";
    static final String newform2 = "New form (open panel)";
    static final String helpText = "This window computes a factorial typology for a given underlying form, a Gen function and the constraints and ranking values specified in a hierarchy. A number of 'subfactorial tricks' are also offered to reduce the number of constraint permutations to an amount that can be handled by the computer and the linguist alike.\n\nSpecify the underlying form and the Gen in the upper part of the window. If the Gen maps that form to an infinite set, then you must (otherwise you can) restrict the number of candidates considered during evaluation.\n\nYou also specify a hierarchy. The factorial typology is computed by generating all possible ways of coupling the constraints to the ranking values occurring in that hierarchy. The type of the hierarchy, whether it is 'OT' or 'HG', determines not only the method using which the hierarchy is employed (strict domination or weighted sum), but also whether the values of the ranking variable 'rank' or 'weight' are used. Note that in the 'HG' case, these permutations do not necessarily cover all possible HG grammars, only those employing these specific weights.\n\nThe output is a list of winning candidates, together with hierarchies producing them. By selecting the corresponding check box, you will also get the winning candidates for each hierarchy, while the process is still running. Another check box determines whether all hierarchies or only the first hierarchy found is reported for each winning candidate. If the third check box is selected, then all reported hierarchies (all hierarchies, or only one per winning candidate, depending on the previous check box), is saved to MyUniverse.\n\nIf the number of constraints is larger than a surprisingly low number, then the computation can take surprisingly long. To save time (and to avoid memory problems, if the number of constraints is even larger), it is recommended to uncheck these boxes. Moreover, a number of 'subfactorial tricks' is also offered to reduce the amount of constraint permutations being evaluated:\n\n1. 'Fixed hierarchy': Use a hierarchy previously saved to MyUniverse to fix the ranking value of some constraints. Constraints in the original hierarchy that also appear in the fixed one will only be assigned the ranking value corresponding to them in the latter hierarchy. Only constraints not present in the fixed hierarchy are permuted. Note that the fixed ranking value must also appear in the original hierarchy (the one to be permuted), even if with a different constraint. Note also that constraints appearing in the fixed hierarchy but not in the original one are simply ignored.\n\n2. 'A priori table': A table previously saved to MyUniverse, with at least two columns. Each cell in the table contains the name of a constraint. A row corresponds to the following ranking restriction: the constraint specified in the first cell must be ranked higher than the constraint specified in the second cell. In OT, 'ranked higher' means having a higher value for 'rank', whereas in HG, it means having a lower (i.e., more negative) value for 'weight'. Note that this subfactorial trick is the least efficient one: if the number of constraints is high, even though the restrictions reduce drastically the possible number of permutations, then it will still take much time, because every permutation is generated (even if not evaluated on the candidate set), before being filtered out if it does not meet the criteria of the 'a priori table'.\n\n3. 'Ignore last n constraints': The lowest 'n' ranking values (in the HG case: the highest 'n' weights) are not used. In other words, the evaluation process uses less constraints. In the OT case, the evaluation stops when we reach the constraint that is n'th from the end (cf. Coetzee's model). Thus, the number of permutations being considered is reduced by a factor of n!. Note that if a candidate emerges as the 'winner' in this case, it does not mean that it necessarily wins for some permutation of the original hierarchy; it only means that is survives up to the last n strata for some hierarchy.\n\nThese 'subfactorial tricks' can also be combined. For example, here is a technique to explore systematically a set of constraints in OT: First, you set the 'ignore constraints' feature in a way that only the highest part of the hierarchy will be varied, yielding a reasonable number of variations. If you are lucky (or smart), then for most of the cases only a single candidate will survive the highest strata, and so you know that all permutations of the ignored constraints in the lower part of the hierarchy will result in the same output. In some cases, however, more candidates are still competing after the highest ranked constraints. Then, you create a new hierarchy, with the highest ranked constraints being fixed to the rank values specific to this case, and you repeat the experiment with this new hierarchy as 'fixed hierarchy' and with a lower 'ignore last n' value.\n\nAll outputs are returned in the main panel.\n";

    public FrameActionFactorialTypology(Universe u) {
        super(490, 390, "Calculate factorial typology");
        this.U = u != null ? u : OTKit.MyUniverse;
        JPanel grid = new JPanel();
        grid.setLayout(new GridLayout(0, 2, 10, 10));
        this.background.add(grid);
        JButton addUf = new JButton("Underlying form:");
        addUf.addActionListener(this);
        addUf.setActionCommand("add_uf");
        grid.add(addUf);
        grid.add(this.undf);
        JButton addGen = new JButton("Gen:");
        addGen.addActionListener(this);
        addGen.setActionCommand("add_gen");
        grid.add(addGen);
        grid.add(this.gen);
        JButton addHier = new JButton("Hierarchy:");
        addHier.addActionListener(this);
        addHier.setActionCommand("add_hier");
        grid.add(addHier);
        grid.add(this.hier);
        grid.add(new JLabel("Number of candidates:"));
        grid.add(this.nr_c);
        grid.add(this.verbose);
        grid.add(new JLabel());
        grid.add(this.collectAll);
        grid.add(new JLabel());
        grid.add(this.add2MyU);
        grid.add(new JLabel());
        JButton run = new JButton("Calculate factorial typology");
        run.addActionListener(this);
        run.setActionCommand("run");
        grid.add(run);
        JButton subfact = new JButton("Subfactorial tricks");
        subfact.addActionListener(this);
        subfact.setActionCommand("subfact");
        grid.add(subfact);
        JButton help = new JButton("Help");
        help.addActionListener(this);
        help.setActionCommand("help");
        grid.add(help);
        JButton close = new JButton("Close");
        close.addActionListener(this);
        close.setActionCommand("close");
        grid.add(close);
        this.update();
    }

    private void update() {
        if (this.uf != null) {
            this.undf.setText("\"" + this.uf.form(this.U) + "\"");
        }
        if (this.ge != null) {
            this.gen.setText(this.ge.name());
        }
        if (this.hi != null) {
            this.hier.setText(this.hi.name());
        }
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String what = e.getActionCommand();
        if (what.equals("close")) {
            this.processEvent(new WindowEvent(this, 201));
        } else if (what.equals("help")) {
            OTKit.help(helpText);
        } else if (what.equals("add_uf")) {
            Object[] pv = this.U.MyForms.keySet().toArray();
            Object[] possibleValues = new Object[pv.length + 1];
            possibleValues[0] = newform;
            int i = 0;
            while (i < pv.length) {
                possibleValues[i + 1] = pv[i];
                ++i;
            }
            if (possibleValues.length == 0) {
                OTKit.warning("No form yet in " + this.U.name() + ".");
            } else {
                Object selectedValue = JOptionPane.showInputDialog(null, "Choose an (underlying) form", "Forms", 1, null, possibleValues, possibleValues[0]);
                if (selectedValue != null) {
                    if (selectedValue.equals(newform)) {
                        String q = JOptionPane.showInputDialog(null, (Object)"String that will be contained by the new underlying form:");
                        if (q != null) {
                            this.uf = new MyForm(newform, "simple string");
                            this.uf.params = new Vector();
                            this.uf.params.add(q);
                        }
                    } else if (selectedValue.equals(newform2)) {
                        FrameDefineForm frame = new FrameDefineForm(null);
                        this.uf = frame.myf;
                    } else {
                        this.uf = this.U.MyForms.get(selectedValue);
                    }
                }
            }
            this.update();
        } else if (what.equals("add_hier")) {
            Object[] possibleValues = this.U.MyHierarchies.keySet().toArray();
            if (possibleValues.length == 0) {
                OTKit.warning("No hierarchy yet in " + this.U.name() + ".");
            } else {
                Object selectedValue = JOptionPane.showInputDialog(null, "Choose a hierarchy", "Hierarchies", 1, null, possibleValues, possibleValues[0]);
                if (selectedValue != null) {
                    this.hi = this.U.MyHierarchies.get(selectedValue);
                }
            }
            this.update();
        } else if (what.equals("add_gen")) {
            Object[] possibleValues = this.U.MyGens.keySet().toArray();
            if (possibleValues.length == 0) {
                OTKit.warning("No Gen yet in " + this.U.name() + ".");
            } else {
                Object selectedValue = JOptionPane.showInputDialog(null, "Choose a Gen", "Gen functions", 1, null, possibleValues, possibleValues[0]);
                if (selectedValue != null) {
                    this.ge = this.U.MyGens.get(selectedValue);
                }
            }
            this.update();
        } else if (what.equals("run")) {
            if (this.uf == null) {
                OTKit.error("Underlying form not defined yet.");
            } else if (this.ge == null) {
                OTKit.error("Gen not defined yet.");
            } else if (this.hi == null) {
                OTKit.error("Hierarchy not defined yet.");
            } else {
                Integer nr = null;
                if (!this.nr_c.getText().trim().isEmpty()) {
                    try {
                        nr = Integer.parseInt(this.nr_c.getText().trim());
                    }
                    catch (NumberFormatException numFormExcpt) {
                        OTKit.error("Value in field \"Number of candidates\" must be an integer!");
                    }
                }
                OTKit.return_out("Factorial typology:\n Form: " + this.uf.form(this.U) + "\n Gen: " + this.ge.name() + "\n Starting hierarchy: " + this.hi.name());
                if (this.fixed != null) {
                    OTKit.return_out(" Fixed subhierarchy: " + this.fixed.name());
                }
                if (this.apriori != null) {
                    OTKit.return_out(" A priori rankings in Table: " + this.apriori.name());
                }
                if (this.ignore != 0) {
                    OTKit.return_out(" Ignore last: " + this.ignore);
                }
                if (nr != null) {
                    OTKit.return_out(" Considering only the first " + nr + " candidates generated by Gen.");
                }
                OTKit.return_out("");
                OTKit.return_out("Winning candidates: \n" + FrameActionFactorialTypology.factorial_typolgy(this.uf.form(this.U), this.ge.gen(this.U), nr, this.hi.hier(this.U), this.fixed, this.apriori, this.ignore, this.verbose.isSelected(), this.collectAll.isSelected(), this.add2MyU.isSelected(), this.U) + "\n");
                String form_script = this.uf.name().equals(newform) || this.uf.name().equals(newform2) ? this.uf.longScript() : this.uf.shortScript();
                String h = "factorial_typology(" + form_script + ", " + this.ge.shortScript();
                if (nr != null) {
                    h = String.valueOf(h) + ", " + nr;
                }
                h = String.valueOf(h) + ", " + this.hi.shortScript();
                if (this.fixed != null) {
                    h = String.valueOf(h) + ", " + this.fixed.shortScript();
                }
                if (this.apriori != null) {
                    h = String.valueOf(h) + ", " + this.apriori.shortScript();
                }
                if (this.ignore != 0) {
                    h = String.valueOf(h) + ", ignore " + this.ignore;
                }
                if (this.verbose.isSelected()) {
                    h = String.valueOf(h) + ", verbose";
                }
                if (this.collectAll.isSelected()) {
                    h = String.valueOf(h) + ", collectAll";
                }
                if (this.add2MyU.isSelected()) {
                    h = String.valueOf(h) + ", add2myu";
                }
                h = String.valueOf(h) + ")";
                OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                OTKit_GUI.printText("> " + h);
            }
        } else if (what.equals("subfact")) {
            String q;
            Object selectedValue;
            Object[] possibleValues = new Object[1 + this.U.MyHierarchies.keySet().size()];
            possibleValues[0] = "No fixed hierarchy.";
            int i = 0;
            for (String key : this.U.MyHierarchies.keySet()) {
                possibleValues[++i] = key;
            }
            Object selected = possibleValues[0];
            if (this.fixed != null) {
                selected = this.fixed.name();
            }
            if ((selectedValue = JOptionPane.showInputDialog(null, "Choose a fixed subhierarchy,\nor press cancel", "Fixed subhierarchy", 1, null, possibleValues, selected)) != null) {
                this.fixed = selectedValue.equals(possibleValues[0]) ? null : this.U.MyHierarchies.get(selectedValue);
            }
            possibleValues = new Object[1 + this.U.MyTables.keySet().size()];
            possibleValues[0] = "No a priori table.";
            i = 0;
            for (String key : this.U.MyTables.keySet()) {
                possibleValues[++i] = key;
            }
            selected = possibleValues[0];
            if (this.apriori != null) {
                selected = this.apriori.name();
            }
            if ((selectedValue = JOptionPane.showInputDialog(null, "Choose a table containing a priori rankings,\nor press cancel", "A priori rankings", 1, null, possibleValues, selected)) != null) {
                this.apriori = selectedValue.equals(possibleValues[0]) ? null : this.U.MyTables.get(selectedValue);
            }
            if ((q = JOptionPane.showInputDialog(null, "Ignore last n constraints.\nEnter value of n, or press cancel.", "" + this.ignore)) != null && !q.trim().isEmpty()) {
                try {
                    this.ignore = Integer.parseInt(q.trim());
                }
                catch (NumberFormatException exc) {
                    OTKit.error("n must be parsable to an integer!");
                }
            }
        }
    }

    public static String factorial_typolgy(Form uf, Gen gen, Integer nr_candidates, Hierarchy h, MyHierarchy fixed, MyTable apriori, int ignore, boolean verbose, boolean collectAll, boolean add2MyU, Universe U) {
        boolean type_is_ot;
        String out = "";
        if (h.type.equalsIgnoreCase("ot")) {
            type_is_ot = true;
        } else if (h.type.equalsIgnoreCase("hg")) {
            type_is_ot = false;
        } else {
            OTKit.error("Type of hierarchy " + h.name + " is neither OT nor HG.");
            return "";
        }
        Vector<Object> allc = new Vector<Candidate>();
        if (nr_candidates == null) {
            allc = gen.allCandidates(uf);
            if (((Candidate)allc.get((int)0)).sf.equals(MapForm.InfiniteSet)) {
                OTKit.return_err("Gen " + gen.name + " maps underlying form " + uf + " to an infinite set.");
                OTKit.error("Gen " + gen.name + " maps underlying form " + uf + " to an infinite set.");
            } else if (((Candidate)allc.get((int)0)).sf.equals(MapForm.NoMapping)) {
                OTKit.return_err("Gen " + gen.name + " maps underlying form " + uf + " to no candidate.");
                OTKit.error("Gen " + gen.name + " maps underlying form " + uf + " to no candidate.");
                return "";
            }
        } else {
            allc.add(gen.firstCandidate(uf));
            if (((Candidate)allc.get((int)0)).sf.equals(MapForm.NoMapping)) {
                OTKit.return_err("Gen " + gen.name + " maps underlying form " + uf + " to no candidate.");
                OTKit.error("Gen " + gen.name + " maps underlying form " + uf + " to no candidate.");
                return "";
            }
            int i = 1;
            while (i < nr_candidates) {
                Candidate c = gen.nextCandidate((Candidate)allc.lastElement());
                if (c.sf.equals(MapForm.NoMoreForm)) {
                    i = nr_candidates;
                } else {
                    allc.add(c);
                }
                ++i;
            }
        }
        if (h.constraints().isEmpty()) {
            OTKit.error("Hierarchy " + h.name + " contains no constraint.");
            return "";
        }
        HashMap<Candidate, String> stringout = new HashMap<Candidate, String>();
        Hierarchy fxd = new Hierarchy();
        fxd.type = h.type;
        Vector<Constraint> names = new Vector<Constraint>();
        Vector<Double> ranks = new Vector<Double>();
        int i = 0;
        Hierarchy f = new Hierarchy();
        if (fixed != null) {
            f = fixed.hier(U);
        }
        for (Constraint c : h.constraints()) {
            if (type_is_ot) {
                ranks.add(h.rankOf(c));
                continue;
            }
            ranks.add(h.weightOf(c));
        }
        for (Constraint c : h.constraints()) {
            if (fixed != null && f.constraints().contains(c)) {
                if (type_is_ot) {
                    fxd.addConstraintWithRank(c, f.rankOf(c));
                    if (ranks.remove(f.rankOf(c))) continue;
                    OTKit.return_err("Ranks appearing in the fixed hierarchy '" + fixed.name() + "' must also appear in the hierarchy '" + h.name + "' to be permuted.");
                    OTKit.error("Ranks appearing in the fixed hierarchy '" + fixed.name() + "' must also appear in the hierarchy '" + h.name + "' to be permuted.");
                    return "";
                }
                fxd.addConstraintWithWeight(c, f.weightOf(c));
                if (ranks.remove(f.weightOf(c))) continue;
                OTKit.return_err("Weights appearing in the fixed hierarchy '" + fixed.name() + "' must also appear in the hierarchy '" + h.name + "' to be permuted.");
                OTKit.error("Weights appearing in the fixed hierarchy '" + fixed.name() + "' must also appear in the hierarchy '" + h.name + "' to be permuted.");
                return "";
            }
            names.add(c);
        }
        boolean apr = apriori != null;
        Constraint[][] aprio = new Constraint[0][2];
        if (apr) {
            aprio = new Constraint[apriori.rows()][apriori.cols()];
        }
        int nr_of_restrictions = 0;
        if (apr) {
            nr_of_restrictions = apriori.rows();
        }
        if (apr && apriori.cols() < 2) {
            OTKit.return_err("Table " + apriori.name() + " does not have at least 2 columns.");
            OTKit.error("Table " + apriori.name() + " does not have at least 2 columns.");
            return "";
        }
        i = 0;
        while (i < nr_of_restrictions) {
            int j = 0;
            while (j < 2) {
                String name = apriori.table()[i][j].trim();
                if (!h.constraintNames().contains(name)) {
                    OTKit.warning("A priori table " + apriori.name() + " contains '" + name + "' (in row " + i + ", column " + j + "),\n" + "but hierarchy " + h.name + " does not " + "contain a constraint thus named.");
                }
                aprio[i][j] = Constraint.empty(name);
                ++j;
            }
            ++i;
        }
        if (ignore > h.numberOfConstraints()) {
            ignore = h.numberOfConstraints();
        }
        if (ignore > 0) {
            Vector<Constraint> fcons;
            double[] allranks = new double[h.numberOfConstraints()];
            i = 0;
            for (Double r : ranks) {
                allranks[i] = r;
                ++i;
            }
            if (type_is_ot) {
                for (Constraint c : fxd.constraints()) {
                    allranks[i] = fxd.rankOf(c);
                    ++i;
                }
            } else {
                for (Constraint c : fxd.constraints()) {
                    allranks[i] = fxd.weightOf(c);
                    ++i;
                }
            }
            Arrays.sort(allranks);
            if (type_is_ot) {
                i = 0;
                while (i < ignore) {
                    fcons = fxd.constraints();
                    if (!ranks.remove(allranks[i])) {
                        int j = fcons.size();
                        while (j > 0) {
                            if (fxd.rankOf(fcons.get(j - 1)) == allranks[i]) {
                                fxd.removeConstraint(fcons.get(j - 1));
                                j = 0;
                            }
                            --j;
                        }
                    }
                    ++i;
                }
            } else {
                i = allranks.length - 1;
                while (i > allranks.length - ignore - 1) {
                    fcons = fxd.constraints();
                    if (!ranks.remove(allranks[i])) {
                        int j = fcons.size();
                        while (j > 0) {
                            if (fxd.weightOf(fcons.get(j - 1)) == allranks[i]) {
                                fxd.removeConstraint(fcons.get(j - 1));
                                j = 0;
                            }
                            --j;
                        }
                    }
                    --i;
                }
            }
        }
        int size = ranks.size();
        CombinationGenerator CG = new CombinationGenerator(names.size(), size);
        int[] indices = new int[size];
        Vector<Constraint> names1 = new Vector<Constraint>();
        MyHierarchy mh = new MyHierarchy(h);
        long hnr = 0L;
        while (CG.hasMore()) {
            int[] indexes = CG.getNext();
            names1.clear();
            int[] nArray = indexes;
            int n = indexes.length;
            int n2 = 0;
            while (n2 < n) {
                int j = nArray[n2];
                names1.add((Constraint)names.get(j));
                ++n2;
            }
            PermutationGenerator P = new PermutationGenerator(size);
            while (P.hasMore()) {
                Vector<Candidate> C;
                Double r2;
                Double r1;
                boolean apr_ok;
                indices = P.getNext();
                Hierarchy clone = fxd.clone();
                clone.name = String.valueOf(h.name) + "-p" + ++hnr;
                clone.type = h.type;
                if (add2MyU) {
                    mh = new MyHierarchy(clone);
                }
                if (type_is_ot) {
                    i = 0;
                    while (i < size) {
                        clone.addConstraintWithRank((Constraint)names1.get(i), (Double)ranks.get(indices[i]));
                        ++i;
                    }
                    apr_ok = true;
                    i = 0;
                    while (apr_ok && i < nr_of_restrictions) {
                        r1 = clone.rankOf(aprio[i][0]);
                        r2 = clone.rankOf(aprio[i][1]);
                        if (r2 != null && (r1 == null || r2 > r1)) {
                            apr_ok = false;
                            --hnr;
                        }
                        ++i;
                    }
                    if (apr_ok) {
                        clone.sortByRank();
                        if (verbose) {
                            OTKit.return_out(String.valueOf(clone.name) + " : " + clone.sortedByRankHierarchy());
                        }
                        C = Eval.CompareOT(allc, clone);
                        if (verbose) {
                            i = 0;
                            while (i < C.size()) {
                                OTKit.return_out(C.get(i).toString());
                                ++i;
                            }
                        }
                        for (Candidate c : C) {
                            if (!stringout.containsKey(c)) {
                                stringout.put(c, String.valueOf(clone.name) + " : " + clone.sortedByRankHierarchy());
                                if (!add2MyU) continue;
                                mh.addMeToHash(U);
                                continue;
                            }
                            if (!collectAll) continue;
                            stringout.put(c, String.valueOf((String)stringout.get(c)) + "\n" + clone.name + " : " + clone.sortedByRankHierarchy());
                            if (!add2MyU) continue;
                            mh.addMeToHash(U);
                        }
                    }
                } else {
                    i = 0;
                    while (i < size) {
                        clone.addConstraintWithWeight((Constraint)names1.get(i), (Double)ranks.get(indices[i]));
                        ++i;
                    }
                    apr_ok = true;
                    i = 0;
                    while (apr_ok && i < nr_of_restrictions) {
                        r1 = clone.weightOf(aprio[i][0]);
                        r2 = clone.weightOf(aprio[i][1]);
                        if (r2 != null && (r1 == null || r2 < r1)) {
                            apr_ok = false;
                            --hnr;
                        }
                        ++i;
                    }
                    if (apr_ok) {
                        String hierinfo = "";
                        for (Constraint c : clone.constraints()) {
                            hierinfo = String.valueOf(hierinfo) + c.name() + " = " + clone.weightOf(c) + ", ";
                        }
                        hierinfo = hierinfo.substring(0, hierinfo.length() - 2);
                        if (verbose) {
                            OTKit.return_out(String.valueOf(clone.name) + " : " + hierinfo);
                        }
                        C = Eval.CompareHG(allc, clone);
                        if (verbose) {
                            i = 0;
                            while (i < C.size()) {
                                OTKit.return_out(C.get(i).toString());
                                ++i;
                            }
                        }
                        for (Candidate c : C) {
                            if (!stringout.containsKey(c)) {
                                stringout.put(c, String.valueOf(clone.name) + " : " + hierinfo);
                                if (!add2MyU) continue;
                                mh.addMeToHash(U);
                                continue;
                            }
                            if (!collectAll) continue;
                            stringout.put(c, String.valueOf((String)stringout.get(c)) + "\n" + clone.name + " : " + hierinfo);
                            if (!add2MyU) continue;
                            mh.addMeToHash(U);
                        }
                    }
                }
                if (!apr_ok || !verbose) continue;
                OTKit.return_out("");
            }
        }
        for (Candidate c : stringout.keySet()) {
            out = String.valueOf(out) + "\n" + c + "\n" + (String)stringout.get(c) + "\n";
        }
        return out;
    }

    private static class CombinationGenerator {
        private int[] a;
        private final int K;
        private final int L;
        private final int M;
        private boolean first_returned = false;

        private CombinationGenerator(int k, int l) {
            if (k < 0) {
                throw new IllegalArgumentException("k: min 0");
            }
            if (l < 0) {
                throw new IllegalArgumentException("l: min 0");
            }
            if (k < l) {
                throw new IllegalArgumentException("l  <= k");
            }
            this.K = k;
            this.L = l;
            this.M = this.K - this.L;
            this.a = new int[this.L];
            this.reset();
        }

        private void reset() {
            int i = 0;
            while (i < this.L) {
                this.a[i] = i;
                ++i;
            }
        }

        private boolean hasMore() {
            return this.L > 0 && this.a[0] < this.M || !this.first_returned;
        }

        private int[] getNext() {
            if (!this.first_returned) {
                this.first_returned = true;
                return this.a;
            }
            int i = this.L;
            while (i > 0) {
                if (this.a[i - 1] < this.K - this.L + i - 1) {
                    int n = i - 1;
                    this.a[n] = this.a[n] + 1;
                    int j = 0;
                    while (i + j < this.L) {
                        this.a[i + j] = this.a[i - 1] + j + 1;
                        ++j;
                    }
                    i = 0;
                }
                --i;
            }
            return this.a;
        }
    }

    private static class PermutationGenerator {
        private int N;
        private int[] a;
        private BigInteger numLeft;
        private BigInteger total;
        boolean first_returned = false;

        private PermutationGenerator(int n) {
            this.N = n;
            if (n < 0) {
                throw new IllegalArgumentException("Min 0");
            }
            if (n == 0) {
                this.numLeft = BigInteger.ZERO;
                this.total = BigInteger.ZERO;
            } else {
                this.a = new int[n];
                this.total = this.getFactorial(n);
                this.reset();
            }
        }

        private void reset() {
            int i = 0;
            while (i < this.N) {
                this.a[i] = i;
                ++i;
            }
            this.numLeft = new BigInteger(this.total.toString());
        }

        private BigInteger getNumLeft() {
            return this.numLeft;
        }

        private BigInteger getTotal() {
            return this.total;
        }

        private boolean hasMore() {
            if (this.N == 0) {
                return false;
            }
            return this.numLeft.compareTo(BigInteger.ZERO) == 1;
        }

        private BigInteger getFactorial(int n) {
            if (n == 0) {
                return BigInteger.ONE;
            }
            BigInteger fact = BigInteger.ONE;
            int i = n;
            while (i > 1) {
                fact = fact.multiply(new BigInteger(Integer.toString(i)));
                --i;
            }
            return fact;
        }

        private int[] getNext() {
            if (this.N < 2 || !this.first_returned) {
                this.numLeft = this.numLeft.subtract(BigInteger.ONE);
                this.first_returned = true;
                return this.a;
            }
            int j = this.N - 2;
            while (this.a[j] > this.a[j + 1]) {
                --j;
            }
            int k = this.N - 1;
            while (this.a[j] > this.a[k]) {
                --k;
            }
            int temp = this.a[k];
            this.a[k] = this.a[j];
            this.a[j] = temp;
            int r = this.N - 1;
            int s = j + 1;
            while (r > s) {
                temp = this.a[s];
                this.a[s] = this.a[r];
                this.a[r] = temp;
                --r;
                ++s;
            }
            this.numLeft = this.numLeft.subtract(BigInteger.ONE);
            return this.a;
        }
    }
}

