/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.userInterface;

import hu.birot.OTKit.dataType.Form;
import hu.birot.OTKit.dataType.MapForm;
import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Gen;
import hu.birot.OTKit.otBuildingBlocks.Hierarchy;
import hu.birot.OTKit.uiMyElements.MyGen;
import hu.birot.OTKit.uiMyElements.MyHierarchy;
import hu.birot.OTKit.uiMyElements.Universe;
import hu.birot.OTKit.userInterface.FrameActionGrammatical;
import hu.birot.OTKit.userInterface.OTKFrame;
import hu.birot.OTKit.userInterface.OTKit;
import hu.birot.OTKit.userInterface.OTKit_GUI;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FrameActionFullLanguage
extends OTKFrame {
    private static final long serialVersionUID = 1L;
    Universe U;
    MyHierarchy hi = null;
    MyGen ba = null;
    MyGen ge = null;
    JLabel hier = new JLabel("");
    JLabel base = new JLabel("");
    JLabel gen = new JLabel("");
    JTextField nr_c = new JTextField("");
    JTextField nr_u = new JTextField("");
    static final String helpText = "This window computes a whole language, defined by a base, a Gen and a hierarchy.\n\nA 'base' (or 'lexicon') is a set of underlying forms: those that are mapped to the surface forms appearing in the language, while the map uses the Gen function and the hierarchy. The 'Richness of the Base' principle theoretically permits any form to appear in the base, but in practice a language only has a restricted vocabulary. What this window does is to compute all the grammatical (maximally harmonic) candidates corresponding to each element of the base.\n\nTechnically, a 'base' is a Gen from MyUniverse. The 'lexicon' of the language is the set to which it maps an empty form (in Java: a 'new Form()'). To be more precise, the surface forms of the candidates in the candidate set generated by this Gen become the 'base', the set of underlying forms in the language. The simplest solution is to create a Gen from a table listing all the underlying forms; but in any case it is recommended that you use a Gen mapping any form to the same candidate set.\n\nTwo fields serve to restrict the base and the Gen function. Left empty, they are not restricted, but if they contain an integer number, then only so many forms are generated. If the Gen used for the base has an infinite range, then you must restrict it before running the computation. Similarly, if the Gen function of the language maps underlying forms to an infinite candidate set, you also have to restrict the candidate set to be evaluated for the hierarchy. Moreover, if these ranges are finite but huge, then such a restriction is also recommended.\n";

    public FrameActionFullLanguage(Universe u) {
        super(490, 300, "Generate full language");
        this.U = u != null ? u : OTKit.MyUniverse;
        JPanel grid = new JPanel();
        grid.setLayout(new GridLayout(0, 2, 10, 10));
        this.background.add(grid);
        JButton addBa = new JButton("Base:");
        addBa.addActionListener(this);
        addBa.setActionCommand("add_ba");
        grid.add(addBa);
        grid.add(this.base);
        grid.add(new JLabel("Number of underlying forms:"));
        grid.add(this.nr_u);
        JButton addGen = new JButton("Gen:");
        addGen.addActionListener(this);
        addGen.setActionCommand("add_gen");
        grid.add(addGen);
        grid.add(this.gen);
        grid.add(new JLabel("Number of candidates:"));
        grid.add(this.nr_c);
        JButton addHier = new JButton("Hierarchy:");
        addHier.addActionListener(this);
        addHier.setActionCommand("add_hier");
        grid.add(addHier);
        grid.add(this.hier);
        JButton run = new JButton("Calculate whole language");
        run.addActionListener(this);
        run.setActionCommand("run");
        grid.add(run);
        grid.add(new JLabel());
        JButton help = new JButton("Help");
        help.addActionListener(this);
        help.setActionCommand("help");
        grid.add(help);
        JButton close = new JButton("Close");
        close.addActionListener(this);
        close.setActionCommand("close");
        grid.add(close);
        this.update();
    }

    private void update() {
        if (this.ba != null) {
            this.base.setText("\"" + this.ba.name() + "\"");
        }
        if (this.ge != null) {
            this.gen.setText(this.ge.name());
        }
        if (this.hi != null) {
            this.hier.setText(this.hi.name());
        }
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String what = e.getActionCommand();
        if (what.equals("close")) {
            this.processEvent(new WindowEvent(this, 201));
        } else if (what.equals("help")) {
            OTKit.help(helpText);
        } else if (what.equals("add_ba")) {
            Object[] possibleValues = this.U.MyGens.keySet().toArray();
            if (possibleValues.length == 0) {
                OTKit.warning("No Gen yet in " + this.U.name() + ".");
            } else {
                Object selectedValue = JOptionPane.showInputDialog(null, "Choose a Gen for the Base", "Base", 1, null, possibleValues, possibleValues[0]);
                if (selectedValue != null) {
                    this.ba = this.U.MyGens.get(selectedValue);
                }
            }
            this.update();
        } else if (what.equals("add_hier")) {
            Object[] possibleValues = this.U.MyHierarchies.keySet().toArray();
            if (possibleValues.length == 0) {
                OTKit.warning("No hierarchy yet in " + this.U.name() + ".");
            } else {
                Object selectedValue = JOptionPane.showInputDialog(null, "Choose a hierarchy", "Hierarchies", 1, null, possibleValues, possibleValues[0]);
                if (selectedValue != null) {
                    this.hi = this.U.MyHierarchies.get(selectedValue);
                }
            }
            this.update();
        } else if (what.equals("add_gen")) {
            Object[] possibleValues = this.U.MyGens.keySet().toArray();
            if (possibleValues.length == 0) {
                OTKit.warning("No Gen yet in " + this.U.name() + ".");
            } else {
                Object selectedValue = JOptionPane.showInputDialog(null, "Choose a Gen", "Gen functions", 1, null, possibleValues, possibleValues[0]);
                if (selectedValue != null) {
                    this.ge = this.U.MyGens.get(selectedValue);
                }
            }
            this.update();
        } else if (what.equals("run")) {
            Integer nuf = null;
            Integer nca = null;
            if (this.ba == null) {
                OTKit.error("Base not defined yet.");
            } else if (this.ge == null) {
                OTKit.error("Gen not defined yet.");
            } else if (this.hi == null) {
                OTKit.error("Hierarchy not defined yet.");
            } else {
                boolean error = false;
                if (this.nr_u.getText().trim().isEmpty()) {
                    nuf = null;
                } else {
                    try {
                        nuf = Integer.parseInt(this.nr_u.getText());
                    }
                    catch (NumberFormatException numFormExcpt) {
                        OTKit.error("Value in field \"Number of underlying forms\" must be an integer!");
                        error = true;
                    }
                }
                if (this.nr_c.getText().trim().isEmpty()) {
                    nca = null;
                } else {
                    try {
                        nca = Integer.parseInt(this.nr_c.getText());
                    }
                    catch (NumberFormatException numFormExcpt) {
                        OTKit.error("Value in field \"Number of candidates\" must be an integer!");
                        error = true;
                    }
                }
                if (!error) {
                    OTKit.return_out("\n Base: \"" + this.ba.name() + "\"\n Gen: " + this.ge.name() + "\n Hierarchy: " + this.hi.name() + "\n Language:");
                    OTKit.return_out(String.valueOf(FrameActionFullLanguage.full_language(this.ba.gen(this.U), nuf, this.ge.gen(this.U), nca, this.hi.hier(this.U))) + "\n");
                    String h = "full_language(" + this.ba.shortScript() + ", ";
                    if (nuf != null) {
                        h = String.valueOf(h) + nuf + ", ";
                    }
                    h = String.valueOf(h) + this.ge.shortScript() + ", ";
                    if (nca != null) {
                        h = String.valueOf(h) + nca + ", ";
                    }
                    h = String.valueOf(h) + this.hi.shortScript() + ")";
                    OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                    OTKit_GUI.printText("> " + h);
                }
            }
        }
    }

    public static String full_language(Gen base, Integer numb_uf, Gen gen, Integer numb_cand, Hierarchy h) {
        Vector<Object> b;
        block10: {
            int n;
            block8: {
                block9: {
                    b = new Vector<Candidate>();
                    if (numb_uf != null) break block8;
                    b = base.allCandidates(new Form());
                    if (!((Candidate)b.get((int)0)).sf.equals(MapForm.InfiniteSet)) break block9;
                    OTKit.return_err("Base " + base.name + " maps empty form to an infinite set.");
                    OTKit.error("Base " + base.name + " maps empty form to an infinite set.");
                    break block10;
                }
                if (!((Candidate)b.get((int)0)).sf.equals(MapForm.NoMapping)) break block10;
                OTKit.return_err("Base " + base.name + " maps empty form to no candidate.");
                OTKit.error("Base " + base.name + " maps empty form to no candidate.");
                break block10;
            }
            b.add(base.firstCandidate(new Form()));
            if (((Candidate)b.get((int)0)).sf.equals(MapForm.NoMapping)) {
                OTKit.return_err("Base " + base.name + " maps empty form to no candidate.");
                OTKit.error("Base " + base.name + " maps empty form to no candidate.");
            }
            boolean bl = true;
            while (n < numb_uf) {
                Candidate c = base.nextCandidate((Candidate)b.lastElement());
                if (c.sf.equals(MapForm.NoMoreForm)) {
                    n = numb_uf;
                } else {
                    b.add(c);
                }
                ++n;
            }
        }
        String out = "";
        if (numb_cand == null) {
            for (Candidate candidate : b) {
                out = String.valueOf(out) + "*** Underlying form = " + candidate.sf + "\n" + FrameActionGrammatical.grammatical_forms(candidate.sf, gen, h);
            }
        } else {
            for (Candidate candidate : b) {
                out = String.valueOf(out) + "*** Underlying form = " + candidate.sf + "\n" + FrameActionGrammatical.grammatical_forms(candidate.sf, gen, h, numb_cand);
            }
        }
        return out;
    }
}

