/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.userInterface;

import hu.birot.OTKit.dataType.MapForm;
import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Eval;
import hu.birot.OTKit.otBuildingBlocks.Gen;
import hu.birot.OTKit.otBuildingBlocks.Hierarchy;
import hu.birot.OTKit.uiMyElements.MyCandidate;
import hu.birot.OTKit.uiMyElements.MyGen;
import hu.birot.OTKit.uiMyElements.MyHierarchy;
import hu.birot.OTKit.uiMyElements.Universe;
import hu.birot.OTKit.userInterface.FrameDefineCandidate;
import hu.birot.OTKit.userInterface.OTKFrame;
import hu.birot.OTKit.userInterface.OTKit;
import hu.birot.OTKit.userInterface.OTKit_GUI;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FrameActionGrJudgm
extends OTKFrame {
    private static final long serialVersionUID = 1L;
    Universe U;
    MyHierarchy hi = null;
    MyCandidate ca = null;
    MyGen ge = null;
    JLabel hier = new JLabel("");
    JLabel cand = new JLabel("");
    JLabel gen = new JLabel("");
    JLabel judg = new JLabel("?");
    JTextField nr_c = new JTextField("");
    static final String newform = "New candidate from strings";
    static final String newform2 = "New candidate (open panel)";
    static final String helpText = "This window checks whether a candidate is grammatical (maximally harmonic) with respect to a given Gen function and a hierarchy. If the candidate set corresponding to the underlying form of the specified candidate is finite, then all candidates are compared to the specified one. Otherwise, you must restrict the number of candidates, which is also useful whenever the candidate set is finite but huge.\n\nFor more detailed information, please refer to the help of the \"grammatical outputs\" window.\n";

    public FrameActionGrJudgm(Universe u) {
        super(490, 300, "Grammatical judgment for a candidate, w.r.t. gen and hierarchy");
        this.U = u != null ? u : OTKit.MyUniverse;
        JPanel grid = new JPanel();
        grid.setLayout(new GridLayout(0, 2, 10, 10));
        this.background.add(grid);
        JButton addC = new JButton("Candidate:");
        addC.addActionListener(this);
        addC.setActionCommand("add_c");
        grid.add(addC);
        grid.add(this.cand);
        JButton addGen = new JButton("Gen:");
        addGen.addActionListener(this);
        addGen.setActionCommand("add_gen");
        grid.add(addGen);
        grid.add(this.gen);
        JButton addHier = new JButton("Hierarchy:");
        addHier.addActionListener(this);
        addHier.setActionCommand("add_hier");
        grid.add(addHier);
        grid.add(this.hier);
        grid.add(new JLabel("Number of candidates:"));
        grid.add(this.nr_c);
        JButton run = new JButton("Is grammatical?");
        run.addActionListener(this);
        run.setActionCommand("run");
        grid.add(run);
        grid.add(this.judg);
        JButton help = new JButton("Help");
        help.addActionListener(this);
        help.setActionCommand("help");
        grid.add(help);
        JButton close = new JButton("Close");
        close.addActionListener(this);
        close.setActionCommand("close");
        grid.add(close);
        this.update();
    }

    private void update() {
        if (this.ca != null) {
            this.cand.setText("\"" + this.ca.cand(this.U) + "\"");
        }
        if (this.ge != null) {
            this.gen.setText(this.ge.name());
        }
        if (this.hi != null) {
            this.hier.setText(this.hi.name());
        }
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String what = e.getActionCommand();
        if (what.equals("close")) {
            this.processEvent(new WindowEvent(this, 201));
        } else if (what.equals("help")) {
            OTKit.help(helpText);
        } else if (what.equals("add_c")) {
            Object[] pv = this.U.MyCandidates.keySet().toArray();
            Object[] possibleValues = new Object[pv.length + 1];
            possibleValues[0] = newform;
            int i = 0;
            while (i < pv.length) {
                possibleValues[i + 1] = pv[i];
                ++i;
            }
            if (possibleValues.length == 0) {
                OTKit.warning("No candidate yet in " + this.U.name() + ".");
            } else {
                Object selectedValue = JOptionPane.showInputDialog(null, "Choose a candidate", "Candidates", 1, null, possibleValues, possibleValues[0]);
                if (selectedValue != null) {
                    if (selectedValue.equals(newform)) {
                        String sf;
                        String uf = JOptionPane.showInputDialog(null, (Object)"String that will be contained by the new candidate's underlying form:");
                        if (uf != null && (sf = JOptionPane.showInputDialog(null, (Object)"String that will be contained by the new candidate's surface form:")) != null) {
                            this.ca = new MyCandidate(newform, "uf_and_sf_from_strings");
                            this.ca.params = new Vector();
                            this.ca.params.add(uf);
                            this.ca.params.add(sf);
                        }
                    } else if (selectedValue.equals(newform2)) {
                        FrameDefineCandidate frame = new FrameDefineCandidate(null);
                        this.ca = frame.myc;
                    } else {
                        this.ca = this.U.MyCandidates.get(selectedValue);
                    }
                }
            }
            this.update();
        } else if (what.equals("add_hier")) {
            Object[] possibleValues = this.U.MyHierarchies.keySet().toArray();
            if (possibleValues.length == 0) {
                OTKit.warning("No hierarchy yet in " + this.U.name() + ".");
            } else {
                Object selectedValue = JOptionPane.showInputDialog(null, "Choose a hierarchy", "Hierarchies", 1, null, possibleValues, possibleValues[0]);
                if (selectedValue != null) {
                    this.hi = this.U.MyHierarchies.get(selectedValue);
                }
            }
            this.update();
        } else if (what.equals("add_gen")) {
            Object[] possibleValues = this.U.MyGens.keySet().toArray();
            if (possibleValues.length == 0) {
                OTKit.warning("No Gen yet in " + this.U.name() + ".");
            } else {
                Object selectedValue = JOptionPane.showInputDialog(null, "Choose a Gen", "Gen functions", 1, null, possibleValues, possibleValues[0]);
                if (selectedValue != null) {
                    this.ge = this.U.MyGens.get(selectedValue);
                }
            }
            this.update();
        } else if (what.equals("run")) {
            if (this.ca == null) {
                OTKit.error("Candidate not defined yet.");
            } else if (this.ge == null) {
                OTKit.error("Gen not defined yet.");
            } else if (this.hi == null) {
                OTKit.error("Hierarchy not defined yet.");
            } else if (this.nr_c.getText().trim().isEmpty()) {
                this.judg.setText(String.valueOf(FrameActionGrJudgm.isGrammatical(this.ca.cand(this.U), this.ge.gen(this.U), this.hi.hier(this.U))) + "\n");
                String ca_script = this.ca.name().equals(newform) || this.ca.name().equals(newform2) ? this.ca.longScript() : this.ca.shortScript();
                String h = "is_grammatical(" + ca_script + ", " + this.ge.shortScript() + ", " + this.hi.shortScript() + ")";
                OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                OTKit_GUI.printText("> " + h);
            } else {
                try {
                    int nr = Integer.parseInt(this.nr_c.getText().trim());
                    this.judg.setText(String.valueOf(FrameActionGrJudgm.isGrammatical(this.ca.cand(this.U), this.ge.gen(this.U), this.hi.hier(this.U), nr)) + "\n");
                    String ca_script = this.ca.name().equals(newform) || this.ca.name().equals(newform2) ? this.ca.longScript() : this.ca.shortScript();
                    String h = "is_grammatical(" + ca_script + ", " + this.ge.shortScript() + ", " + this.hi.shortScript() + ", " + nr + ")";
                    OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                    OTKit_GUI.printText("> " + h);
                }
                catch (NumberFormatException numFormExcpt) {
                    OTKit.error("Value in field \"Number of candidates\" must be an integer!");
                }
            }
        }
    }

    public static String isGrammatical(Candidate ca, Gen gen, Hierarchy h) {
        String out = "";
        Vector<Candidate> allc = gen.allCandidates(ca.uf);
        if (allc.get((int)0).sf.equals(MapForm.InfiniteSet)) {
            OTKit.return_err("Gen " + gen.name + " maps underlying form " + ca.uf + " to an infinite set.");
            OTKit.error("Gen " + gen.name + " maps underlying form " + ca.uf + " to an infinite set.");
        } else if (allc.get((int)0).sf.equals(MapForm.NoMapping)) {
            OTKit.return_err("Gen " + gen.name + " maps underlying form " + ca.uf + " to no candidate.");
            OTKit.error("Gen " + gen.name + " maps underlying form " + ca.uf + " to no candidate.");
        } else {
            Vector<Object> C = new Vector();
            if (h.type.equalsIgnoreCase("ot")) {
                h.sortByRank();
                C = Eval.CompareOT(allc, h);
            } else if (h.type.equalsIgnoreCase("hg")) {
                C = Eval.CompareHG(allc, h);
            } else {
                OTKit.error("Type of hierarchy " + h.name + " is neither OT nor HG.");
            }
            out = C.contains(ca) ? "grammatical" : "ungrammatical";
        }
        return out;
    }

    public static String isGrammatical(Candidate ca, Gen gen, Hierarchy h, int number_candidates) {
        String out = "";
        Vector<Candidate> allc = new Vector<Candidate>();
        allc.add(gen.firstCandidate(ca.uf));
        if (((Candidate)allc.get((int)0)).sf.equals(MapForm.NoMapping)) {
            OTKit.return_err("Gen " + gen.name + " maps underlying form " + ca.uf + " to no candidate.");
            OTKit.error("Gen " + gen.name + " maps underlying form " + ca.uf + " to no candidate.");
            return "";
        }
        int i = 1;
        while (i < number_candidates) {
            Candidate c = gen.nextCandidate((Candidate)allc.lastElement());
            if (c.sf.equals(MapForm.NoMoreForm)) {
                i = number_candidates;
            } else {
                allc.add(c);
            }
            ++i;
        }
        Vector<Object> C = new Vector();
        if (h.type.equalsIgnoreCase("ot")) {
            h.sortByRank();
            C = Eval.CompareOT(allc, h);
        } else if (h.type.equalsIgnoreCase("hg")) {
            C = Eval.CompareHG(allc, h);
        } else {
            OTKit.error("Type of hierarchy " + h.name + " is neither OT nor HG.");
        }
        out = C.contains(ca) ? "grammatical" : "ungrammatical";
        return out;
    }
}

