/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.userInterface;

import hu.birot.OTKit.dataType.Form;
import hu.birot.OTKit.dataType.MapForm;
import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Constraint;
import hu.birot.OTKit.otBuildingBlocks.Eval;
import hu.birot.OTKit.otBuildingBlocks.Gen;
import hu.birot.OTKit.otBuildingBlocks.Hierarchy;
import hu.birot.OTKit.uiMyElements.MyForm;
import hu.birot.OTKit.uiMyElements.MyGen;
import hu.birot.OTKit.uiMyElements.MyHierarchy;
import hu.birot.OTKit.uiMyElements.Universe;
import hu.birot.OTKit.userInterface.FrameDefineForm;
import hu.birot.OTKit.userInterface.OTKFrame;
import hu.birot.OTKit.userInterface.OTKit;
import hu.birot.OTKit.userInterface.OTKit_GUI;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameActionGrammatical
extends OTKFrame {
    private static final long serialVersionUID = 1L;
    Universe U;
    MyHierarchy hi = null;
    MyForm uf = null;
    MyGen ge = null;
    JLabel hier = new JLabel("");
    JLabel undf = new JLabel("");
    JLabel gen = new JLabel("");
    JTextField nr_c = new JTextField("");
    static final String newform = "New form from string";
    static final String newform2 = "New form (open panel)";
    static final String helpText = "This window computes the grammatical candidate[s] (surface form[s]) corresponding to a certain underlying form, with respect to a Gen function and a hierarchy (grammar).\n\nHence, the underlying form, the Gen and the hierarchy must be specified. The corresponding buttons offer you the list of elements already present in MyUniverse, which therefore must be defined or loaded before running the grammaticality computations. Yet, to save you time, it is also possible to enter new (underlying) forms containing only a string.\n\nIf the set of candidates generated by the specified Gen from the specified underlying form is finite, then the best candidate(s) of the entire candidate set are returned. If the field \"number of candidates\" is left empty, then a comprehensive search is performed: every candidate is looked at.\n\nIf the candidate set is infinite, you should restrict the search space to a finite subset. In this case, fill a value in the field \"number of candidates\" to define how many of the first candidates will be considered. (Iteration is performed, using the \"first candidate\" and \"next candidate\" methods of the Gen.) It is also useful to restrict the number of candidates if the candidate set is finite but extremely large.\n\nPressing button \"calculate grammatical forms\" will only return the most harmonic candidate(s). Button \"draw tableau\" outputs the tableau, using the hand symbol pointing to the most harmonic candidate(s), as well as the column separator and end-of-row symbols, as defined among the options. All outputs are returned in the main panel.\n";

    public FrameActionGrammatical(Universe u) {
        super(490, 300, "Calculate grammatical candidates for underlying form, gen and hierarchy");
        this.U = u != null ? u : OTKit.MyUniverse;
        JPanel grid = new JPanel();
        grid.setLayout(new GridLayout(0, 2, 10, 10));
        this.background.add(grid);
        JButton addUf = new JButton("Underlying form:");
        addUf.addActionListener(this);
        addUf.setActionCommand("add_uf");
        grid.add(addUf);
        grid.add(this.undf);
        JButton addGen = new JButton("Gen:");
        addGen.addActionListener(this);
        addGen.setActionCommand("add_gen");
        grid.add(addGen);
        grid.add(this.gen);
        JButton addHier = new JButton("Hierarchy:");
        addHier.addActionListener(this);
        addHier.setActionCommand("add_hier");
        grid.add(addHier);
        grid.add(this.hier);
        grid.add(new JLabel("Number of candidates:"));
        grid.add(this.nr_c);
        JButton run = new JButton("Calculate grammatical forms");
        run.addActionListener(this);
        run.setActionCommand("run");
        grid.add(run);
        JButton tableau = new JButton("Draw tableau");
        tableau.addActionListener(this);
        tableau.setActionCommand("tableau");
        grid.add(tableau);
        JButton help = new JButton("Help");
        help.addActionListener(this);
        help.setActionCommand("help");
        grid.add(help);
        JButton close = new JButton("Close");
        close.addActionListener(this);
        close.setActionCommand("close");
        grid.add(close);
        this.update();
    }

    private void update() {
        if (this.uf != null) {
            this.undf.setText("\"" + this.uf.form(this.U) + "\"");
        }
        if (this.ge != null) {
            this.gen.setText(this.ge.name());
        }
        if (this.hi != null) {
            this.hier.setText(this.hi.name());
        }
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String what = e.getActionCommand();
        if (what.equals("close")) {
            this.processEvent(new WindowEvent(this, 201));
        } else if (what.equals("help")) {
            OTKit.help(helpText);
        } else if (what.equals("add_uf")) {
            Object[] pv = this.U.MyForms.keySet().toArray();
            Object[] possibleValues = new Object[pv.length + 1];
            possibleValues[0] = newform;
            int i = 0;
            while (i < pv.length) {
                possibleValues[i + 1] = pv[i];
                ++i;
            }
            if (possibleValues.length == 0) {
                OTKit.warning("No form yet in " + this.U.name() + ".");
            } else {
                Object selectedValue = JOptionPane.showInputDialog(null, "Choose an (underlying) form", "Forms", 1, null, possibleValues, possibleValues[0]);
                if (selectedValue != null) {
                    if (selectedValue.equals(newform)) {
                        String q = JOptionPane.showInputDialog(null, (Object)"String that will be contained by the new underlying form:");
                        if (q != null) {
                            this.uf = new MyForm(newform, "simple string");
                            this.uf.params = new Vector();
                            this.uf.params.add(q);
                        }
                    } else if (selectedValue.equals(newform2)) {
                        FrameDefineForm frame = new FrameDefineForm(null);
                        this.uf = frame.myf;
                    } else {
                        this.uf = this.U.MyForms.get(selectedValue);
                    }
                }
            }
            this.update();
        } else if (what.equals("add_hier")) {
            Object[] possibleValues = this.U.MyHierarchies.keySet().toArray();
            if (possibleValues.length == 0) {
                OTKit.warning("No hierarchy yet in " + this.U.name() + ".");
            } else {
                Object selectedValue = JOptionPane.showInputDialog(null, "Choose a hierarchy", "Hierarchies", 1, null, possibleValues, possibleValues[0]);
                if (selectedValue != null) {
                    this.hi = this.U.MyHierarchies.get(selectedValue);
                }
            }
            this.update();
        } else if (what.equals("add_gen")) {
            Object[] possibleValues = this.U.MyGens.keySet().toArray();
            if (possibleValues.length == 0) {
                OTKit.warning("No Gen yet in " + this.U.name() + ".");
            } else {
                Object selectedValue = JOptionPane.showInputDialog(null, "Choose a Gen", "Gen functions", 1, null, possibleValues, possibleValues[0]);
                if (selectedValue != null) {
                    this.ge = this.U.MyGens.get(selectedValue);
                }
            }
            this.update();
        } else if (what.equals("run")) {
            if (this.uf == null) {
                OTKit.error("Underlying form not defined yet.");
            } else if (this.ge == null) {
                OTKit.error("Gen not defined yet.");
            } else if (this.hi == null) {
                OTKit.error("Hierarchy not defined yet.");
            } else if (this.nr_c.getText().trim().isEmpty()) {
                OTKit.return_out("\n Underlying form: \"" + this.uf.form(this.U) + "\"\n Gen: " + this.ge.name() + "\n Hierarchy: " + this.hi.name() + "\n Best candidate(s):");
                OTKit.return_out(String.valueOf(FrameActionGrammatical.grammatical_forms(this.uf.form(this.U), this.ge.gen(this.U), this.hi.hier(this.U))) + "\n");
                String form_script = this.uf.name().equals(newform) || this.uf.name().equals(newform2) ? this.uf.longScript() : this.uf.shortScript();
                String h = "grammatical_outputs(" + form_script + ", " + this.ge.shortScript() + ", " + this.hi.shortScript() + ")";
                OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                OTKit_GUI.printText("> " + h);
            } else {
                try {
                    int nr = Integer.parseInt(this.nr_c.getText().trim());
                    OTKit.return_out("\n Underlying form: \"" + this.uf.form(this.U) + "\"\n Gen: " + this.ge.name() + "\n Hierarchy: " + this.hi.name() + "\n Best of the first " + nr + " candidate(s):");
                    OTKit.return_out(String.valueOf(FrameActionGrammatical.grammatical_forms(this.uf.form(this.U), this.ge.gen(this.U), this.hi.hier(this.U), nr)) + "\n");
                    String form_script = this.uf.name().equals(newform) || this.uf.name().equals(newform2) ? this.uf.longScript() : this.uf.shortScript();
                    String h = "grammatical_outputs(" + form_script + ", " + this.ge.shortScript() + ", " + this.hi.shortScript() + ", " + nr + ")";
                    OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                    OTKit_GUI.printText("> " + h);
                }
                catch (NumberFormatException numFormExcpt) {
                    OTKit.error("Value in field \"Number of candidates\" must be an integer!");
                }
            }
        } else if (what.equals("tableau")) {
            if (this.uf == null) {
                OTKit.error("Underlying form not defined yet.");
            } else if (this.ge == null) {
                OTKit.error("Gen not defined yet.");
            } else if (this.hi == null) {
                OTKit.error("Hierarchy not defined yet.");
            } else if (this.nr_c.getText().trim().isEmpty()) {
                OTKit.return_out("\n Underlying form: \"" + this.uf.form(this.U) + "\"\n Gen: " + this.ge.name() + "\n Hierarchy: " + this.hi.name() + "\n Tableau:");
                OTKit.return_out(String.valueOf(FrameActionGrammatical.drawTableau(this.uf.form(this.U), this.ge.gen(this.U), this.hi.hier(this.U))) + "\n");
                String form_script = this.uf.name().equals(newform) || this.uf.name().equals(newform2) ? this.uf.longScript() : this.uf.shortScript();
                String h = "draw_tableau(" + form_script + ", " + this.ge.shortScript() + ", " + this.hi.shortScript() + ")";
                OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                OTKit_GUI.printText("> " + h);
            } else {
                try {
                    int nr = Integer.parseInt(this.nr_c.getText().trim());
                    OTKit.return_out("\n Underlying form: \"" + this.uf.form(this.U) + "\"\n Gen: " + this.ge.name() + "\n Hierarchy: " + this.hi.name() + "\n Tableau for the first " + nr + " candidate(s):");
                    OTKit.return_out(String.valueOf(FrameActionGrammatical.drawTableau(this.uf.form(this.U), this.ge.gen(this.U), this.hi.hier(this.U), nr)) + "\n");
                    String form_script = this.uf.name().equals(newform) || this.uf.name().equals(newform2) ? this.uf.longScript() : this.uf.shortScript();
                    String h = "draw_tableau(" + form_script + ", " + this.ge.shortScript() + ", " + this.hi.shortScript() + ", " + nr + ")";
                    OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                    OTKit_GUI.printText("> " + h);
                }
                catch (NumberFormatException numFormExcpt) {
                    OTKit.error("Value in field \"Number of candidates\" must be an integer!");
                }
            }
        }
    }

    public static String grammatical_forms(Form uf, Gen gen, Hierarchy h) {
        String out = "";
        Vector<Candidate> allc = gen.allCandidates(uf);
        if (allc.get((int)0).sf.equals(MapForm.InfiniteSet)) {
            OTKit.return_err("Gen " + gen.name + " maps underlying form " + uf + " to an infinite set.");
            OTKit.error("Gen " + gen.name + " maps underlying form " + uf + " to an infinite set.");
        } else if (allc.get((int)0).sf.equals(MapForm.NoMapping)) {
            OTKit.return_err("Gen " + gen.name + " maps underlying form " + uf + " to no candidate.");
            OTKit.error("Gen " + gen.name + " maps underlying form " + uf + " to no candidate.");
        } else if (h.type.equalsIgnoreCase("ot")) {
            h.sortByRank();
            Vector<Candidate> C = Eval.CompareOT(allc, h);
            int i = 0;
            while (i < C.size()) {
                out = String.valueOf(out) + C.get(i).toString() + "\n";
                ++i;
            }
        } else if (h.type.equalsIgnoreCase("hg")) {
            Vector<Candidate> C = Eval.CompareHG(allc, h);
            int i = 0;
            while (i < C.size()) {
                out = String.valueOf(out) + C.get(i).toString() + "\n";
                ++i;
            }
        } else {
            OTKit.error("Type of hierarchy " + h.name + " is neither OT nor HG.");
        }
        return out;
    }

    public static String grammatical_forms(Form uf, Gen gen, Hierarchy h, int number_candidates) {
        String out = "";
        Vector<Candidate> allc = new Vector<Candidate>();
        allc.add(gen.firstCandidate(uf));
        if (((Candidate)allc.get((int)0)).sf.equals(MapForm.NoMapping)) {
            OTKit.return_err("Gen " + gen.name + " maps underlying form " + uf + " to no candidate.");
            OTKit.error("Gen " + gen.name + " maps underlying form " + uf + " to no candidate.");
            return "";
        }
        int i = 1;
        while (i < number_candidates) {
            Candidate c = gen.nextCandidate((Candidate)allc.lastElement());
            if (c.sf.equals(MapForm.NoMoreForm)) {
                i = number_candidates;
            } else {
                allc.add(c);
            }
            ++i;
        }
        if (h.type.equalsIgnoreCase("ot")) {
            h.sortByRank();
            Vector<Candidate> C = Eval.CompareOT(allc, h);
            int i2 = 0;
            while (i2 < C.size()) {
                out = String.valueOf(out) + C.get(i2).toString() + "\n";
                ++i2;
            }
        } else if (h.type.equalsIgnoreCase("hg")) {
            Vector<Candidate> C = Eval.CompareHG(allc, h);
            int i3 = 0;
            while (i3 < C.size()) {
                out = String.valueOf(out) + C.get(i3).toString() + "\n";
                ++i3;
            }
        } else {
            OTKit.error("Type of hierarchy " + h.name + " is neither OT nor HG.");
        }
        return out;
    }

    private static String drawTableau(Form uf, Gen gen, Hierarchy h, Vector<Candidate> allc) {
        String tableau = " /" + uf + "/  ";
        String rankingv = "";
        if (h.type.equalsIgnoreCase("ot")) {
            rankingv = "rank";
        } else if (h.type.equalsIgnoreCase("hg")) {
            rankingv = "weight";
        } else {
            OTKit.error("Type of hierarchy " + h.name + " is neither OT nor HG.");
            return "";
        }
        Constraint[] hier1 = h.sortBy(rankingv);
        Constraint[] hier = new Constraint[hier1.length];
        int i = 0;
        while (i < hier1.length) {
            hier[i] = hier1[hier1.length - 1 - i];
            ++i;
        }
        Object object = hier;
        int n = hier.length;
        int n2 = 0;
        while (n2 < n) {
            Constraint cons = object[n2];
            tableau = String.valueOf(tableau) + OTKit.separator + " " + cons.name() + " ";
            ++n2;
        }
        tableau = String.valueOf(tableau) + OTKit.end_of_row + "\n";
        tableau = String.valueOf(tableau) + " " + rankingv + " ";
        object = hier;
        n = hier.length;
        n2 = 0;
        while (n2 < n) {
            Constraint cons = object[n2];
            tableau = String.valueOf(tableau) + OTKit.separator + " " + h.get(cons.name(), rankingv) + " ";
            ++n2;
        }
        tableau = String.valueOf(tableau) + OTKit.end_of_row + "\n";
        tableau = String.valueOf(tableau) + "-------------------------------------------" + OTKit.end_of_row + "\n";
        if (allc.get((int)0).sf.equals(MapForm.InfiniteSet)) {
            OTKit.return_err("Gen " + gen.name + " maps underlying form " + uf + " to an infinite set.");
            OTKit.error("Gen " + gen.name + " maps underlying form " + uf + " to an infinite set.");
        } else if (allc.get((int)0).sf.equals(MapForm.NoMapping)) {
            OTKit.return_err("Gen " + gen.name + " maps underlying form " + uf + " to no candidate.");
            OTKit.error("Gen " + gen.name + " maps underlying form " + uf + " to no candidate.");
        } else {
            Vector<Candidate> C;
            if (h.type.equalsIgnoreCase("ot")) {
                h.sortByRank();
                C = Eval.CompareOT(allc, h);
            } else if (h.type.equalsIgnoreCase("hg")) {
                C = Eval.CompareHG(allc, h);
            } else {
                OTKit.return_err("Type of hierarchy " + h.name + " is neither OT nor HG.");
                C = new Vector();
            }
            for (Candidate c : allc) {
                Constraint fatal = null;
                if (C.contains(c)) {
                    tableau = String.valueOf(tableau) + OTKit.hand_symbol + " ";
                } else if (h.type.equalsIgnoreCase("ot")) {
                    fatal = Eval.CompareOT((Candidate)c, (Candidate)C.get((int)0), (Hierarchy)h).fatal;
                }
                tableau = String.valueOf(tableau) + c.toString() + " ";
                Constraint[] constraintArray = hier;
                int n3 = hier.length;
                int n4 = 0;
                while (n4 < n3) {
                    Constraint cons = constraintArray[n4];
                    tableau = String.valueOf(tableau) + OTKit.separator + " " + cons.value(c) + " ";
                    if (cons.equals(fatal)) {
                        tableau = String.valueOf(tableau) + OTKit.bang + " ";
                    }
                    ++n4;
                }
                if (h.type.equalsIgnoreCase("hg")) {
                    tableau = String.valueOf(tableau) + " " + OTKit.separator + " S = " + Eval.EvalHG(c, h);
                }
                tableau = String.valueOf(tableau) + " " + OTKit.end_of_row + "\n";
            }
        }
        return tableau;
    }

    public static String drawTableau(Form uf, Gen gen, Hierarchy h, int number_candidates) {
        Vector<Candidate> allc = new Vector<Candidate>();
        allc.add(gen.firstCandidate(uf));
        if (((Candidate)allc.get((int)0)).sf.equals(MapForm.NoMapping)) {
            OTKit.return_err("Gen " + gen.name + " maps underlying form " + uf + " to no candidate.");
            return "";
        }
        int i = 1;
        while (i < number_candidates) {
            Candidate c = gen.nextCandidate((Candidate)allc.lastElement());
            if (c.sf.equals(MapForm.NoMoreForm)) {
                i = number_candidates;
            } else {
                allc.add(c);
            }
            ++i;
        }
        return FrameActionGrammatical.drawTableau(uf, gen, h, allc);
    }

    public static String drawTableau(Form uf, Gen gen, Hierarchy h) {
        Vector<Candidate> allc = gen.allCandidates(uf);
        return FrameActionGrammatical.drawTableau(uf, gen, h, allc);
    }
}

