/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.userInterface;

import hu.birot.OTKit.otBuildingBlocks.Constraint;
import hu.birot.OTKit.uiMyElements.Universe;
import hu.birot.OTKit.userInterface.OTKFrame;
import hu.birot.OTKit.userInterface.OTKit;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class FrameActionTableau
extends OTKFrame {
    private static final long serialVersionUID = 1L;
    Universe U;
    JTextArea con = new JTextArea(7, 29);
    JTextArea cand = new JTextArea(7, 29);
    JTextArea viol = new JTextArea(18, 35);

    public FrameActionTableau(Universe u) {
        super(800, 420, "Tableau");
        this.U = u != null ? u : OTKit.MyUniverse;
        this.background.setLayout(new BoxLayout(this.background, 0));
        JPanel grid1 = new JPanel();
        grid1.setLayout(new GridLayout(0, 1, 10, 10));
        this.background.add(grid1);
        JPanel grid2 = new JPanel();
        grid2.setLayout(new FlowLayout(0));
        this.background.add(grid2);
        JButton addHier = new JButton("Constraints from hierarchy");
        addHier.addActionListener(this);
        addHier.setActionCommand("add_hier");
        JButton addCon = new JButton("Constraints:");
        addCon.addActionListener(this);
        addCon.setActionCommand("add_con");
        JPanel row1 = new JPanel();
        row1.setLayout(new FlowLayout(0));
        row1.setSize(100, 100);
        row1.add(addHier);
        row1.add(new JLabel(" or "));
        row1.add(addCon);
        grid1.add(row1);
        JScrollPane jScrollPane1 = new JScrollPane(this.con, 20, 30);
        row1.add(jScrollPane1);
        JButton addCand = new JButton("Candidates:");
        addCand.addActionListener(this);
        addCand.setActionCommand("add_cand");
        JPanel row3 = new JPanel();
        row3.setLayout(new FlowLayout(0));
        row3.setSize(100, 100);
        row3.add(addCand);
        grid1.add(row3);
        JScrollPane jScrollPane2 = new JScrollPane(this.cand, 20, 30);
        row3.add(jScrollPane2);
        this.viol.setLineWrap(false);
        grid2.add(new JLabel("Tableau (columns separated by " + OTKit.separator + "):"));
        JScrollPane jScrollPane3 = new JScrollPane(this.viol, 20, 30);
        grid2.add(jScrollPane3);
        JButton refresh = new JButton("Refresh");
        refresh.addActionListener(this);
        refresh.setActionCommand("refresh");
        grid2.add(refresh);
        JButton close = new JButton("Close");
        close.addActionListener(this);
        close.setActionCommand("close");
        grid2.add(close);
        this.update();
    }

    private void update() {
        String[] mco = this.con.getText().split("\n");
        String[] mca = this.cand.getText().split("\n");
        if (!this.con.getText().equals("") && !this.cand.getText().equals("")) {
            String tableau = "          ";
            String[] stringArray = mco;
            int n = mco.length;
            int n2 = 0;
            while (n2 < n) {
                String cons = stringArray[n2];
                if (!cons.trim().equals("")) {
                    tableau = String.valueOf(tableau) + OTKit.separator + " " + cons + " ";
                }
                ++n2;
            }
            tableau = String.valueOf(tableau) + OTKit.end_of_row + "\n";
            stringArray = mca;
            n = mca.length;
            n2 = 0;
            while (n2 < n) {
                String cand = stringArray[n2];
                if (!cand.trim().equals("")) {
                    tableau = String.valueOf(tableau) + cand + " ";
                    String[] stringArray2 = mco;
                    int n3 = mco.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String cons = stringArray2[n4];
                        if (!cons.trim().equals("")) {
                            tableau = String.valueOf(tableau) + OTKit.separator + " " + this.U.MyConstraints.get(cons.trim()).con(this.U).value(this.U.MyCandidates.get(cand.trim()).cand(this.U)) + " ";
                        }
                        ++n4;
                    }
                }
                tableau = String.valueOf(tableau) + OTKit.end_of_row + "\n";
                ++n2;
            }
            this.viol.setText(tableau);
        }
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String what = e.getActionCommand();
        if (what.equals("close")) {
            this.processEvent(new WindowEvent(this, 201));
        } else if (what.equals("refresh")) {
            this.update();
        } else if (what.equals("add_hier")) {
            Object[] possibleValues = this.U.MyHierarchies.keySet().toArray();
            if (possibleValues.length == 0) {
                OTKit.warning("No hierarchy yet in " + this.U.name() + ".");
            } else {
                Object selectedValue = JOptionPane.showInputDialog(null, "Choose a hierarchy", "Hierarchies", 1, null, possibleValues, possibleValues[0]);
                if (selectedValue != null) {
                    if (!this.con.getText().equals("")) {
                        this.con.setText(String.valueOf(this.con.getText()) + "\n");
                    }
                    Constraint[] cc = this.U.MyHierarchies.get(selectedValue).hier(this.U).sortByRank();
                    int i = cc.length - 1;
                    while (i > -1) {
                        this.con.setText(String.valueOf(this.con.getText()) + "\n" + cc[i].name());
                        --i;
                    }
                }
            }
            this.update();
        } else if (what.equals("add_con")) {
            Object[] possibleValues = this.U.MyConstraints.keySet().toArray();
            if (possibleValues.length == 0) {
                OTKit.warning("No constraint yet in " + this.U.name() + ".");
            } else {
                Object selectedValue = JOptionPane.showInputDialog(null, "Choose a constraint", "Constraints", 1, null, possibleValues, possibleValues[0]);
                if (selectedValue != null) {
                    if (!this.con.getText().equals("")) {
                        this.con.setText(String.valueOf(this.con.getText()) + "\n");
                    }
                    this.con.setText(String.valueOf(this.con.getText()) + this.U.MyConstraints.get(selectedValue).name());
                }
            }
            this.update();
        } else if (what.equals("add_cand")) {
            Object[] possibleValues = this.U.MyCandidates.keySet().toArray();
            if (possibleValues.length == 0) {
                OTKit.warning("No candidates yet in " + this.U.name() + ".");
            } else {
                Object selectedValue = JOptionPane.showInputDialog(null, "Choose a candidate", "Candidates", 1, null, possibleValues, possibleValues[0]);
                if (selectedValue != null) {
                    if (!this.cand.getText().equals("")) {
                        this.cand.setText(String.valueOf(this.cand.getText()) + "\n");
                    }
                    this.cand.setText(String.valueOf(this.cand.getText()) + this.U.MyCandidates.get(selectedValue).name());
                }
            }
            this.update();
        }
    }
}

