/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.userInterface;

import hu.birot.OTKit.uiMyElements.MyCandidate;
import hu.birot.OTKit.uiMyElements.Scheme_cand;
import hu.birot.OTKit.uiMyElements.Universe;
import hu.birot.OTKit.userInterface.FrameOrganizeUniverse;
import hu.birot.OTKit.userInterface.OTKFrame;
import hu.birot.OTKit.userInterface.OTKit;
import hu.birot.OTKit.userInterface.OTKit_GUI;
import hu.birot.OTKit.userInterface.XMLstuff;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FrameDefineCandidate
extends OTKFrame {
    private static final long serialVersionUID = 1L;
    public MyCandidate myc;
    protected JComboBox CandSchemeTypes = new JComboBox();
    protected JComboBox CandSchemes = new JComboBox();
    protected JComboBox existingCand = new JComboBox();
    protected JPanel Params = new JPanel();
    protected Vector<JLabel> ParamLabel = new Vector();
    protected Vector<JTextField> ParamValue = new Vector();
    protected JTextField scheme = new JTextField();
    protected JTextField name = new JTextField();
    protected JTextArea Description = new JTextArea();
    protected HashMap<String, MyCandidate> name2mc = new HashMap();
    static final String selectAllCandidates = "All candidates";
    protected static MyCandidate empty_mc = new MyCandidate("", "");
    public static final String helpText = "How to define a new candidate?\n\nIn OTKit, a candidate consists of\n  1. a name;\n  2. forms: a surface form, optionally an underlying form, other forms or a chain;\n\nThe third column in this field defines the name and the form(s). Remember that the name is the unique identifier of a candidate: if you give a name that already exists, then the earlier candidate with that name will be deleted from MyUniverse, and moved temporarily to TrashUniverse.\n\nTo define the forms, you need a scheme together with one or more parameters. Schemes typically determine two factors: first, how many forms the candidate contain, and second, how those forms are determined. A candidate can contain a single form, the surface form (that is, the underlying form is uninteresting or trivial); or of more forms: an underlying form-surface form pair, a chain of surface forms, an underlying form-surface form-auditory form-articulatory form quatruplet (cf. Paul Boersma's model), etc.\n\nThe forms within the candidate can also be determined in several ways. Some schemes see their parameters as mere strings. In other cases, the parameters are seen as the names of Forms that should be present (loaded, defined) in MyUniverse.\n\nThe leftmost column contains a list of available schemes; choose one of them and fill in the parameters in the third column. Explanation of the schemes appears in the second column. By choosing a \"scheme type\", you can restrict the list of schemes.\n\nIn the first column you will also find two other ways to start creating a new candidate: you can load the specifications of a candidate already available either in MyUniverse or in some file. Do not forget to give the new candidate a new name, unless you want to rewrite the old one. Moreover, saving an old candidate under a new name and then deleting the old one in \"organize MyUniverse\" is the way to rename a candidate. \n\nPressing the Apply button tests if the candidate can be created, and also suggests a name. Once you have checked the values in the third column, press a button in the rightmost one, either to add the candidate just created to MyUniverse, or to save it to file. Both employ the current values of the fields in the third column. Closing the window without saving the candidate (to file or to MyUniverse) results in losing it.\n\n";

    public FrameDefineCandidate(MyCandidate mc) {
        super(900, 350, "Define a new candidate");
        this.myc = mc == null ? empty_mc : mc;
        this.existingCand.addItem("");
        for (String name : OTKit.MyUniverse.MyCandidates.keySet()) {
            MyCandidate c = OTKit.MyUniverse.MyCandidates.get(name);
            this.existingCand.addItem(c.name());
            this.name2mc.put(c.name(), c);
        }
        this.CandSchemeTypes.setEditable(false);
        this.CandSchemeTypes.addItem(selectAllCandidates);
        int i = 0;
        while (i < Scheme_cand.Scheme_types.length) {
            this.CandSchemeTypes.addItem(Scheme_cand.Scheme_types[i]);
            ++i;
        }
        this.CandSchemes.setEditable(false);
        this.CandSchemes.addItem("");
        this.CandSchemes.setSelectedItem("");
        i = 0;
        while (i < Scheme_cand.S.length) {
            this.CandSchemes.addItem(Scheme_cand.S[i].name);
            ++i;
        }
        this.CandSchemes.setLayout(new FlowLayout());
        this.update();
        this.background.setLayout(new GridLayout(1, 4, 10, 20));
        JPanel panel1 = new JPanel();
        JPanel panel2 = new JPanel();
        JPanel panel3 = new JPanel();
        JPanel panel4 = new JPanel();
        this.background.add(panel1);
        this.background.add(panel2);
        this.background.add(panel3);
        this.background.add(panel4);
        panel1.setLayout(new GridLayout(0, 1, 10, 1));
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel3.setLayout(new BoxLayout(panel3, 1));
        panel4.setLayout(new GridLayout(0, 1, 10, 1));
        panel3.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        JButton toFile = new JButton("Open file");
        this.existingCand.setActionCommand("existingCand");
        toFile.setActionCommand("fromFile");
        this.CandSchemeTypes.setActionCommand("candSchemeTypes");
        this.CandSchemes.setActionCommand("cand_scheme");
        this.existingCand.addActionListener(this);
        toFile.addActionListener(this);
        this.CandSchemeTypes.addActionListener(this);
        this.CandSchemes.addActionListener(this);
        panel1.add(new JLabel("Candidate scheme types:", 2));
        panel1.add(this.CandSchemeTypes);
        panel1.add(new JLabel(" "));
        panel1.add(new JLabel("Candidate schemes:", 2));
        panel1.add(this.CandSchemes);
        panel1.add(new JLabel(" "));
        panel1.add(new JLabel("Candidates in MyUniverse:", 2));
        panel1.add(this.existingCand);
        panel1.add(new JLabel(" "));
        panel1.add(new JLabel("Load from file:", 2));
        panel1.add(toFile);
        panel1.add(new JLabel(" "));
        panel2.add(new JLabel(" "));
        panel2.add(new JLabel("Description os scheme:", 2));
        JScrollPane jScrollPane2 = new JScrollPane(this.Description);
        panel2.add(jScrollPane2);
        this.Description.setColumns(20);
        this.Description.setRows(8);
        this.Description.setLineWrap(true);
        this.Description.setWrapStyleWord(true);
        panel2.add(new JLabel(" "));
        panel3.add(new JLabel("Name of the candidate:", 0));
        this.name.setMaximumSize(new Dimension(400, 30));
        panel3.add(this.name);
        panel3.add(new JLabel(" "));
        panel3.add(new JLabel("Scheme used:", 2));
        panel3.add(this.scheme);
        this.scheme.setEditable(false);
        this.scheme.setMaximumSize(new Dimension(400, 30));
        panel3.add(new JLabel(" "));
        panel3.add(new JLabel("Parameter(s) of the candidate: ", 2));
        panel3.add(new JLabel(" "));
        this.Params.setLayout(new GridLayout(0, 2));
        panel3.add(this.Params);
        panel3.add(new JLabel(" "));
        JButton apply = new JButton("Apply");
        panel4.add(new JLabel(" "));
        panel4.add(apply);
        apply.setActionCommand("apply");
        apply.addActionListener(this);
        JButton add_uni = new JButton("Add to MyUniverse");
        JButton save = new JButton("Save to File");
        JButton close = new JButton("Close window");
        JButton getHelp = new JButton("Get help");
        add_uni.setActionCommand("add_to_universe");
        save.setActionCommand("save");
        close.setActionCommand("close");
        getHelp.setActionCommand("getHelp");
        add_uni.addActionListener(this);
        save.addActionListener(this);
        close.addActionListener(this);
        getHelp.addActionListener(this);
        panel4.add(new JLabel(" "));
        panel4.add(add_uni);
        panel4.add(new JLabel(" "));
        panel4.add(save);
        panel4.add(new JLabel(" "));
        panel4.add(close);
        panel4.add(new JLabel(" "));
        panel4.add(getHelp);
        this.setVisible(true);
    }

    public void update() {
        this.name.setText(this.myc.name());
        this.scheme.setText(this.myc.scheme());
        if (!this.myc.scheme().equals("")) {
            this.Description.setText(Scheme_cand.name2scheme.get((Object)this.myc.scheme()).description);
        }
        this.Params.removeAll();
        this.ParamLabel.clear();
        this.ParamValue.clear();
        if (!this.myc.scheme().equals("")) {
            if (Scheme_cand.name2scheme.get(this.myc.scheme()) == null) {
                OTKit.error("Candidate scheme '" + this.myc.scheme() + "' does not exists!");
                this.scheme.setText("");
            } else {
                int i = 0;
                while (i < Scheme_cand.name2scheme.get((Object)this.myc.scheme()).nr_param) {
                    this.ParamLabel.add(new JLabel("Param " + (i + 1)));
                    JTextField jt = new JTextField(this.myc.params.get(i));
                    this.ParamValue.add(jt);
                    this.Params.add(this.ParamLabel.get(i));
                    this.Params.add(this.ParamValue.get(i));
                    ++i;
                }
                i = 0;
                while (i < 5 - Scheme_cand.name2scheme.get((Object)this.myc.scheme()).nr_param) {
                    this.Params.add(new JLabel(" "));
                    this.Params.add(new JLabel(" "));
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < 3) {
                this.Params.add(new JLabel(" "));
                this.Params.add(new JLabel(" "));
                ++i;
            }
        }
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String what = e.getActionCommand();
        if (what.equals("getHelp")) {
            OTKit.help(helpText);
        } else if (what.equals("existingCand")) {
            this.myc = this.name2mc.get(this.existingCand.getSelectedItem());
            if (this.myc != null) {
                this.update();
            }
        } else if (what.equals("fromFile")) {
            String[] str = OTKit_GUI.readFile("Load file", XMLstuff.xmlfilter);
            if (str[4] == null && str[5] == null && str[6] == null) {
                Universe U = new Universe("Universe " + str[1]);
                U.fromXML(XMLstuff.string2xml(str[0]));
                FrameOrganizeUniverse org_univ = new FrameOrganizeUniverse(U);
                org_univ.tag_type = "my_candidate";
                org_univ.target = this;
                org_univ.refreshList();
            }
        } else if (what.equals("candSchemeTypes")) {
            this.Params.removeAll();
            if (this.CandSchemeTypes.getSelectedItem().equals(selectAllCandidates)) {
                int i = 0;
                while (i < Scheme_cand.S.length) {
                    this.CandSchemes.removeItem(Scheme_cand.S[i].name);
                    this.CandSchemes.addItem(Scheme_cand.S[i].name);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < Scheme_cand.S.length) {
                    this.CandSchemes.removeItem(Scheme_cand.S[i].name);
                    if (this.CandSchemeTypes.getSelectedItem().toString().equals(Scheme_cand.S[i].type)) {
                        this.CandSchemes.addItem(Scheme_cand.S[i].name);
                    }
                    ++i;
                }
            }
        } else if (what.equals("cand_scheme")) {
            String sel = this.CandSchemes.getSelectedItem().toString();
            if (sel.equals("")) {
                this.myc = empty_mc;
            } else {
                Scheme_cand.Candidate_scheme cs = Scheme_cand.name2scheme.get(sel);
                this.myc = new MyCandidate("", cs.name);
                this.myc.params = new Vector();
                int i = 0;
                while (i < cs.nr_param) {
                    this.myc.params.add("");
                    ++i;
                }
            }
            this.update();
        } else if (what.equals("apply")) {
            Scheme_cand.Candidate_scheme cs = Scheme_cand.name2scheme.get(this.scheme.getText());
            if (cs != null) {
                String cname = cs.name;
                this.myc = new MyCandidate(cname, cs.name);
                this.myc.params = new Vector();
                int i = 0;
                while (i < cs.nr_param) {
                    this.myc.params.add(this.ParamValue.get(i).getText());
                    ++i;
                }
                this.myc = new MyCandidate(this.myc.cand(OTKit.MyUniverse).toString(), cs.name);
                i = 0;
                while (i < cs.nr_param) {
                    this.myc.params.add(this.ParamValue.get(i).getText());
                    ++i;
                }
                this.update();
            }
        } else if (what.equals("add_to_universe")) {
            if (this.myc.scheme().equals("")) {
                OTKit.error("Candidate scheme is empty! Specify a proper scheme.");
                OTKit_GUI.printText("Error in creating candidate. No scheme specified. Not added to MyUniverse.");
            } else if (this.name.getText().trim().equals("")) {
                OTKit.error("Candidate name is empty or white space! Specify a name.");
                OTKit_GUI.printText("Error in creating candidate. Not added to MyUniverse.");
            } else {
                this.myc = new MyCandidate(this.name.getText().trim(), this.scheme.getText());
                this.myc.params = new Vector();
                int i = 0;
                while (i < Scheme_cand.name2scheme.get((Object)this.myc.scheme()).nr_param) {
                    this.myc.params.add(this.ParamValue.get(i).getText());
                    ++i;
                }
                if (this.myc.cand(OTKit.MyUniverse) == Scheme_cand.error) {
                    OTKit_GUI.printText("Error in creating candidate.");
                } else {
                    String name = this.myc.name();
                    if (OTKit.MyUniverse.MyCandidates.keySet().contains(name)) {
                        MyCandidate old = OTKit.MyUniverse.MyCandidates.get(name);
                        MyCandidate toTrash = new MyCandidate(String.valueOf(name) + ":old", old.scheme());
                        toTrash.params = old.params;
                        OTKit.TrashUniverse.MyCandidates.put(name, toTrash);
                        OTKit.MyUniverse.MyCandidates.remove(name);
                        OTKit.error("Candidate with name " + name + " already existed in MyUniverse.\n Earlier one moved to Trash Universe.");
                        OTKit.return_err("Candidate with name " + name + " already existed in MyUniverse.\n Earlier one moved to Trash Universe.");
                    }
                    OTKit.MyUniverse.MyCandidates.put(name, this.myc);
                    this.existingCand.removeItem(name);
                    this.existingCand.addItem(name);
                    this.name2mc.put(name, this.myc);
                    OTKit_GUI.printText("Candidate '" + name + "' added to MyUniverse.");
                    String h = "add2MyUniverse( " + this.myc.longScript() + " )";
                    OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                    OTKit_GUI.printText("> " + h);
                }
            }
        } else if (what.equals("save")) {
            if (this.myc.scheme().equals("")) {
                OTKit.error("Candidate scheme is empty! Specify a proper scheme.");
                OTKit_GUI.printText("Error in creating candidate. No scheme specified. Not saved.");
            } else if (this.name.getText().trim().equals("")) {
                OTKit.error("Candidate name is empty or white space! Specify a name.");
                OTKit_GUI.printText("Error in creating candidate. Not saved.");
            } else {
                this.myc = new MyCandidate(this.name.getText().trim(), this.scheme.getText());
                this.myc.params = new Vector();
                int i = 0;
                while (i < Scheme_cand.name2scheme.get((Object)this.myc.scheme()).nr_param) {
                    this.myc.params.add(this.ParamValue.get(i).getText());
                    ++i;
                }
                if (this.myc.cand(OTKit.MyUniverse) == Scheme_cand.error) {
                    OTKit_GUI.printText("Error in creating candidate. Not saved.");
                } else {
                    Universe U = new Universe("single candidate");
                    U.MyCandidates.put(this.myc.name(), this.myc);
                    String f = OTKit_GUI.printToFile(XMLstuff.xml2string(U.toXML()), "Save candidate", XMLstuff.xmlfilter);
                    if (f != null) {
                        OTKit_GUI.printText("Candidate successfully saved to file.");
                        String h = "save( \"" + f.replace('\\', '/') + "\", " + this.myc.longScript() + " )";
                        OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                        OTKit_GUI.printText("> " + h);
                    }
                }
            }
        } else if (what.equals("close")) {
            this.processEvent(new WindowEvent(this, 201));
        }
    }
}

