/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.userInterface;

import hu.birot.OTKit.uiMyElements.MyConstraint;
import hu.birot.OTKit.uiMyElements.Scheme_constr;
import hu.birot.OTKit.uiMyElements.Universe;
import hu.birot.OTKit.userInterface.FrameOrganizeUniverse;
import hu.birot.OTKit.userInterface.OTKFrame;
import hu.birot.OTKit.userInterface.OTKit;
import hu.birot.OTKit.userInterface.OTKit_GUI;
import hu.birot.OTKit.userInterface.XMLstuff;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FrameDefineConstr
extends OTKFrame {
    private static final long serialVersionUID = 1L;
    public MyConstraint myc;
    protected JComboBox ConstrSchemeTypes = new JComboBox();
    protected JComboBox ConstrSchemes = new JComboBox();
    protected JComboBox existingConstr = new JComboBox();
    protected JPanel Params = new JPanel();
    protected Vector<JLabel> ParamLabel = new Vector();
    protected Vector<JTextField> ParamValue = new Vector();
    protected JTextField scheme = new JTextField();
    protected JTextField name = new JTextField();
    protected JTextArea shortDescription = new JTextArea();
    protected JTextArea longDescription = new JTextArea();
    protected HashMap<String, MyConstraint> name2mc = new HashMap();
    static final String selectAllConstraints = "All constraints";
    protected static MyConstraint empty_mc = new MyConstraint();
    public static final String helpText = "How to define a new constraint?\n\nIn OTKit, a constraint consists of\n  1. a name;\n  2. a function assigning a number of violation marks to a candidate;\n  3. optionally, of a short description and of a long description.\n\nThe second column in this field defines the name and the function. OTKit will suggest a constraint name mirroring the function, which you can then change. Remember that the name is the unique identifier of a constraint: if you give a name that already exists, then the earlier constraint with that name will be deleted from MyUniverse, and moved temporarily to TrashUniverse.\n\nTo define a function, you need a scheme together with (zero or more) parameters. For instance, \"no P1\" (that is, *P1) is a scheme, and if parameter P1 is specified as the string \"a\", then you obtain a constraint assigning one violation mark to each occurrences of \"a\" in the surface form.\n\nThe leftmost column contains a list of available schemes; choose one of them and fill in the parameters in the second column. Explanation of the constraints/schemes appears in the third column. Note that the descriptions are for human readers only, and they do not affect the behaviour of OTKit in any way. By pressing the Apply button, the name and the descriptions are updated, while an error message appears if the parameters are not correctly filled in. By choosing a \"scheme type\", you can restrict the list of schemes to, say, constraints working on strings or constraints combining other constraints (constraint arithmetic).\n\nIn the first column you will also find two other ways to start creating a new constraint: you can load the specifications of a constraint already available either in MyUniverse or in some file. Do not forget to give the new constraint a new name, unless you want to change the behaviour of an old one. Moreover, saving an old constraint under a new name and then deleting the old one in \"organize MyUniverse\" is the way to rename a constraint. \n\nOnce you have checked the values in the two middle columns, press a button in the rightmost one, either to add the constraint just created to MyUniverse, or to save it to file. Both employ the current values of the fields in the two middle columns. Closing the window without saving the constraint (to file or to MyUniverse) results in losing it.\n\n";

    public FrameDefineConstr(MyConstraint mc) {
        super(1000, 300, "Define a new constraint");
        this.myc = mc == null ? empty_mc : mc;
        this.existingConstr.addItem("");
        for (String name : OTKit.MyUniverse.MyConstraints.keySet()) {
            MyConstraint c = OTKit.MyUniverse.MyConstraints.get(name);
            this.existingConstr.addItem(c.name());
            this.name2mc.put(c.name(), c);
        }
        this.ConstrSchemeTypes.setEditable(false);
        this.ConstrSchemeTypes.addItem(selectAllConstraints);
        int i = 0;
        while (i < Scheme_constr.Scheme_types.length) {
            this.ConstrSchemeTypes.addItem(Scheme_constr.Scheme_types[i]);
            ++i;
        }
        this.ConstrSchemes.setEditable(false);
        this.ConstrSchemes.addItem("");
        this.ConstrSchemes.setSelectedItem("");
        i = 0;
        while (i < Scheme_constr.S.length) {
            this.ConstrSchemes.addItem(Scheme_constr.S[i].name);
            ++i;
        }
        this.ConstrSchemes.setLayout(new FlowLayout());
        this.update();
        this.background.setLayout(new GridLayout(1, 4, 10, 20));
        JPanel panel1 = new JPanel();
        JPanel panel2 = new JPanel();
        JPanel panel3 = new JPanel();
        JPanel panel4 = new JPanel();
        this.background.add(panel1);
        this.background.add(panel2);
        this.background.add(panel3);
        this.background.add(panel4);
        panel1.setLayout(new GridLayout(0, 1, 10, 1));
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel3.setLayout(new BoxLayout(panel3, 1));
        panel4.setLayout(new GridLayout(0, 1, 10, 1));
        panel2.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        panel3.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        JButton toFile = new JButton("Open file");
        this.existingConstr.setActionCommand("existingConstr");
        toFile.setActionCommand("fromFile");
        this.ConstrSchemeTypes.setActionCommand("constSchemeTypes");
        this.ConstrSchemes.setActionCommand("constr_scheme");
        this.existingConstr.addActionListener(this);
        toFile.addActionListener(this);
        this.ConstrSchemeTypes.addActionListener(this);
        this.ConstrSchemes.addActionListener(this);
        panel1.add(new JLabel("Constraint scheme types:"));
        panel1.add(this.ConstrSchemeTypes);
        panel1.add(new JLabel(" "));
        panel1.add(new JLabel("Constraint schemes:"));
        panel1.add(this.ConstrSchemes);
        panel1.add(new JLabel(" "));
        panel1.add(new JLabel("Constraints in MyUniverse:"));
        panel1.add(this.existingConstr);
        panel1.add(new JLabel(" "));
        panel1.add(new JLabel("Load from file:"));
        panel1.add(toFile);
        panel1.add(new JLabel(" "));
        panel2.add(new JLabel("Name of the constraint:", 2));
        panel2.add(this.name);
        panel2.add(new JLabel("Scheme used:", 2));
        panel2.add(new JLabel(" "));
        panel2.add(this.scheme);
        this.scheme.setEditable(false);
        panel2.add(new JLabel("Parameter(s) of the constraint: ", 2));
        panel2.add(new JLabel(" "));
        this.Params.setLayout(new GridLayout(0, 2));
        panel2.add(this.Params);
        panel2.add(new JLabel(" "));
        JButton apply = new JButton("Apply");
        panel2.add(apply);
        panel2.add(new JLabel(" "));
        apply.setActionCommand("apply");
        apply.addActionListener(this);
        panel3.add(new JLabel("Short description:", 2));
        JScrollPane jScrollPane1 = new JScrollPane(this.shortDescription);
        panel3.add(jScrollPane1);
        this.shortDescription.setColumns(20);
        this.shortDescription.setRows(2);
        this.shortDescription.setLineWrap(true);
        this.shortDescription.setWrapStyleWord(true);
        panel3.add(new JLabel(" "));
        panel3.add(new JLabel("Long description:", 2));
        JScrollPane jScrollPane2 = new JScrollPane(this.longDescription);
        panel3.add(jScrollPane2);
        this.longDescription.setColumns(20);
        this.longDescription.setRows(8);
        this.longDescription.setLineWrap(true);
        this.longDescription.setWrapStyleWord(true);
        panel3.add(new JLabel(" "));
        JButton add_uni = new JButton("Add to MyUniverse");
        JButton save = new JButton("Save to File");
        JButton close = new JButton("Close window");
        JButton getHelp = new JButton("Get help");
        add_uni.setActionCommand("add_to_universe");
        save.setActionCommand("save");
        close.setActionCommand("close");
        getHelp.setActionCommand("getHelp");
        add_uni.addActionListener(this);
        save.addActionListener(this);
        close.addActionListener(this);
        getHelp.addActionListener(this);
        panel4.add(new JLabel(" "));
        panel4.add(add_uni);
        panel4.add(new JLabel(" "));
        panel4.add(save);
        panel4.add(new JLabel(" "));
        panel4.add(close);
        panel4.add(new JLabel(" "));
        panel4.add(getHelp);
        panel4.add(new JLabel(" "));
        this.setVisible(true);
    }

    public void update() {
        this.name.setText(this.myc.name());
        this.scheme.setText(this.myc.scheme);
        this.shortDescription.setText(this.myc.short_descr);
        this.longDescription.setText(this.myc.long_descr);
        this.Params.removeAll();
        this.ParamLabel.clear();
        this.ParamValue.clear();
        if (!this.myc.scheme.equals("")) {
            if (Scheme_constr.name2scheme.get(this.myc.scheme) == null) {
                OTKit.error("Constraint scheme '" + this.myc.scheme + "' does not exists!");
                this.scheme.setText("");
            } else {
                int i = 0;
                while (i < Scheme_constr.name2scheme.get((Object)this.myc.scheme).nr_param) {
                    this.ParamLabel.add(new JLabel("Param " + (i + 1)));
                    this.ParamValue.add(new JTextField(this.myc.params.get(i)));
                    this.Params.add(this.ParamLabel.get(i));
                    this.Params.add(this.ParamValue.get(i));
                    ++i;
                }
                i = 0;
                while (i < 3 - Scheme_constr.name2scheme.get((Object)this.myc.scheme).nr_param) {
                    this.Params.add(new JLabel(" "));
                    this.Params.add(new JLabel(" "));
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < 3) {
                this.Params.add(new JLabel(" "));
                this.Params.add(new JLabel(" "));
                ++i;
            }
        }
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String what = e.getActionCommand();
        if (what.equals("getHelp")) {
            OTKit.help(helpText);
        } else if (what.equals("existingConstr")) {
            this.myc = this.name2mc.get(this.existingConstr.getSelectedItem());
            if (this.myc != null) {
                this.update();
            }
        } else if (what.equals("fromFile")) {
            String[] str = OTKit_GUI.readFile("Load file", XMLstuff.xmlfilter);
            if (str[4] == null && str[5] == null && str[6] == null) {
                Universe U = new Universe("Universe " + str[1]);
                U.fromXML(XMLstuff.string2xml(str[0]));
                FrameOrganizeUniverse org_univ = new FrameOrganizeUniverse(U);
                org_univ.tag_type = "my_constraint";
                org_univ.target = this;
                org_univ.refreshList();
            }
        } else if (what.equals("constSchemeTypes")) {
            this.Params.removeAll();
            if (this.ConstrSchemeTypes.getSelectedItem().equals(selectAllConstraints)) {
                int i = 0;
                while (i < Scheme_constr.S.length) {
                    this.ConstrSchemes.removeItem(Scheme_constr.S[i].name);
                    this.ConstrSchemes.addItem(Scheme_constr.S[i].name);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < Scheme_constr.S.length) {
                    this.ConstrSchemes.removeItem(Scheme_constr.S[i].name);
                    if (this.ConstrSchemeTypes.getSelectedItem().toString().equals(Scheme_constr.S[i].type)) {
                        this.ConstrSchemes.addItem(Scheme_constr.S[i].name);
                    }
                    ++i;
                }
            }
        } else if (what.equals("constr_scheme")) {
            String sel = this.ConstrSchemes.getSelectedItem().toString();
            if (sel.equals("")) {
                this.myc = empty_mc;
            } else {
                Scheme_constr.Constraint_scheme cs = Scheme_constr.name2scheme.get(sel);
                this.myc = new MyConstraint();
                this.myc.scheme = cs.name;
                this.myc.short_descr = cs.short_descr;
                this.myc.long_descr = cs.long_descr;
                this.myc.params = new Vector();
                int i = 0;
                while (i < cs.nr_param) {
                    this.myc.params.add("");
                    ++i;
                }
            }
            this.update();
        } else if (what.equals("apply")) {
            Scheme_constr.Constraint_scheme cs = Scheme_constr.name2scheme.get(this.scheme.getText());
            if (cs != null) {
                String cname = cs.name;
                String shortd = cs.short_descr;
                String longd = cs.long_descr;
                int i = 0;
                while (i < cs.nr_param) {
                    cname = cname.replaceAll("P" + (i + 1), this.ParamValue.get(i).getText());
                    shortd = shortd.replaceAll("P" + (i + 1), this.ParamValue.get(i).getText());
                    longd = longd.replaceAll("P" + (i + 1), this.ParamValue.get(i).getText());
                    ++i;
                }
                this.myc = new MyConstraint();
                this.myc.scheme = cs.name;
                this.myc.short_descr = shortd;
                this.myc.long_descr = longd;
                this.myc.params = new Vector();
                i = 0;
                while (i < cs.nr_param) {
                    this.myc.params.add(this.ParamValue.get(i).getText());
                    ++i;
                }
                this.myc.name = cname;
                this.myc.con(OTKit.MyUniverse);
                this.update();
            }
        } else if (what.equals("add_to_universe")) {
            this.myc = new MyConstraint();
            this.myc.scheme = this.scheme.getText();
            if (this.myc.scheme.equals("")) {
                OTKit.error("Constraint scheme is empty! Specify a proper scheme.");
                OTKit_GUI.printText("Error in creating constraint. No scheme specified. Not added to MyUniverse.");
            } else if (this.name.getText().trim().equals("")) {
                OTKit.error("Constraint name is empty or white space! Specify a name.");
                OTKit_GUI.printText("Error in creating constraint. Not added to MyUniverse.");
            } else {
                this.myc.short_descr = this.shortDescription.getText();
                this.myc.long_descr = this.longDescription.getText();
                this.myc.params = new Vector();
                int i = 0;
                while (i < Scheme_constr.name2scheme.get((Object)this.myc.scheme).nr_param) {
                    this.myc.params.add(this.ParamValue.get(i).getText());
                    ++i;
                }
                this.myc.name = this.name.getText().trim();
                if (this.myc.con(OTKit.MyUniverse) == Scheme_constr.error) {
                    OTKit_GUI.printText("Error in creating constraint.");
                } else {
                    String name = this.myc.name();
                    if (OTKit.MyUniverse.MyConstraints.keySet().contains(name)) {
                        MyConstraint old = OTKit.MyUniverse.MyConstraints.get(name);
                        MyConstraint toTrash = new MyConstraint();
                        toTrash.name = String.valueOf(name) + ":old";
                        toTrash.scheme = old.scheme;
                        toTrash.params = old.params;
                        toTrash.short_descr = old.short_descr;
                        toTrash.long_descr = old.long_descr;
                        OTKit.TrashUniverse.MyConstraints.put(name, toTrash);
                        OTKit.MyUniverse.MyConstraints.remove(name);
                        OTKit.error("Constraint with name " + name + " already existed in MyUniverse.\n Earlier one moved to Trash Universe.");
                        OTKit.return_err("Constraint with name " + name + " already existed in MyUniverse.\n Earlier one moved to Trash Universe.");
                    }
                    OTKit.MyUniverse.MyConstraints.put(name, this.myc);
                    this.existingConstr.removeItem(name);
                    this.existingConstr.addItem(name);
                    this.name2mc.put(name, this.myc);
                    OTKit_GUI.printText("Constraint '" + name + "' added to MyUniverse.");
                    String h = "add2MyUniverse( " + this.myc.longScript() + " )";
                    OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                    OTKit_GUI.printText("> " + h);
                }
            }
        } else if (what.equals("save")) {
            this.myc = new MyConstraint();
            this.myc.scheme = this.scheme.getText();
            if (this.myc.scheme.equals("")) {
                OTKit.error("Constraint scheme is empty! Specify a proper scheme.");
                OTKit_GUI.printText("Error in creating constraint. No scheme specified. Not saved.");
            } else if (this.name.getText().trim().equals("")) {
                OTKit.error("Constraint name is empty or white space! Specify a name.");
                OTKit_GUI.printText("Error in creating constraint. Not saved.");
            } else {
                this.myc.short_descr = this.shortDescription.getText();
                this.myc.long_descr = this.longDescription.getText();
                this.myc.params = new Vector();
                int i = 0;
                while (i < Scheme_constr.name2scheme.get((Object)this.myc.scheme).nr_param) {
                    this.myc.params.add(this.ParamValue.get(i).getText());
                    ++i;
                }
                this.myc.name = this.name.getText().trim();
                if (this.myc.con(OTKit.MyUniverse) == Scheme_constr.error) {
                    OTKit_GUI.printText("Error in creating constraint. Not saved.");
                } else {
                    Universe U = new Universe("single constraint");
                    U.MyConstraints.put(this.myc.name(), this.myc);
                    String f = OTKit_GUI.printToFile(XMLstuff.xml2string(U.toXML()), "Save constraint", XMLstuff.xmlfilter);
                    if (f != null) {
                        OTKit_GUI.printText("Constraint successfully saved to file.");
                        String h = "save( \"" + f.replace('\\', '/') + "\", " + this.myc.longScript() + " )";
                        OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                        OTKit_GUI.printText("> " + h);
                    }
                }
            }
        } else if (what.equals("close")) {
            this.processEvent(new WindowEvent(this, 201));
        }
    }
}

