/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.userInterface;

import hu.birot.OTKit.uiMyElements.MyForm;
import hu.birot.OTKit.uiMyElements.Scheme_form;
import hu.birot.OTKit.uiMyElements.Universe;
import hu.birot.OTKit.userInterface.FrameOrganizeUniverse;
import hu.birot.OTKit.userInterface.OTKFrame;
import hu.birot.OTKit.userInterface.OTKit;
import hu.birot.OTKit.userInterface.OTKit_GUI;
import hu.birot.OTKit.userInterface.XMLstuff;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FrameDefineForm
extends OTKFrame {
    private static final long serialVersionUID = 1L;
    public MyForm myf;
    protected JComboBox FormSchemeTypes = new JComboBox();
    protected JComboBox FormSchemes = new JComboBox();
    protected JComboBox existingForm = new JComboBox();
    protected JPanel Params = new JPanel();
    protected Vector<JLabel> ParamLabel = new Vector();
    protected Vector<JTextField> ParamValue = new Vector();
    protected JTextField scheme = new JTextField();
    protected JTextField name = new JTextField();
    protected JTextArea Description = new JTextArea();
    protected HashMap<String, MyForm> name2mf = new HashMap();
    static final String selectAllForms = "All forms";
    protected static MyForm empty_mf = new MyForm("", "");
    public static final String helpText = "How to define a new form?\n\nIn OTKit, a form consists of\n  1. a name;\n  2. a \"content\": anything, such as a string, a counter, a tree, etc.\n\nThe third column in this field defines the name and the content. Remember that the name is the unique identifier of a form: if you give a name that already exists, then the earlier form with that name will be deleted from MyUniverse, and moved temporarily to TrashUniverse.\n\nTo define the content, you need to use a scheme together with one or more parameters. By filling the values of the parameter(s), you specify exactly what strings, counters, trees, etc. make up the form.\n\nThe leftmost column contains a list of available schemes; choose one of them and fill in the parameter(s) in the third column. Explanation of the scheme appears in the second column. By choosing a \"scheme type\", you can restrict the list of schemes.\n\nIn the first column you will also find two other ways to start creating a new form: you can load the specifications of a form already available either in MyUniverse or in some file. Do not forget to give the new form a new name, unless you want to redefine the old one. Moreover, saving an old form under a new name and then deleting the old one in \"organize MyUniverse\" is the way to rename a form. \n\nPressing the Apply button tests if the form can be created, and also suggests a name. Once you have checked the values in the third column, press a button in the rightmost one, either to add the form just created to MyUniverse, or to save it to file. Both employ the current values of the fields in the third column. Closing the window without saving the form (to file or to MyUniverse) results in losing it.\n\n";

    public FrameDefineForm(MyForm mf) {
        super(1050, 380, "Define a new form");
        this.myf = mf == null ? empty_mf : mf;
        this.existingForm.addItem("");
        for (String name : OTKit.MyUniverse.MyForms.keySet()) {
            MyForm f = OTKit.MyUniverse.MyForms.get(name);
            this.existingForm.addItem(f.name());
            this.name2mf.put(f.name(), f);
        }
        this.FormSchemeTypes.setEditable(false);
        this.FormSchemeTypes.addItem(selectAllForms);
        int i = 0;
        while (i < Scheme_form.Scheme_types.length) {
            this.FormSchemeTypes.addItem(Scheme_form.Scheme_types[i]);
            ++i;
        }
        this.FormSchemes.setEditable(false);
        this.FormSchemes.addItem("");
        this.FormSchemes.setSelectedItem("");
        i = 0;
        while (i < Scheme_form.S.length) {
            this.FormSchemes.addItem(Scheme_form.S[i].name);
            ++i;
        }
        this.FormSchemes.setLayout(new FlowLayout());
        this.update();
        this.background.setLayout(new GridLayout(1, 4, 10, 20));
        JPanel panel1 = new JPanel();
        JPanel panel2 = new JPanel();
        JPanel panel3 = new JPanel();
        JPanel panel4 = new JPanel();
        this.background.add(panel1);
        this.background.add(panel2);
        this.background.add(panel3);
        this.background.add(panel4);
        panel1.setLayout(new GridLayout(0, 1, 10, 1));
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel3.setLayout(new BoxLayout(panel3, 1));
        panel4.setLayout(new GridLayout(0, 1, 10, 1));
        panel3.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        JButton toFile = new JButton("Open file");
        this.existingForm.setActionCommand("existingForm");
        toFile.setActionCommand("fromFile");
        this.FormSchemeTypes.setActionCommand("formSchemeTypes");
        this.FormSchemes.setActionCommand("form_scheme");
        this.existingForm.addActionListener(this);
        toFile.addActionListener(this);
        this.FormSchemeTypes.addActionListener(this);
        this.FormSchemes.addActionListener(this);
        panel1.add(new JLabel("Form scheme types:"));
        panel1.add(this.FormSchemeTypes);
        panel1.add(new JLabel(" "));
        panel1.add(new JLabel("Form schemes:"));
        panel1.add(this.FormSchemes);
        panel1.add(new JLabel(" "));
        panel1.add(new JLabel("Forms in MyUniverse:"));
        panel1.add(this.existingForm);
        panel1.add(new JLabel(" "));
        panel1.add(new JLabel("Load from file:"));
        panel1.add(toFile);
        panel1.add(new JLabel(" "));
        panel2.add(new JLabel(" "));
        panel2.add(new JLabel("Description os scheme:", 2));
        JScrollPane jScrollPane2 = new JScrollPane(this.Description);
        panel2.add(jScrollPane2);
        this.Description.setColumns(20);
        this.Description.setRows(8);
        this.Description.setLineWrap(true);
        this.Description.setWrapStyleWord(true);
        panel2.add(new JLabel(" "));
        panel3.add(new JLabel("Name of the form:", 2));
        this.name.setMaximumSize(new Dimension(400, 30));
        panel3.add(this.name);
        panel3.add(new JLabel(" "));
        panel3.add(new JLabel("Scheme used:", 2));
        this.scheme.setMaximumSize(new Dimension(400, 30));
        this.scheme.setEditable(false);
        panel3.add(this.scheme);
        panel3.add(new JLabel(" "));
        panel3.add(new JLabel("Parameter(s) of the form: ", 2));
        panel3.add(new JLabel(" "));
        this.Params.setLayout(new GridLayout(0, 2));
        panel3.add(this.Params);
        panel3.add(new JLabel(" "));
        JButton apply = new JButton("Apply");
        panel4.add(new JLabel(" "));
        panel4.add(apply);
        apply.setActionCommand("apply");
        apply.addActionListener(this);
        JButton add_uni = new JButton("Add to MyUniverse");
        JButton save = new JButton("Save to File");
        JButton close = new JButton("Close window");
        JButton getHelp = new JButton("Get help");
        add_uni.setActionCommand("add_to_universe");
        save.setActionCommand("save");
        close.setActionCommand("close");
        getHelp.setActionCommand("getHelp");
        add_uni.addActionListener(this);
        save.addActionListener(this);
        close.addActionListener(this);
        getHelp.addActionListener(this);
        panel4.add(new JLabel(" "));
        panel4.add(add_uni);
        panel4.add(new JLabel(" "));
        panel4.add(save);
        panel4.add(new JLabel(" "));
        panel4.add(close);
        panel4.add(new JLabel(" "));
        panel4.add(getHelp);
        this.setVisible(true);
    }

    public void update() {
        this.name.setText(this.myf.name());
        this.scheme.setText(this.myf.scheme());
        if (!this.myf.scheme().equals("")) {
            this.Description.setText(Scheme_form.name2scheme.get((Object)this.myf.scheme()).description);
        }
        this.Params.removeAll();
        this.ParamLabel.clear();
        this.ParamValue.clear();
        if (!this.myf.scheme().equals("")) {
            if (Scheme_form.name2scheme.get(this.myf.scheme()) == null) {
                OTKit.error("Form scheme '" + this.myf.scheme() + "' does not exists!");
                this.scheme.setText("");
            } else {
                int i = 0;
                while (i < Scheme_form.name2scheme.get((Object)this.myf.scheme()).nr_param) {
                    this.ParamLabel.add(new JLabel("Param " + (i + 1)));
                    this.ParamValue.add(new JTextField(this.myf.params.get(i)));
                    this.Params.add(this.ParamLabel.get(i));
                    this.Params.add(this.ParamValue.get(i));
                    ++i;
                }
                i = 0;
                while (i < 5 - Scheme_form.name2scheme.get((Object)this.myf.scheme()).nr_param) {
                    this.Params.add(new JLabel(" "));
                    this.Params.add(new JLabel(" "));
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < 3) {
                this.Params.add(new JLabel(" "));
                this.Params.add(new JLabel(" "));
                ++i;
            }
        }
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String what = e.getActionCommand();
        if (what.equals("getHelp")) {
            OTKit.help(helpText);
        } else if (what.equals("existingForm")) {
            this.myf = this.name2mf.get(this.existingForm.getSelectedItem());
            if (this.myf != null) {
                this.update();
            }
        } else if (what.equals("fromFile")) {
            String[] str = OTKit_GUI.readFile("Load file", XMLstuff.xmlfilter);
            if (str[4] == null && str[5] == null && str[6] == null) {
                Universe U = new Universe("Universe " + str[1]);
                U.fromXML(XMLstuff.string2xml(str[0]));
                FrameOrganizeUniverse org_univ = new FrameOrganizeUniverse(U);
                org_univ.tag_type = "my_form";
                org_univ.target = this;
                org_univ.refreshList();
            }
        } else if (what.equals("formSchemeTypes")) {
            this.Params.removeAll();
            if (this.FormSchemeTypes.getSelectedItem().equals(selectAllForms)) {
                int i = 0;
                while (i < Scheme_form.S.length) {
                    this.FormSchemes.removeItem(Scheme_form.S[i].name);
                    this.FormSchemes.addItem(Scheme_form.S[i].name);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < Scheme_form.S.length) {
                    this.FormSchemes.removeItem(Scheme_form.S[i].name);
                    if (this.FormSchemeTypes.getSelectedItem().toString().equals(Scheme_form.S[i].type)) {
                        this.FormSchemes.addItem(Scheme_form.S[i].name);
                    }
                    ++i;
                }
            }
        } else if (what.equals("form_scheme")) {
            String sel = this.FormSchemes.getSelectedItem().toString();
            if (sel.equals("")) {
                this.myf = empty_mf;
            } else {
                Scheme_form.Form_scheme cs = Scheme_form.name2scheme.get(sel);
                this.myf = new MyForm("", cs.name);
                this.myf.params = new Vector();
                int i = 0;
                while (i < cs.nr_param) {
                    this.myf.params.add("");
                    ++i;
                }
            }
            this.update();
        } else if (what.equals("apply")) {
            Scheme_form.Form_scheme cs = Scheme_form.name2scheme.get(this.scheme.getText());
            if (cs != null) {
                String cname = cs.name;
                this.myf = new MyForm(cname, cs.name);
                this.myf.params = new Vector();
                int i = 0;
                while (i < cs.nr_param) {
                    this.myf.params.add(this.ParamValue.get(i).getText());
                    ++i;
                }
                this.myf = new MyForm(this.myf.form(OTKit.MyUniverse).toString(), cs.name);
                i = 0;
                while (i < cs.nr_param) {
                    this.myf.params.add(this.ParamValue.get(i).getText());
                    ++i;
                }
                this.update();
            }
        } else if (what.equals("add_to_universe")) {
            if (this.myf.scheme().equals("")) {
                OTKit.error("Form scheme is empty! Specify a proper scheme.");
                OTKit_GUI.printText("Error in creating form. No scheme specified. Not added to MyUniverse.");
            } else if (this.name.getText().trim().equals("")) {
                OTKit.error("Form name is empty or white space! Specify a name.");
                OTKit_GUI.printText("Error in creating form. Not added to MyUniverse.");
            } else {
                this.myf = new MyForm(this.name.getText().trim(), this.scheme.getText());
                this.myf.params = new Vector();
                int i = 0;
                while (i < Scheme_form.name2scheme.get((Object)this.myf.scheme()).nr_param) {
                    this.myf.params.add(this.ParamValue.get(i).getText());
                    ++i;
                }
                if (this.myf.form(OTKit.MyUniverse) == Scheme_form.error) {
                    OTKit_GUI.printText("Error in creating form.");
                } else {
                    String name = this.myf.name();
                    if (OTKit.MyUniverse.MyForms.keySet().contains(name)) {
                        MyForm old = OTKit.MyUniverse.MyForms.get(name);
                        MyForm toTrash = new MyForm(String.valueOf(name) + ":old", old.scheme());
                        toTrash.params = old.params;
                        OTKit.TrashUniverse.MyForms.put(name, toTrash);
                        OTKit.MyUniverse.MyForms.remove(name);
                        OTKit.error("Form with name " + name + " already existed in MyUniverse.\n Earlier one moved to Trash Universe.");
                        OTKit.return_err("Form with name " + name + " already existed in MyUniverse.\n Earlier one moved to Trash Universe.");
                    }
                    OTKit.MyUniverse.MyForms.put(name, this.myf);
                    this.existingForm.removeItem(name);
                    this.existingForm.addItem(name);
                    this.name2mf.put(name, this.myf);
                    OTKit_GUI.printText("Form '" + name + "' added to MyUniverse.");
                    String h = "add2MyUniverse( " + this.myf.longScript() + " )";
                    OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                    OTKit_GUI.printText("> " + h);
                }
            }
        } else if (what.equals("save")) {
            if (this.myf.scheme().equals("")) {
                OTKit.error("Form scheme is empty! Specify a proper scheme.");
                OTKit_GUI.printText("Error in creating form. No scheme specified. Not saved.");
            } else if (this.name.getText().trim().equals("")) {
                OTKit.error("Form name is empty or white space! Specify a name.");
                OTKit_GUI.printText("Error in creating form. Not saved.");
            } else {
                this.myf = new MyForm(this.name.getText().trim(), this.scheme.getText());
                this.myf.params = new Vector();
                int i = 0;
                while (i < Scheme_form.name2scheme.get((Object)this.myf.scheme()).nr_param) {
                    this.myf.params.add(this.ParamValue.get(i).getText());
                    ++i;
                }
                if (this.myf.form(OTKit.MyUniverse) == Scheme_form.error) {
                    OTKit_GUI.printText("Error in creating form. Not saved.");
                } else {
                    Universe U = new Universe("single form");
                    U.MyForms.put(this.myf.name(), this.myf);
                    String f = OTKit_GUI.printToFile(XMLstuff.xml2string(U.toXML()), "Save form", XMLstuff.xmlfilter);
                    if (f != null) {
                        OTKit_GUI.printText("Form successfully saved to file.");
                        String h = "save( \"" + f.replace('\\', '/') + "\", " + this.myf.longScript() + " )";
                        OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                        OTKit_GUI.printText("> " + h);
                    }
                }
            }
        } else if (what.equals("close")) {
            this.processEvent(new WindowEvent(this, 201));
        }
    }
}

