/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.userInterface;

import hu.birot.OTKit.uiMyElements.MyGen;
import hu.birot.OTKit.uiMyElements.Scheme_gen;
import hu.birot.OTKit.uiMyElements.Universe;
import hu.birot.OTKit.userInterface.FrameOrganizeUniverse;
import hu.birot.OTKit.userInterface.OTKFrame;
import hu.birot.OTKit.userInterface.OTKit;
import hu.birot.OTKit.userInterface.OTKit_GUI;
import hu.birot.OTKit.userInterface.XMLstuff;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FrameDefineGen
extends OTKFrame {
    private static final long serialVersionUID = 1L;
    public MyGen my;
    protected JComboBox FormSchemeTypes = new JComboBox();
    protected JComboBox FormSchemes = new JComboBox();
    protected JComboBox existingForm = new JComboBox();
    protected JPanel Params = new JPanel();
    protected Vector<JLabel> ParamLabel = new Vector();
    protected Vector<JTextField> ParamValue = new Vector();
    protected JTextField scheme = new JTextField();
    protected JTextField name = new JTextField();
    protected JTextArea Description = new JTextArea();
    protected HashMap<String, MyGen> name2mf = new HashMap();
    static final String selectAllForms = "All gens";
    protected static MyGen empty_mg = new MyGen("", "");
    public static final String helpText = "How to define a new Gen?\n\nIn OTKit, a Gen consists of\n  1. a name;\n  2. the Gen function, purely spoken.\n\nThe name is the unique identifier of the Gen. If you save Gen with a name that belongs already to a Gen in MyUniverse, the earlier one will be overwritten (and moved temporarily to TrashUniverse.)\nThe function can be defined by choosing one of the schemes (grouped into scheme types) on the left edge of the panel. Having chosen one, you can read its description in the second column. Alternatively, you can load a previously defined Gen from MyUniverse or from a file.\nBelow the field where you have to specify the name, you will eventually find further field(s) to specify the parameters of the scheme. For example, a scheme may need a table (see \"Table\" in the \"Define\" menu of the main OTKit panel), whose name will be specified as a parameter of the scheme. For more specifications, please read the descriptions of the schemes.\nAfter having specified a scheme and the value of its parameter(s), click on \"Apply\" to check whether the scheme can be made into a Gen. If it works, a name will be proposed, which you probably will rewrite.\nOnce done, double check the name, the scheme and the value(s) of the parameter(s). Then, you can save the freshly defined Gen to MyUniverse or to a file, using the corresponding buttons. Without it, closing the window will result in losing the outcome of your efforts.";

    public FrameDefineGen(MyGen mg) {
        super(1050, 380, "Define a new Gen");
        this.my = mg == null ? empty_mg : mg;
        this.existingForm.addItem("");
        for (String name : OTKit.MyUniverse.MyGens.keySet()) {
            MyGen f = OTKit.MyUniverse.MyGens.get(name);
            this.existingForm.addItem(f.name());
            this.name2mf.put(f.name(), f);
        }
        this.FormSchemeTypes.setEditable(false);
        this.FormSchemeTypes.addItem(selectAllForms);
        int i = 0;
        while (i < Scheme_gen.Scheme_types.length) {
            this.FormSchemeTypes.addItem(Scheme_gen.Scheme_types[i]);
            ++i;
        }
        this.FormSchemes.setEditable(false);
        this.FormSchemes.addItem("");
        this.FormSchemes.setSelectedItem("");
        i = 0;
        while (i < Scheme_gen.S.length) {
            this.FormSchemes.addItem(Scheme_gen.S[i].name);
            ++i;
        }
        this.FormSchemes.setLayout(new FlowLayout());
        this.update();
        this.background.setLayout(new GridLayout(1, 4, 10, 20));
        JPanel panel1 = new JPanel();
        JPanel panel2 = new JPanel();
        JPanel panel3 = new JPanel();
        JPanel panel4 = new JPanel();
        this.background.add(panel1);
        this.background.add(panel2);
        this.background.add(panel3);
        this.background.add(panel4);
        panel1.setLayout(new GridLayout(0, 1, 10, 1));
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel3.setLayout(new BoxLayout(panel3, 1));
        panel4.setLayout(new GridLayout(0, 1, 10, 1));
        panel3.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        JButton toFile = new JButton("Open file");
        this.existingForm.setActionCommand("existingForm");
        toFile.setActionCommand("fromFile");
        this.FormSchemeTypes.setActionCommand("formSchemeTypes");
        this.FormSchemes.setActionCommand("form_scheme");
        this.existingForm.addActionListener(this);
        toFile.addActionListener(this);
        this.FormSchemeTypes.addActionListener(this);
        this.FormSchemes.addActionListener(this);
        panel1.add(new JLabel("Gen scheme types:"));
        panel1.add(this.FormSchemeTypes);
        panel1.add(new JLabel(" "));
        panel1.add(new JLabel("Gen schemes:"));
        panel1.add(this.FormSchemes);
        panel1.add(new JLabel(" "));
        panel1.add(new JLabel("Gens in MyUniverse:"));
        panel1.add(this.existingForm);
        panel1.add(new JLabel(" "));
        panel1.add(new JLabel("Load from file:"));
        panel1.add(toFile);
        panel1.add(new JLabel(" "));
        panel2.add(new JLabel(" "));
        panel2.add(new JLabel("Description os scheme:", 2));
        JScrollPane jScrollPane2 = new JScrollPane(this.Description);
        panel2.add(jScrollPane2);
        this.Description.setColumns(20);
        this.Description.setRows(8);
        this.Description.setLineWrap(true);
        this.Description.setWrapStyleWord(true);
        panel2.add(new JLabel(" "));
        panel3.add(new JLabel("Name of the Gen:", 2));
        this.name.setMaximumSize(new Dimension(400, 30));
        panel3.add(this.name);
        panel3.add(new JLabel(" "));
        panel3.add(new JLabel("Scheme used:", 2));
        this.scheme.setMaximumSize(new Dimension(400, 30));
        this.scheme.setEditable(false);
        panel3.add(this.scheme);
        panel3.add(new JLabel(" "));
        panel3.add(new JLabel("Parameter(s) of the scheme: ", 2));
        panel3.add(new JLabel(" "));
        this.Params.setLayout(new GridLayout(0, 2));
        panel3.add(this.Params);
        panel3.add(new JLabel(" "));
        JButton apply = new JButton("Apply");
        panel4.add(new JLabel(" "));
        panel4.add(apply);
        apply.setActionCommand("apply");
        apply.addActionListener(this);
        JButton add_uni = new JButton("Add to MyUniverse");
        JButton save = new JButton("Save to File");
        JButton close = new JButton("Close window");
        JButton getHelp = new JButton("Get help");
        add_uni.setActionCommand("add_to_universe");
        save.setActionCommand("save");
        close.setActionCommand("close");
        getHelp.setActionCommand("getHelp");
        add_uni.addActionListener(this);
        save.addActionListener(this);
        close.addActionListener(this);
        getHelp.addActionListener(this);
        panel4.add(new JLabel(" "));
        panel4.add(add_uni);
        panel4.add(new JLabel(" "));
        panel4.add(save);
        panel4.add(new JLabel(" "));
        panel4.add(close);
        panel4.add(new JLabel(" "));
        panel4.add(getHelp);
        this.setVisible(true);
    }

    public void update() {
        this.name.setText(this.my.name());
        this.scheme.setText(this.my.scheme());
        if (!this.my.scheme().equals("")) {
            this.Description.setText(Scheme_gen.name2scheme.get((Object)this.my.scheme()).description);
        }
        this.Params.removeAll();
        this.ParamLabel.clear();
        this.ParamValue.clear();
        if (!this.my.scheme().equals("")) {
            if (Scheme_gen.name2scheme.get(this.my.scheme()) == null) {
                OTKit.error("Gen scheme '" + this.my.scheme() + "' does not exists!");
                this.scheme.setText("");
            } else {
                int i = 0;
                while (i < Scheme_gen.name2scheme.get((Object)this.my.scheme()).nr_param) {
                    this.ParamLabel.add(new JLabel("Param " + (i + 1)));
                    this.ParamValue.add(new JTextField(this.my.params.get(i)));
                    this.Params.add(this.ParamLabel.get(i));
                    this.Params.add(this.ParamValue.get(i));
                    ++i;
                }
                i = 0;
                while (i < 5 - Scheme_gen.name2scheme.get((Object)this.my.scheme()).nr_param) {
                    this.Params.add(new JLabel(" "));
                    this.Params.add(new JLabel(" "));
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < 3) {
                this.Params.add(new JLabel(" "));
                this.Params.add(new JLabel(" "));
                ++i;
            }
        }
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String what = e.getActionCommand();
        if (what.equals("getHelp")) {
            OTKit.help(helpText);
        } else if (what.equals("existingForm")) {
            this.my = this.name2mf.get(this.existingForm.getSelectedItem());
            if (this.my != null) {
                this.update();
            }
        } else if (what.equals("fromFile")) {
            String[] str = OTKit_GUI.readFile("Load file", XMLstuff.xmlfilter);
            if (str[4] == null && str[5] == null && str[6] == null) {
                Universe U = new Universe("Universe " + str[1]);
                U.fromXML(XMLstuff.string2xml(str[0]));
                FrameOrganizeUniverse org_univ = new FrameOrganizeUniverse(U);
                org_univ.tag_type = "my_gen";
                org_univ.target = this;
                org_univ.refreshList();
            }
        } else if (what.equals("formSchemeTypes")) {
            this.Params.removeAll();
            if (this.FormSchemeTypes.getSelectedItem().equals(selectAllForms)) {
                int i = 0;
                while (i < Scheme_gen.S.length) {
                    this.FormSchemes.removeItem(Scheme_gen.S[i].name);
                    this.FormSchemes.addItem(Scheme_gen.S[i].name);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < Scheme_gen.S.length) {
                    this.FormSchemes.removeItem(Scheme_gen.S[i].name);
                    if (this.FormSchemeTypes.getSelectedItem().toString().equals(Scheme_gen.S[i].type)) {
                        this.FormSchemes.addItem(Scheme_gen.S[i].name);
                    }
                    ++i;
                }
            }
        } else if (what.equals("form_scheme")) {
            String sel = this.FormSchemes.getSelectedItem().toString();
            if (sel.equals("")) {
                this.my = empty_mg;
            } else {
                Scheme_gen.Gen_scheme cs = Scheme_gen.name2scheme.get(sel);
                this.my = new MyGen("", cs.name);
                this.my.params = new Vector();
                int i = 0;
                while (i < cs.nr_param) {
                    this.my.params.add("");
                    ++i;
                }
            }
            this.update();
        } else if (what.equals("apply")) {
            Scheme_gen.Gen_scheme cs = Scheme_gen.name2scheme.get(this.scheme.getText());
            if (cs != null) {
                String cname = cs.name;
                int i = 0;
                while (i < cs.nr_param) {
                    cname = cname.replaceAll("P" + (i + 1), this.ParamValue.get(i).getText());
                    ++i;
                }
                this.my = new MyGen(cname, cs.name);
                this.my.params = new Vector();
                i = 0;
                while (i < cs.nr_param) {
                    this.my.params.add(this.ParamValue.get(i).getText());
                    ++i;
                }
                this.update();
            }
        } else if (what.equals("add_to_universe")) {
            if (this.my.scheme().equals("")) {
                OTKit.error("Gen scheme is empty! Specify a proper scheme.");
                OTKit_GUI.printText("Error in creating Gen. No scheme specified. Not added to MyUniverse.");
            } else if (this.name.getText().trim().equals("")) {
                OTKit.error("Gen name is empty or white space! Specify a name.");
                OTKit_GUI.printText("Error in creating Gen. Not added to MyUniverse.");
            } else {
                this.my = new MyGen(this.name.getText().trim(), this.scheme.getText());
                this.my.params = new Vector();
                int i = 0;
                while (i < Scheme_gen.name2scheme.get((Object)this.my.scheme()).nr_param) {
                    this.my.params.add(this.ParamValue.get(i).getText());
                    ++i;
                }
                if (this.my.gen(OTKit.MyUniverse) == Scheme_gen.error) {
                    OTKit_GUI.printText("Error in creating Gen.");
                } else {
                    String name = this.my.name();
                    if (OTKit.MyUniverse.MyForms.keySet().contains(name)) {
                        MyGen old = OTKit.MyUniverse.MyGens.get(name);
                        MyGen toTrash = new MyGen(String.valueOf(name) + ":old", old.scheme());
                        toTrash.params = old.params;
                        OTKit.TrashUniverse.MyGens.put(name, toTrash);
                        OTKit.MyUniverse.MyGens.remove(name);
                        OTKit.error("Gen with name " + name + " already existed in MyUniverse.\n Earlier one moved to Trash Universe.");
                        OTKit.return_err("Gen with name " + name + " already existed in MyUniverse.\n Earlier one moved to Trash Universe.");
                    }
                    OTKit.MyUniverse.MyGens.put(name, this.my);
                    this.existingForm.removeItem(name);
                    this.existingForm.addItem(name);
                    this.name2mf.put(name, this.my);
                    OTKit_GUI.printText("Gen '" + name + "' added to MyUniverse.");
                    String h = "add2MyUniverse( " + this.my.longScript() + " )";
                    OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                    OTKit_GUI.printText("> " + h);
                }
            }
        } else if (what.equals("save")) {
            if (this.my.scheme().equals("")) {
                OTKit.error("Gen scheme is empty! Specify a proper scheme.");
                OTKit_GUI.printText("Error in creating Gen. No scheme specified. Not saved.");
            } else if (this.name.getText().trim().equals("")) {
                OTKit.error("Gen name is empty or white space! Specify a name.");
                OTKit_GUI.printText("Error in creating Gen. Not saved.");
            } else {
                this.my = new MyGen(this.name.getText().trim(), this.scheme.getText());
                this.my.params = new Vector();
                int i = 0;
                while (i < Scheme_gen.name2scheme.get((Object)this.my.scheme()).nr_param) {
                    this.my.params.add(this.ParamValue.get(i).getText());
                    ++i;
                }
                if (this.my.gen(OTKit.MyUniverse) == Scheme_gen.error) {
                    OTKit_GUI.printText("Error in creating Gen. Not saved.");
                } else {
                    Universe U = new Universe("single Gen");
                    U.MyGens.put(this.my.name(), this.my);
                    String f = OTKit_GUI.printToFile(XMLstuff.xml2string(U.toXML()), "Save form", XMLstuff.xmlfilter);
                    if (f != null) {
                        OTKit_GUI.printText("Gen successfully saved to file.");
                        String h = "save( \"" + f.replace('\\', '/') + "\", " + this.my.longScript() + " )";
                        OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                        OTKit_GUI.printText("> " + h);
                    }
                }
            }
        } else if (what.equals("close")) {
            this.processEvent(new WindowEvent(this, 201));
        }
    }
}

