/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.userInterface;

import hu.birot.OTKit.otBuildingBlocks.Constraint;
import hu.birot.OTKit.otBuildingBlocks.Hierarchy;
import hu.birot.OTKit.uiMyElements.MyHierarchy;
import hu.birot.OTKit.uiMyElements.Universe;
import hu.birot.OTKit.userInterface.OTKFrame;
import hu.birot.OTKit.userInterface.OTKit;
import hu.birot.OTKit.userInterface.OTKit_GUI;
import hu.birot.OTKit.userInterface.XMLstuff;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class FrameDefineHierarchy
extends OTKFrame {
    private static final long serialVersionUID = 1L;
    public MyHierarchy myh;
    Universe U = OTKit.MyUniverse;
    public OTKFrame target = null;
    public String tag_type = null;
    private Hierarchy h;
    private Vector<String> rankvar = new Vector();
    private JTextField name = new JTextField();
    private JTextField type = new JTextField();
    private JPanel list = new JPanel();
    private HashMap<String, HashMap<String, JTextField>> rankval = new HashMap();
    private HashMap<String, JCheckBox> cb_hash_c = new HashMap();
    private HashMap<String, JCheckBox> cb_hash_r = new HashMap();
    static final int head_height = 40;
    static final int con_height = 200;
    static final int but_height = 400;
    static final int width = 600;
    public static final String helpText = "How to define a new hierarchy?\n\nIn OTKit, a hierarchy consists of\n  1. a name;\n  2. a type;\n  3. a list of \"ranked constraints\".\n\nThe name (specified in the upper left corner of the window) is the unique identifier of the hierarchy. If you enter a name of a hierarchy already existing in MyUniverse, the earlier one will be overwritten (and moved temporarily to TrashUniverse). \n\nThe type (in the upper right corner) can have values such as \"ot\" or \"hg\", and it determines how the hierarchy should be used by different actions.\n\nA \"ranked constraint\" is a constraint name, as well as a number of ranking variable name/ranking value pairs. Importantly, the hierarchy only includes the constraint names: it is your responsibility to have constraints with the same names defined (loaded) in MyUniverse at the time of executing any action involving this hierarchy.\n\nA hierarchy can include several ranking variables. The standard ranking variable is 'rank', others are 'weight', 'perturbed rank', 'kvalue' etc. You can also define your own variables. Make sure you know which action requires what ranking variables.\n\nEach constraint (rows in the window) is assigned a certain value for each ranking variable (columns in the window). The values are real numbers (double), with the exception of 'setranking', which takes a string.\n\nButtons: Rows and columns can be added and removed by using the buttons add/remove constraint/ranking. Before removing constraints or ranking variables, mark them in the check box. Once the hierarchy has been defined, it can be saved to MyUniverse or to a file.\n\nFinally, the 'vary ranking values' button offers a number of options to set and change the ranking values of the constraints. These operations are applied to all constraints presently in the hierarchy, and usually involve one or two ranking variables. Usually you will be asked to specify some ranking variable names and/or some numerical parameters.\n\n  \tSet ranking variable to constant value: set the values in a column to a specified value.\n   Copy ranking variable to another ranking variable: copy the values in a column to another one.\n   Add constant value to ranking variable: increase the values in a column by a constant value.\n   Rank to exponential weight: the value of ranking variable 'weight' is set as the negative of a base q to the power of the ranking variable 'rank'.\n   Exponential weight to rank: the value of the ranking variable 'rank' is set as the logarithm (of base q) of -1 times the ranking variable 'weight'.\n   perturbed_rank = unperturbed_rank + uniform noise: a white noise in the range of [0, r] is added to the ranking variable 'unperturbed_rank'.\n   perturbed_rank = unperturbed_rank + Gaussian noise: same, but with a Normal noise (mean = 0, standard deviation = s).";
    String[] possibleRankingValues = new String[]{"rank", "rank1", "rank2", "perturbed_rank", "unperturbed_rank", "kvalue", "weight", "setrank"};

    public FrameDefineHierarchy(MyHierarchy mh) {
        super(620, 690, "Define a hierarchy");
        this.background.setLayout(new BoxLayout(this.background, 1));
        JPanel header = new JPanel();
        header.setLayout(new GridLayout(1, 5, 10, 10));
        header.setMaximumSize(new Dimension(600, 40));
        this.background.add(header);
        header.add(new JLabel("Name:"));
        header.add(this.name);
        header.add(new JLabel());
        header.add(new JLabel("Type:"));
        header.add(this.type);
        JScrollPane jScrollPane1 = new JScrollPane(this.list);
        this.background.add(jScrollPane1);
        this.list.setLayout(new GridLayout(0, 2, 10, 10));
        this.list.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.background.add(new JLabel(" "));
        JPanel buttons = new JPanel();
        buttons.setMaximumSize(new Dimension(600, 400));
        buttons.setLayout(new GridLayout(0, 2, 10, 10));
        this.background.add(buttons);
        JButton add_c = new JButton("Add constraint");
        add_c.setActionCommand("add_c");
        add_c.addActionListener(this);
        add_c.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(add_c);
        JButton add_r = new JButton("Add ranking variable");
        add_r.setActionCommand("add_r");
        add_r.addActionListener(this);
        add_r.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(add_r);
        JButton selButton_c = new JButton("Select all constraints");
        selButton_c.setActionCommand("select_all_c");
        selButton_c.addActionListener(this);
        selButton_c.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(selButton_c);
        JButton selButton = new JButton("Select all ranking variables");
        selButton.setActionCommand("select_all_r");
        selButton.addActionListener(this);
        selButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(selButton);
        JButton deselButton_c = new JButton("Deselect all constraints");
        deselButton_c.setActionCommand("deselect_all_c");
        deselButton_c.addActionListener(this);
        deselButton_c.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(deselButton_c);
        JButton deselButton = new JButton("Deselect all ranking variables");
        deselButton.setActionCommand("deselect_all_r");
        deselButton.addActionListener(this);
        deselButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(deselButton);
        JButton remove_c = new JButton("Remove selected constraints");
        remove_c.setActionCommand("remove_c");
        remove_c.addActionListener(this);
        remove_c.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(remove_c);
        JButton remove_r = new JButton("Remove selected ranking variables");
        remove_r.setActionCommand("remove_r");
        remove_r.addActionListener(this);
        remove_r.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(remove_r);
        JButton addButton = new JButton("Add to MyUniverse");
        addButton.setActionCommand("add_to_universe");
        addButton.addActionListener(this);
        addButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(addButton);
        JButton saveButton = new JButton("Save to file");
        saveButton.setActionCommand("save");
        saveButton.addActionListener(this);
        saveButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(saveButton);
        JButton helpButton = new JButton("Get help");
        helpButton.setActionCommand("help");
        helpButton.addActionListener(this);
        helpButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(helpButton);
        JButton varyButton = new JButton("Vary ranking values");
        varyButton.setActionCommand("vary");
        varyButton.addActionListener(this);
        varyButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(varyButton);
        JButton okButton = new JButton("Close window");
        okButton.setActionCommand("close");
        okButton.addActionListener(this);
        okButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(okButton);
        JButton refreshButton = new JButton("Refresh window");
        refreshButton.setActionCommand("refresh");
        refreshButton.addActionListener(this);
        refreshButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(refreshButton);
        this.update();
        this.setVisible(true);
    }

    protected void update() {
        this.h = this.myh != null ? this.myh.hier() : new Hierarchy();
        this.myh = new MyHierarchy(this.h);
        this.name.setText(this.h.name);
        this.type.setText(this.h.type);
        this.cb_hash_r.clear();
        for (String r : this.h.allRankingVariables()) {
            if (this.rankvar.contains(r)) continue;
            this.rankvar.add(r);
        }
        for (String r : this.rankvar) {
            this.cb_hash_r.put(r, new JCheckBox());
        }
        this.cb_hash_c.clear();
        for (String c : this.h.constraintNames()) {
            this.cb_hash_c.put(c, new JCheckBox());
            if (this.rankval.containsKey(c)) {
                this.rankval.get(c).clear();
            }
            HashMap<String, JTextField> row = new HashMap<String, JTextField>();
            for (String r : this.rankvar) {
                row.put(r, new JTextField("" + this.h.get(c, r)));
            }
            this.rankval.put(c, row);
        }
        this.list.removeAll();
        this.list.add(new JLabel("Constraints:", 2));
        JPanel varnames = new JPanel();
        varnames.setLayout(new GridLayout(1, this.rankvar.size(), 5, 5));
        for (String rankv : this.rankvar) {
            JPanel jp = new JPanel();
            jp.setLayout(new GridLayout(2, 1));
            jp.add(new JLabel(rankv));
            jp.add(this.cb_hash_r.get(rankv));
            varnames.add(jp);
        }
        this.list.add(varnames);
        for (String con : this.h.constraintNames()) {
            JPanel left = new JPanel();
            left.setLayout(new FlowLayout(0));
            left.add(this.cb_hash_c.get(con));
            left.add(new JLabel(con));
            this.list.add(left);
            JPanel right = new JPanel();
            right.setLayout(new GridLayout(1, this.rankvar.size(), 5, 5));
            for (String rankv : this.rankvar) {
                right.add(this.rankval.get(con).get(rankv));
            }
            this.list.add(right);
        }
        int i = 0;
        while (i < 5 - this.h.constraintNames().size()) {
            this.list.add(new JPanel());
            this.list.add(new JPanel());
            ++i;
        }
        this.list.repaint();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent evt) {
        String what = evt.getActionCommand();
        if (what.equals("close")) {
            this.processEvent(new WindowEvent(this, 201));
        } else if (what.equals("refresh")) {
            this.update();
        } else if (what.equals("select_all_c")) {
            for (String mc : this.cb_hash_c.keySet()) {
                this.cb_hash_c.get(mc).setSelected(true);
            }
        } else if (what.equals("deselect_all_c")) {
            for (String mc : this.cb_hash_c.keySet()) {
                this.cb_hash_c.get(mc).setSelected(false);
            }
        } else if (what.equals("select_all_r")) {
            for (String mc : this.cb_hash_r.keySet()) {
                this.cb_hash_r.get(mc).setSelected(true);
            }
        } else if (what.equals("deselect_all_r")) {
            for (String mc : this.cb_hash_r.keySet()) {
                this.cb_hash_r.get(mc).setSelected(false);
            }
        } else if (what.equals("remove_c")) {
            for (String c : this.cb_hash_c.keySet()) {
                if (!this.cb_hash_c.get(c).isSelected()) continue;
                this.h.removeConstraint(c);
            }
            this.myh = new MyHierarchy(this.h);
            this.update();
        } else if (what.equals("remove_r")) {
            for (String r : this.cb_hash_r.keySet()) {
                if (!this.cb_hash_r.get(r).isSelected()) continue;
                this.rankvar.remove(r);
                for (String c : this.h.constraintNames()) {
                    this.h.set(c, r, Hierarchy.no_ranking_value);
                }
            }
            this.myh = new MyHierarchy(this.h);
            this.update();
        } else if (what.equals("add_c")) {
            this.to_h();
            Object[] possibleValues = new Object[this.U.MyConstraints.size() + 1];
            possibleValues[0] = "Enter a new constraint name";
            int i = 1;
            for (String c : this.U.MyConstraints.keySet()) {
                possibleValues[i] = c;
                ++i;
            }
            Object selectedValue = JOptionPane.showInputDialog(null, "Choose a constraint name or choose to enter a new constraint:", "Constraints", 1, null, possibleValues, possibleValues[0]);
            if (selectedValue != null && selectedValue.toString().equals(possibleValues[0])) {
                String cname = JOptionPane.showInputDialog(null, (Object)"Enter new constraint name:");
                if (cname != null && !cname.trim().isEmpty()) {
                    this.h.addConstraint(Constraint.empty(cname.trim()));
                }
            } else if (selectedValue != null) {
                this.h.addConstraint(this.U.MyConstraints.get(selectedValue.toString()).con(this.U));
            }
            this.myh = new MyHierarchy(this.h);
            this.update();
        } else if (what.equals("add_r")) {
            this.to_h();
            String selectedValue = this.selectedRankingVariable(this.possibleRankingValues);
            if (selectedValue != null && !selectedValue.toString().isEmpty()) {
                this.rankvar.remove(selectedValue.toString());
                this.rankvar.add(selectedValue.toString());
            }
            this.myh = new MyHierarchy(this.h);
            this.update();
        } else if (what.equals("add_to_universe")) {
            if (this.name.getText().trim().isEmpty()) {
                OTKit.error("Hierarchy name is empty or white space! Specify a name.");
                OTKit_GUI.printText("Error in creating hierarchy. Not added to MyUniverse.");
            } else {
                this.to_h();
                for (String c : this.h.constraintNames()) {
                    if (this.U.MyConstraints.containsKey(c)) {
                        this.U.MyConstraints.get(c).con(this.U);
                        continue;
                    }
                    OTKit.warning("No constraint with name '" + c + "' in " + this.U.name() + ".");
                }
                if (this.U.MyHierarchies.containsKey(this.myh.name())) {
                    Hierarchy h_toTrash = this.h.clone();
                    h_toTrash.name = String.valueOf(this.h.name) + ":old";
                    new MyHierarchy(h_toTrash).addMeToHash(OTKit.TrashUniverse);
                    OTKit.error("Hierarchy with name " + this.name.getText().trim() + " already existed in " + this.U.name() + ".\n Earlier one moved to Trash Universe.");
                    OTKit.return_err("Hierarchy with name " + this.name.getText().trim() + " already existed in " + this.U.name() + ".\n Earlier one moved to Trash Universe.");
                }
                this.myh.addMeToHash(this.U);
                String h = "add2MyUniverse( " + this.myh.longScript() + " )";
                OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                OTKit_GUI.printText("> " + h);
            }
        } else if (what.equals("save")) {
            if (this.name.getText().trim().isEmpty()) {
                OTKit.error("Hierarchy name is empty or white space! Specify a name.");
                OTKit_GUI.printText("Error in creating hierarchy. Not saved.");
            } else {
                String f;
                this.to_h();
                for (String c : this.h.constraintNames()) {
                    if (this.U.MyConstraints.containsKey(c)) {
                        this.U.MyConstraints.get(c).con(this.U);
                        continue;
                    }
                    OTKit.warning("No constraint with name '" + c + "' in " + this.U.name() + ".");
                }
                Universe Un = new Universe("single hierarchy");
                this.myh.addMeToHash(Un);
                if (JOptionPane.showConfirmDialog(null, "Do you also want to save the constraints of the hierarchy (those that are currently in MyUniverse) to the same file?", "Constraints?", 0, 3) == 0) {
                    for (String c : this.h.constraintNames()) {
                        if (this.U.MyConstraints.get(c) == null) continue;
                        this.U.MyConstraints.get(c).addMeToHash(Un);
                    }
                }
                if ((f = OTKit_GUI.printToFile(XMLstuff.xml2string(Un.toXML()), "Hierarchy constraint", XMLstuff.xmlfilter)) != null) {
                    OTKit_GUI.printText("Hierarchy successfully saved to file.");
                    String h = "save( \"" + f.replace('\\', '/') + "\", " + this.myh.longScript() + " )";
                    OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                    OTKit_GUI.printText("> " + h);
                }
            }
        } else if (what.equals("help")) {
            OTKit.help(helpText);
        } else if (what.equals("vary")) {
            this.h.name = this.name.getText();
            this.h.type = this.type.getText();
            for (String c : this.h.constraintNames()) {
                for (String r : this.rankvar) {
                    this.h.set(c, r, this.rankval.get(c).get(r).getText());
                }
            }
            this.vary(this.h);
            this.myh = new MyHierarchy(this.h);
            this.update();
        }
    }

    void to_h() {
        this.h.name = this.name.getText();
        this.h.type = this.type.getText();
        for (String c : this.h.constraintNames()) {
            for (String r : this.rankvar) {
                this.h.set(c, r, this.rankval.get(c).get(r).getText());
            }
        }
        this.myh = new MyHierarchy(this.h);
    }

    String selectedRankingVariable(Object[] possibleValues) {
        String newvar = "Enter new ranking variable name";
        Vector<Object> poss = new Vector<Object>();
        poss.add(newvar);
        Object[] objectArray = possibleValues;
        int n = possibleValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            poss.add(o);
            ++n2;
        }
        Object selectedValue = JOptionPane.showInputDialog(null, "Choose a ranking variable or choose to enter a new one:", "Ranking variables", 1, null, poss.toArray(), newvar);
        if (selectedValue == null) {
            return null;
        }
        if (selectedValue.toString().equals(newvar)) {
            String s = JOptionPane.showInputDialog(null, (Object)"Enter new ranking value name:");
            if (s == null || s.trim().isEmpty()) {
                return null;
            }
            return s.trim();
        }
        return selectedValue.toString().trim();
    }

    void vary(Hierarchy h) {
        String q;
        String set_rank_const = "Set ranking variable to constant value";
        String copy = "Copy ranking variable to another ranking variable";
        String add = "Add constant value to ranking variable";
        String rank2exp = "Rank to exponential weight";
        String exp2rank = "Exponential weight to rank";
        String uniform_perturb = "perturbed_rank = unperturbed_rank + uniform noise";
        String gaussian_perturb = "perturbed_rank = unperturbed_rank + Gaussian noise";
        Object[] options = new String[]{"Set ranking variable to constant value", "Copy ranking variable to another ranking variable", "Add constant value to ranking variable", "Rank to exponential weight", "Exponential weight to rank", "perturbed_rank = unperturbed_rank + uniform noise", "perturbed_rank = unperturbed_rank + Gaussian noise"};
        Object selectedValue = JOptionPane.showInputDialog(null, "Choose an action on the hierarchy:", "Actions on Hierarchy", 1, null, options, options[0]);
        if (selectedValue == null) {
            return;
        }
        String s = selectedValue.toString();
        if (s.equals("Set ranking variable to constant value")) {
            String q2;
            String r = this.selectedRankingVariable(this.rankvar.toArray());
            if (r != null && (q2 = JOptionPane.showInputDialog(null, (Object)"Ranking value r for all constraints:")) != null && !q2.trim().isEmpty()) {
                for (String c : h.constraintNames()) {
                    h.set(c, r, q2);
                }
            }
        } else if (s.equals("Add constant value to ranking variable")) {
            if (this.rankvar.isEmpty()) {
                OTKit.warning("No ranking variable yet.");
                return;
            }
            Object r = JOptionPane.showInputDialog(null, "Choose an existing ranking variable whose values will be copied.", "Ranking variables", 1, null, this.rankvar.toArray(), this.rankvar.firstElement());
            if (r == null) {
                return;
            }
            String q3 = JOptionPane.showInputDialog(null, (Object)("Value C by which " + r + "has to be incremented:"));
            if (q3 != null && !q3.trim().isEmpty()) {
                double qq = Double.NaN;
                try {
                    qq = Double.parseDouble(q3.trim());
                }
                catch (NumberFormatException e) {
                    OTKit.error("C must be parsable to an integer or a double!");
                    return;
                }
                String rank = r.toString();
                for (String cnstr : h.constraintNames()) {
                    double v = qq + Double.parseDouble(h.get(cnstr, rank).toString());
                    h.set(cnstr, rank, v);
                }
            }
        } else if (s.equals("Rank to exponential weight")) {
            String q4 = JOptionPane.showInputDialog(null, (Object)"Enter base q of exponential weight system:");
            if (q4 != null && !q4.trim().isEmpty()) {
                double qq = Double.NaN;
                try {
                    qq = Double.parseDouble(q4.trim());
                }
                catch (NumberFormatException e) {
                    OTKit.error("q must be parsable to an integer or a double!");
                    return;
                }
                h.rank2weight(qq);
            }
        } else if (s.equals("Exponential weight to rank")) {
            String q5 = JOptionPane.showInputDialog(null, (Object)"Enter base q of exponential weight system:");
            if (q5 != null && !q5.trim().isEmpty()) {
                double qq = Double.NaN;
                try {
                    qq = Double.parseDouble(q5.trim());
                }
                catch (NumberFormatException e) {
                    OTKit.error("q must be parsable to an integer or a double!");
                    return;
                }
                h.weight2rank(qq);
            }
        } else if (s.equals("Copy ranking variable to another ranking variable")) {
            if (this.rankvar.isEmpty()) {
                OTKit.warning("No ranking variable yet.");
                return;
            }
            Object r1 = JOptionPane.showInputDialog(null, "Choose an existing ranking variable whose values will be copied.", "Ranking variables", 1, null, this.rankvar.toArray(), this.rankvar.firstElement());
            if (r1 == null) {
                return;
            }
            String r2 = this.selectedRankingVariable(this.rankvar.toArray());
            if (r2 == null) {
                return;
            }
            h.copyRank(r1.toString(), r2);
        } else if (s.equals("perturbed_rank = unperturbed_rank + uniform noise")) {
            String q6 = JOptionPane.showInputDialog(null, (Object)"Noise is a random number between 0 and r, following a uniform distribution. What is r?");
            if (q6 != null && !q6.trim().isEmpty()) {
                double qq = Double.NaN;
                try {
                    qq = Double.parseDouble(q6.trim());
                }
                catch (NumberFormatException e) {
                    OTKit.error("q must be parsable to an integer or a double!");
                    return;
                }
                h.perturbUniform(qq);
            }
        } else if (s.equals("perturbed_rank = unperturbed_rank + Gaussian noise") && (q = JOptionPane.showInputDialog(null, (Object)"Noise follows a Normal (Gaussian) distribution with mean 0 and standard deviation s. What is s?")) != null && !q.trim().isEmpty()) {
            double qq = Double.NaN;
            try {
                qq = Double.parseDouble(q.trim());
            }
            catch (NumberFormatException e) {
                OTKit.error("q must be parsable to an integer or a double!");
                return;
            }
            h.perturbGaussian(0.0, qq);
        }
    }
}

