/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.userInterface;

import hu.birot.OTKit.uiMyElements.MyTable;
import hu.birot.OTKit.uiMyElements.Universe;
import hu.birot.OTKit.userInterface.OTKFrame;
import hu.birot.OTKit.userInterface.OTKit;
import hu.birot.OTKit.userInterface.OTKit_GUI;
import hu.birot.OTKit.userInterface.XMLstuff;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class FrameDefineTable
extends OTKFrame {
    private static final long serialVersionUID = 1L;
    public MyTable my;
    Universe U = OTKit.MyUniverse;
    public OTKFrame target = null;
    public String tag_type = null;
    private String[][] t;
    private int R = 3;
    private int C = 1;
    private JTextField name = new JTextField();
    private JPanel list = new JPanel();
    private JTextField[][] cells;
    private JCheckBox[] cb_hash_row;
    private JCheckBox[] cb_hash_col;
    static final int head_height = 40;
    static final int con_height = 200;
    static final int but_height = 400;
    static final int width = 600;
    public static final String helpText = "A table is a collection of values (numbers or strings) organized into rows and columns. Tables are employed to define other elements, such as a Gen, a constraint or a topology. Certain schemes will require the name of a table (loaded to MyUniverse) as their parameter. For instance, the simplest Gen is a finite list of candidates, listed as a table with a single column. The definition of a constraint may use a tableau-like table, with the first column containing the surface forms or candidates, and the second column containing the violations.\n\nHow to define a new table?\n\nIn OTKit, a table consists of\n  1. a name;\n  2. the table itself, R x C cells, organized into R rows and C columns.\n\nThe name (specified in the uppermost part of the window) is the unique identifier of the table. If you enter a name of a table already existing in MyUniverse, the earlier one will be overwritten (and moved temporarily to TrashUniverse). \n\nThe \"meaning\" of the columns depends on the use of the table. For instance, the first column may contain surface form strings, name of candidates, etc. The second column may contain weights or violations of constraint or neighbor candidates, and so forth. When you create the table, its use is not known yet. So errors, such as cells that are supposed to contain numbers but do not, will cause problems only later.\nThe order of the rows is usually unimportant.\nUse the 'Add row/column' buttons to add a new row or a new column at the end of the table. To remove a row or a column, first select the ones to be removed, and then press the 'remove selected rows/columns' button.\nOnce you have finished editing the table, and you have also specified its name, button 'add to MyUniverse' will create the table. Button 'save to file' will export the table to an xml file.\nFinally, the button 'vary columns' offers a number of tools to transform the columns: filling a column with a constant value; copying the values in a column to another one; summing, multiplying or concatenating two columns, and putting the result in a third one. Remember that in each case, not only the source but also the target columns should be created (using, for instance, 'add column') before the transformation. Arithmetic manipulations, obviously, require that each cell contain (integer or real) number values. Source and target need not be different. For example, in order to replace a column with the squared values, choose 'Product of columns' with the same column given as the first factor, the second factor and also the result.\n\n";

    public FrameDefineTable(MyTable mt) {
        super(620, 690, "Define a table");
        int i;
        this.background.setLayout(new BoxLayout(this.background, 1));
        this.cells = new JTextField[this.R][this.C];
        if (mt != null) {
            this.my = mt;
            this.R = mt.rows();
            this.C = mt.cols();
            this.t = mt.table();
            this.update_cells_from_t();
            this.name.setText(mt.name());
        } else {
            i = 0;
            while (i < this.R) {
                int j = 0;
                while (j < this.C) {
                    this.cells[i][j] = new JTextField("");
                    ++j;
                }
                ++i;
            }
        }
        this.cb_hash_row = new JCheckBox[this.R];
        this.cb_hash_col = new JCheckBox[this.C];
        i = 0;
        while (i < this.R) {
            this.cb_hash_row[i] = new JCheckBox();
            ++i;
        }
        i = 0;
        while (i < this.C) {
            this.cb_hash_col[i] = new JCheckBox();
            ++i;
        }
        JPanel header = new JPanel();
        header.setLayout(new GridLayout(1, 5, 10, 10));
        header.setMaximumSize(new Dimension(600, 40));
        this.background.add(header);
        header.add(new JLabel("Name:"));
        header.add(this.name);
        JScrollPane jScrollPane1 = new JScrollPane(this.list);
        this.background.add(jScrollPane1);
        this.list.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.background.add(new JLabel(" "));
        JPanel buttons = new JPanel();
        buttons.setMaximumSize(new Dimension(600, 400));
        buttons.setLayout(new GridLayout(0, 2, 10, 10));
        this.background.add(buttons);
        JButton add_c = new JButton("Add row");
        add_c.setActionCommand("add_row");
        add_c.addActionListener(this);
        add_c.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(add_c);
        JButton add_r = new JButton("Add column");
        add_r.setActionCommand("add_col");
        add_r.addActionListener(this);
        add_r.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(add_r);
        JButton selButton_c = new JButton("Select rows");
        selButton_c.setActionCommand("select_all_row");
        selButton_c.addActionListener(this);
        selButton_c.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(selButton_c);
        JButton selButton = new JButton("Select all columns");
        selButton.setActionCommand("select_all_col");
        selButton.addActionListener(this);
        selButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(selButton);
        JButton deselButton_c = new JButton("Deselect all rows");
        deselButton_c.setActionCommand("deselect_all_row");
        deselButton_c.addActionListener(this);
        deselButton_c.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(deselButton_c);
        JButton deselButton = new JButton("Deselect all columns");
        deselButton.setActionCommand("deselect_all_col");
        deselButton.addActionListener(this);
        deselButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(deselButton);
        JButton remove_c = new JButton("Remove selected rows");
        remove_c.setActionCommand("remove_row");
        remove_c.addActionListener(this);
        remove_c.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(remove_c);
        JButton remove_r = new JButton("Remove selected columns");
        remove_r.setActionCommand("remove_col");
        remove_r.addActionListener(this);
        remove_r.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(remove_r);
        JButton addButton = new JButton("Add to MyUniverse");
        addButton.setActionCommand("add_to_universe");
        addButton.addActionListener(this);
        addButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(addButton);
        JButton saveButton = new JButton("Save to file");
        saveButton.setActionCommand("save");
        saveButton.addActionListener(this);
        saveButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(saveButton);
        JButton helpButton = new JButton("Get help");
        helpButton.setActionCommand("help");
        helpButton.addActionListener(this);
        helpButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(helpButton);
        JButton varyButton = new JButton("Vary columns");
        varyButton.setActionCommand("vary");
        varyButton.addActionListener(this);
        varyButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(varyButton);
        JButton okButton = new JButton("Close window");
        okButton.setActionCommand("close");
        okButton.addActionListener(this);
        okButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(okButton);
        JButton refreshButton = new JButton("Refresh window");
        refreshButton.setActionCommand("refresh");
        refreshButton.addActionListener(this);
        refreshButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(refreshButton);
        this.update();
    }

    private void update_t_from_cells() {
        this.t = new String[this.R][this.C];
        int i = 0;
        while (i < this.R) {
            int j = 0;
            while (j < this.C) {
                if (this.cells.length > i && this.cells[i].length > j) {
                    this.t[i][j] = this.cells[i][j].getText();
                }
                ++j;
            }
            ++i;
        }
    }

    private void update_cells_from_t() {
        this.cells = new JTextField[this.R][this.C];
        int i = 0;
        while (i < this.R) {
            int j = 0;
            while (j < this.C) {
                this.cells[i][j] = new JTextField();
                if (this.t.length > i && this.t[i].length > j) {
                    this.cells[i][j].setText(this.t[i][j]);
                }
                ++j;
            }
            ++i;
        }
    }

    private void update_checkboxes() {
        JCheckBox[] cb = new JCheckBox[this.C];
        int i = 0;
        while (i < this.C) {
            cb[i] = new JCheckBox();
            ++i;
        }
        i = 0;
        while (i < this.C) {
            if (this.cb_hash_col.length > i) {
                cb[i] = this.cb_hash_col[i];
            }
            ++i;
        }
        this.cb_hash_col = cb;
        cb = new JCheckBox[this.R];
        i = 0;
        while (i < this.R) {
            cb[i] = new JCheckBox();
            ++i;
        }
        i = 0;
        while (i < this.R) {
            if (this.cb_hash_row.length > i) {
                cb[i] = this.cb_hash_row[i];
            }
            ++i;
        }
        this.cb_hash_row = cb;
    }

    protected void update() {
        JPanel c;
        this.update_checkboxes();
        this.update_t_from_cells();
        this.update_cells_from_t();
        this.my = new MyTable(this.name.getText(), this.t);
        int COL = Math.max(1 + this.C, 4);
        this.list.removeAll();
        this.list.setLayout(new GridLayout(0, COL, 10, 10));
        this.list.add(new JPanel());
        int i = 0;
        while (i < this.C) {
            c = new JPanel();
            c.setLayout(new GridLayout(2, 1));
            c.add(new JLabel("" + (i + 1)));
            c.add(this.cb_hash_col[i]);
            this.list.add(c);
            ++i;
        }
        i = 1 + this.C;
        while (i < COL) {
            this.list.add(new JPanel());
            ++i;
        }
        i = 0;
        while (i < this.R) {
            c = new JPanel();
            c.setLayout(new GridLayout(1, 2));
            c.add(this.cb_hash_row[i]);
            c.add(new JLabel("" + (i + 1)));
            this.list.add(c);
            int j = 0;
            while (j < this.C) {
                this.list.add(this.cells[i][j]);
                ++j;
            }
            j = 1 + this.C;
            while (j < COL) {
                this.list.add(new JPanel());
                ++j;
            }
            ++i;
        }
        i = this.R;
        while (i < 10) {
            int j = 0;
            while (j <= COL) {
                this.list.add(new JPanel());
                ++j;
            }
            ++i;
        }
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent evt) {
        String what = evt.getActionCommand();
        if (what.equals("close")) {
            this.processEvent(new WindowEvent(this, 201));
        } else if (what.equals("refresh")) {
            this.update();
        } else if (what.equals("select_all_row")) {
            JCheckBox[] jCheckBoxArray = this.cb_hash_row;
            int n = this.cb_hash_row.length;
            int n2 = 0;
            while (n2 < n) {
                JCheckBox mc = jCheckBoxArray[n2];
                mc.setSelected(true);
                ++n2;
            }
        } else if (what.equals("deselect_all_row")) {
            JCheckBox[] jCheckBoxArray = this.cb_hash_row;
            int n = this.cb_hash_row.length;
            int n3 = 0;
            while (n3 < n) {
                JCheckBox mc = jCheckBoxArray[n3];
                mc.setSelected(false);
                ++n3;
            }
        } else if (what.equals("select_all_col")) {
            JCheckBox[] jCheckBoxArray = this.cb_hash_col;
            int n = this.cb_hash_col.length;
            int n4 = 0;
            while (n4 < n) {
                JCheckBox mc = jCheckBoxArray[n4];
                mc.setSelected(true);
                ++n4;
            }
        } else if (what.equals("deselect_all_col")) {
            JCheckBox[] jCheckBoxArray = this.cb_hash_col;
            int n = this.cb_hash_col.length;
            int n5 = 0;
            while (n5 < n) {
                JCheckBox mc = jCheckBoxArray[n5];
                mc.setSelected(false);
                ++n5;
            }
        } else if (what.equals("remove_row")) {
            int i = 0;
            while (i < this.R) {
                if (this.cb_hash_row[i].isSelected()) {
                    int j = i;
                    while (j < this.R - 1) {
                        this.cb_hash_row[j] = this.cb_hash_row[j + 1];
                        int k = 0;
                        while (k < this.C) {
                            this.cells[j][k] = this.cells[j + 1][k];
                            ++k;
                        }
                        ++j;
                    }
                    --i;
                    --this.R;
                }
                ++i;
            }
            this.update();
        } else if (what.equals("remove_col")) {
            int i = 0;
            while (i < this.C) {
                if (this.cb_hash_col[i].isSelected()) {
                    int j = i;
                    while (j < this.C - 1) {
                        this.cb_hash_col[j] = this.cb_hash_col[j + 1];
                        int k = 0;
                        while (k < this.R) {
                            this.cells[k][j] = this.cells[k][j + 1];
                            ++k;
                        }
                        ++j;
                    }
                    --i;
                    --this.C;
                }
                ++i;
            }
            this.update();
        } else if (what.equals("add_row")) {
            ++this.R;
            this.update();
        } else if (what.equals("add_col")) {
            ++this.C;
            this.update();
        } else if (what.equals("add_to_universe")) {
            this.update();
            if (this.name.getText().trim().isEmpty()) {
                OTKit.error("Table name is empty or white space! Specify a name.");
                OTKit_GUI.printText("Error in creating table. Not added to MyUniverse.");
            } else {
                if (this.U.MyTables.containsKey(this.my.name())) {
                    new MyTable(String.valueOf(this.my.name()) + ":old", this.t).addMeToHash(OTKit.TrashUniverse);
                    OTKit.error("Table with name " + this.my.name() + " already existed in " + this.U.name() + ".\n Earlier one moved to Trash Universe.");
                    OTKit.return_err("Table with name " + this.my.name() + " already existed in " + this.U.name() + ".\n Earlier one moved to Trash Universe.");
                }
                this.my.addMeToHash(this.U);
                String h = "add2MyUniverse( " + this.my.longScript() + " )";
                OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                OTKit_GUI.printText("> " + h);
            }
        } else if (what.equals("save")) {
            this.update();
            if (this.name.getText().trim().isEmpty()) {
                OTKit.error("Table name is empty or white space! Specify a name.");
                OTKit_GUI.printText("Error in creating table. Not saved.");
            } else {
                Universe Un = new Universe("single table");
                this.my.addMeToHash(Un);
                String f = OTKit_GUI.printToFile(XMLstuff.xml2string(Un.toXML()), "Save table", XMLstuff.xmlfilter);
                if (f != null) {
                    OTKit_GUI.printText("Table successfully saved to file.");
                    String h = "save( \"" + f.replace('\\', '/') + "\", " + this.my.longScript() + " )";
                    OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                    OTKit_GUI.printText("> " + h);
                }
            }
        } else if (what.equals("help")) {
            OTKit.help(helpText);
        } else if (what.equals("vary")) {
            this.update_t_from_cells();
            this.vary_t();
            this.update_cells_from_t();
            this.update();
        }
    }

    private void vary_t() {
        block41: {
            String s;
            block40: {
                int col;
                String set_constant = "Set value of column to constant value.";
                String set_copy = "Copy column A to copy B.";
                String set_sum = "Sum of columns A and B copied to column C.";
                String set_concat = "Concatenation of columns A and B copied to column C.";
                String set_product = "Product of columns A and B copied to column C.";
                Object[] options = new String[]{"Set value of column to constant value.", "Copy column A to copy B.", "Sum of columns A and B copied to column C.", "Concatenation of columns A and B copied to column C.", "Product of columns A and B copied to column C."};
                Object selectedValue = JOptionPane.showInputDialog(null, "Choose an action on the table:", "Actions on Table", 1, null, options, options[0]);
                if (selectedValue == null) {
                    return;
                }
                s = selectedValue.toString();
                if (!s.equals("Set value of column to constant value.")) break block40;
                if (this.C == 0) {
                    OTKit.warning("First add a column to the table.");
                    return;
                }
                if (this.C == 1) {
                    col = 1;
                } else {
                    Integer col1 = this.choose_col("Column whose value is to be set to a constant number.");
                    if (col1 == null) {
                        return;
                    }
                    col = col1;
                }
                String q = JOptionPane.showInputDialog(null, (Object)"Constant value in this column:");
                if (q == null || q.trim().isEmpty()) break block41;
                int i = 0;
                while (i < this.R) {
                    this.t[i][col - 1] = q;
                    ++i;
                }
                break block41;
            }
            if (s.equals("Copy column A to copy B.")) {
                if (this.C < 2) {
                    OTKit.warning("You must have two columns for copying: the source and the destination.");
                    return;
                }
                Integer Col1 = this.choose_col("Source column for copying.");
                if (Col1 == null) {
                    return;
                }
                int col1 = Col1;
                Integer Col2 = this.choose_col("Destination column for copying.");
                if (Col2 == null) {
                    return;
                }
                int col2 = Col2;
                int i = 0;
                while (i < this.R) {
                    this.t[i][col2 - 1] = this.t[i][col1 - 1];
                    ++i;
                }
            } else if (s.equals("Concatenation of columns A and B copied to column C.")) {
                if (this.C < 1) {
                    OTKit.warning("You must have three columns for concatenating: col1 + col2 = col3.");
                    return;
                }
                Integer Col1 = this.choose_col("First part of the concatenation.");
                if (Col1 == null) {
                    return;
                }
                int col1 = Col1;
                Integer Col2 = this.choose_col("Second part of the concatenation.");
                if (Col2 == null) {
                    return;
                }
                int col2 = Col2;
                Integer Col3 = this.choose_col("Result of the concatenation.");
                if (Col3 == null) {
                    return;
                }
                int col3 = Col3;
                int i = 0;
                while (i < this.R) {
                    this.t[i][col3 - 1] = String.valueOf(this.t[i][col1 - 1]) + this.t[i][col2 - 1];
                    ++i;
                }
            } else if (s.equals("Sum of columns A and B copied to column C.")) {
                if (this.C < 1) {
                    OTKit.warning("You must have three columns for addition: col1 + col2 = col3.");
                    return;
                }
                Integer Col1 = this.choose_col("First addend of the sum.");
                if (Col1 == null) {
                    return;
                }
                int col1 = Col1;
                Integer Col2 = this.choose_col("Second addend of the sum.");
                if (Col2 == null) {
                    return;
                }
                int col2 = Col2;
                Integer Col3 = this.choose_col("Result of the sum.");
                if (Col3 == null) {
                    return;
                }
                int col3 = Col3;
                int i = 0;
                while (i < this.R) {
                    double b;
                    double a;
                    try {
                        a = Double.parseDouble(this.t[i][col1 - 1]);
                    }
                    catch (NumberFormatException e) {
                        OTKit.error("Not an (integer or real) number in row " + (i + 1) + " column " + col1 + ".");
                        return;
                    }
                    try {
                        b = Double.parseDouble(this.t[i][col2 - 1]);
                    }
                    catch (NumberFormatException e) {
                        OTKit.error("Not an (integer or real) number in row " + (i + 1) + " column " + col2 + ".");
                        return;
                    }
                    this.t[i][col3 - 1] = String.valueOf(a + b);
                    ++i;
                }
            } else if (s.equals("Product of columns A and B copied to column C.")) {
                if (this.C < 1) {
                    OTKit.warning("You must have three columns for multiplication: col1 * col2 = col3.");
                    return;
                }
                Integer Col1 = this.choose_col("First factor of the product.");
                if (Col1 == null) {
                    return;
                }
                int col1 = Col1;
                Integer Col2 = this.choose_col("Second factor of the product.");
                if (Col2 == null) {
                    return;
                }
                int col2 = Col2;
                Integer Col3 = this.choose_col("Result of the product.");
                if (Col3 == null) {
                    return;
                }
                int col3 = Col3;
                int i = 0;
                while (i < this.R) {
                    double b;
                    double a;
                    try {
                        a = Double.parseDouble(this.t[i][col1 - 1]);
                    }
                    catch (NumberFormatException e) {
                        OTKit.error("Not an (integer or real) number in row " + (i + 1) + " column " + col1 + ".");
                        return;
                    }
                    try {
                        b = Double.parseDouble(this.t[i][col2 - 1]);
                    }
                    catch (NumberFormatException e) {
                        OTKit.error("Not an (integer or real) number in row " + (i + 1) + " column " + col2 + ".");
                        return;
                    }
                    this.t[i][col3 - 1] = String.valueOf(a * b);
                    ++i;
                }
            }
        }
    }

    private Integer choose_col(String txt) {
        Integer col = null;
        String r = JOptionPane.showInputDialog(null, (Object)(String.valueOf(txt) + " Enter column number (between 1 and " + this.C + "):"));
        if (r == null) {
            return col;
        }
        try {
            col = Integer.parseInt(r);
        }
        catch (NumberFormatException e) {
            OTKit.error("Column number must be an integer!");
            col = this.choose_col(txt);
        }
        if (col <= 0) {
            OTKit.error("Column number must be a positive integer.");
            col = this.choose_col(txt);
        }
        if (col > this.C) {
            OTKit.error("No such column. Enter a number not greater than " + this.C + ".");
            col = this.choose_col(txt);
        }
        return col;
    }
}

