/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.userInterface;

import hu.birot.OTKit.grammarExamples.MetricalStress;
import hu.birot.OTKit.userInterface.OTKFrame;
import hu.birot.OTKit.userInterface.OTKit;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FrameOptionsMetrPhon
extends OTKFrame {
    private static final long serialVersionUID = 1L;
    JTextField eos = new JTextField("" + OTKit.metr_EOS);
    JTextField bof = new JTextField("" + OTKit.metr_BOF);
    JTextField eof = new JTextField("" + OTKit.metr_EOF);
    JTextField prs = new JTextField("" + OTKit.metr_PRS);
    JTextField scs = new JTextField("" + OTKit.metr_SCS);
    JTextField lon = new JTextField("" + OTKit.metr_LONG);
    JTextField mor = new JTextField("" + OTKit.metr_MORA);
    JTextField syl = new JTextField("" + OTKit.metr_SYLL);
    String helpText = "Help on the Metrical Phonology Options window:\n\nIn this window, you can set a number of options for models of metrical phonology:\n  End-of-syllable:     \t Character used to delineate syllables in the middle of words.\n  Beginning-of-foot:   \t Character representing the opening bracket of a foot.\n  End-of-foot:         \t Character representing the closing bracket of a foot.\n  Primary stress:      \t Character appearing before the first segment of a syllable with primary stress.\n  Secondary stress:    \t Character appearing before the first segment of a syllable with secondary stress.\n  Long segment:        \t Character whose meaning is that the previous vowel is long or consonant is a geminate.\n  Mora:                \t Character denoting one mora.\n  Syllable:            \t Character denoting one syllable.\n\n Note that whenever a symbol is a single character, then the first (non-blank) character appearing in the text field will be used.\n\n Pressing the 'ok' button will both save the settings ('apply') and close this window ('cancel').\n";
    static final int number_rows = 8;
    static final int opt_height = 176;
    static final int but_height = 60;

    public FrameOptionsMetrPhon() {
        super(400, 316, "Options for Metrical Phonology");
        JPanel options = new JPanel();
        options.setLayout(new GridLayout(0, 2));
        options.setMaximumSize(new Dimension(400, 176));
        this.background.add(options);
        options.add(new JLabel("Metrical Phonology:"));
        options.add(new JLabel());
        options.add(new JLabel("End-of-syllable symbol: "));
        options.add(this.eos);
        options.add(new JLabel("Beginning-of-foot symbol: "));
        options.add(this.bof);
        options.add(new JLabel("End-of-foot symbol: "));
        options.add(this.eof);
        options.add(new JLabel("Primary stress symbol: "));
        options.add(this.prs);
        options.add(new JLabel("Secondary stress symbol: "));
        options.add(this.scs);
        options.add(new JLabel("Long phoneme symbol: "));
        options.add(this.lon);
        options.add(new JLabel("Mora symbol: "));
        options.add(this.mor);
        options.add(new JLabel("Syllable symbol: "));
        options.add(this.syl);
        this.background.add(new JLabel(" "));
        JPanel buttons = new JPanel();
        buttons.setMaximumSize(new Dimension(400, 60));
        buttons.setLayout(new GridLayout(0, 2, 10, 10));
        this.background.add(buttons);
        JButton closeButton = new JButton("Apply");
        closeButton.setActionCommand("apply");
        closeButton.addActionListener(this);
        buttons.add(closeButton);
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("ok");
        okButton.addActionListener(this);
        buttons.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(this);
        buttons.add(cancelButton);
        JButton helpButton = new JButton("Get help");
        helpButton.setActionCommand("help");
        helpButton.addActionListener(this);
        buttons.add(helpButton);
        this.add(this.background);
        this.setVisible(true);
    }

    void set_options() {
        OTKit.metr_EOS = this.eos.getText().trim().charAt(0);
        OTKit.metr_BOF = this.bof.getText().trim().charAt(0);
        OTKit.metr_EOF = this.eof.getText().trim().charAt(0);
        OTKit.metr_PRS = this.prs.getText().trim().charAt(0);
        OTKit.metr_SCS = this.scs.getText().trim().charAt(0);
        OTKit.metr_LONG = this.lon.getText().trim().charAt(0);
        OTKit.metr_MORA = this.mor.getText().trim().charAt(0);
        OTKit.metr_SYLL = this.syl.getText().trim().charAt(0);
    }

    public void actionPerformed(ActionEvent evt) {
        String what = evt.getActionCommand();
        if (what.equals("cancel")) {
            this.processEvent(new WindowEvent(this, 201));
        }
        if (what.equals("apply")) {
            this.set_options();
        }
        if (what.equals("ok")) {
            this.set_options();
            this.processEvent(new WindowEvent(this, 201));
        }
        if (what.equals("help")) {
            OTKit.help(this.helpText);
        }
    }

    public static final MetricalStress newMetricalStress() {
        MetricalStress G = new MetricalStress();
        G.EOS = OTKit.metr_EOS;
        G.BOF = OTKit.metr_BOF;
        G.EOF = OTKit.metr_EOF;
        G.PRS = OTKit.metr_PRS;
        G.SCS = OTKit.metr_SCS;
        G.LONG = OTKit.metr_LONG;
        G.MORA = OTKit.metr_MORA;
        G.SYLL = OTKit.metr_SYLL;
        return G;
    }

    public static final MetricalStress newMetricalStress(char[] vowels, char[] consonants) {
        MetricalStress G = new MetricalStress(vowels, consonants);
        G.EOS = OTKit.metr_EOS;
        G.BOF = OTKit.metr_BOF;
        G.EOF = OTKit.metr_EOF;
        G.PRS = OTKit.metr_PRS;
        G.SCS = OTKit.metr_SCS;
        G.LONG = OTKit.metr_LONG;
        G.MORA = OTKit.metr_MORA;
        G.SYLL = OTKit.metr_SYLL;
        return G;
    }
}

