/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.userInterface;

import hu.birot.OTKit.uiMyElements.MyCandidate;
import hu.birot.OTKit.uiMyElements.MyConstraint;
import hu.birot.OTKit.uiMyElements.MyElement;
import hu.birot.OTKit.uiMyElements.MyForm;
import hu.birot.OTKit.uiMyElements.MyGen;
import hu.birot.OTKit.uiMyElements.MyHierarchy;
import hu.birot.OTKit.uiMyElements.MyTable;
import hu.birot.OTKit.uiMyElements.Universe;
import hu.birot.OTKit.userInterface.FrameDefineCandidate;
import hu.birot.OTKit.userInterface.FrameDefineConstr;
import hu.birot.OTKit.userInterface.FrameDefineForm;
import hu.birot.OTKit.userInterface.FrameDefineGen;
import hu.birot.OTKit.userInterface.FrameDefineHierarchy;
import hu.birot.OTKit.userInterface.FrameDefineTable;
import hu.birot.OTKit.userInterface.OTKFrame;
import hu.birot.OTKit.userInterface.OTKit;
import hu.birot.OTKit.userInterface.OTKit_GUI;
import hu.birot.OTKit.userInterface.XMLstuff;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FrameOrganizeUniverse
extends OTKFrame
implements ItemListener {
    public String scriptinfo = "";
    private static final long serialVersionUID = 1L;
    Universe U = OTKit.MyUniverse;
    JPanel list = new JPanel();
    public HashMap<MyElement, JCheckBox> cb_hash = new HashMap();
    public Vector<MyElement> chosen = new Vector();
    public OTKFrame target = null;
    public String tag_type = null;
    static final int all_height = 400;
    static final int but_height = 100;
    static final int width = 600;

    public FrameOrganizeUniverse(Universe Univ) {
        super(620, 550, "Organize and save " + Univ.name);
        JButton saveButton;
        this.U = Univ;
        this.background.add(new JLabel("Elements in " + this.U.name() + ":", 2));
        JScrollPane jScrollPane1 = new JScrollPane(this.list);
        this.background.add(jScrollPane1);
        this.list.setLayout(new GridLayout(0, 2, 10, 10));
        this.list.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.refreshList();
        this.background.add(new JLabel(" "));
        JPanel buttons = new JPanel();
        buttons.setMaximumSize(new Dimension(600, 100));
        buttons.setLayout(new GridLayout(0, 2, 10, 10));
        this.background.add(buttons);
        JButton selButton = new JButton("Select all");
        selButton.setActionCommand("select_all");
        selButton.addActionListener(this);
        selButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(selButton);
        JButton deselButton = new JButton("Deselect all");
        deselButton.setActionCommand("deselect_all");
        deselButton.addActionListener(this);
        deselButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(deselButton);
        JButton removeButton = new JButton("Remove selected from " + Univ.name);
        removeButton.setActionCommand("remove");
        removeButton.addActionListener(this);
        removeButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(removeButton);
        if (this.U == OTKit.MyUniverse) {
            saveButton = new JButton("Save selected to file");
            saveButton.setActionCommand("save");
            saveButton.addActionListener(this);
            saveButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            buttons.add(saveButton);
        } else {
            saveButton = new JButton("Move selected to MyUniverse");
            saveButton.setActionCommand("save_to_my");
            saveButton.addActionListener(this);
            saveButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            buttons.add(saveButton);
        }
        JButton okButton = new JButton("Close window");
        okButton.setActionCommand("close");
        okButton.addActionListener(this);
        okButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(okButton);
        JButton refreshButton = new JButton("Refresh window");
        refreshButton.setActionCommand("refresh");
        refreshButton.addActionListener(this);
        refreshButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttons.add(refreshButton);
        this.add(this.background);
        this.setVisible(true);
    }

    protected void refreshList() {
        this.list.removeAll();
        this.cb_hash.clear();
        int i = 1;
        while (i < Universe.tags.length) {
            String tag = Universe.tags[i];
            if (this.tag_type == null || this.tag_type.equals(tag)) {
                HashMap<String, ?> hash = this.U.tag2hash(tag);
                Object[] indexes = hash.keySet().toArray(new String[hash.keySet().size()]);
                Arrays.sort(indexes);
                Object[] objectArray = indexes;
                int n = indexes.length;
                int n2 = 0;
                while (n2 < n) {
                    Object index = objectArray[n2];
                    MyElement me = (MyElement)hash.get(index);
                    JPanel left = new JPanel();
                    left.setLayout(new FlowLayout(0));
                    JCheckBox cb = new JCheckBox();
                    this.cb_hash.put(me, cb);
                    cb.addItemListener(this);
                    left.add(cb);
                    left.add(new JLabel(String.valueOf(tag.replaceAll("my_", "")) + " " + me.name()));
                    JButton jb = new JButton("view / edit");
                    jb.setActionCommand(String.valueOf(tag) + ":" + me.name());
                    jb.addActionListener(this);
                    JPanel right = new JPanel();
                    right.setMaximumSize(new Dimension(70, 10));
                    right.add(jb);
                    this.list.add(left);
                    this.list.add(right);
                    ++n2;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 6 - this.cb_hash.size()) {
            this.list.add(new JPanel());
            this.list.add(new JPanel());
            ++i;
        }
        this.list.repaint();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent evt) {
        String what = evt.getActionCommand();
        if (what.equals("close")) {
            this.processEvent(new WindowEvent(this, 201));
        } else if (what.equals("refresh")) {
            this.refreshList();
        } else if (what.equals("select_all")) {
            for (MyElement me : this.cb_hash.keySet()) {
                this.cb_hash.get(me).setSelected(true);
                this.chosen.remove(me);
                this.chosen.add(me);
            }
        } else if (what.equals("deselect_all")) {
            for (MyElement me : this.cb_hash.keySet()) {
                this.cb_hash.get(me).setSelected(false);
                this.chosen.remove(me);
            }
        } else if (what.equals("remove")) {
            Vector<MyElement> ch = new Vector<MyElement>();
            String script = "";
            for (MyElement o : this.chosen) {
                ch.add(o);
            }
            for (MyElement o : ch) {
                this.chosen.remove(o);
                if (this.U != OTKit.TrashUniverse) {
                    OTKit.TrashUniverse.tag2hash(o.tag()).remove(o.name());
                    OTKit.TrashUniverse.tag2hash(o.tag()).put(o.name(), o);
                }
                if (this.U.tag2hash(o.tag()).remove(o.name()) == null) continue;
                OTKit_GUI.printText(String.valueOf(o.name()) + " removed from " + this.U.name);
                script = String.valueOf(script) + ", " + o.shortScript();
            }
            this.refreshList();
            String h = "remove_from_MyUniverse( " + script.substring(1) + "  )";
            if (this.U == OTKit.MyUniverse) {
                OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                OTKit_GUI.printText("> " + h);
            }
        } else if (what.equals("save")) {
            Universe U2 = new Universe("saved elements from " + this.U.name);
            String short_script = "";
            for (MyElement o : this.chosen) {
                U2.tag2hash(o.tag()).put(o.name(), o);
                short_script = String.valueOf(short_script) + ", " + o.shortScript();
            }
            String f = OTKit_GUI.printToFile(XMLstuff.xml2string(U2.toXML()), "Save as universe", XMLstuff.xmlfilter);
            if (f != null) {
                OTKit_GUI.printText("Chosen elements successfully saved to file.");
                String h = "save( \"" + f.replace('\\', '/') + "\"" + short_script + " )";
                OTKit.history = String.valueOf(OTKit.history) + h + "\n";
                OTKit_GUI.printText("> " + h);
            }
        } else if (what.equals("save_to_my")) {
            Vector<MyElement> ch = new Vector<MyElement>();
            String long_script = "";
            String short_script = "";
            for (MyElement o : this.chosen) {
                ch.add(o);
            }
            for (MyElement o : ch) {
                this.chosen.remove(o);
                if (this.U != OTKit.TrashUniverse && OTKit.MyUniverse.tag2hash(o.tag()).keySet().contains(o.name())) {
                    o.removeMeFromHash(OTKit.TrashUniverse);
                    o.addMeToHash(OTKit.TrashUniverse);
                    OTKit.error("Older " + o.name() + " found in MyUniverse: moved to TrashUniverse.");
                }
                o.removeMeFromHash(this.U);
                o.removeMeFromHash(OTKit.MyUniverse);
                o.addMeToHash(OTKit.MyUniverse);
                OTKit_GUI.printText(String.valueOf(o.name()) + " moved to MyUniverse.");
                long_script = String.valueOf(long_script) + ", " + o.longScript();
                short_script = String.valueOf(short_script) + ", " + o.shortScript();
            }
            String h = "add2MyUniverse( " + long_script.substring(1) + " )";
            if (this.scriptinfo != "") {
                h = String.valueOf(h) + "\n" + this.scriptinfo.replace(")", String.valueOf(short_script) + " )");
            }
            OTKit.history = String.valueOf(OTKit.history) + h + "\n";
            OTKit_GUI.printText("> " + h);
            this.refreshList();
        } else if (what.startsWith("my_constraint:")) {
            MyConstraint cc = this.U.MyConstraints.get(what.subSequence("my_constraint:".length(), what.length()));
            if (this.target == null) {
                FrameDefineConstr newconstrframe = new FrameDefineConstr(cc);
                newconstrframe.myc = cc;
                newconstrframe.update();
            } else {
                ((FrameDefineConstr)this.target).myc = cc;
                ((FrameDefineConstr)this.target).update();
            }
        } else if (what.startsWith("hierarchy:")) {
            MyHierarchy hh = this.U.MyHierarchies.get(what.subSequence("hierarchy:".length(), what.length()));
            if (this.target == null) {
                FrameDefineHierarchy newhierarchyframe = new FrameDefineHierarchy(hh);
                newhierarchyframe.myh = hh;
                newhierarchyframe.update();
            } else {
                ((FrameDefineHierarchy)this.target).myh = hh;
                ((FrameDefineHierarchy)this.target).update();
            }
        } else if (what.startsWith("my_candidate:")) {
            MyCandidate cc = this.U.MyCandidates.get(what.subSequence("my_candidate:".length(), what.length()));
            if (this.target == null) {
                FrameDefineCandidate newcandidateframe = new FrameDefineCandidate(cc);
                newcandidateframe.myc = cc;
                newcandidateframe.update();
            } else {
                ((FrameDefineCandidate)this.target).myc = cc;
                ((FrameDefineCandidate)this.target).update();
            }
        } else if (what.startsWith("my_form:")) {
            MyForm ff = this.U.MyForms.get(what.subSequence("my_form:".length(), what.length()));
            if (this.target == null) {
                FrameDefineForm newformframe = new FrameDefineForm(ff);
                newformframe.myf = ff;
                newformframe.update();
            } else {
                ((FrameDefineForm)this.target).myf = ff;
                ((FrameDefineForm)this.target).update();
            }
        } else if (what.startsWith("table:")) {
            MyTable ff = this.U.MyTables.get(what.subSequence("table:".length(), what.length()));
            if (this.target == null) {
                FrameDefineTable newframe = new FrameDefineTable(ff);
            } else {
                ((FrameDefineTable)this.target).my = ff;
                ((FrameDefineTable)this.target).update();
            }
        } else if (what.startsWith("my_gen:")) {
            MyGen ff = this.U.MyGens.get(what.subSequence("my_gen:".length(), what.length()));
            if (this.target == null) {
                FrameDefineGen newframe = new FrameDefineGen(ff);
            } else {
                ((FrameDefineGen)this.target).my = ff;
                ((FrameDefineGen)this.target).update();
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        MyElement source = null;
        for (MyElement me : this.cb_hash.keySet()) {
            if (this.cb_hash.get(me) != e.getItemSelectable()) continue;
            source = me;
        }
        if (e.getStateChange() == 1) {
            this.chosen.add(source);
        } else {
            this.chosen.remove(source);
        }
    }
}

