/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.userInterface;

import hu.birot.OTKit.uiMyElements.Universe;
import hu.birot.OTKit.userInterface.Impressum;
import hu.birot.OTKit.userInterface.OTKit_GUI;
import hu.birot.OTKit.userInterface.OTKit_script;
import hu.birot.OTKit.userInterface.XMLstuff;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JOptionPane;

public class OTKit {
    public static String history = "";
    public static Universe MyUniverse = new Universe("MyUniverse");
    public static Universe TrashUniverse = new Universe("TrashUniverse");
    public static String defaultDirectory = "";
    public static String separator = "&";
    public static String end_of_row = "";
    public static String hand_symbol = "==>";
    public static String bang = "!";
    public static char metr_EOS = (char)46;
    public static char metr_SYLL = (char)963;
    public static char metr_BOF = (char)91;
    public static char metr_EOF = (char)93;
    public static char metr_PRS = (char)49;
    public static char metr_SCS = (char)50;
    public static char metr_LONG = (char)58;
    public static char metr_MORA = (char)181;
    public static final String welcome_text = " \n\n Welcome to OTKit version 1.2.0.\n\nTo get more information type: help()\n\n";
    public static boolean gui = false;
    private static final String commandlinehelp = "  OTKit: Tools for Optimality Theory \nUsage:\nWithout arguments:\n  java -jar OTKit.jar               \t starts graphical user interface.\nWith arguments: user interface not launched, unless argument -u is used.\n  java -jar OTKit.jar  -h           \t gets this help.\n  java -jar OTKit.jar  -v           \t gets version number.\n  java -jar OTKit.jar  -s filename  \t executes script file.\n  java -jar OTKit.jar  -l filename  \t loads universe file (OTKit XML format).\n  java -jar OTKit.jar  -u           \t launches graphical user interface.\n  java -jar OTKit.jar  -S           \t gets overview of scripting language.\nFor example, to load a universe file, execute two scripts and then launch \nthe user interface:\n  java -jar OTKit.jar -l universe1.xml -s script1.txt -s script2.txt -u\n\n";

    public static void main(String[] args) {
        if (args.length == 0) {
            gui = true;
            OTKit_GUI mainframe = new OTKit_GUI("OTKit");
        } else {
            int i = 0;
            while (i < args.length) {
                String t;
                BufferedReader reader;
                File file;
                StringBuffer contents;
                String s = args[i];
                if (s.equals("-v")) {
                    System.out.println("Version: 1.2.0");
                } else if (s.equals("-l") && args.length > i + 1) {
                    contents = new StringBuffer();
                    try {
                        file = new File(args[i + 1]);
                        reader = new BufferedReader(new FileReader(file));
                        t = null;
                        while ((t = reader.readLine()) != null) {
                            contents.append(t).append(System.getProperty("line.separator"));
                        }
                    }
                    catch (FileNotFoundException e) {
                        OTKit.return_err("Error loading file " + args[i + 1] + ": " + e.getMessage());
                    }
                    catch (IOException e) {
                        OTKit.return_err("Error loading file " + args[i + 1] + ": " + e.getMessage());
                    }
                    MyUniverse.fromXML(XMLstuff.string2xml(contents.toString()));
                    ++i;
                } else if (s.equals("-s") && args.length > i + 1) {
                    contents = new StringBuffer();
                    try {
                        file = new File(args[i + 1]);
                        reader = new BufferedReader(new FileReader(file));
                        t = null;
                        while ((t = reader.readLine()) != null) {
                            contents.append(t).append(System.getProperty("line.separator"));
                        }
                    }
                    catch (FileNotFoundException e) {
                        OTKit.return_err("Error at executing script " + args[i + 1] + ":" + e.getMessage());
                    }
                    catch (IOException e) {
                        OTKit.return_err("Error at executing script " + args[i + 1] + ":" + e.getMessage());
                    }
                    new OTKit_script().execScript(contents.toString());
                    ++i;
                } else if (s.equals("-u")) {
                    gui = true;
                    OTKit_GUI mainframe = new OTKit_GUI("OTKit");
                } else if (s.equals("-h") || s.equals("-help") || s.equals("--help")) {
                    System.out.println(commandlinehelp);
                } else if (s.equals("-S") || s.equals("-help") || s.equals("--help")) {
                    System.out.println("\n Help for OTKit scripting: \n\n Commands:\n    help():              \t returns basic help.\n    exit():                \t quits OTKit.\n    print(t):            \t\t prints text t to the output.\n    history():           \t prints history of commands.\n    include(f):          \t executes the content of script file f at this point. Here f is a filename (optionally with path).\n    universe():          \t prints everything that is in MyUniverse.\n    add2MyUniverse(e1,..., en): \t adds e1,... and en to MyUniverse, where e1,..., en are expressions (see below).\n    remove_from_MyUniverse(e1,..., en):   remove expressions e1,... and en from MyUniverse.\n    clear_MyUniverse():  \t make MyUniverse empty.\n    load(f):             \t loads the content of XML file f to MyUniverse. Here f is a filename (optionally with path) or a url.\n    load(f, e1,..., en): \t loads elements/expressions e1, ..., en from XML file (or url) f to MyUniverse. Elements in f \n                         \t\t whose name coincides with the name of e1,... or en will be loaded.\n    save(f):             \t saves MyUniverse to file f, where f is a filename (optionally with path; in Windows, use / or \\\\).\n    save(f, e1,..., en): \t saves elements/expressions e1, ..., en to file f, where f is a filename (optionally with path).\n    value(con, cand):    \t applies constraint con to candidate can.\n    grammatical_outputs(u, g, h): generates the grammatical output[s] (candidate[s]) corresponding to underlying form u,\n                         \t\t Gen function g and hierarchy h.\n    grammatical_outputs(u, g, h, n): generates the grammatical output[s] (candidate[s]) corresponding to underlying form u,\n                         \t\t Gen function g and hierarchy h. At most the first n elements of the candidate set are considered.\n    draw_tableau(u, g, h): \t generates the tableau corresponding to underlying form u,\n                         \t\t Gen function g and hierarchy h.\n    draw_tableau(u, g, h, n): \t generates the tableau corresponding to underlying form u,\n                         \t\t Gen function g and hierarchy h. At most the first n elements of the candidate set are considered.\n    is_grammatical(c, g, h): \t check if candidate c is grammatical (most harmonic) with respect to Gen function g and hierarchy h.\n    is_grammatical(c, g, h, n): check if candidate c is grammatical (most harmonic) with respect to Gen function g and hierarchy h.\n                         \t\t At most the first n elements of the candidate set are considered.\n    full_language(b, [nr_u,] g, [nr_c,] h): generates full language for base b, Gen function g and hierarchy h.\n                         \t\t Parameters nr_u (number of underlying forms) and nr_c (number of candidates) are optional, but \n                         \t\t required (correspondingly) if the base and/or the gen maps unto an infinite set.\n    factorial_typology(f, g, [nr,] h [, fixed, apr, ignore n, verbose, collectAll, add2myu]): generates factorial typology for \n                         \t\t underlying form f, Gen function g and hierarchy h. Optional third parameter nr is the\n                         \t\t number of candidates to be considered (compulsory if the candidate set by f and g is\n                         \t\t infinite). The following optional arguments may follow the last mandatory argument,\n                         \t\t h, in any particular order: a fixed hierarchy; an apriori table apr; the string\n                         \t\t 'ignore n', where n is a number; the string 'verbose', to return the winning candidates\n                         \t\t for every hierarchy; the string 'collectAll' to return all hierarchies per winning\n                         \t\t candidate; and the string 'add2myu' to add all reported hierarchies to MyUniverse.\n                         \t\t For more details, see the help of the window 'factorial typology'.\n\n Expressions:\n    Candidate(n):       \t candidate in MyUniverse whose name is n.\n    Candidate(n, s, p1,..., pn): \t create a new candidate whose name will be n,\n                        \t\t and whose scheme is s (check the spelling!). The number of parameters\n                        \t\t p1,..., pn is defined by the scheme.\n    Cand(str):  \t\t candidate with both name and surface form being string str (underlying form is empty form).\n    Constraint(n):       \t constraint in MyUniverse whose name is n.\n    Constraint(n, s, p1,..., pn, sd, ld):  create a new constraint whose name will be n,\n                        \t\t and whose scheme is s (check the spelling!). The number of parameters\n                        \t\t p1,..., pn is defined by the scheme. Long description ld is optional,\n                        \t\t as is short description sd (unless long description is specified).\n    Form(n): \t\t form in MyUniverse whose name is n.\n    Form(n, s, p1,..., pn):  \t create a new form whose name will be n,\n                        \t\t and whose scheme is s (check the spelling!). The number of parameters\n                        \t\t p1,..., pn is defined by the scheme.\n    Hierarchy(n):       \t hierarchy in MyUniverse whose name is n.\n    Gen(n):             \t Gen in MyUniverse whose name is n.\n    Gen(n, s, p1,..., pn): \t create a new Gen whose name will be n,\n                        \t\t and whose scheme is s (check the spelling!). The number of parameters\n                        \t\t p1,..., pn is defined by the scheme.\n    Table(n):           \t table in MyUniverse whose name is n.\n    Table(n, r, c, (x11,...,x1c), (x21,...,x2c),...(xr1,...,xrc)): create a table with name n. Number of rows is r,\n                        \t\t number of columns is c. Value of each row is put in parenthesis. If there are too\n                        \t\t few rows, or too few cells in a row, the rest is filled in with empty strings.\n\n Everything after a # in a line is a comment.");
                } else {
                    System.out.println("For help: java -jar OTKit.jar -h");
                }
                ++i;
            }
            if (!gui) {
                System.exit(0);
            }
        }
        try {
            if (!OTKit_GUI.read_f(Impressum.latestVersion).toString().contains("1.2.0")) {
                OTKit.warning("New version of OTKit available on website\n" + Impressum.urlWebsite);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void error(String s) {
        System.err.println(s);
        if (gui) {
            JOptionPane.showMessageDialog(null, s, "OTKit error", 0);
        }
    }

    public static void warning(String s) {
        System.err.println(s);
        if (gui) {
            JOptionPane.showMessageDialog(null, s, "OTKit warning", 2);
        }
    }

    public static void return_err(String s) {
        System.err.println("Error: " + s);
        if (gui) {
            OTKit_GUI.printText("!! " + s);
        }
    }

    public static void return_out(String s) {
        System.out.println(s);
        if (gui) {
            OTKit_GUI.printText(s);
        }
    }

    public static void help(String s) {
        if (gui) {
            OTKit_GUI.printText(s);
        } else {
            System.out.println(s);
        }
    }
}

