/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.userInterface;

import hu.birot.OTKit.uiMyElements.MyCandidate;
import hu.birot.OTKit.uiMyElements.MyConstraint;
import hu.birot.OTKit.uiMyElements.MyElement;
import hu.birot.OTKit.uiMyElements.MyForm;
import hu.birot.OTKit.uiMyElements.MyGen;
import hu.birot.OTKit.uiMyElements.MyHierarchy;
import hu.birot.OTKit.uiMyElements.MyTable;
import hu.birot.OTKit.uiMyElements.Scheme_cand;
import hu.birot.OTKit.uiMyElements.Scheme_constr;
import hu.birot.OTKit.uiMyElements.Scheme_form;
import hu.birot.OTKit.uiMyElements.Scheme_gen;
import hu.birot.OTKit.uiMyElements.Universe;
import hu.birot.OTKit.userInterface.FrameActionFactorialTypology;
import hu.birot.OTKit.userInterface.FrameActionFullLanguage;
import hu.birot.OTKit.userInterface.FrameActionGrJudgm;
import hu.birot.OTKit.userInterface.FrameActionGrammatical;
import hu.birot.OTKit.userInterface.OTKit;
import hu.birot.OTKit.userInterface.XMLstuff;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTKit_script {
    public String output = "";
    public String error = "";
    public boolean error_returned_continuously = true;
    public boolean ouptut_returned_continuously = true;
    public static final String help = "\n Help for OTKit: \n\n    help():         \t returns basic help\n    help(GUI):      \t returns help on using the graphical interface\n    help(script):   \t returns help on scripting\n    help(schemes):  \t returns help on the schemes used for forms, candidates, constraints and gens.\n";
    public static final String help_scr = "\n Help for OTKit scripting: \n\n Commands:\n    help():              \t returns basic help.\n    exit():                \t quits OTKit.\n    print(t):            \t\t prints text t to the output.\n    history():           \t prints history of commands.\n    include(f):          \t executes the content of script file f at this point. Here f is a filename (optionally with path).\n    universe():          \t prints everything that is in MyUniverse.\n    add2MyUniverse(e1,..., en): \t adds e1,... and en to MyUniverse, where e1,..., en are expressions (see below).\n    remove_from_MyUniverse(e1,..., en):   remove expressions e1,... and en from MyUniverse.\n    clear_MyUniverse():  \t make MyUniverse empty.\n    load(f):             \t loads the content of XML file f to MyUniverse. Here f is a filename (optionally with path) or a url.\n    load(f, e1,..., en): \t loads elements/expressions e1, ..., en from XML file (or url) f to MyUniverse. Elements in f \n                         \t\t whose name coincides with the name of e1,... or en will be loaded.\n    save(f):             \t saves MyUniverse to file f, where f is a filename (optionally with path; in Windows, use / or \\\\).\n    save(f, e1,..., en): \t saves elements/expressions e1, ..., en to file f, where f is a filename (optionally with path).\n    value(con, cand):    \t applies constraint con to candidate can.\n    grammatical_outputs(u, g, h): generates the grammatical output[s] (candidate[s]) corresponding to underlying form u,\n                         \t\t Gen function g and hierarchy h.\n    grammatical_outputs(u, g, h, n): generates the grammatical output[s] (candidate[s]) corresponding to underlying form u,\n                         \t\t Gen function g and hierarchy h. At most the first n elements of the candidate set are considered.\n    draw_tableau(u, g, h): \t generates the tableau corresponding to underlying form u,\n                         \t\t Gen function g and hierarchy h.\n    draw_tableau(u, g, h, n): \t generates the tableau corresponding to underlying form u,\n                         \t\t Gen function g and hierarchy h. At most the first n elements of the candidate set are considered.\n    is_grammatical(c, g, h): \t check if candidate c is grammatical (most harmonic) with respect to Gen function g and hierarchy h.\n    is_grammatical(c, g, h, n): check if candidate c is grammatical (most harmonic) with respect to Gen function g and hierarchy h.\n                         \t\t At most the first n elements of the candidate set are considered.\n    full_language(b, [nr_u,] g, [nr_c,] h): generates full language for base b, Gen function g and hierarchy h.\n                         \t\t Parameters nr_u (number of underlying forms) and nr_c (number of candidates) are optional, but \n                         \t\t required (correspondingly) if the base and/or the gen maps unto an infinite set.\n    factorial_typology(f, g, [nr,] h [, fixed, apr, ignore n, verbose, collectAll, add2myu]): generates factorial typology for \n                         \t\t underlying form f, Gen function g and hierarchy h. Optional third parameter nr is the\n                         \t\t number of candidates to be considered (compulsory if the candidate set by f and g is\n                         \t\t infinite). The following optional arguments may follow the last mandatory argument,\n                         \t\t h, in any particular order: a fixed hierarchy; an apriori table apr; the string\n                         \t\t 'ignore n', where n is a number; the string 'verbose', to return the winning candidates\n                         \t\t for every hierarchy; the string 'collectAll' to return all hierarchies per winning\n                         \t\t candidate; and the string 'add2myu' to add all reported hierarchies to MyUniverse.\n                         \t\t For more details, see the help of the window 'factorial typology'.\n\n Expressions:\n    Candidate(n):       \t candidate in MyUniverse whose name is n.\n    Candidate(n, s, p1,..., pn): \t create a new candidate whose name will be n,\n                        \t\t and whose scheme is s (check the spelling!). The number of parameters\n                        \t\t p1,..., pn is defined by the scheme.\n    Cand(str):  \t\t candidate with both name and surface form being string str (underlying form is empty form).\n    Constraint(n):       \t constraint in MyUniverse whose name is n.\n    Constraint(n, s, p1,..., pn, sd, ld):  create a new constraint whose name will be n,\n                        \t\t and whose scheme is s (check the spelling!). The number of parameters\n                        \t\t p1,..., pn is defined by the scheme. Long description ld is optional,\n                        \t\t as is short description sd (unless long description is specified).\n    Form(n): \t\t form in MyUniverse whose name is n.\n    Form(n, s, p1,..., pn):  \t create a new form whose name will be n,\n                        \t\t and whose scheme is s (check the spelling!). The number of parameters\n                        \t\t p1,..., pn is defined by the scheme.\n    Hierarchy(n):       \t hierarchy in MyUniverse whose name is n.\n    Gen(n):             \t Gen in MyUniverse whose name is n.\n    Gen(n, s, p1,..., pn): \t create a new Gen whose name will be n,\n                        \t\t and whose scheme is s (check the spelling!). The number of parameters\n                        \t\t p1,..., pn is defined by the scheme.\n    Table(n):           \t table in MyUniverse whose name is n.\n    Table(n, r, c, (x11,...,x1c), (x21,...,x2c),...(xr1,...,xrc)): create a table with name n. Number of rows is r,\n                        \t\t number of columns is c. Value of each row is put in parenthesis. If there are too\n                        \t\t few rows, or too few cells in a row, the rest is filled in with empty strings.\n\n Everything after a # in a line is a comment.";
    public static final String help_GUI = "\n Quick help on using the OTKit graphical interface: \n\nFirst, add elements to MyUniverse. Then, run experiments with them. Elements include forms, candidates, constraints, hierarchies, Gen functions, etc.\n\nTo fill MyUniverse, use the options under the 'Define' menu. Alternatively, load previously defined and saved elements. If this is the first time you play with OTKit, you can also load an example universe (in the 'Help' menu).\n\nUse 'Organize & Save' to edit, delete or save (to file) elements in MyUniverse. Each element has a name. If you introduce a new element with the name of an already existing one (of the same type), then the old one is moved to 'TrashUniverse'; that is also where you will find deleted elements. The 'MyUniverse' menu also includes a function to view elements in the TrashUniverse (and to move them back to MyUniverse), beside a function to save the whole of MyUniverse into an (XML) file.\n\nOnce all your elements are defined or loaded into MyUniverse, you can start working with them. The 'Competence' and 'Actions' menus include an increasing number of tools to do so.\n\nAlmost everything you do (e.g., creating elements, running experiments) is noted in the 'history'. Saving the history (cf. the 'File' menu) creates a script file. The history -- and similarly, other script files -- can be loaded and executed (also within the 'File' menu). Note that the development of the script language lags behind other functionalities of OTKit.\n\nThe content of this main communication panel (the 'output', because it also includes the output of the experiments) can also be saved to a text file, which can be edited afterwards.\n\nEach (most) popup windows will include a button that provides more help.";

    public boolean execCommand(String str) {
        boolean ok = true;
        String s = str.trim();
        OTKit.history = String.valueOf(OTKit.history) + s + "\n";
        String[] splitted = s.split("#");
        if (splitted.length != 0 && !(s = splitted[0]).isEmpty() && !(s = s.trim()).isEmpty()) {
            Vector<String> par = this.parse(s);
            if (par == null || par.size() == 0) {
                ok = false;
            } else if (par.get(0).equals("exit")) {
                System.exit(0);
            } else if (par.get(0).equals("help")) {
                if (par.get(1).equals("")) {
                    this.output = String.valueOf(this.output) + "\n Help for OTKit: \n\n    help():         \t returns basic help\n    help(GUI):      \t returns help on using the graphical interface\n    help(script):   \t returns help on scripting\n    help(schemes):  \t returns help on the schemes used for forms, candidates, constraints and gens.\n\n";
                } else if (par.get(1).equalsIgnoreCase("script")) {
                    this.output = String.valueOf(this.output) + "\n Help for OTKit scripting: \n\n Commands:\n    help():              \t returns basic help.\n    exit():                \t quits OTKit.\n    print(t):            \t\t prints text t to the output.\n    history():           \t prints history of commands.\n    include(f):          \t executes the content of script file f at this point. Here f is a filename (optionally with path).\n    universe():          \t prints everything that is in MyUniverse.\n    add2MyUniverse(e1,..., en): \t adds e1,... and en to MyUniverse, where e1,..., en are expressions (see below).\n    remove_from_MyUniverse(e1,..., en):   remove expressions e1,... and en from MyUniverse.\n    clear_MyUniverse():  \t make MyUniverse empty.\n    load(f):             \t loads the content of XML file f to MyUniverse. Here f is a filename (optionally with path) or a url.\n    load(f, e1,..., en): \t loads elements/expressions e1, ..., en from XML file (or url) f to MyUniverse. Elements in f \n                         \t\t whose name coincides with the name of e1,... or en will be loaded.\n    save(f):             \t saves MyUniverse to file f, where f is a filename (optionally with path; in Windows, use / or \\\\).\n    save(f, e1,..., en): \t saves elements/expressions e1, ..., en to file f, where f is a filename (optionally with path).\n    value(con, cand):    \t applies constraint con to candidate can.\n    grammatical_outputs(u, g, h): generates the grammatical output[s] (candidate[s]) corresponding to underlying form u,\n                         \t\t Gen function g and hierarchy h.\n    grammatical_outputs(u, g, h, n): generates the grammatical output[s] (candidate[s]) corresponding to underlying form u,\n                         \t\t Gen function g and hierarchy h. At most the first n elements of the candidate set are considered.\n    draw_tableau(u, g, h): \t generates the tableau corresponding to underlying form u,\n                         \t\t Gen function g and hierarchy h.\n    draw_tableau(u, g, h, n): \t generates the tableau corresponding to underlying form u,\n                         \t\t Gen function g and hierarchy h. At most the first n elements of the candidate set are considered.\n    is_grammatical(c, g, h): \t check if candidate c is grammatical (most harmonic) with respect to Gen function g and hierarchy h.\n    is_grammatical(c, g, h, n): check if candidate c is grammatical (most harmonic) with respect to Gen function g and hierarchy h.\n                         \t\t At most the first n elements of the candidate set are considered.\n    full_language(b, [nr_u,] g, [nr_c,] h): generates full language for base b, Gen function g and hierarchy h.\n                         \t\t Parameters nr_u (number of underlying forms) and nr_c (number of candidates) are optional, but \n                         \t\t required (correspondingly) if the base and/or the gen maps unto an infinite set.\n    factorial_typology(f, g, [nr,] h [, fixed, apr, ignore n, verbose, collectAll, add2myu]): generates factorial typology for \n                         \t\t underlying form f, Gen function g and hierarchy h. Optional third parameter nr is the\n                         \t\t number of candidates to be considered (compulsory if the candidate set by f and g is\n                         \t\t infinite). The following optional arguments may follow the last mandatory argument,\n                         \t\t h, in any particular order: a fixed hierarchy; an apriori table apr; the string\n                         \t\t 'ignore n', where n is a number; the string 'verbose', to return the winning candidates\n                         \t\t for every hierarchy; the string 'collectAll' to return all hierarchies per winning\n                         \t\t candidate; and the string 'add2myu' to add all reported hierarchies to MyUniverse.\n                         \t\t For more details, see the help of the window 'factorial typology'.\n\n Expressions:\n    Candidate(n):       \t candidate in MyUniverse whose name is n.\n    Candidate(n, s, p1,..., pn): \t create a new candidate whose name will be n,\n                        \t\t and whose scheme is s (check the spelling!). The number of parameters\n                        \t\t p1,..., pn is defined by the scheme.\n    Cand(str):  \t\t candidate with both name and surface form being string str (underlying form is empty form).\n    Constraint(n):       \t constraint in MyUniverse whose name is n.\n    Constraint(n, s, p1,..., pn, sd, ld):  create a new constraint whose name will be n,\n                        \t\t and whose scheme is s (check the spelling!). The number of parameters\n                        \t\t p1,..., pn is defined by the scheme. Long description ld is optional,\n                        \t\t as is short description sd (unless long description is specified).\n    Form(n): \t\t form in MyUniverse whose name is n.\n    Form(n, s, p1,..., pn):  \t create a new form whose name will be n,\n                        \t\t and whose scheme is s (check the spelling!). The number of parameters\n                        \t\t p1,..., pn is defined by the scheme.\n    Hierarchy(n):       \t hierarchy in MyUniverse whose name is n.\n    Gen(n):             \t Gen in MyUniverse whose name is n.\n    Gen(n, s, p1,..., pn): \t create a new Gen whose name will be n,\n                        \t\t and whose scheme is s (check the spelling!). The number of parameters\n                        \t\t p1,..., pn is defined by the scheme.\n    Table(n):           \t table in MyUniverse whose name is n.\n    Table(n, r, c, (x11,...,x1c), (x21,...,x2c),...(xr1,...,xrc)): create a table with name n. Number of rows is r,\n                        \t\t number of columns is c. Value of each row is put in parenthesis. If there are too\n                        \t\t few rows, or too few cells in a row, the rest is filled in with empty strings.\n\n Everything after a # in a line is a comment.\n";
                } else if (par.get(1).equalsIgnoreCase("GUI")) {
                    this.output = String.valueOf(this.output) + "\n Quick help on using the OTKit graphical interface: \n\nFirst, add elements to MyUniverse. Then, run experiments with them. Elements include forms, candidates, constraints, hierarchies, Gen functions, etc.\n\nTo fill MyUniverse, use the options under the 'Define' menu. Alternatively, load previously defined and saved elements. If this is the first time you play with OTKit, you can also load an example universe (in the 'Help' menu).\n\nUse 'Organize & Save' to edit, delete or save (to file) elements in MyUniverse. Each element has a name. If you introduce a new element with the name of an already existing one (of the same type), then the old one is moved to 'TrashUniverse'; that is also where you will find deleted elements. The 'MyUniverse' menu also includes a function to view elements in the TrashUniverse (and to move them back to MyUniverse), beside a function to save the whole of MyUniverse into an (XML) file.\n\nOnce all your elements are defined or loaded into MyUniverse, you can start working with them. The 'Competence' and 'Actions' menus include an increasing number of tools to do so.\n\nAlmost everything you do (e.g., creating elements, running experiments) is noted in the 'history'. Saving the history (cf. the 'File' menu) creates a script file. The history -- and similarly, other script files -- can be loaded and executed (also within the 'File' menu). Note that the development of the script language lags behind other functionalities of OTKit.\n\nThe content of this main communication panel (the 'output', because it also includes the output of the experiments) can also be saved to a text file, which can be edited afterwards.\n\nEach (most) popup windows will include a button that provides more help.\n";
                } else if (par.get(1).equalsIgnoreCase("schemes")) {
                    this.output = String.valueOf(this.output) + "Form schemes:\n";
                    for (String scheme : Scheme_form.name2scheme.keySet()) {
                        this.output = String.valueOf(this.output) + "  " + scheme + " : " + Scheme_form.name2scheme.get((Object)scheme).nr_param + " parameter(s)\n";
                    }
                    this.output = String.valueOf(this.output) + "\nCandidate schemes:\n";
                    for (String scheme : Scheme_cand.name2scheme.keySet()) {
                        this.output = String.valueOf(this.output) + "  " + scheme + " : " + Scheme_cand.name2scheme.get((Object)scheme).nr_param + " parameter(s)\n";
                    }
                    this.output = String.valueOf(this.output) + "\nConstraint schemes:\n";
                    for (String scheme : Scheme_constr.name2scheme.keySet()) {
                        this.output = String.valueOf(this.output) + "  " + scheme + " : " + Scheme_constr.name2scheme.get((Object)scheme).nr_param + " parameter(s)\n";
                    }
                    this.output = String.valueOf(this.output) + "\nGen schemes:\n";
                    for (String scheme : Scheme_gen.name2scheme.keySet()) {
                        this.output = String.valueOf(this.output) + "  " + scheme + " : " + Scheme_gen.name2scheme.get((Object)scheme).nr_param + " parameter(s)\n";
                    }
                    this.output = String.valueOf(this.output) + "\n";
                } else {
                    this.output = String.valueOf(this.output) + "\n Help for OTKit: \n\n    help():         \t returns basic help\n    help(GUI):      \t returns help on using the graphical interface\n    help(script):   \t returns help on scripting\n    help(schemes):  \t returns help on the schemes used for forms, candidates, constraints and gens.\n\n";
                }
            } else if (par.get(0).equals("history")) {
                this.output = String.valueOf(this.output) + OTKit.history + "\n";
            } else if (par.get(0).equals("print")) {
                this.output = String.valueOf(this.output) + par.get(1) + "\n";
            } else if (par.get(0).equals("include")) {
                if (par.size() <= 1 || par.get(1).equals(null) || par.get(1).equals("")) {
                    OTKit.return_err("Error executing command include: no filename specified");
                    ok = false;
                } else {
                    StringBuffer contents = new StringBuffer();
                    try {
                        File file = new File(par.get(1));
                        BufferedReader reader = new BufferedReader(new FileReader(file));
                        String t = null;
                        while ((t = reader.readLine()) != null) {
                            contents.append(t).append(System.getProperty("line.separator"));
                        }
                    }
                    catch (FileNotFoundException e) {
                        OTKit.return_err("Error at command 'include': " + e.getMessage());
                        ok = false;
                    }
                    catch (IOException e) {
                        OTKit.return_err("Error at command 'include': " + e.getMessage());
                        ok = false;
                    }
                    ok = this.execScript(contents.toString()) && ok;
                }
            } else if (par.get(0).equals("universe")) {
                int i = 1;
                while (i < Universe.tags.length) {
                    for (String name : OTKit.MyUniverse.tag2hash(Universe.tags[i]).keySet()) {
                        this.output = String.valueOf(this.output) + Universe.tags[i] + " " + name + "\n";
                    }
                    ++i;
                }
            } else if (par.get(0).equals("clear_MyUniverse")) {
                OTKit.MyUniverse.clearUniverse();
            } else if (par.get(0).equals("add2MyUniverse")) {
                if (par.size() < 2) {
                    OTKit.return_err("Error executing command add2MyUniverse: at least one argument (a legitimate expression) is required.");
                    ok = false;
                } else {
                    int i = 1;
                    while (i < par.size()) {
                        MyElement me = this.expression(par.get(i));
                        if (me != null) {
                            me.addMeToHash(OTKit.MyUniverse);
                        } else {
                            OTKit.return_err("Error executing command add2MyUniverse: argument '" + par.get(1) + "' is not a legitimate expression.");
                            ok = false;
                        }
                        ++i;
                    }
                }
            } else if (par.get(0).equals("remove_from_MyUniverse")) {
                if (par.size() < 2) {
                    OTKit.return_err("Error executing command remove_from_MyUniverse: at least one argument (a legitimate expression) is required.");
                    ok = false;
                } else {
                    int i = 1;
                    while (i < par.size()) {
                        MyElement me = this.expression(par.get(i));
                        if (me != null) {
                            me.removeMeFromHash(OTKit.MyUniverse);
                        } else {
                            OTKit.return_err("Error executing command remove_from_MyUniverse: argument '" + par.get(1) + "' is not a legitimate expression.");
                            ok = false;
                        }
                        ++i;
                    }
                }
            } else if (par.get(0).equals("save")) {
                if (par.size() <= 1 || par.get(1).equals(null) || par.get(1).equals("")) {
                    OTKit.return_err("Error executing command save: no filename specified");
                    ok = false;
                } else {
                    String content;
                    if (par.size() == 2) {
                        content = XMLstuff.xml2string(OTKit.MyUniverse.toXML());
                    } else {
                        Universe U = new Universe("saved to file");
                        int i = 2;
                        while (i < par.size()) {
                            MyElement me = this.expression(par.get(i));
                            if (me != null) {
                                me.addMeToHash(U);
                            }
                            ++i;
                        }
                        content = XMLstuff.xml2string(U.toXML());
                    }
                    try {
                        File file = new File(par.get(1));
                        FileOutputStream fos = new FileOutputStream(file);
                        fos.write(content.getBytes());
                        fos.close();
                    }
                    catch (FileNotFoundException e) {
                        OTKit.return_err(e.getMessage());
                        ok = false;
                    }
                    catch (IOException e) {
                        OTKit.return_err(e.getMessage());
                        ok = false;
                    }
                }
            } else if (par.get(0).equals("load")) {
                if (par.size() <= 1 || par.get(1).equals(null) || par.get(1).equals("")) {
                    OTKit.return_err("Error executing command load: no filename specified");
                    ok = false;
                } else {
                    StringBuffer contents = new StringBuffer();
                    try {
                        BufferedReader reader;
                        try {
                            InputStream is = new URL(par.get(1)).openStream();
                            reader = new BufferedReader(new InputStreamReader(is));
                        }
                        catch (MalformedURLException mue) {
                            File file = new File(par.get(1));
                            reader = new BufferedReader(new FileReader(file));
                        }
                        String t = null;
                        while ((t = reader.readLine()) != null) {
                            contents.append(t).append(System.getProperty("line.separator"));
                        }
                    }
                    catch (FileNotFoundException e) {
                        OTKit.return_err("Error at command 'load': " + e.getMessage());
                        ok = false;
                    }
                    catch (IOException e) {
                        OTKit.return_err("Error at command 'load': " + e.getMessage());
                        ok = false;
                    }
                    if (par.size() == 2) {
                        OTKit.MyUniverse.fromXML(XMLstuff.string2xml(contents.toString()));
                    } else {
                        Document doc = XMLstuff.string2xml(contents.toString());
                        int i = 2;
                        while (i < par.size()) {
                            Node node;
                            MyElement me = this.expression(par.get(i));
                            if (me != null && (node = XMLstuff.retriever(doc, me.tag(), me.name())) != null) {
                                Universe.elementFromXML(node).addMeToHash(OTKit.MyUniverse);
                            }
                            ++i;
                        }
                    }
                }
            } else if (par.get(0).equals("value")) {
                MyElement m1 = this.expression(par.get(1));
                MyElement m2 = this.expression(par.get(2));
                if (!m1.getClass().toString().endsWith("MyConstraint") || !m2.getClass().toString().endsWith("MyCandidate")) {
                    OTKit.return_err("Error at command 'value': first argument must be constraint, second parameter must be candidate.");
                } else {
                    MyConstraint mcon = (MyConstraint)m1;
                    MyCandidate mcand = (MyCandidate)m2;
                    this.output = String.valueOf(this.output) + mcon.name() + " applied to " + mcand.name() + " gives: ";
                    this.output = String.valueOf(this.output) + mcon.con(OTKit.MyUniverse).value(mcand.cand(OTKit.MyUniverse)) + "\n";
                }
            } else if (par.get(0).equals("full_language")) {
                if (par.size() < 4) {
                    OTKit.return_err("Error executing command 'full_language': too few arguments.");
                    ok = false;
                } else {
                    MyElement m1 = this.expression(par.get(1));
                    if (!(m1 instanceof MyGen)) {
                        OTKit.return_err("Error at command 'full_language': first argument (base) must be a Gen!");
                    } else {
                        int i = 2;
                        Integer numb_uf = null;
                        try {
                            numb_uf = Integer.parseInt(par.get(i));
                            ++i;
                        }
                        catch (NumberFormatException mcand) {
                            // empty catch block
                        }
                        MyElement m2 = this.expression(par.get(i));
                        if (!(m2 instanceof MyGen)) {
                            if (i == 2) {
                                OTKit.return_err("Error at command 'full_language': second argument must be a Gen!");
                            } else {
                                OTKit.return_err("Error at command 'full_language': third argument must be a Gen!");
                            }
                        } else {
                            ++i;
                            Integer numb_cand = null;
                            try {
                                numb_cand = Integer.parseInt(par.get(i));
                                ++i;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            MyElement m3 = this.expression(par.get(i));
                            if (!(m3 instanceof MyHierarchy)) {
                                OTKit.return_err("Error at command 'full_language': last argument must be a Hierarchy!");
                            } else {
                                this.output = String.valueOf(this.output) + FrameActionFullLanguage.full_language(((MyGen)m1).gen(OTKit.MyUniverse), numb_uf, ((MyGen)m2).gen(OTKit.MyUniverse), numb_cand, ((MyHierarchy)m3).hier(OTKit.MyUniverse));
                            }
                        }
                    }
                }
            } else if (par.get(0).equals("grammatical_outputs")) {
                if (par.size() < 4) {
                    OTKit.return_err("Error executing command 'grammatical_outputs': too few arguments.");
                    ok = false;
                } else {
                    MyElement m1 = this.expression(par.get(1));
                    MyElement m2 = this.expression(par.get(2));
                    MyElement m3 = this.expression(par.get(3));
                    if (!(m1 instanceof MyForm)) {
                        OTKit.return_err("Error at command 'grammatical_outputs': first argument must be a form!");
                    } else if (!(m2 instanceof MyGen)) {
                        OTKit.return_err("Error at command 'grammatical_outputs': second argument must be a Gen!");
                    } else if (!(m3 instanceof MyHierarchy)) {
                        OTKit.return_err("Error at command 'grammatical_outputs': third argument must be a Hierarchy!");
                    } else {
                        Integer nr = Integer.MIN_VALUE;
                        if (par.size() > 4) {
                            try {
                                nr = Integer.parseInt(par.get(4));
                            }
                            catch (NumberFormatException e) {
                                OTKit.warning("Warning at command 'grammatical_outputs': fourth argument not an integer, hence ignored.");
                                nr = Integer.MIN_VALUE;
                            }
                        }
                        this.output = nr == Integer.MIN_VALUE ? String.valueOf(this.output) + FrameActionGrammatical.grammatical_forms(((MyForm)m1).form(OTKit.MyUniverse), ((MyGen)m2).gen(OTKit.MyUniverse), ((MyHierarchy)m3).hier(OTKit.MyUniverse)) : String.valueOf(this.output) + FrameActionGrammatical.grammatical_forms(((MyForm)m1).form(OTKit.MyUniverse), ((MyGen)m2).gen(OTKit.MyUniverse), ((MyHierarchy)m3).hier(OTKit.MyUniverse), nr);
                    }
                }
            } else if (par.get(0).equals("draw_tableau")) {
                if (par.size() < 4) {
                    OTKit.return_err("Error executing command 'draw_tableau': too few arguments.");
                    ok = false;
                } else {
                    MyElement m1 = this.expression(par.get(1));
                    MyElement m2 = this.expression(par.get(2));
                    MyElement m3 = this.expression(par.get(3));
                    if (!(m1 instanceof MyForm)) {
                        OTKit.return_err("Error at command 'draw_tableau': first argument must be a form!");
                    } else if (!(m2 instanceof MyGen)) {
                        OTKit.return_err("Error at command 'draw_tableau': second argument must be a Gen!");
                    } else if (!(m3 instanceof MyHierarchy)) {
                        OTKit.return_err("Error at command 'draw_tableau': third argument must be a Hierarchy!");
                    } else {
                        Integer nr = Integer.MIN_VALUE;
                        if (par.size() > 4) {
                            try {
                                nr = Integer.parseInt(par.get(4));
                            }
                            catch (NumberFormatException e) {
                                OTKit.warning("Warning at command 'draw_tableau': fourth argument not an integer, hence ignored.");
                                nr = Integer.MIN_VALUE;
                            }
                        }
                        this.output = nr == Integer.MIN_VALUE ? String.valueOf(this.output) + FrameActionGrammatical.drawTableau(((MyForm)m1).form(OTKit.MyUniverse), ((MyGen)m2).gen(OTKit.MyUniverse), ((MyHierarchy)m3).hier(OTKit.MyUniverse)) : String.valueOf(this.output) + FrameActionGrammatical.drawTableau(((MyForm)m1).form(OTKit.MyUniverse), ((MyGen)m2).gen(OTKit.MyUniverse), ((MyHierarchy)m3).hier(OTKit.MyUniverse), nr);
                    }
                }
            } else if (par.get(0).equals("is_grammatical")) {
                if (par.size() < 4) {
                    OTKit.return_err("Error executing command 'is_grammatical': too few arguments.");
                    ok = false;
                } else {
                    MyElement m1 = this.expression(par.get(1));
                    MyElement m2 = this.expression(par.get(2));
                    MyElement m3 = this.expression(par.get(3));
                    if (!(m1 instanceof MyCandidate)) {
                        OTKit.return_err("Error at command 'is_grammatical': first argument must be a candidate!");
                    } else if (!(m2 instanceof MyGen)) {
                        OTKit.return_err("Error at command 'is_grammatical': second argument must be a Gen!");
                    } else if (!(m3 instanceof MyHierarchy)) {
                        OTKit.return_err("Error at command 'is_grammatical': third argument must be a Hierarchy!");
                    } else {
                        Integer nr = Integer.MIN_VALUE;
                        if (par.size() > 4) {
                            try {
                                nr = Integer.parseInt(par.get(4));
                            }
                            catch (NumberFormatException e) {
                                OTKit.warning("Warning at command 'is_grammatical': fourth argument not an integer, hence ignored.");
                                nr = Integer.MIN_VALUE;
                            }
                        }
                        this.output = nr == Integer.MIN_VALUE ? String.valueOf(this.output) + FrameActionGrJudgm.isGrammatical(((MyCandidate)m1).cand(OTKit.MyUniverse), ((MyGen)m2).gen(OTKit.MyUniverse), ((MyHierarchy)m3).hier(OTKit.MyUniverse)) : String.valueOf(this.output) + FrameActionGrJudgm.isGrammatical(((MyCandidate)m1).cand(OTKit.MyUniverse), ((MyGen)m2).gen(OTKit.MyUniverse), ((MyHierarchy)m3).hier(OTKit.MyUniverse), nr);
                    }
                }
            } else if (par.get(0).equals("factorial_typology")) {
                if (par.size() < 4) {
                    OTKit.return_err("Error executing command 'factorial_typology': too few arguments.");
                    ok = false;
                } else {
                    MyElement m1 = this.expression(par.get(1));
                    MyElement m2 = this.expression(par.get(2));
                    if (!(m1 instanceof MyForm)) {
                        OTKit.return_err("Error at command 'factorial_typology': first argument must be a form!");
                    } else if (!(m2 instanceof MyGen)) {
                        OTKit.return_err("Error at command 'factorial_typology': second argument must be a Gen!");
                    } else {
                        int i = 3;
                        Integer numb_ca = null;
                        try {
                            numb_ca = Integer.parseInt(par.get(i));
                            ++i;
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        MyElement m3 = this.expression(par.get(i));
                        if (!(m3 instanceof MyHierarchy)) {
                            if (i == 3) {
                                OTKit.return_err("Error at command 'factorial_typology': third argument must be a hierarchy!");
                            } else {
                                OTKit.return_err("Error at command 'factorial_typology': fourth argument must be a hierarchy!");
                            }
                        } else {
                            ++i;
                            MyHierarchy fixed = null;
                            MyTable apriori = null;
                            int ignore = 0;
                            boolean verbose = false;
                            boolean collectAll = false;
                            boolean add2MyU = false;
                            int j = i;
                            while (j < par.size()) {
                                String p = par.get(j).trim();
                                if (p.equalsIgnoreCase("verbose")) {
                                    verbose = true;
                                } else if (p.equalsIgnoreCase("collectAll")) {
                                    collectAll = true;
                                } else if (p.equalsIgnoreCase("add2myu")) {
                                    add2MyU = true;
                                } else if (p.startsWith("ignore") || p.startsWith("IGNORE")) {
                                    try {
                                        ignore = Integer.parseInt(p.substring(6).trim());
                                    }
                                    catch (NumberFormatException e) {
                                        OTKit.warning("Warning at command 'factorial_typology': unable to parse integer after 'ignore', therefore 'ignore' ignored.");
                                    }
                                } else {
                                    MyElement m = this.expression(p);
                                    if (m != null && m instanceof MyHierarchy) {
                                        fixed = (MyHierarchy)m;
                                    } else if (m != null && m instanceof MyTable) {
                                        apriori = (MyTable)m;
                                    }
                                }
                                ++j;
                            }
                            this.output = String.valueOf(this.output) + FrameActionFactorialTypology.factorial_typolgy(((MyForm)m1).form(OTKit.MyUniverse), ((MyGen)m2).gen(OTKit.MyUniverse), numb_ca, ((MyHierarchy)m3).hier(OTKit.MyUniverse), fixed, apriori, ignore, verbose, collectAll, add2MyU, OTKit.MyUniverse);
                        }
                    }
                }
            } else {
                this.error = String.valueOf(this.error) + "Unable to interpret command '" + s + "'.";
                ok = false;
            }
        }
        return ok;
    }

    MyElement expression(String str) {
        Vector<String> par;
        MyConstraint me = null;
        if (!str.equals("") && (par = this.parse(str)) != null && par.size() != 0) {
            if (par.get(0).equals("Constraint")) {
                MyConstraint mc = null;
                if (par.size() == 1) {
                    OTKit.return_err("No argument in 'Constraint()'.");
                } else if (par.size() == 2) {
                    mc = OTKit.MyUniverse.MyConstraints.get(par.get(1));
                    if (mc == null) {
                        OTKit.return_err("No constraint found with name '" + par.get(1) + "'. Check spelling!");
                    }
                } else if (par.size() > 2) {
                    String scheme = par.get(2);
                    if (Scheme_constr.name2scheme.get(scheme) == null) {
                        OTKit.return_err("Error executing command Constraint: scheme not found, probably misspelled.");
                    } else if (par.size() < 3 + Scheme_constr.name2scheme.get((Object)scheme).nr_param) {
                        OTKit.return_err("Error executing command Constraint: not enough arguments to fill scheme parameters.");
                    } else {
                        mc = new MyConstraint();
                        mc.scheme = scheme;
                        mc.name = par.get(1);
                        int j = 3;
                        while (j < 3 + Scheme_constr.name2scheme.get((Object)scheme).nr_param) {
                            mc.params.add(par.get(j));
                            ++j;
                        }
                        if (par.size() > j) {
                            mc.short_descr = par.get(j);
                            ++j;
                        }
                        if (par.size() > j) {
                            mc.long_descr = par.get(j);
                        }
                    }
                } else {
                    OTKit.return_err("Error executing command Constraint: no arguments.");
                }
                me = mc;
            } else if (par.get(0).equals("Candidate")) {
                MyCandidate mc = null;
                if (par.size() == 1) {
                    OTKit.return_err("No argument in 'Candidate()'.");
                } else if (par.size() == 2) {
                    mc = OTKit.MyUniverse.MyCandidates.get(par.get(1));
                    if (mc == null) {
                        OTKit.return_err("No candidate found with name '" + par.get(1) + "'. Check spelling!");
                    }
                } else if (par.size() > 2) {
                    String scheme = par.get(2);
                    if (Scheme_cand.name2scheme.get(scheme) == null) {
                        OTKit.return_err("Error executing command 'Candidate': scheme not found, probably misspelled.");
                    } else if (par.size() < 3 + Scheme_cand.name2scheme.get((Object)scheme).nr_param) {
                        OTKit.return_err("Error executing command 'Constraint': not enough arguments to fill scheme parameters.");
                    } else {
                        mc = new MyCandidate(par.get(1), scheme);
                        int j = 3;
                        while (j < 3 + Scheme_cand.name2scheme.get((Object)scheme).nr_param) {
                            mc.params.add(par.get(j));
                            ++j;
                        }
                    }
                } else {
                    OTKit.return_err("Error executing command 'Candidate': no arguments.");
                }
                me = mc;
            } else if (par.get(0).equals("Cand")) {
                MyCandidate mc = null;
                if (par.size() <= 1) {
                    OTKit.return_err("No argument in 'Cand()'.");
                } else {
                    mc = new MyCandidate(par.get(1), "sf_from_string");
                    mc.params.add(par.get(1));
                }
                me = mc;
            } else if (par.get(0).equals("Form")) {
                MyForm mf = null;
                if (par.size() == 1) {
                    OTKit.return_err("No argument in 'Form()'.");
                } else if (par.size() == 2) {
                    mf = OTKit.MyUniverse.MyForms.get(par.get(1));
                    if (mf == null) {
                        OTKit.return_err("No form found with name '" + par.get(1) + "'. Check spelling!");
                    }
                } else if (par.size() > 2) {
                    String scheme = par.get(2);
                    if (Scheme_form.name2scheme.get(scheme) == null) {
                        OTKit.return_err("Error executing command 'Form': scheme not found, probably misspelled.");
                    } else if (par.size() < 3 + Scheme_form.name2scheme.get((Object)scheme).nr_param) {
                        OTKit.return_err("Error executing command 'Form': not enough arguments to fill scheme parameters.");
                    } else {
                        mf = new MyForm(par.get(1), scheme);
                        int j = 3;
                        while (j < 3 + Scheme_form.name2scheme.get((Object)scheme).nr_param) {
                            mf.params.add(par.get(j));
                            ++j;
                        }
                    }
                } else {
                    OTKit.return_err("Error executing command Form: no arguments.");
                }
                me = mf;
            } else if (par.get(0).equals("Gen")) {
                MyGen mg = null;
                if (par.size() == 1) {
                    OTKit.return_err("No argument in 'Gen()'.");
                } else if (par.size() == 2) {
                    mg = OTKit.MyUniverse.MyGens.get(par.get(1));
                    if (mg == null) {
                        OTKit.return_err("No Gen found with name '" + par.get(1) + "'. Check spelling!");
                    }
                } else if (par.size() > 2) {
                    String scheme = par.get(2);
                    if (Scheme_gen.name2scheme.get(scheme) == null) {
                        OTKit.return_err("Error executing command 'Gen': scheme not found, probably misspelled.");
                    } else if (par.size() < 3 + Scheme_gen.name2scheme.get((Object)scheme).nr_param) {
                        OTKit.return_err("Error executing command 'Gen': not enough arguments to fill scheme parameters.");
                    } else {
                        mg = new MyGen(par.get(1), scheme);
                        int j = 3;
                        while (j < 3 + Scheme_gen.name2scheme.get((Object)scheme).nr_param) {
                            mg.params.add(par.get(j));
                            ++j;
                        }
                    }
                } else {
                    OTKit.return_err("Error executing command 'Gen': no parameters.");
                }
                me = mg;
            } else if (par.get(0).equals("Hierarchy")) {
                MyHierarchy mh = null;
                if (par.size() == 1) {
                    OTKit.return_err("No argument in 'Hierarchy()'.");
                } else if (par.size() == 2) {
                    mh = OTKit.MyUniverse.MyHierarchies.get(par.get(1));
                    if (mh == null) {
                        OTKit.return_err("No Hierarchy found with name '" + par.get(1) + "'. Check spelling!");
                    }
                } else if (par.size() > 2) {
                    mh = OTKit.MyUniverse.MyHierarchies.get(par.get(1));
                    if (mh == null) {
                        OTKit.return_err("No Hierarchy found with name '" + par.get(1) + "'. Check spelling!");
                    }
                } else {
                    OTKit.return_err("Error executing command 'Hierarchy': no parameters.");
                }
                me = mh;
            } else if (par.get(0).equals("Table")) {
                MyTable mt = null;
                if (par.size() == 1) {
                    OTKit.return_err("No argument in 'Table()'.");
                } else if (par.size() == 2) {
                    mt = OTKit.MyUniverse.MyTables.get(par.get(1));
                    if (mt == null) {
                        OTKit.return_err("No Table found with name '" + par.get(1) + "'. Check spelling!");
                    }
                } else if (par.size() == 3) {
                    OTKit.return_err("Error executing command 'Table': too few parameters to create a table!");
                } else if (par.size() > 3) {
                    int r = 0;
                    int c = 0;
                    try {
                        r = Integer.parseInt(par.get(2));
                    }
                    catch (NumberFormatException e) {
                        OTKit.return_err("Error executing command 'Table': parameter 2 not a number!");
                    }
                    try {
                        c = Integer.parseInt(par.get(3));
                    }
                    catch (NumberFormatException e) {
                        OTKit.return_err("Error executing command 'Table': parameter 3 not a number!");
                    }
                    String[][] t = new String[r][c];
                    ++r;
                    ++c;
                    int i = 1;
                    while (i < r) {
                        Vector<Object> v;
                        try {
                            v = this.parse(par.get(i + 3));
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            v = new Vector();
                        }
                        int j = 1;
                        while (j < c) {
                            try {
                                t[i - 1][j - 1] = (String)v.get(j);
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                t[i - 1][j - 1] = "";
                            }
                            ++j;
                        }
                        ++i;
                    }
                    mt = new MyTable(par.get(1), t);
                } else {
                    OTKit.return_err("Error executing command 'Table': no parameters.");
                }
                me = mt;
            }
        }
        return me;
    }

    public Vector<String> parse(String s) {
        Vector<String> arg = new Vector<String>();
        if (!(s = s.trim()).contains("(") || !s.endsWith(")")) {
            OTKit.return_err("Error: '" + s + "' could not be parsed as command(arguments).");
            arg = null;
        } else {
            arg.add(s.split("\\(")[0].trim());
            s = s.substring(s.indexOf(40) + 1, s.lastIndexOf(41));
            String a = "";
            int par = 0;
            boolean quote = false;
            boolean escape = false;
            boolean white = false;
            int i = 0;
            while (i < s.length()) {
                if (par > 0) {
                    a = String.valueOf(a) + s.charAt(i);
                    if (s.charAt(i) == '(') {
                        ++par;
                    } else if (s.charAt(i) == ')') {
                        --par;
                    }
                } else if (escape) {
                    a = String.valueOf(a) + s.charAt(i);
                    escape = false;
                } else if (s.charAt(i) == '\\') {
                    escape = true;
                } else if (quote && s.charAt(i) != '\"') {
                    a = String.valueOf(a) + s.charAt(i);
                } else if (quote && s.charAt(i) == '\"') {
                    quote = false;
                } else if (s.charAt(i) == '(') {
                    a = String.valueOf(a) + s.charAt(i);
                    ++par;
                } else if (s.charAt(i) == '\"') {
                    quote = true;
                } else if (s.charAt(i) == '\"') {
                    quote = true;
                } else if (s.charAt(i) == ',') {
                    arg.add(a.trim());
                    a = "";
                } else if (s.charAt(i) == ')') {
                    i = s.length() + 1;
                } else if (white && !Character.isWhitespace(s.charAt(i))) {
                    a = String.valueOf(a) + s.charAt(i);
                    white = false;
                } else if (!white && Character.isWhitespace(s.charAt(i))) {
                    a = String.valueOf(a) + ' ';
                    white = true;
                } else if (!white && !Character.isWhitespace(s.charAt(i))) {
                    a = String.valueOf(a) + s.charAt(i);
                }
                ++i;
            }
            if (i == s.length() && !escape && !quote) {
                arg.add(a.trim());
            } else {
                OTKit.return_err("Error: '" + s + "' could not be parsed as command(arguments).");
            }
        }
        return arg;
    }

    public boolean execScript(String str) {
        boolean ok = true;
        String[] stringArray = str.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            ok = this.execCommand(s) && ok;
            System.err.println(">> " + s);
            if (!this.error.equals("") && this.error_returned_continuously) {
                OTKit.return_err(this.error);
                this.error = "";
            }
            if (!this.output.equals("") && this.ouptut_returned_continuously) {
                OTKit.return_out(this.output);
                this.output = "";
            }
            ++n2;
        }
        return ok;
    }
}

