/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.userInterface;

import hu.birot.OTKit.userInterface.Impressum;
import hu.birot.OTKit.userInterface.OTKit;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLstuff {
    public static final ScriptFilter scriptfilter = new ScriptFilter();
    public static final XMLFilter xmlfilter = new XMLFilter();
    public static final OutFilter outfilter = new OutFilter();

    public static Document emptyDocument() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            System.err.println(e.getMessage());
        }
        Document doc = builder.newDocument();
        doc.setDocumentURI("http://www.birot.hu/OTKit");
        return doc;
    }

    public static String xml2string(Node n) {
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = null;
        try {
            trans = transfac.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        trans.setOutputProperty("omit-xml-declaration", "no");
        trans.setOutputProperty("doctype-system", "http://www.birot.hu/OTKit/files/OTKit.dtd");
        trans.setOutputProperty("indent", "yes");
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(n);
        try {
            trans.transform(source, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return sw.toString();
    }

    public static Document string2xml(String s) {
        s = s.replaceAll("http://www.birot.hu/OTKit/files/OTKit.dtd", new Impressum().currentdtd.toString());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            System.err.println(e.getMessage());
        }
        InputSource inStream = new InputSource();
        inStream.setCharacterStream(new StringReader(s));
        Document doc = builder.newDocument();
        try {
            doc = builder.parse(inStream);
        }
        catch (SAXException e) {
            OTKit.error("XML parse error: " + e.getMessage());
        }
        catch (IOException e) {
            OTKit.error("IO error: " + e.getMessage());
        }
        return doc;
    }

    public static Node retriever(Node n, String tag, String name) {
        boolean retrieved = false;
        Node node = null;
        Node child = n.getFirstChild();
        while (!retrieved && child != null) {
            if (child.getNodeName().equals(tag) && child.getAttributes().getNamedItem("name").getNodeValue().equals(name)) {
                node = child;
                retrieved = true;
            } else if (child.getNodeName().equals("universe")) {
                node = XMLstuff.retriever(child, tag, name);
                retrieved = node != null;
            }
            child = child.getNextSibling();
        }
        return node;
    }

    public static class OutFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.endsWith(".otk.out");
        }
    }

    public static class ScriptFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.endsWith(".otk.scr");
        }
    }

    public static class XMLFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.endsWith(".otk.xml");
        }
    }
}

