/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.dataType;

import hu.birot.OTKit.dataType.Form;
import hu.birot.OTKit.dataType.FormValuePair;
import hu.birot.OTKit.dataType.MapForm;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapFormExamples {
    public static MapForm equals(final HashMap<Form, FormValuePair[]> hm) {
        return new MapForm(){

            @Override
            public Form first(Form form1) {
                if (hm.containsKey(form1)) {
                    return ((FormValuePair[])hm.get(form1))[0].form();
                }
                return MapForm.NoMapping;
            }

            @Override
            public Form next(Form form1, Form form_last) {
                if (hm.containsKey(form1)) {
                    FormValuePair[] fvpa = (FormValuePair[])hm.get(form1);
                    int length = fvpa.length;
                    int i = 0;
                    while (i < length) {
                        if (fvpa[i].form().equals(form_last)) {
                            if (i + 1 < length) {
                                return fvpa[i + 1].form();
                            }
                            return MapForm.NoMoreForm;
                        }
                        ++i;
                    }
                    return MapForm.NotInRange;
                }
                return MapForm.NoMapping;
            }

            @Override
            public Form random(Form form1, double rnd) {
                if (hm.containsKey(form1)) {
                    FormValuePair[] fvpa = (FormValuePair[])hm.get(form1);
                    double sum = 0.0;
                    double f = 0.0;
                    int i = 0;
                    while (i < fvpa.length) {
                        sum += fvpa[i].value();
                        ++i;
                    }
                    double rndf = rnd * sum;
                    i = 0;
                    while (i < fvpa.length) {
                        if (rndf <= (f += fvpa[i].value())) {
                            return fvpa[i].form();
                        }
                        ++i;
                    }
                    return MapForm.RndTooHigh;
                }
                return MapForm.NoMapping;
            }

            @Override
            public Vector<Form> all(Form form1) {
                Vector<Form> forms = new Vector<Form>();
                if (hm.containsKey(form1)) {
                    FormValuePair[] fvpa = (FormValuePair[])hm.get(form1);
                    int i = 0;
                    while (i < fvpa.length) {
                        forms.add(fvpa[i].form());
                        ++i;
                    }
                } else {
                    forms.add(MapForm.NoMapping);
                }
                return forms;
            }
        };
    }

    public static MapForm linearCombination(final MapForm mapform1, final double factor1, final MapForm mapform2, final double factor2) {
        return new MapForm(){

            @Override
            public Form first(Form form1) {
                if (!mapform1.first(form1).equals(MapForm.NoMapping)) {
                    return mapform1.first(form1);
                }
                return mapform2.first(form1);
            }

            @Override
            public Form next(Form form1, Form form_last) {
                if (!mapform1.first(form1).equals(MapForm.NoMapping)) {
                    Form f = mapform1.next(form1, form_last);
                    if (f.equals(MapForm.NoMapping)) {
                        return mapform2.first(form1);
                    }
                    return mapform1.next(form1, form_last);
                }
                return mapform2.next(form1, form_last);
            }

            @Override
            public Form random(Form form1, double rnd) {
                boolean mapform2Maps;
                boolean mapform1Maps = !mapform1.first(form1).equals(MapForm.NoMapping);
                boolean bl = mapform2Maps = !mapform2.first(form1).equals(MapForm.NoMapping);
                if (mapform1Maps && mapform2Maps) {
                    if (rnd < (factor1 + 0.0) / (factor1 + factor2)) {
                        return mapform1.random(form1, rnd * (factor1 + factor2 + 0.0) / factor1);
                    }
                    return mapform2.random(form1, (rnd * (factor1 + factor2 + 0.0) - factor1) / factor2);
                }
                if (mapform1Maps && !mapform2Maps) {
                    return mapform1.random(form1, rnd);
                }
                if (!mapform1Maps && mapform2Maps) {
                    return mapform2.random(form1, rnd);
                }
                return MapForm.NoMapping;
            }

            @Override
            public Vector<Form> all(Form form1) {
                if (mapform1.all(form1).contains(MapForm.InfiniteSet) || mapform2.all(form1).contains(MapForm.InfiniteSet)) {
                    Vector<Form> all = new Vector<Form>();
                    all.add(MapForm.InfiniteSet);
                    return all;
                }
                Vector all = (Vector)mapform1.all(form1).clone();
                for (Form f : mapform2.all(form1)) {
                    if (all.contains(f)) continue;
                    all.add(f);
                }
                return all;
            }
        };
    }
}

