/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.dataType.violation;

import hu.birot.OTKit.dataType.violation.Violation;
import java.util.HashMap;
import java.util.regex.Pattern;

public class FloatViolation
extends Violation {
    public static final FloatViolation nullViolation = new FloatViolation(0.0);
    public static final FloatViolation oneViolation = new FloatViolation(1.0);
    public static final double EPSILON = 1.0E-9;
    private double fvalue;
    private static HashMap<Double, FloatViolation> hm = new HashMap();
    public static RuntimeException ArgumentNotFloatViolation = new RuntimeException("Argument is not FloatViolation");
    protected final Pattern delete_after_comma = Pattern.compile("\\.0*$");

    public FloatViolation(double f) {
        this.fvalue = f < 1.0E-9 && f > -1.0E-9 ? 0.0 : (double)((float)f);
    }

    public Double value() {
        return this.fvalue;
    }

    public static FloatViolation v(double v) {
        if (!hm.containsKey(v)) {
            hm.put(v, new FloatViolation(v));
        }
        return hm.get(v);
    }

    public boolean betterEqual(Violation v) {
        if (!v.getClass().equals(this.getClass())) {
            return false;
        }
        return this.fvalue <= (Double)v.value();
    }

    public double difference(Violation v) {
        if (this == v) {
            return 0.0;
        }
        try {
            return this.fvalue - (Double)v.value();
        }
        catch (ClassCastException e) {
            throw ArgumentNotFloatViolation;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o.getClass().equals(this.thisclass)) {
            return ((FloatViolation)o).fvalue == this.fvalue;
        }
        return false;
    }

    public Violation clone() {
        return new FloatViolation(this.fvalue);
    }

    public String toString() {
        return this.delete_after_comma.matcher(String.valueOf(this.fvalue)).replaceAll("");
    }

    public int hashCode() {
        return ("" + this.fvalue).hashCode();
    }
}

