/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.grammarExamples;

import hu.birot.OTKit.dataType.Form;
import hu.birot.OTKit.dataType.MapForm;
import hu.birot.OTKit.dataType.violation.IntegerViolation;
import hu.birot.OTKit.dataType.violation.Violation;
import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Constraint;
import hu.birot.OTKit.otBuildingBlocks.Gen;
import hu.birot.OTKit.otBuildingBlocks.Grammar;
import hu.birot.OTKit.otBuildingBlocks.Hierarchy;
import hu.birot.OTKit.otBuildingBlocks.Topology;
import java.util.Vector;

public class StringGrammar
extends Grammar {
    public final int L;
    public final int K;
    public static final IntegerViolation nulViol = IntegerViolation.nullViolation;
    public static final IntegerViolation oneViol = IntegerViolation.oneViolation;

    public Form StrForm(int[] array) {
        final int[] a = (int[])array.clone();
        return new Form(a, "StringGrammar"){

            public boolean equals(Object form) {
                if (this == form) {
                    return true;
                }
                if (form == null || !form.getClass().equals(this.getClass())) {
                    return false;
                }
                Form f = (Form)form;
                if (!f.type().equals("StringGrammar")) {
                    return false;
                }
                int[] farray = (int[])f.object();
                int i = 0;
                while (i < StringGrammar.this.L) {
                    if (farray[i] != a[i]) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            public String toString() {
                String str = "";
                int i = 0;
                while (i < StringGrammar.this.L) {
                    str = String.valueOf(str) + a[i] + " ";
                    ++i;
                }
                return str.trim();
            }

            public int hashCode() {
                int hc = 0;
                int i = 0;
                while (i < StringGrammar.this.L) {
                    hc += a[i] * (int)Math.pow(StringGrammar.this.K, i);
                    ++i;
                }
                return hc;
            }
        };
    }

    public Form StrFormSet(Form f, int locus, int value) {
        int[] farray = (int[])((int[])f.object()).clone();
        farray[locus] = value;
        return this.StrForm(farray);
    }

    public static int StrFormGet(Form f, int locus) {
        int[] farray = (int[])f.object();
        return farray[locus];
    }

    public Constraint No_i(final int letter) {
        return new Constraint("No" + letter){

            public Violation value(Candidate c) {
                int v = 0;
                int[] str = (int[])c.sf.object();
                int j = 0;
                while (j < StringGrammar.this.L) {
                    if (str[j] == letter) {
                        ++v;
                    }
                    ++j;
                }
                return IntegerViolation.v(v);
            }
        };
    }

    public Constraint NoInitial_i(final int letter) {
        return new Constraint("Ni" + letter){

            public Violation value(Candidate c) {
                if (StringGrammar.StrFormGet(c.sf, 0) == letter) {
                    return oneViol;
                }
                return nulViol;
            }
        };
    }

    public Constraint NoFinal_i(final int letter) {
        return new Constraint("Nf" + letter){

            public Violation value(Candidate c) {
                if (StringGrammar.StrFormGet(c.sf, StringGrammar.this.L - 1) == letter) {
                    return oneViol;
                }
                return nulViol;
            }
        };
    }

    public Constraint Assimilate() {
        return new Constraint("Assimilate"){

            public Violation value(Candidate c) {
                int v = 0;
                int[] str = (int[])c.sf.object();
                int j = 1;
                while (j < StringGrammar.this.L) {
                    if (str[j] != str[j - 1]) {
                        ++v;
                    }
                    ++j;
                }
                return IntegerViolation.v(v);
            }
        };
    }

    public Constraint Dissimilate() {
        return new Constraint("Dissimilate"){

            public Violation value(Candidate c) {
                int v = 0;
                int[] str = (int[])c.sf.object();
                int j = 1;
                while (j < StringGrammar.this.L) {
                    if (str[j] == str[j - 1]) {
                        ++v;
                    }
                    ++j;
                }
                return IntegerViolation.v(v);
            }
        };
    }

    public Constraint Faithful() {
        return new Constraint("Faithfulness"){

            public Violation value(Candidate c) {
                int v = 0;
                int[] str_undr = (int[])c.uf.object();
                int[] str_surf = (int[])c.sf.object();
                int j = 0;
                while (j < StringGrammar.this.L) {
                    v += Math.min((str_undr[j] - str_surf[j] + StringGrammar.this.K) % StringGrammar.this.K, (str_surf[j] - str_undr[j] + StringGrammar.this.K) % StringGrammar.this.K);
                    ++j;
                }
                return IntegerViolation.v(v);
            }
        };
    }

    public StringGrammar(int alphabetsize, int length, String h_type) {
        this.L = length;
        this.K = alphabetsize;
        this.type = h_type;
        this.hierarchy = new Hierarchy();
        this.hierarchy.type = h_type;
        int i = 0;
        while (i < this.K) {
            this.hierarchy.addConstraint(this.No_i(i));
            this.hierarchy.addConstraint(this.NoInitial_i(i));
            this.hierarchy.addConstraint(this.NoFinal_i(i));
            ++i;
        }
        this.hierarchy.addConstraint(this.Assimilate());
        this.hierarchy.addConstraint(this.Dissimilate());
        this.hierarchy.addConstraint(this.Faithful());
        this.gen = new Gen(){

            @Override
            public Candidate firstCandidate(Form uf) {
                int[] array = new int[StringGrammar.this.L];
                int i = 0;
                while (i < StringGrammar.this.L) {
                    array[i] = 0;
                    ++i;
                }
                return new Candidate(uf, StringGrammar.this.StrForm(array));
            }

            @Override
            public Vector<Candidate> allCandidates(Form uf) {
                Vector<Candidate> allcands = new Vector<Candidate>();
                int[] array = new int[StringGrammar.this.L];
                int max = (int)Math.pow(StringGrammar.this.K, StringGrammar.this.L);
                int i = 0;
                while (i < max) {
                    int k = i;
                    int j = 0;
                    while (j < StringGrammar.this.L) {
                        array[j] = k % StringGrammar.this.K;
                        k /= StringGrammar.this.K;
                        ++j;
                    }
                    allcands.add(new Candidate(uf, StringGrammar.this.StrForm(array)));
                    ++i;
                }
                return allcands;
            }

            @Override
            public Candidate randomCandidate(Form uf, double rnd) {
                if (rnd < 0.0) {
                    rnd = 0.0;
                }
                if (rnd > 1.0) {
                    return new Candidate(uf, MapForm.RndTooHigh);
                }
                if (rnd == 1.0) {
                    rnd -= 1.0E-8;
                }
                int k = (int)(rnd * Math.pow(StringGrammar.this.K, StringGrammar.this.L));
                int[] array = new int[StringGrammar.this.L];
                int j = 0;
                while (j < StringGrammar.this.L) {
                    array[j] = k % StringGrammar.this.K;
                    k /= StringGrammar.this.K;
                    ++j;
                }
                return new Candidate(uf, StringGrammar.this.StrForm(array));
            }
        };
        this.topology = new Topology(){

            @Override
            public Candidate rndNeighborOf(Candidate w, double rnd) {
                if (rnd < 0.0) {
                    rnd = 0.0;
                }
                if (rnd > 1.0) {
                    return new Candidate(w.uf, MapForm.RndTooHigh);
                }
                if (rnd == 1.0) {
                    rnd -= 1.0E-8;
                }
                int action = (int)(rnd * 2.0 * (double)StringGrammar.this.L);
                int increase = action % 2;
                increase = 2 * increase - 1;
                int locus = action / 2;
                return new Candidate(w.uf, StringGrammar.this.StrFormSet(w.sf, locus, (StringGrammar.this.K + StringGrammar.StrFormGet(w.sf, locus) + increase) % StringGrammar.this.K));
            }

            @Override
            public Candidate firstNeighborOf(Candidate w) {
                return new Candidate(w.uf, StringGrammar.this.StrFormSet(w.sf, 0, (StringGrammar.this.K + StringGrammar.StrFormGet(w.sf, 0) - 1) % StringGrammar.this.K));
            }

            @Override
            public Vector<Candidate> allNeighborsOf(Candidate w) {
                Vector<Candidate> allcands = new Vector<Candidate>();
                int locus = 0;
                while (locus < StringGrammar.this.L) {
                    allcands.add(new Candidate(w.uf, StringGrammar.this.StrFormSet(w.sf, locus, (StringGrammar.StrFormGet(w.sf, locus) + 1) % StringGrammar.this.K)));
                    allcands.add(new Candidate(w.uf, StringGrammar.this.StrFormSet(w.sf, locus, (StringGrammar.this.K + StringGrammar.StrFormGet(w.sf, locus) - 1) % StringGrammar.this.K)));
                    ++locus;
                }
                return allcands;
            }
        };
        this.base = new MapForm(){

            @Override
            public Form first(Form form1) {
                int[] array = new int[StringGrammar.this.L];
                int i = 0;
                while (i < StringGrammar.this.L) {
                    array[i] = 0;
                    ++i;
                }
                return StringGrammar.this.StrForm(array);
            }

            @Override
            public Form next(Form form1, Form form_last) {
                throw new RuntimeException("This method must be overriden.");
            }

            @Override
            public Form random(Form form1, double rnd) {
                if (rnd < 0.0) {
                    rnd = 0.0;
                }
                if (rnd > 1.0) {
                    return MapForm.RndTooHigh;
                }
                if (rnd == 1.0) {
                    rnd -= 1.0E-8;
                }
                int k = (int)(rnd * Math.pow(StringGrammar.this.K, StringGrammar.this.L));
                int[] array = new int[StringGrammar.this.L];
                int j = 0;
                while (j < StringGrammar.this.L) {
                    array[j] = k % StringGrammar.this.K;
                    k /= StringGrammar.this.K;
                    ++j;
                }
                return StringGrammar.this.StrForm(array);
            }

            @Override
            public Vector<Form> all(Form form1) {
                Vector<Form> allcands = new Vector<Form>();
                int[] array = new int[StringGrammar.this.L];
                int max = (int)Math.pow(StringGrammar.this.K, StringGrammar.this.L);
                int i = 0;
                while (i < max) {
                    int k = i;
                    int j = 0;
                    while (j < StringGrammar.this.L) {
                        array[j] = k % StringGrammar.this.K;
                        k /= StringGrammar.this.K;
                        ++j;
                    }
                    allcands.add(StringGrammar.this.StrForm(array));
                    ++i;
                }
                return allcands;
            }
        };
        this.utter = new MapForm(){

            @Override
            public Form first(Form form1) {
                return form1;
            }

            @Override
            public Form next(Form form1, Form form_last) {
                if (form1.equals(form_last)) {
                    return MapForm.NoMoreForm;
                }
                return MapForm.NotInRange;
            }

            @Override
            public Form random(Form form1, double rnd) {
                if (rnd > 1.0) {
                    return MapForm.RndTooHigh;
                }
                return form1;
            }

            @Override
            public Vector<Form> all(Form form1) {
                Vector<Form> all = new Vector<Form>();
                all.add(form1);
                return all;
            }
        };
    }

    public void setPragueHierarchy() {
        this.hierarchy.setKvalue("No0", 14.0);
        this.hierarchy.setKvalue("Assimilate", 13.0);
        this.hierarchy.setKvalue("Faithfulness", 12.0);
        this.hierarchy.setKvalue("Ni1", 11.0);
        this.hierarchy.setKvalue("Ni0", 10.0);
        this.hierarchy.setKvalue("Ni2", 9.0);
        this.hierarchy.setKvalue("Ni3", 8.0);
        this.hierarchy.setKvalue("Nf0", 7.0);
        this.hierarchy.setKvalue("Nf1", 6.0);
        this.hierarchy.setKvalue("Nf2", 5.0);
        this.hierarchy.setKvalue("Nf3", 4.0);
        this.hierarchy.setKvalue("No3", 3.0);
        this.hierarchy.setKvalue("No2", 2.0);
        this.hierarchy.setKvalue("No1", 1.0);
        this.hierarchy.setKvalue("Dissimilate", 0.0);
    }
}

