/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.learning;

import hu.birot.OTKit.dataType.violation.Violation;
import hu.birot.OTKit.learning.OfflineLearning;
import hu.birot.OTKit.learning.OnlineLearning;
import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Constraint;
import hu.birot.OTKit.otBuildingBlocks.Grammar;
import hu.birot.OTKit.performance.Production;
import java.util.HashMap;
import java.util.Vector;

public class OfflineLearningExamples {
    public static OfflineLearning RCD(final String approach) {
        return new OfflineLearning(){

            @Override
            public boolean learn(Grammar G, Vector<Candidate> cand) {
                boolean consistent = true;
                Vector CT = new Vector();
                for (Candidate w : cand) {
                    Vector<Candidate> losers;
                    if (approach.equals("all")) {
                        losers = G.gen.allCandidates(w.uf);
                        losers.remove(w);
                    } else if (approach.equals("neighb")) {
                        losers = G.topology.allNeighborsOf(w);
                    } else {
                        throw new RuntimeException("RCD's specified approach does not exist!");
                    }
                    HashMap<Constraint, Violation> winner_marks = G.hierarchy.value(w);
                    for (Candidate l : losers) {
                        HashMap<Constraint, String> compare = new HashMap<Constraint, String>();
                        for (Constraint c : G.hierarchy.constraints()) {
                            Violation loser_mark = c.value(l);
                            Violation winner_mark = winner_marks.get(c);
                            if (Violation.isBetter(winner_mark, loser_mark)) {
                                compare.put(c, "W");
                                continue;
                            }
                            if (Violation.isBetter(loser_mark, winner_mark)) {
                                compare.put(c, "L");
                                continue;
                            }
                            if (Violation.isEqual(winner_mark, loser_mark)) {
                                compare.put(c, "E");
                                continue;
                            }
                            compare.put(c, "NC");
                        }
                        CT.add(compare);
                    }
                }
                for (Constraint c : G.hierarchy.constraints()) {
                    G.hierarchy.setRank(c, Double.NEGATIVE_INFINITY);
                }
                boolean stop = false;
                Vector<HashMap> to_remove = new Vector<HashMap>();
                int rank = 0;
                while (!stop) {
                    stop = true;
                    for (Constraint c : G.hierarchy.constraints()) {
                        consistent = true;
                        if (G.hierarchy.rankOf(c) != Double.NEGATIVE_INFINITY) continue;
                        consistent = false;
                        boolean undominated = true;
                        int n = 0;
                        while (undominated && n < CT.size()) {
                            if (((String)((HashMap)CT.get(n)).get(c)).equals("L")) {
                                undominated = false;
                            }
                            ++n;
                        }
                        if (!undominated) continue;
                        G.hierarchy.setRank(c, (double)rank);
                        stop = false;
                    }
                    if (!stop) {
                        for (Constraint c : G.hierarchy.constraints()) {
                            if (G.hierarchy.rankOf(c) != (double)rank) continue;
                            to_remove.clear();
                            for (HashMap hashMap : CT) {
                                if (!((String)hashMap.get(c)).equals("W")) continue;
                                to_remove.add(hashMap);
                            }
                            for (HashMap hashMap : to_remove) {
                                CT.remove(hashMap);
                            }
                        }
                    }
                    --rank;
                }
                return consistent;
            }
        };
    }

    public static OfflineLearning RepeatOnline(final OnlineLearning algorithm, final Production P) {
        return new OfflineLearning(){

            @Override
            public boolean learn(Grammar G, Vector<Candidate> cand) {
                if (cand.isEmpty()) {
                    return false;
                }
                for (Candidate candidate : cand) {
                    algorithm.learn(G, P, candidate);
                }
                return true;
            }
        };
    }
}

