/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.learning;

import hu.birot.OTKit.dataType.Form;
import hu.birot.OTKit.learning.ConstraintMotion;
import hu.birot.OTKit.learning.ConstraintMotionExamples;
import hu.birot.OTKit.learning.OnlineLearning;
import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Eval;
import hu.birot.OTKit.otBuildingBlocks.Grammar;
import hu.birot.OTKit.performance.Production;
import java.util.Vector;

public class OnlineLearningExamples {
    public static OnlineLearning ErrorDriven(final ConstraintMotion cm) {
        return new OnlineLearning(){

            public boolean learn(Grammar G, Production P, Candidate cand) {
                Candidate loser = new Candidate(cand.uf, P.produce(G, cand.uf));
                return cm.update(G, cand, loser);
            }
        };
    }

    public static OnlineLearning GLA(double plasticity) {
        return OnlineLearningExamples.ErrorDriven(ConstraintMotionExamples.Boersma(plasticity));
    }

    public static OnlineLearning Magri(double plasticity) {
        return OnlineLearningExamples.ErrorDriven(ConstraintMotionExamples.Magri(plasticity));
    }

    public static OnlineLearning EDCD() {
        return OnlineLearningExamples.ErrorDriven(ConstraintMotionExamples.TesarSmolensky());
    }

    public static OnlineLearning localOptima(final ConstraintMotion cm_w, final ConstraintMotion cm_l) {
        return new OnlineLearning(){

            public boolean learn(Grammar G, Production P, Candidate cand) {
                Form uf = cand.uf;
                Vector<Object> neighbors = new Vector();
                Candidate loser = new Candidate(uf, P.produce(G, uf));
                neighbors = Eval.Compare(G.topology.allNeighborsOf(cand), G.hierarchy);
                Candidate bnw = (Candidate)neighbors.get((int)Math.random() * neighbors.size());
                neighbors = Eval.Compare(G.topology.allNeighborsOf(loser), G.hierarchy);
                Candidate bnl = (Candidate)neighbors.get((int)Math.random() * neighbors.size());
                boolean w = cm_w.update(G, cand, bnw);
                boolean l = cm_l.update(G, bnl, loser);
                return l || w;
            }
        };
    }

    public static OnlineLearning localBoersma(double plasticity) {
        return OnlineLearningExamples.localOptima(ConstraintMotionExamples.Boersma(plasticity), ConstraintMotionExamples.Boersma(plasticity));
    }

    public static OnlineLearning localMagri(double plasticity) {
        return OnlineLearningExamples.localOptima(ConstraintMotionExamples.Magri(plasticity), ConstraintMotionExamples.Magri(plasticity));
    }

    public static OnlineLearning localOptimaReversed(final ConstraintMotion cm_w, final ConstraintMotion cm_l) {
        return new OnlineLearning(){

            public boolean learn(Grammar G, Production P, Candidate cand) {
                Form uf = cand.uf;
                Vector<Object> neighbors = new Vector();
                Candidate loser = new Candidate(uf, P.produce(G, uf));
                neighbors = Eval.Compare(G.topology.allNeighborsOf(cand), G.hierarchy);
                Candidate bnw = (Candidate)neighbors.get((int)Math.random() * neighbors.size());
                neighbors = Eval.Compare(G.topology.allNeighborsOf(loser), G.hierarchy);
                Candidate bnl = (Candidate)neighbors.get((int)Math.random() * neighbors.size());
                boolean w = cm_w.update(G, cand, bnw);
                boolean l = cm_l.update(G, loser, bnl);
                return l || w;
            }
        };
    }
}

