/*
 * Decompiled with CFR 0.152.
 */
package hu.birot.OTKit.performance;

import hu.birot.OTKit.dataType.Form;
import hu.birot.OTKit.otBuildingBlocks.Candidate;
import hu.birot.OTKit.otBuildingBlocks.Eval;
import hu.birot.OTKit.otBuildingBlocks.Grammar;
import hu.birot.OTKit.otBuildingBlocks.Hierarchy;
import hu.birot.OTKit.otBuildingBlocks.Topology;
import hu.birot.OTKit.performance.CoolingSchedule;
import hu.birot.OTKit.performance.CoolingScheduleExamples;
import hu.birot.OTKit.performance.Production;
import hu.birot.OTKit.performance.RandomWalks;
import hu.birot.OTKit.performance.RulesOfMoving;
import hu.birot.OTKit.performance.RulesOfMovingExamples;
import java.util.Vector;

public class ProductionExamples {
    public static Production grammatical() {
        return new Production(){

            public Form produce(Grammar G, Form f) {
                G.hierarchy.sortByRank();
                Vector<Candidate> C = Eval.Compare(G.gen.allCandidates(f), G.hierarchy);
                int index = (int)Math.random() * C.size();
                return C.get((int)index).sf;
            }
        };
    }

    public static Production SAOTnm(final double K_max, final double K_step, final double t_max, final double t_min, final double t_step, final int nr_unmoved) {
        return new Production(){

            public Form produce(Grammar G, Form f) {
                return RandomWalks.randomWalk((Candidate)G.gen.randomCandidate((Form)f, (double)Math.random()), (Topology)G.topology, (Hierarchy)G.hierarchy, (RulesOfMoving)RulesOfMovingExamples.simulatedAnnealing(), (CoolingSchedule)CoolingScheduleExamples.saotNM((double)K_max, (double)K_step, (double)t_max, (double)t_min, (double)t_step, (int)nr_unmoved)).output.sf;
            }
        };
    }

    public static Production SA(final double K_max, final double K_step, final double t_max, final double t_min, final double t_step, final int nr_unmoved) {
        return new Production(){

            public Form produce(Grammar G, Form f) {
                Form sf = new Form();
                String type = G.type.toLowerCase();
                double q = 2.0;
                if (type.equals("ot")) {
                    G.hierarchy.type = "ot";
                } else if (type.equals("hg")) {
                    G.hierarchy.type = "hg";
                    q = 2.0;
                } else if (type.endsWith("hg")) {
                    G.hierarchy.type = "hg";
                    q = Double.parseDouble(type.split("-")[0]);
                    if (q < 1.0 || q == Double.POSITIVE_INFINITY) {
                        throw new RuntimeException("q-HG grammars: q is not properly specified.");
                    }
                } else {
                    throw new RuntimeException("q-HG grammars: type of Grammar not properly specified.");
                }
                if (type.equals("ot")) {
                    sf = RandomWalks.randomWalk((Candidate)G.gen.randomCandidate((Form)f, (double)Math.random()), (Topology)G.topology, (Hierarchy)G.hierarchy, (RulesOfMoving)RulesOfMovingExamples.simulatedAnnealing(), (CoolingSchedule)CoolingScheduleExamples.saotNM((double)K_max, (double)K_step, (double)t_max, (double)t_min, (double)t_step, (int)nr_unmoved)).output.sf;
                } else {
                    double Tmax = Math.pow(q, K_max + (t_max - 1.0) / (t_max - t_min));
                    double r = Math.pow(q, -t_step / (t_max - t_min));
                    sf = RandomWalks.randomWalk((Candidate)G.gen.randomCandidate((Form)f, (double)Math.random()), (Topology)G.topology, (Hierarchy)G.hierarchy, (RulesOfMoving)RulesOfMovingExamples.simulatedAnnealing(), (CoolingSchedule)CoolingScheduleExamples.exponentialNM((double)Tmax, (double)r, (int)nr_unmoved)).output.sf;
                }
                return sf;
            }
        };
    }

    public static Production constant(final Form F) {
        return new Production(){

            public Form produce(Grammar G, Form f) {
                return F;
            }
        };
    }
}

